package org.unitedfront2.dao;

import org.unitedfront2.domain.Account;

/**
 * AJEgf[^𑀍삷邽߂̃C^[tF[XłB
 *
 * @author kurokkie
 *
 */
public interface AccountDao extends Registerable<Account>,
    SimpleFindable<Account>, Updatable<Account>, Dao {

    /**
     * @require ${account.code} ͈ӂȒlł
     */
    @Override
    void register(Account account);

    /**
     * @require ${account.code} ͈ӂȒlł
     */
    @Override
    void update(Account account);

    /**
     * ꎞIȔF؂ɗpF؃L[擾܂Bf[^ɂȂΐVɐ܂B
     *
     * @param accountId AJEg ID
     * @ensure  ${accountId} ɑΉꎞL[݂Ȃ΁AꎞL[Vɔs
     * @ensure  ${accountId} ɑΉꎞL[݂΁ÄꎞL[ėp
     * @return F؃L[
     */
    String generateTemporaryAuthKey(int accountId);

    /**
     * [AhXAJEg擾܂B
     *
     * @param mailAddr [AhX
     * @return AJEgAȂ <code>null</code>
     */
    Account findByMailAddr(String mailAddr);

    /**
     * ꎞIɔsF؃L[AJEg擾܂BF؃L[ݒ肳ꂽԂ̃AJEg擾
     * ܂B
     *
     * @param temporaryAuthKey ꎞIɔsF؃L[
     * @return F؃L[ݒς݂̃AJEg
     */
    Account findByTemporaryAuthKey(String temporaryAuthKey);

    /**
     * w肵bo߂F؃L[폜܂B
     *
     * @param seconds b
     * @require ${seconds} >= 0
     * @ensure ${seconds} bo߂F؃L[폜
     * @ensure ${seconds} bo߂ĂȂF؃L[͍폜ĂȂ
     */
    void deleteOldTemporaryAuthKey(int seconds);

    /**
     * w肵AJEg̈ꎞF؃L[폜܂B
     *
     * @param accountId AJEg ID
     * @require ${accountId} exists.
     * @ensure ${accountId} not exists.
     */
    void deleteTemporaryAuthKey(int accountId);
}
