package org.unitedfront2.web.mail;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import junit.framework.Assert;

import org.junit.Before;
import org.junit.Test;
import org.springframework.mail.SimpleMailMessage;

public class XmlTemplateSpringMailSenderTest {

    private XmlTemplateSpringMailSender mailSender;

    private Map<String, Object> model;

    @Before
    public void setUp() {
        mailSender = new XmlTemplateSpringMailSender();
        mailSender.setMailSender(new TestMailSender());
        mailSender.setSimpleMailMessageValidator(new SimpleMailMessageValidator());
        TestUser user = new TestUser();
        user.setName("eX^[");
        user.setTo("tester@unitedfront2.org");
        Date date = new Date();
        model = new HashMap<String, Object>();
        model.put("user", user);
        model.put("date", date);
        model.put("systemMailAddr", "system@unitedfront2.org");
    }

    @Test
    public void testSend{̃[ev[g߂() {
        mailSender.setMailTemplateName(XmlTemplateSpringMailSenderTest
                .class.getPackage().getName() + ".Test-mail");
        mailSender.send(model, new Locale("ja"));
        SimpleMailMessage sentMessage = ((TestMailSender) mailSender.getMailSender()).getSentMessage();
        Assert.assertTrue("悪vȂ", Arrays.equals(new String[] {"tester@unitedfront2.org", "user@unitedfront2.com"}, sentMessage.getTo()));
        Assert.assertEquals("system@unitedfront2.org", sentMessage.getFrom());
        Assert.assertTrue("BCCvȂ", Arrays.equals(new String[] {"bcc@example.com", "system@unitedfront2.org"}, sentMessage.getBcc()));
        Assert.assertTrue("CCvȂ", Arrays.equals(new String[] {"cc@example.com", "system@unitedfront2.org"}, sentMessage.getCc()));
        Assert.assertEquals("悤", sentMessage.getSubject());
        Assert.assertEquals("悤 eX^[ B " + model.get("date") + " łB", sentMessage.getText());
    }

    @Test
    public void testSendp̃ev[g߂() {
        mailSender.setMailTemplateName(XmlTemplateSpringMailSenderTest.class.getPackage().getName() + ".Test-mail");
        mailSender.send(model, new Locale("en"));
        SimpleMailMessage sentMessage = ((TestMailSender) mailSender.getMailSender()).getSentMessage();
        Assert.assertTrue("悪vȂ", Arrays.equals(new String[] {"tester@unitedfront2.org", "user@unitedfront2.com"}, sentMessage.getTo()));
        Assert.assertEquals("system@unitedfront2.org", sentMessage.getFrom());
        Assert.assertTrue("BCCvȂ", Arrays.equals(new String[] {"bcc@example.com", "system@unitedfront2.org"}, sentMessage.getBcc()));
        Assert.assertTrue("CCvȂ", Arrays.equals(new String[] {"cc@example.com", "system@unitedfront2.org"}, sentMessage.getCc()));
        Assert.assertEquals("Welcome", sentMessage.getSubject());
        Assert.assertEquals("Welcome eX^[. Now " + model.get("date") + ".", sentMessage.getText());
    }

    @Test
    public void testSend߉\ȍŏ̍\() {
        mailSender.setMailTemplateName(XmlTemplateSpringMailSenderTest.class.getPackage().getName() + ".Test-simpleMail");
        mailSender.send(model, new Locale("ja"));
        SimpleMailMessage sentMessage = ((TestMailSender) mailSender.getMailSender()).getSentMessage();
        Assert.assertEquals(1, sentMessage.getTo().length);
        Assert.assertEquals("system@unitedfront2.org", sentMessage.getFrom());
        Assert.assertEquals(0, sentMessage.getBcc().length);
        Assert.assertEquals("悤", sentMessage.getSubject());
        Assert.assertEquals("", sentMessage.getText());
    }

    @Test
    public void testSendf̑nullꍇ͋󕶎ɕϊ() {
        mailSender.setMailTemplateName(XmlTemplateSpringMailSenderTest.class.getPackage().getName() + ".Test-mail");
        ((TestUser) model.get("user")).setName(null);
        mailSender.send(model, new Locale("ja"));
        SimpleMailMessage sentMessage = ((TestMailSender) mailSender.getMailSender()).getSentMessage();
        Assert.assertEquals("悤  B " + model.get("date") + " łB", sentMessage.getText());
    }
}
