package org.unitedfront2.domain.communication;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.dao.SimpleFindable;
import org.unitedfront2.domain.SimpleTableModule;
import org.unitedfront2.domain.accesscontrol.AccessDeniedException;
import org.unitedfront2.domain.accesscontrol.OwnerOnly;
import org.unitedfront2.domain.accesscontrol.Public;
import org.unitedfront2.test.TableModuleTestCaseSupport;

public class ProfileTableTest extends TableModuleTestCaseSupport<Profile> {

    @Autowired private ProfileTable profileTable;

    @Override
    public void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        profileTable.install(simpleUser1.getId());
        profileTable.install(simpleUser2.getId());
        profileTable.install(simpleUser3.getId());
    }

    @Override
    protected Profile createDomain() {
        return profileTable.find(simpleUser1.getId());
    }

    @Override
    protected SimpleTableModule<Profile> getTableModule() {
        return profileTable;
    }

    @Override
    protected SimpleFindable<Profile> getSimpleDao() {
        return profileTable.getSimpleDao();
    }

    @Ignore
    @Override
    protected void store(Profile domain) throws Exception {
        // ignore
    }

    @Override
    protected String getPrimaryKeyPropertyName() {
        return "ownerId";
    }

    @Test
    public void testInstall() throws AccessDeniedException {
        Profile profile = profileTable.get(simpleUser1.getId());
        profile.retrieveSelfIntroduction();
        Assert.assertNotNull(profile);
        Assert.assertNotNull(profile.getSelfIntroduction());
        Assert.assertEquals(profile.getOwnerId(), profile.getSelfIntroduction().getOwnerId());
        Assert.assertTrue(profile.getReadAccessControl().getType() == Public.class);
        Assert.assertEquals(profile.getReadAccessControl(), profile.getSelfIntroduction().getReadAccessControl());
        Assert.assertTrue(profile.getWriteAccessControl().getType() == OwnerOnly.class);
        Assert.assertEquals(profile.getWriteAccessControl(), profile.getSelfIntroduction().getWriteAccessControl());
    }

    @Test
    public void testFindByOwnerCode[U݂() {
        Profile expected = profileTable.findByOwnerCode(simpleUser1.getCode());
        Profile actual = profileTable.find(simpleUser1.getId());
        Assert.assertEquals(expected, actual);
    }
}
