package org.unitedfront2.domain.communication;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.accesscontrol.OwnerOnly;
import org.unitedfront2.domain.accesscontrol.Public;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public class BlogEntryTableTest extends TransactionalTestCaseWithInitialData {

    @Autowired private BlogEntryTable blogEntryTable;

    @Test
    public void testFindByCode() {
        BlogEntry blogEntry = domainFactory.prototype(new BlogEntry(createEntry()));
        blogEntry.store();

        BlogEntry found = blogEntryTable.findByCode(blogEntry.getCode());
        Assert.assertEquals(blogEntry, found);
    }

    private Message createEntry() {
        MessageEntry entry = new MessageEntry();
        entry.setSubject("̋LłB");
        entry.setBody("͍̋LłB");
        Map<Locale, MessageEntry> entryMap
            = new HashMap<Locale, MessageEntry>();
        entryMap.put(Locale.JAPANESE, entry);
        Message article = domainFactory.prototype(new Message(null, entryMap,
                simpleUser1.getId(), simpleUser1.getId(),
                domainFactory.prototype(Public.class),
                domainFactory.prototype(OwnerOnly.class)));
        return article;
    }
}
