package org.unitedfront2.domain.accesscontrol;

import org.junit.Assert;
import org.junit.Test;
import org.unitedfront2.domain.communication.Profile;

public class PublicTest extends AccessControlTestSupport {

    @Override
    protected AccessControl getAccessControl() {
        return domainFactory.prototype(Public.class);
    }

    @Override
    protected Class<? extends AccessControl> getChangeTo() {
        return UserOnly.class;
    }

    @Test
    public void testAccessToResourceNłANZXł() throws AccessDeniedException {
        Profile profile = profileTable.get(simpleUser1.getId());
        try {
            accessControl.access(profile, simpleUser1.getId());
            accessControl.access(profile);
            accessControl.access(profile);
            Assert.assertTrue(true);
        } catch (AccessDeniedException e) {
            Assert.fail();
        }
    }

    @Test
    public void testAccessToCopyrightedResourceNłANZXł() throws AccessDeniedException {
        Profile profile = profileTable.get(simpleUser1.getId());
        profile.retrieveSelfIntroduction();
        try {
            accessControl.access(profile.getSelfIntroduction(), simpleUser1.getId());
            accessControl.access(profile.getSelfIntroduction());
            Assert.assertTrue(true);
        } catch (AccessDeniedException e) {
            Assert.fail();
        }
    }
}
