package org.unitedfront2.domain;

import org.unitedfront2.dao.SampleDomainDao;
import org.unitedfront2.dao.SimpleFindable;

public class SampleDomainTable extends SimpleTableModule<SampleDomain> {

    private SampleDomainDao sampleDomainDao;

    @Override
    protected SimpleFindable<SampleDomain> getSimpleDao() {
        return sampleDomainDao;
    }

    /**
     * TvhC擾܂B
     *
     * @param code R[h
     * @return TvhCAȂ <code>null</code>
     */
    public SampleDomain findByCode(String code) {
        return sampleDomainDao.findByCode(code);
    }

    /**
     * TvhC擾܂B
     *
     * @param code R[h
     * @return TvhC
     * @throws IllegalArgumentException w肵R[hTvhC݂Ȃ
     */
    public SampleDomain getByCode(String code) throws IllegalArgumentException {
        SampleDomain sampleDomain = findByCode(code);
        if (sampleDomain == null) {
            String message = "The sample domain code '" + code + "' not found.";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        return sampleDomain;
    }

    /**
     * TvhC݂邩肵܂B
     *
     * @param code R[h
     * @return ݂Ȃ <code>true</code> A݂ȂȂ <code>false</code>
     */
    public boolean existByCode(String code) {
        return findByCode(code) != null;
    }

    /**
     * o^ĂTvhC̑擾܂B
     *
     * @return TvhC̑
     */
    public int count() {
        return sampleDomainDao.count();
    }

    public void setSampleDomainDao(SampleDomainDao sampleDomainDao) {
        this.sampleDomainDao = sampleDomainDao;
    }
}
