package org.unitedfront2.domain;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.Repeat;
import org.unitedfront2.domain.Account.Role;
import org.unitedfront2.domain.Account.Status;
import org.unitedfront2.test.TransactionalTestCase;

public class AccountTest extends TransactionalTestCase {

    private Account account;

    @Autowired private AccountTable accountTable;

    @Before
    public void onSetUpBeforeTransaction() {
        account = new Account("tester@unitedfront2.org", "password", Status.AVAILABLE, Role.ROLE_USER);
        account.encrypt();
        account = domainFactory.prototype(account);
    }

    @Test
    @Repeat(value=100)
    public void testCreateRandomPassword_ȃpX[h() {
        String password = Account.createRandomPassword(4, 8);
        Assert.assertTrue("pX[h̏s", password.matches("[0-9a-zA-Z]{4,8}"));
    }

    @Test
    public void testEncryptpX[hÍ() {
        Account account = new Account();
        account.setPlainPassword("password");

        Assert.assertFalse(account.isEncrypted());
        account.encrypt();
        Assert.assertTrue("ÍĂȂ", account.isEncrypted());
        Assert.assertEquals("5f4dcc3b5aa765d61d8327deb882cf99", account.getPassword());
    }

    @Test(expected=IllegalStateException.class)
    public void testEncryptpX[hÍς݂ł邽ߗO() {
        account.encrypt();
    }

    @Test
    public void testEncryptÍԂłẴpX[hݒ肷ƍĂшÍł() {
        account.setPlainPassword("password");
        account.encrypt();
        Assert.assertEquals("5f4dcc3b5aa765d61d8327deb882cf99", account.getPassword());
        Assert.assertTrue("ÍĂȂ", account.isEncrypted());
    }

    @Test
    public void testCopyPasswordToÍOpX[h𑼂̃AJEgɓ]() {
        account.setPlainPassword("password");
        Account toAccount = new Account();
        account.copyPasswordTo(toAccount);
        Assert.assertEquals("password", toAccount.getPlainPassword());
        Assert.assertEquals(account.isEncrypted(), toAccount.isEncrypted());
    }

    @Test
    public void testCopyPasswordToÍꂽpX[h𑼂̃AJEgɓ]() {
        Account toAccount = new Account();
        account.copyPasswordTo(toAccount);
        Assert.assertEquals(account.getPassword(), toAccount.getPassword());
        Assert.assertEquals(account.isEncrypted(), toAccount.isEncrypted());
    }

    @Test
    public void testStoreo^() throws MailAddrUsedByOtherException {
        account.addRole(Role.ROLE_ADMIN);

        Assert.assertNull(account.getId());
        account.store();
        Assert.assertEquals(accountTable.get(account.getId()), account);
    }

    @Test(expected=MailAddrUsedByOtherException.class)
    public void testStoreo^݂邪[AhXɎgpĂ() throws MailAddrUsedByOtherException {
        account.store();
        Account otherAccount = account;
        otherAccount.setId(null);

        Assert.assertNull(otherAccount.getId());
        otherAccount.store();
    }

    @Test
    public void testStoreXV() throws MailAddrUsedByOtherException {
        account.store();
        account.setMailAddr("new_" + account.getMailAddr());

        Assert.assertNotNull(account.getId());
        account.store();
        Assert.assertEquals(accountTable.find(account.getId()), account);
    }

    @Test(expected=MailAddrUsedByOtherException.class)
    public void testStoreXV݂邪[AhXɎgpĂ() throws MailAddrUsedByOtherException {
        account.store();

        Account otherAccount = domainFactory.prototype(account);
        otherAccount.setId(null);
        otherAccount.setMailAddr("new_" + otherAccount.getMailAddr());
        otherAccount.store();
        account.setMailAddr(otherAccount.getMailAddr());

        Assert.assertNotNull(account.getId());
        account.store();
    }

    @Test
    public void testGetPasswordÍꂽpX[h̎擾() {
        account.setEncryptedPassword("5f4dcc3b5aa765d61d8327deb882cf99");
        Assert.assertEquals("5f4dcc3b5aa765d61d8327deb882cf99", account.getPassword());
    }

    @Test
    public void testGetPassword̃pX[h̎擾() {
        account.setPlainPassword("password");
        Assert.assertEquals(Account.HIDDEN_PASSWORD, account.getPassword());
    }

    @Test
    public void testSetPlainPassword̃pX[hݒ肳() {
        account.setPlainPassword("password");
        Assert.assertEquals("password", account.getPlainPassword());
        Assert.assertFalse("ÍĂ", account.isEncrypted());
    }

    @Test
    public void testGetPlainPassword̃pX[h擾() {
        account.setPlainPassword("password");
        Assert.assertEquals("password", account.getPlainPassword());
    }

    @Test(expected=IllegalStateException.class)
    public void testGetPlainPasswordpX[hÍς() {
        account.getPlainPassword();
    }

    @Test
    public void testSetEncryptedPasswordÍꂽpX[hݒ肷() {
        account.setEncryptedPassword("5f4dcc3b5aa765d61d8327deb882cf99");
        Assert.assertEquals("5f4dcc3b5aa765d61d8327deb882cf99", account.getPassword());
        Assert.assertTrue("ÍĂȂ", account.isEncrypted());
    }

    @Test
    public void testSetStatus() {
        account.setStatus("AVAILABLE");
        Assert.assertEquals(Status.AVAILABLE, account.getStatus());
    }

    @Test
    public void testRetrieveTemporaryAuthKey() throws MailAddrUsedByOtherException {
        account.store();

        Assert.assertTrue(accountTable.exist(account.getId()));
        account.retrieveTemporaryAuthKey();
        Assert.assertNotNull(account.getTemporaryAuthKey());
    }

    @Test
    public void testDeleteTemporaryAuthKey() throws MailAddrUsedByOtherException {
        account.store();
        account.retrieveTemporaryAuthKey();

        Assert.assertTrue(accountTable.exist(account.getId()));
        account.deleteTemporaryAuthKey();
        Assert.assertNull(account.getTemporaryAuthKey());
    }
}
