package org.unitedfront2.dao;

import java.util.ArrayList;
import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.Widget;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public class WidgetDaoTest extends TransactionalTestCaseWithInitialData {

    @Autowired private WidgetDao widgetDao;

    @Test
    public void testFind() {
        List<Widget> found = widgetDao.find(simpleUser1.getId());
        Assert.assertNotNull(found);
    }

    @Test
    public void testSave() {
        List<Widget> expected = new ArrayList<Widget>();
        expected.add(Widget.PUBLIC_COMMUNITIES);
        expected.add(Widget.FOOTMARK);
        widgetDao.register(simpleUser1.getId(), expected);
        List<Widget> actual = widgetDao.find(simpleUser1.getId());
        Assert.assertEquals(expected, actual);
    }
}
