package org.unitedfront2.web.tags.message;

import java.io.IOException;
import java.io.Writer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.commons.lang.StringUtils;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.MessageEntry;
import org.unitedfront2.web.WebUtils;

/**
 * bZ[W̖{o͂^OCułBP[ɉēK؂Ȗ{I܂B
 *
 * @author kurokkie
 *
 */
public class MessageBodyTag extends TagSupport {

    /** VAԍ */
    private static final long serialVersionUID = 507213415686790538L;

    /** bZ[W */
    private Message message;

    @Override
    public int doStartTag() throws JspException {
        MessageEntry messageEntry = message.getEntryMap().get(WebUtils
                .getLocale((HttpServletRequest) pageContext.getRequest()));
        if (messageEntry == null
                || StringUtils.isBlank(messageEntry.getBody())) {
            messageEntry = message.getRequiredEntry();
        }
        Writer out = pageContext.getOut();
        try {
            out.write(messageEntry.getBody());
        } catch (IOException e) {
            throw new JspException(e);
        }
        return SKIP_BODY;
    }

    public void setMessage(Message message) {
        this.message = message;
    }
}
