package org.unitedfront2.web.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.NoSuchMessageException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.support.RequestContextUtils;

/**
 * Tu^Cgr[ɓnC^[Zv^NXłB
 *
 * @author kurokkie
 *
 */
public class TitleInterceptor extends HandlerInterceptorAdapter {

    /** ̃ftHg */
    public static final String TITLE_KEY = "title";

    /**
     * ^Cg̃bZ[WR[hi[邽߂̃p[^B^CgANVNXȂǂ琧䂷ۂɗp
     * ܂B
     */
    public static final String TITLE_CODE_PARAM_NAME
        = TitleInterceptor.class.getName() + ".TITLE";

    /**
     * ^CgbZ[W֓ñL[łB
     * ̃L[gāAfƃr[Ƀ^CgbZ[ẄƂȂIuWFNgzݒ肵܂B
     */
    public static final String TITLE_ARGS_PARAM_NAME
        = TitleInterceptor.class.getName() + ".TITLE_ARGS";

    /** Oo͕ϐ */
    protected final Log logger = LogFactory.getLog(getClass());

    /** xOo͂𖳎r[ */
    private List<String> ignoreViewNames = new ArrayList<String>();

    /**
     * bZ[W\[X^CgɂׂbZ[WTAr[ɓn܂B
     * r[ƓbZ[WR[hbZ[W^CgƂ݂Ȃ܂B
     *
     * @param request HTTP NGXg
     * @param response HTTP X|X
     * @param handler nh
     * @param modelAndView fƃr[
     */
    @Override
    public void postHandle(HttpServletRequest request,
            HttpServletResponse response, Object handler,
            ModelAndView modelAndView) {
        WebApplicationContext context = WebApplicationContextUtils
                .getWebApplicationContext(
                        request.getSession().getServletContext());
        Locale locale = RequestContextUtils.getLocale(request);
        Object titleCode = modelAndView.getModel().get(TITLE_CODE_PARAM_NAME);
        if (titleCode == null) {
            logger.info("skip inserting title");
            return;
        }

        String code = titleCode.toString();
        Object args = modelAndView.getModel().get(TITLE_ARGS_PARAM_NAME);
        try {
            String title;
            if (!(args instanceof Object[])) {
                title = context.getMessage(code, null, locale);
            } else {
                title = context.getMessage(code, (Object[]) args, locale);
            }
            request.setAttribute(TITLE_KEY, title);
        } catch (NoSuchMessageException e) {
            if (ignoreViewNames.contains(modelAndView.getViewName())) {
                logger.debug(e.getMessage());
            } else {
                logger.warn(e.getMessage(), e);
            }
        }
    }

    public void setIgnoreViewNames(List<String> ignoreViewNames) {
        this.ignoreViewNames = ignoreViewNames;
    }
}
