package org.unitedfront2.web.controller.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.Widget;
import org.unitedfront2.domain.WidgetTable;
import org.unitedfront2.web.WebUtils;

/**
 * EBWFbg̍XV@\̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "widget.updateAction")
public class UpdateAction extends MultiAction {

    /** EBWFbge[u */
    @Autowired private WidgetTable widgetTable;

    /**
     * gp̃EBWFbgtH[ʂɓn܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     */
    public Event setupForm(RequestContext context) {
        List<Widget> unusedWidgets = new ArrayList<Widget>();
        Account account = WebUtils.findAccount(context);
        List<Widget> list = widgetTable.get(account.getId());
        for (Widget widget : Widget.values()) {
            if (!list.contains(widget)) {
                unusedWidgets.add(widget);
            }
        }
        context.getRequestScope().put("unusedWidgets", unusedWidgets);
        context.getRequestScope().put("availableWidgets",
                Arrays.asList(Widget.values()));
        return success();
    }

    /**
     * ͒l؂ƃoChs܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     * @throws IllegalArgumentException ؗO
     */
    public Event bindAndValidate(RequestContext context)
        throws IllegalArgumentException {

        validate(context);
        bind(context);
        return success();
    }

    private void validate(RequestContext context)
        throws IllegalArgumentException {

        List<String> strWidgets = getStrWidgets(context);
        for (String s : strWidgets) {
            try {
                Widget.valueOf(s);
            } catch (IllegalArgumentException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn(e.getMessage());
                }
                context.getRequestScope().put("error", true);
                context.getRequestScope().put("strWidgets", strWidgets);
                throw e;
            }
        }
    }

    private void bind(RequestContext context) {
        List<String> strWidgets = getStrWidgets(context);
        List<Widget> widgets = new ArrayList<Widget>(strWidgets.size());
        for (String s : strWidgets) {
            widgets.add(Widget.valueOf(s));
        }
        context.getFlowScope().put("widgets", widgets);
    }

    private List<String> getStrWidgets(RequestContext context) {
        String strWidgets = context.getRequestParameters().get("widgets");
        List<String> list;
        if (!StringUtils.isEmpty(strWidgets)) {
            String[] widgets = strWidgets.split(",");
            list = new ArrayList<String>(widgets.length);
            for (String widget : widgets) {
                if (list.contains(widget)) {
                    continue;
                }
                list.add(widget);
            }
        } else {
            list = new ArrayList<String>(0);
        }
        return list;
    }

    /**
     * EBWFbgXV܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     */
    public Event update(RequestContext context) {
        List<Widget> list = new ArrayList<Widget>((List<Widget>)
            context.getFlowScope().get("widgets"));
        User user = WebUtils.findUser(context);
        widgetTable.store(user.getId(), list);
        WebUtils.setWidgets(WebUtils.getSession(context), list);
        return success();
    }
}
