
package org.unitedfront2.web.controller.user;

import javax.annotation.Resource;

import org.springframework.stereotype.Repository;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Validator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.SubflowUtils;

/**
 * [UύX@\̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "user.formAction")
public class FormAction
    extends org.unitedfront2.web.controller.FormAction {

    /** [UIuWFNg̕ϐ (user) */
    public static final String USER_PARAM_NAME = "user";

    @Override
    protected void initAction() {
        super.initAction();
        setFormObjectClass(SimpleUser.class);
    }

    /**
     * [Uf[^擾AtH[IuWFNgƂėp܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     */
    @Override
    public Event init(RequestContext context) {
        super.init(context);
        putFormObject(context, WebUtils.findUser(context));
        return success();
    }

    @Override
    protected void initBinder(RequestContext context, DataBinder binder) {
        super.initBinder(context, binder);
        binder.setAllowedFields(new String[] {"code", "name"});
    }

    @Override
    public Event setupForm(RequestContext context) throws Exception {
        super.setupForm(context);
        SubflowUtils.setupMessages(context, null, "user.Form.description");
        return success();
    }

    /**
     * [UIuWFNgĂяỏʑJڂ֕Ԃ܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event finish(RequestContext context) {
        context.getFlowScope().put(USER_PARAM_NAME, getFormObject(context));
        return success();
    }

    @Override
    @Resource(name = "user.formValidator")
    public void setValidator(Validator validator) {
        super.setValidator(validator);
    }
}
