package org.unitedfront2.web.controller.mail;

import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Mail;
import org.unitedfront2.web.controller.FormAction;

/**
 * [MANV̒ۃNXłB
 *
 * @author kurokkie
 *
 */
public abstract class SendMailActionSupport extends FormAction {

    /** fɊi[郁[IuWFNg̕ϐ */
    public static final String MAIL_PARAM_NAME = "mail";

    @Override
    protected void initAction() {
        super.initAction();
        setFormObjectClass(Mail.class);
    }

    /**
     * {@link FormAction#init(RequestContext)}
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @ensure t[XR[vɁAϐ {@link FormAction#SEND_MAIL_PARAM_NAME} ̒lݒ
     * 
     * @ensure NGXgXR[v̕ϐ {@link #MAIL_PARAM_NAME}  <code>null</code>
     * ܂͕ϐ {@link #MAIL_PARAM_NAME}  <code>toMailAddr</code> ݒ肳Ă
     * ꍇ̓[MItɂ܂
     */
    @Override
    public Event init(RequestContext context) {
        super.init(context);
        if (!isSendMail()) {
            // O[oݒŃ[ItƂȂĂ
            return success();
        }
        Object obj = context.getRequestScope().get(MAIL_PARAM_NAME);
        if (obj == null) {
            return success();
        }
        Mail mail = (Mail) obj;
        if (mail.getToMailAddr() == null) {
            context.getFlowScope().put(SEND_MAIL_PARAM_NAME, false);
        }
        return success();
    }
}
