package org.unitedfront2.web.controller.community;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.accesscontrol.AccessDeniedException;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.CommunityTable;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.MultiThreadCommunity;
import org.unitedfront2.domain.communication.SingleThreadCommunity;
import org.unitedfront2.domain.communication.Thread;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.flow.BadRequestException;
import org.unitedfront2.web.flow.PageNotFoundException;

/**
 * uO֘Ã[eBeBNXłB
 *
 * @author kurokkie
 *
 */
final class Utils {

    /**
     * R~jeB擾܂B
     *
     * @param context {@link RequestContext}
     * @param action {@link Action}
     * @param communityTable R~jeBe[u
     * @param codeParamName R~jeB̃R[h
     * @return R~jeB
     */
    public static Community findCommunity(RequestContext context,
        Action action, CommunityTable communityTable, String codeParamName) {
        String code = context.getRequestParameters().get(codeParamName);
        if (code == null) {
            code = context.getFlowScope().getString(codeParamName);
        }
        Community c = communityTable.findByCode(code);
        if (c == null) {
            String message = "The Community [Code='" + code + "'] not found.";
            throw new PageNotFoundException(context, action, message);
        }
        return c;
    }

    /**
     * R~jeB擾܂B
     *
     * @param request {@link HttpServletRequest}
     * @param communityTable R~jeBe[u
     * @param codeParamName R~jeB̃R[h
     * @return R~jeB
     */
    public static Community findCommunity(HttpServletRequest request,
        CommunityTable communityTable, String codeParamName) {
        String code;
        try {
            code = ServletRequestUtils.getRequiredStringParameter(request,
                    codeParamName);
        } catch (ServletRequestBindingException e) {
            throw new org.unitedfront2.web.BadRequestException(e);
        }
        Community c = communityTable.findByCode(code);
        if (c == null) {
            String message = "The Community [Code='" + code + "'] not found.";
            throw new org.unitedfront2.web.PageNotFoundException(message);
        }
        return c;
    }

    /**
     * }`XbhR~jeB擾܂B
     *
     * @param context {@link RequestContext}
     * @param action {@link Action}
     * @param communityTable R~jeBe[u
     * @param codeParamName R~jeB̃R[h
     * @return R~jeB
     */
    public static MultiThreadCommunity findMultiThreadCommunity(
            RequestContext context, Action action,
            CommunityTable communityTable, String codeParamName) {
        Community c = findCommunity(context, action, communityTable,
                codeParamName);
        if (MultiThreadCommunity.class != c.getClass()) {
            String message = "The community '" + codeParamName + "' is not "
                + MultiThreadCommunity.class.getName() + ".";
            throw new BadRequestException(context, action, message);
        }
        return (MultiThreadCommunity) c;
    }

    /**
     * }`XbhR~jeB擾܂B
     *
     * @param request {@link HttpServletRequest}
     * @param communityTable R~jeBe[u
     * @param codeParamName R~jeB̃R[h
     * @return R~jeB
     */
    public static MultiThreadCommunity findMultiThreadCommunity(
            HttpServletRequest request, CommunityTable communityTable,
            String codeParamName) {
        Community c = findCommunity(request, communityTable, codeParamName);
        if (MultiThreadCommunity.class != c.getClass()) {
            String message = "The community '" + codeParamName + "' is not "
                + MultiThreadCommunity.class.getName() + ".";
            throw new org.unitedfront2.web.BadRequestException(message);
        }
        return (MultiThreadCommunity) c;
    }

    /**
     * R~jeB̎擾Ɖ{`FbNs܂B
     *
     * @param context {@link RequestContext}
     * @param action {@link Action}
     * @param communityTable {@link CommunityTable}
     * @param codeParamName R[h̃p[^
     * @return R~jeB
     */
    public static Community findCommunityAndReadAccess(RequestContext context,
            Action action, CommunityTable communityTable,
            String codeParamName) {
        Community c = findCommunity(context, action, communityTable,
                codeParamName);
        try {
            c.readAccess(WebUtils.findUser(context));
        } catch (AccessDeniedException e) {
            throw new org.unitedfront2.web.flow.AccessDeniedException(context,
                    action, e.getMessage(), e);
        }
        return c;
    }

    /**
     * R~jeB̎擾Ɖ{`FbNs܂B
     *
     * @param request {@link HttpServletRequest}
     * @param communityTable {@link CommunityTable}
     * @param codeParamName R[h̃p[^
     * @return R~jeB
     */
    public static Community findCommunityAndReadAccess(
            HttpServletRequest request, CommunityTable communityTable,
            String codeParamName) {
        Community c = findCommunity(request, communityTable,
                codeParamName);
        try {
            c.readAccess(WebUtils.findUser(request.getSession(false)));
        } catch (AccessDeniedException e) {
            throw new org.unitedfront2.web.AccessDeniedException(e);
        }
        return c;
    }

    /**
     * R~jeB̎擾ƕҏW`FbNs܂B
     *
     * @param context {@link RequestContext}
     * @param action {@link Action}
     * @param communityTable {@link CommunityTable}
     * @param codeParamName R[h̃p[^
     * @return R~jeB
     */
    public static Community findCommunityAndWriteAccess(RequestContext context,
            Action action, CommunityTable communityTable,
            String codeParamName) {
        Community c = findCommunity(context, action, communityTable,
                codeParamName);
        try {
            c.writeAccess(WebUtils.findUser(context));
        } catch (AccessDeniedException e) {
            throw new org.unitedfront2.web.flow.AccessDeniedException(context,
                    action, e);
        }
        return c;
    }

    /**
     * R~jeB̎擾ƕҏW`FbNs܂B
     *
     * @param request {@link HttpServletRequest}
     * @param communityTable {@link CommunityTable}
     * @param codeParamName R[h̃p[^
     * @return R~jeB
     */
    public static Community findCommunityAndWriteAccess(
            HttpServletRequest request, CommunityTable communityTable,
            String codeParamName) {
        Community c = findCommunity(request, communityTable,
                codeParamName);
        try {
            c.writeAccess(WebUtils.findUser(request.getSession(false)));
        } catch (AccessDeniedException e) {
            throw new org.unitedfront2.web.AccessDeniedException(e);
        }
        return c;
    }

    /**
     * R~jeB̎擾Ɠe`FbNs܂B
     *
     * @param context {@link RequestContext}
     * @param action {@link Action}
     * @param communityTable {@link CommunityTable}
     * @param codeParamName R[h̃p[^
     * @return R~jeB
     */
    public static Community findCommunityAndPostAccess(RequestContext context,
            Action action, CommunityTable communityTable,
            String codeParamName) {
        Community c = findCommunity(context, action, communityTable,
                codeParamName);
        try {
            c.postAccess(WebUtils.findUser(context));
        } catch (AccessDeniedException e) {
            throw new org.unitedfront2.web.flow.AccessDeniedException(context,
                    action, e);
        }
        return c;
    }

    /**
     * R~jeB̎擾Ɠe`FbNs܂B
     *
     * @param request {@link HttpServletRequest}
     * @param communityTable {@link CommunityTable}
     * @param codeParamName R[h̃p[^
     * @return R~jeB
     */
    public static Community findCommunityAndPostAccess(
            HttpServletRequest request, CommunityTable communityTable,
            String codeParamName) {
        Community c = findCommunity(request, communityTable,
                codeParamName);
        try {
            c.postAccess(WebUtils.findUser(request.getSession(false)));
        } catch (AccessDeniedException e) {
            throw new org.unitedfront2.web.AccessDeniedException(e);
        }
        return c;
    }

    /**
     * Xbh擾܂BVOXbhȂΕۗLXbhA}`XbhȂw肳ꂽXbh ID
     * XbhԂ܂B}`XbhȂXbh ID w肳ꂽꍇ
     * {@link BadRequestException} 𔭐܂B
     *
     * @param context {@link RequestContext}
     * @param action {@link Action}
     * @param community R~jeB
     * @param threadIdParamName Xbh ID p[^
     * @return Xbh
     */
    public static Thread findThread(RequestContext context, Action action,
            Community community, String threadIdParamName) {
        if (SingleThreadCommunity.class == community.getClass()) {
            SingleThreadCommunity c = (SingleThreadCommunity) community;
            c.retrieveThread();
            return c.getThread();
        } else if (MultiThreadCommunity.class == community.getClass()) {
            int threadId = context.getRequestParameters().getRequiredInteger(
                    threadIdParamName);
            MultiThreadCommunity c = (MultiThreadCommunity) community;
            Thread t = c.findThread(threadId);
            if (t == null) {
                String message = "The community '" + community.getCode()
                    + "' doesn't have the thread '" + threadId + "'.";
                throw new BadRequestException(context, action, message);
            }
            return t;
        } else {
            // T|[gĂȂR~jeBBN肦ȂB
            String message = "The community class '"
                + community.getClass().getName() + "' not supported.";
            throw new IllegalStateException(message);
        }
    }

    /**
     * Xbh擾܂BVOXbhȂΕۗLXbhA}`XbhȂw肳ꂽXbh ID
     * XbhԂ܂B}`XbhȂXbh ID w肳ꂽꍇ
     * {@link BadRequestException} 𔭐܂B
     *
     * @param request {@link HttpServletRequest}
     * @param community R~jeB
     * @param threadIdParamName Xbh ID p[^
     * @return Xbh
     */
    public static Thread findThread(HttpServletRequest request,
            Community community, String threadIdParamName) {
        if (SingleThreadCommunity.class == community.getClass()) {
            SingleThreadCommunity c = (SingleThreadCommunity) community;
            c.retrieveThread();
            return c.getThread();
        } else if (MultiThreadCommunity.class == community.getClass()) {
            int threadId;
            try {
                threadId = ServletRequestUtils.getRequiredIntParameter(request,
                        threadIdParamName);
            } catch (ServletRequestBindingException e) {
                throw new org.unitedfront2.web.BadRequestException(e);
            }
            MultiThreadCommunity c = (MultiThreadCommunity) community;
            Thread t = c.findThread(threadId);
            if (t == null) {
                String message = "The community '" + community.getCode()
                    + "' doesn't have the thread '" + threadId + "'.";
                throw new org.unitedfront2.web.BadRequestException(message);
            }
            return t;
        } else {
            // T|[gĂȂR~jeBBN肦ȂB
            String message = "The community class '"
                + community.getClass().getName() + "' not supported.";
            throw new IllegalStateException(message);
        }
    }

    /**
     * Xbh擾{`FbNs܂BVOXbhȂΕۗLXbhA}`XbhȂ
     * w肳ꂽXbh ID XbhԂ܂B}`XbhȂXbh ID w肳ꂽ
     *  {@link BadRequestException} 𔭐܂B
     *
     * @param context {@link RequestContext}
     * @param action {@link Action}
     * @param community R~jeB
     * @param threadIdParamName Xbh ID p[^
     * @return Xbh
     */
    public static Thread findThreadAndReadAccess(RequestContext context,
            Action action, Community community, String threadIdParamName) {
        Thread t = findThread(context, action, community, threadIdParamName);
        try {
            t.readAccess(WebUtils.findUser(context));
        } catch (AccessDeniedException e) {
            throw new org.unitedfront2.web.flow.AccessDeniedException(context,
                    action, e);
        }
        return t;
    }

    /**
     * Xbh擾ҏW`FbNs܂BVOXbhȂΕۗLXbhA}`XbhȂ
     * w肳ꂽXbh ID XbhԂ܂B}`XbhȂXbh ID w肳ꂽ
     *  {@link BadRequestException} 𔭐܂B
     *
     * @param context {@link RequestContext}
     * @param action {@link Action}
     * @param community R~jeB
     * @param threadIdParamName Xbh ID p[^
     * @return Xbh
     */
    public static Thread findThreadAndWriteAccess(RequestContext context,
            Action action, Community community, String threadIdParamName) {
        Thread t = findThread(context, action, community, threadIdParamName);
        try {
            t.writeAccess(WebUtils.findUser(context));
        } catch (AccessDeniedException e) {
            throw new org.unitedfront2.web.flow.AccessDeniedException(context,
                    action, e);
        }
        return t;
    }

    /**
     * L擾܂B
     *
     * @param context {@link RequestContext}
     * @param action {@link Action}
     * @param community R~jeB
     * @param threadIdParamName Xbh ID ̃p[^
     * @param entryCodeParamName LR[h̃p[^
     * @return L
     */
    public static Message findEntry(RequestContext context, Action action,
            Community community, String threadIdParamName,
            String entryCodeParamName) {
        String entryCode = context.getRequestParameters().getRequired(
            entryCodeParamName);
        if (community.getClass() == SingleThreadCommunity.class) {
            SingleThreadCommunity c = (SingleThreadCommunity) community;
            c.retrieveThread();
            Message entry = c.getThread().findEntryByEntryCode(entryCode);
            if (entry == null) {
                // bZ[W݂ȂAXbhɏĂȂ
                String message = "The entry '" + entryCodeParamName
                    + "' not found in this thread " + c.getThreadId() + ".";
                throw new BadRequestException(context, action, message);
            }
            return entry;
        } else if (community.getClass() == MultiThreadCommunity.class) {
            int threadId = context.getRequestParameters().getRequiredInteger(
                    threadIdParamName);
            MultiThreadCommunity c = (MultiThreadCommunity) community;
            Thread t = c.findThread(threadId);
            if (t == null) {
                String message = "The thread " + threadId
                    + " not found in this community '" + community.getCode()
                    + "'.";
                throw new BadRequestException(context, action, message);
            }
            Message e = t.findEntryByEntryCode(entryCode);
            if (e == null) {
                String message = "The entry '" + entryCode
                    + "' not found in this thread " + threadId + ".";
                throw new BadRequestException(context, action, message);
            }
            return e;
        } else {
            String message = "The community type '"
                + community.getClass().getName() + "' not supported.";
            throw new IllegalStateException(message);
        }
    }

    /**
     * L擾Ɖ{`FbNs܂B
     *
     * @param context {@link RequestContext}
     * @param action {@link Action}
     * @param community R~jeB
     * @param threadIdParamName Xbh ID ̃p[^
     * @param entryCodeParamName LR[h̃p[^
     * @return L
     */
    public static Message findEntryAndReadAccess(RequestContext context,
            Action action, Community community, String threadIdParamName,
            String entryCodeParamName) {
        Message entry = findEntry(context, action, community, threadIdParamName,
                entryCodeParamName);
        try {
            entry.readAccess(WebUtils.findUser(context));
        } catch (AccessDeniedException e) {
            throw new org.unitedfront2.web.flow.AccessDeniedException(context,
                    action, e);
        }
        return entry;
    }

    /**
     * L擾ƕҏW`FbNs܂B
     *
     * @param context {@link RequestContext}
     * @param action {@link Action}
     * @param community R~jeB
     * @param threadIdParamName Xbh ID ̃p[^
     * @param entryCodeParamName LR[h̃p[^
     * @return L
     */
    public static Message findEntryAndWriteAccess(RequestContext context,
            Action action, Community community, String threadIdParamName,
            String entryCodeParamName) {
        Message entry = findEntry(context, action, community, threadIdParamName,
                entryCodeParamName);
        try {
            entry.writeAccess(WebUtils.findUser(context));
        } catch (AccessDeniedException e) {
            throw new org.unitedfront2.web.flow.AccessDeniedException(context,
                    action, e);
        }
        return entry;
    }

    /**
     * R~jeB̋Lꗗ擾܂BeLɂ URI ݒ肳܂B
     *
     * @param community R~jeB
     * @param no Jnԍ
     * @param num L
     * @return LXg
     */
    public static List<Message> findEntries(Community community, int no,
            int num) {
        if (community.getClass() == SingleThreadCommunity.class) {
            SingleThreadCommunity stc = (SingleThreadCommunity) community;
            stc.retrieveEntries(no, num);
            for (Message e : stc.getEntries()) {
                e.setUri(Utils.getPermaLink(stc, e));
            }
            return stc.getEntries();
        } else if (community.getClass() == MultiThreadCommunity.class) {
            MultiThreadCommunity mtc = (MultiThreadCommunity) community;
            mtc.retrieveThreads();
            List<Message> entries = new ArrayList<Message>();
            for (Thread t : mtc.getThreads()) {
                t.retrieveEntries(no, num);
                for (Message e : t.getEntries()) {
                    e.setUri(Utils.getPermaLink(mtc, t, e));
                }
                entries.addAll(t.getEntries());
            }
            return entries;
        } else {
            String message = "The community type '"
                + community.getClass().getName() + "' not supported.";
            throw new UnsupportedOperationException(message);
        }
    }

    /**
     * Lւ̃p[}N擾܂B
     *
     * @param community R~jeB
     * @param entry L
     * @return p[}N
     */
    public static String getPermaLink(Community community, Message entry) {
        return getPermaLink(community, null, entry);
    }

    /**
     * Lւ̃p[}N擾܂B
     *
     * @param community R~jeB
     * @param thread Xbh
     * @param entry L
     * @return p[}N
     */
    public static String getPermaLink(Community community, Thread thread,
            Message entry) {
        if (community.getClass() == SingleThreadCommunity.class) {
            return "/community/" + community.getCode() + "/entry-"
                + entry.getCode() + ".html";
        } else if (community.getClass() == MultiThreadCommunity.class) {
            if (thread == null) {
                throw new IllegalArgumentException(
                        "The thread must not be null.");
            }
            return "/community/" + community.getCode() + "/" + thread.getId()
                + "/entry-" + entry.getCode() + ".html";
        } else {
            String message = "The community type '" + community.getClass()
                + "' not supported.";
            throw new UnsupportedOperationException(message);
        }
    }

    private Utils() {
        super();
    }
}
