package org.unitedfront2.web.controller.community;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.accesscontrol.AccessControl;
import org.unitedfront2.domain.accesscontrol.OwnerOnly;
import org.unitedfront2.domain.accesscontrol.UserOnly;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.SingleThreadCommunity;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.SubflowUtils;

/**
 * R~jeB쐬@\̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "community.createAction")
public class CreateAction extends AbstractAction {

    /** hCt@Ng */
    @Autowired private DomainFactory domainFactory;

    @Override
    protected Event doExecute(RequestContext context) throws Exception {
        context.getFlowScope().put(SubflowUtils.PAGE_TITLE_CODE_PARAM_NAME,
                "community.CreateForm");
        context.getFlowScope().put(FormAction.LAST_SUBMIT_CODE_PARAM_NAME,
                "doCreate");
        User user = WebUtils.getUser(context);
        Community c = createCommunity(user);
        context.getFlowScope().put(FormAction.COMMUNITY_PARAM_NAME, c);
        return success();
    }

    private Community createCommunity(User user) {
        AccessControl readAccessControl = domainFactory.prototype(
                UserOnly.class);
        AccessControl writeAccessControl = domainFactory.prototype(
                OwnerOnly.class);
        SingleThreadCommunity c = domainFactory.prototype(
                SingleThreadCommunity.class);
        c.setOverview(createOverview(user, readAccessControl,
                writeAccessControl));
        c.setOwnerId(user.getId());
        c.setReadAccessControl(readAccessControl);
        c.setWriteAccessControl(writeAccessControl);
        c.setPostAccessControl(domainFactory.prototype(UserOnly.class));
        return c;
    }

    private Message createOverview(User user, AccessControl readAccessControl,
            AccessControl writeAccessControl) {
        return domainFactory.prototype(new Message(null, null, user.getId(),
                user.getId(), readAccessControl, writeAccessControl));
    }
}
