package org.unitedfront2.web.controller.blog;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Blog;
import org.unitedfront2.domain.communication.BlogTable;
import org.unitedfront2.web.controller.SubflowUtils;
import org.unitedfront2.web.flow.AccessDeniedException;

/**
 * uO̊{ύXANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "blog.updateAction")
public class UpdateAction extends AbstractAction {

    /** uOe[u */
    @Autowired private BlogTable blogTable;

    /**
     * XVuO肵܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @throws AccessDeniedException ҏWȂ
     */
    @Override
    protected Event doExecute(RequestContext context)
        throws AccessDeniedException {
        Blog blog = Utils.findAndWriteAccessByCode(context, this, blogTable,
            "blogCode");
        context.getFlowScope().put(FormAction.LAST_SUBMIT_CODE_PARAM_NAME,
            "doUpdate");
        context.getFlowScope().put(FormAction.BLOG_PARAM_NAME, blog);
        context.getFlowScope().put(SubflowUtils.PAGE_TITLE_CODE_PARAM_NAME,
                "blog.UpdateForm");

        return success();
    }
}
