package org.unitedfront2.web.controller.account;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Errors;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.AccountValidator;
import org.unitedfront2.validation.SpringValidatorSupport;
import org.unitedfront2.validation.ValidationException;

/**
 * [AhXύX̌؃NXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "account.mailAddrFormValidator")
public class MailAddrFormValidator
    extends SpringValidatorSupport<AccountValidator, Account> {

    /**
     * [AhX̒l؂܂B
     *
     * @param account AJEg
     * @param errors G[
     */
    @Override
    protected void doValidate(Account account, Errors errors) {
        try {
            getOriginalValidator().validateMailAddr(account);
        } catch (ValidationException e) {
            rejectValue("mailAddr", e, errors);
        }
    }

    @Override
    @Autowired
    public void setOriginalValidator(AccountValidator originalValidator) {
        super.setOriginalValidator(originalValidator);
    }
}
