package org.unitedfront2.web.controller.account;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.Account;
import org.unitedfront2.domain.AccountTable;
import org.unitedfront2.domain.MailAddrAndPassword;
import org.unitedfront2.domain.MailAddrUsedByOtherException;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.FormAction;

/**
 * pX[hύX̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "account.mailAddrChangeAction")
public class MailAddrChangeAction extends FormAction {

    /** spX[h̍ŏ (4) */
    public static final int PASSWORD_MIN_LENGTH = 4;

    /** spX[h̍ő啶 (8) */
    public static final int PASSWORD_MAX_LENGTH = 8;

    /** [ev[g (account.MailAddrChange-mail) */
    public static final String MAIL_ADDR_CHANGE_MAIL_TEMPLATE_NAME
        = "account.MailAddrChange-mail";

    /** AJEge[u */
    @Autowired private AccountTable accountTable;

    @Override
    protected void initAction() {
        super.initAction();
        setMailTemplateName(MAIL_ADDR_CHANGE_MAIL_TEMPLATE_NAME);
        setFormObjectClass(Account.class);
    }

    /**
     * [AhX̕ύXƃpX[h̍Ĕss܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     * @throws MailAddrUsedByOtherException [AhXɎgĂ
     */
    public Event changeMailAddrAndReissuePassword(RequestContext context)
        throws MailAddrUsedByOtherException {

        int id = WebUtils.getAccount(context).getId();
        String newMailAddr = ((Account) getFormObject(context)).getMailAddr();
        String newPassword = Account.createRandomPassword(PASSWORD_MIN_LENGTH,
                PASSWORD_MAX_LENGTH);

        Account newAccount = accountTable.get(id);
        newAccount.setMailAddr(newMailAddr);
        newAccount.setPlainPassword(newPassword);
        newAccount.encrypt();
        try {
            newAccount.store();
        } catch (MailAddrUsedByOtherException e) {
            logger.warn(e.getMessage());
            Errors errors = getBindingErrors(context, newAccount);
            errors.rejectValue("mailAddr",
                    "account.validation.mailAddrUserdByOther",
                    new Object[] {e.getMailAddr()}, e.getMessage());
            throw e;
        }

        context.getRequestScope().put("mailAddrAndPassword",
                new MailAddrAndPassword(newAccount.getMailAddr(), newPassword));

        doSendMail(context);

        WebUtils.setWidgets(WebUtils.getSession(context), null);

        return success();
    }

    /**
     * [AhX̕ύXs܂B
     *
     * @param context NGXgReLXg
     * @return Cxg
     * @throws MailAddrUsedByOtherException [AhXɎgĂ
     */
    public Event changeMailAddr(RequestContext context)
        throws MailAddrUsedByOtherException {

        Account account = (Account) getFormObject(context);
        int id = WebUtils.getAccount(context).getId();
        Account newAccount = accountTable.find(id);
        newAccount.setMailAddr(account.getMailAddr());
        try {
            newAccount.store();
        } catch (MailAddrUsedByOtherException e) {
            logger.warn(e.getMessage());
            Errors errors = getBindingErrors(context, account);
            errors.rejectValue("mailAddr",
                "account.validation.mailAddrUserdByOther",
                new Object[] {e.getMailAddr()}, e.getMessage());
            throw e;
        }

        WebUtils.setWidgets(WebUtils.getSession(context), null);

        return success();
    }

    @Override
    @Resource(name = "account.mailAddrFormValidator")
    public void setValidator(Validator validator) {
        super.setValidator(validator);
    }
}
