package org.unitedfront2.web.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.domain.communication.MessageCodeUsedByOtherException;
import org.unitedfront2.domain.communication.MessageTable;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.controller.message.FormAction;

/**
 * m点XVANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "informationUpdateAction")
public class InformationUpdateAction extends MultiAction {

    /** bZ[We[u */
    @Autowired private MessageTable messageTable;

    /**
     * ݂̂m点tH[ɐݒ肵܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event init(RequestContext context) {
        Message information = messageTable.getByCode(
                WebUtils.SYSTEM_INFORMATION_MESSAGE_CODE);
        context.getFlowScope().put(FormAction.MESSAGE_PARAM_NAME, information);
        context.getFlowScope().put(SubflowUtils.PAGE_TITLE_CODE_PARAM_NAME,
                "InformationUpdateForm");
        context.getFlowScope().put(SubflowUtils.FORM_SUBMIT_CODE_PARAM_NAME,
                "doUpdate");
        context.getFlowScope().put(FormAction.SUBJECT_DISABLED_PARAM_NAME,
                true);
        return success();
    }

    /**
     * m点XV܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event update(RequestContext context) {
        Message message = (Message) context.getFlowScope().get(
                org.unitedfront2.web.controller.message.FormAction
                .MESSAGE_PARAM_NAME);
        try {
            message.store();
        } catch (MessageCodeUsedByOtherException e) {
            logger.error(e);
            throw new IllegalStateException(e);
        }
        return success();
    }
}
