package org.unitedfront2.domain.communication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitedfront2.dao.MailDao;
import org.unitedfront2.domain.AccountTable;
import org.unitedfront2.domain.Domain;
import org.unitedfront2.domain.Identifiable;
import org.unitedfront2.domain.SimpleUser;
import org.unitedfront2.domain.SimpleUserTable;
import org.unitedfront2.domain.Storable;
import org.unitedfront2.domain.User;

/**
 * [NXłB[͂P΂P̃R~jP[Vp̃c[łBe[ɑ΂ĕԐMĂƂŁAXg
 * \Ã[Q`ł܂B[̃XbhƌĂт܂B
 *
 * @author kurokkie
 *
 */
public class Mail implements Identifiable<Mail>, Storable, Serializable,
    Domain {

    /** _ŐƂ̃R[h̒ (32) */
    public static final int GENERATED_CODE_LENGTH = 32;

    /** VAԍ */
    private static final long serialVersionUID = -8522418960016784969L;

    /** _R[hdۂɁAĐčă`W (10) */
    private static final int MAX_CHALLENGE_COUNT = 10;

    /**
     * ƍol̃[UIuWFNg𕜌܂B
     *
     * @param mails [Xg
     * @ensure SẴ[̈Ƀ[UIuWFNgݒ肳B ID 
     * <code>null</code> Ȃݒ肳Ȃ
     * @ensure SẴ[̍olɃ[UIuWFNgݒ肳Bol ID 
     * <code>null</code> Ȃݒ肳Ȃ
     */
    public static void retrieveUsers(List<Mail> mails) {
        for (Mail m : mails) {
            m.retrieveTo();
            m.retrieveFrom();
        }
    }

    /** O */
    protected final transient Log logger = LogFactory.getLog(getClass());

    /** ID */
    private Integer id;

    /** R[h */
    private String code;

    /** ̃[U ID */
    private Integer toId;

    /** ol̃[U ID */
    private Integer fromId;

    /** M */
    private Date sentDate;

    /**  */
    private String subject;

    /** { */
    private String body;

    /** 惆[Uǂ̏ꍇ true AłȂ false */
    private boolean read;

    /** 惆[U */
    private transient SimpleUser to;

    /** ol[U */
    private transient SimpleUser from;

    /** ̃[AhXBۂɃ[𑗐M邽߂̕ϐB */
    private transient String toMailAddr;

    /** ̃[ɑ΂ĕԐM[ */
    private transient Mail next;

    /** [f[^ANZXIuWFNg **/
    private transient MailDao mailDao;

    /** [Ue[u */
    private transient SimpleUserTable simpleUserTable;

    /** AJEge[u */
    private transient AccountTable accountTable;

    public Mail() {
        super();
    }

    public Mail(Integer toId, Integer fromId, String subject, String body) {
        super();
        this.toId = toId;
        this.fromId = fromId;
        this.subject = subject;
        this.body = body;
    }

    public Mail(Integer id, String code, Integer toId, Integer fromId,
            String subject, String body, Date sentDate, boolean read) {
        this(toId, fromId, subject, body);
        this.id = id;
        this.code = code;
        this.sentDate = (Date) sentDate.clone();
        this.read = read;
    }

    @Override
    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(this)
            .append("id", id)
            .append("code", code)
            .append("toId", toId)
            .append("fromId", fromId)
            .append("sentDate", sentDate)
            .append("subject", subject)
            .append("body", body)
            .append("read", read)
            .append("next", next);
        if (to != null) {
            tsb.append("to", to);
        }
        if (from != null) {
            tsb.append("from", from);
        }
        return tsb.toString();
    }

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof Mail)) {
            return false;
        }
        Mail castOther = (Mail) other;
        return new EqualsBuilder()
            .append(id, castOther.id)
            .append(code, castOther.code)
            .append(toId, castOther.toId)
            .append(fromId, castOther.fromId)
            .append(sentDate, castOther.sentDate)
            .append(subject, castOther.subject)
            .append(body, castOther.body)
            .append(read, castOther.read).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder()
            .append(id)
            .append(code)
            .append(toId)
            .append(fromId)
            .append(sentDate)
            .append(subject)
            .append(body)
            .append(read).toHashCode();
    }

    @Override
    public boolean identify(Mail other) {
        if (id == null || other.getId() == null) {
            return false;
        }
        return id.equals(other.getId());
    }

    /**
     * {@link #send()} Ɠl̏łB
     *
     * @see Storable#store()
     */
    @Override
    public void store() {
        send();
    }

    /**
     * ̃[𑗐M܂BR[h͎Ŕs܂BM͌ݓݒ肳܂B
     *
     * @require ${this.toId} is not null.
     * @ensure ${this.code} is auto generated.
     * @ensure ${this.lastUpdateDate} is current date.
     */
    public void send() {
        if (toId == null) {
            String message = "The toId must not be null. Mail[" + this + "]";
            logger.error(message);
            throw new IllegalStateException(message);
        }
        this.code = generateCode();
        this.sentDate = mailDao.getCurrentDate();
        mailDao.register(this);
    }

    private String generateCode() {
        for (int i = 0; i < MAX_CHALLENGE_COUNT; i++) {
            String code = RandomStringUtils.randomAlphanumeric(
                    GENERATED_CODE_LENGTH).toLowerCase(Locale.ENGLISH);
            if (mailDao.findByCode(code) == null) {
                return code;
            }
        }
        String message = "Failed to generate code.";
        logger.error(message);
        throw new IllegalStateException(message);
    }

    /**
     * [ԐM܂BR[h͎Ŕs܂BM͌ݓݒ肳܂B
     *
     * @param parentId e[ ID
     * @require ${this.toId} is not null.
     * @require ${this.fromId} is not null.
     * @ensure ${this.code} is auto generated.
     * @ensure ${this.lastUpdateDate} is current date.
     * @see #store()
     */
    public void send(int parentId) {
        if (toId == null) {
            String message = "The To must not be null. Mail[" + this + "]";
            logger.error(message);
            throw new IllegalStateException(message);
        }
        if (fromId == null) {
            String message = "The from must not be null. Mail[" + this + "]";
            logger.error(message);
            throw new IllegalStateException(message);
        }
        this.code = generateCode();
        this.sentDate = mailDao.getCurrentDate();
        mailDao.register(this, parentId);
    }

    /**
     * ̃[ ${userId} ̏ꍇÃ[ǂɂ܂B
     *
     * @param userId {[U ID
     * @ensure ̃[ ${userId} ̏ꍇÃ[̊/ǏԂf[^x[XƓ
     */
    public void read(int userId) {
        if (userId == toId.intValue()) {
            read = true;
            mailDao.updateRead(id, true);
        }
    }

    /**
     * ̃[Xbh̑SĂ ${userId} ̃[ǂɂ܂B
     *
     * @param userId {[U ID
     * @ensure ̃[Xbh̑SĂ ${userId} ̃[̊/ǏԂf[^x[XƓ
     * 
     */
    public void readAll(int userId) {
        read(userId);
        if (next != null) {
            next.readAll(userId);
        }
    }

    /**
     * ̃[ ${userId} ̏ꍇÃ[𖢓ǂɂ܂B
     *
     * @param userId {[U ID
     * @ensure ̃[ ${userId} ̏ꍇÃ[̊/ǏԂf[^x[XƓ
     */
    public void unread(int userId) {
        if (userId == toId.intValue()) {
            read = false;
            mailDao.updateRead(id, false);
        }
    }

    /**
     * ̃[Xbh̑SĂ ${userId} ̃[𖢓ǂɂ܂B
     *
     * @param userId {[U ID
     * @ensure ̃[Xbh̑SĂ ${userId} ̃[̊/ǏԂf[^x[XƓ
     * 
     */
    public void unreadAll(int userId) {
        unread(userId);
        if (next != null) {
            next.unreadAll(userId);
        }
    }

    /**
     * [Xbhɖǃ[邩ǂ肵܂B
     *
     * @param toId 惆[U ID
     * @return ǂ̃[ <code>true</code> AȂ <code>false</code>
     */
    public boolean hasUnread(int toId) {
        if (toId == this.toId && !isRead()) {
            return true;
        } else {
            return next != null && next.hasUnread(toId);
        }
    }

    /**
     * Xbh̃[擾܂B
     *
     * @return Xbh̃[
     */
    public int getCount() {
        int count = 1;
        if (next != null) {
            count += next.getCount();
        }
        return count;
    }

    /**
     * [Xbhe珇̃XgƂĕԂ܂B
     *
     * @return [Xg
     */
    public List<Mail> asList() {
        List<Mail> list = new ArrayList<Mail>(getCount());
        addToList(list, this);
        return list;
    }

    private void addToList(List<Mail> list, Mail mail) {
        list.add(mail);
        if (mail.next != null) {
            addToList(list, mail.next);
        }
    }

    /**
     * [Xbhq珇̃XgƂĕԂ܂B
     *
     * @return [Xg
     */
    public List<Mail> asListDesc() {
        List<Mail> list = asList();
        Collections.reverse(list);
        return list;
    }

    /**
     * [ɈʒuTu[Ԃ܂BTu[ݒ肳ĂȂꍇ͎gԂ܂B
     *
     * @return [̃[
     */
    public Mail getTail() {
        Mail mail = this;
        while (mail.getNext() != null) {
            mail = mail.getNext();
        }
        return mail;
    }

    /**
     * <code>user</code> ɂƂĂ̒ʐMԂ܂B<code>user</code> ͂̃[̈
     * ܂͍olɊ܂܂ĂKv܂B
     *
     * @param user [U
     * @require ${this.to} not null.
     * @require ${this.from} not null.
     * @return ʐM
     */
    public SimpleUser other(User user) {
        if (user.identify(to)) {
            return from;
        } else if (user.identify(from)) {
            return to;
        } else {
            throw new IllegalArgumentException("The user '" + user
                + "' is neither TO or FROM.");
        }
    }

    /**
     * ${this.toId} ݒ肳Ă΁A${this.to} ɒlݒ肵܂B
     */
    public void retrieveTo() {
        if (this.toId != null) {
            this.to = simpleUserTable.find(this.toId);
        }
    }

    /**
     * 惆[Ũ[AhX𕜌܂B${this.to} ĂȂΕ܂B
     */
    public void retrieveToMailAddr() {
        if (to == null) {
            retrieveTo();
        }
        this.toMailAddr = accountTable.find(to.getId()).getMailAddr();
    }

    /**
     * ${this.fromId} ݒ肳Ă΁A${this.from} ɒlݒ肵܂B
     */
    public void retrieveFrom() {
        if (this.fromId != null) {
            this.from = simpleUserTable.find(this.fromId);
        }
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getToId() {
        return toId;
    }

    public void setToId(Integer toId) {
        this.toId = toId;
    }

    public Integer getFromId() {
        return fromId;
    }

    public void setFromId(Integer fromId) {
        this.fromId = fromId;
    }

    public Date getSentDate() {
        if (sentDate == null) {
            return null;
        } else {
            return (Date) sentDate.clone();
        }
    }

    public void setSentDate(Date sentDate) {
        if (sentDate == null) {
            this.sentDate = null;
        } else {
            this.sentDate = (Date) sentDate.clone();
        }
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public boolean isRead() {
        return read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public SimpleUser getTo() {
        return to;
    }

    public void setTo(SimpleUser to) {
        this.to = to;
    }

    public SimpleUser getFrom() {
        return from;
    }

    public void setFrom(SimpleUser from) {
        this.from = from;
    }

    public String getToMailAddr() {
        return toMailAddr;
    }

    public void setToMailAddr(String toMailAddr) {
        this.toMailAddr = toMailAddr;
    }

    public Mail getNext() {
        return next;
    }

    public void setNext(Mail next) {
        this.next = next;
    }

    public void setMailDao(MailDao mailDao) {
        this.mailDao = mailDao;
    }

    public void setSimpleUserTable(SimpleUserTable simpleUserTable) {
        this.simpleUserTable = simpleUserTable;
    }

    public void setAccountTable(AccountTable accountTable) {
        this.accountTable = accountTable;
    }
}
