package org.unitedfront2.dao.jdbc;

import org.springframework.stereotype.Repository;
import org.unitedfront2.dao.SelfIntroductionDao;

/**
 * {@link SelfIntroductionDao} ̎łB
 *
 * @author kurokkie
 *
 */
@Repository(value = "selfIntroductionDao")
public class SelfIntroductionDaoImpl extends DaoSupport
    implements SelfIntroductionDao {

    @Override
    public int findMessageId(int ownerId) {
        return getSimpleJdbcTemplate().queryForInt(
                "SELECT MessageId FROM SelfIntroduction WHERE OwnerId = ?",
                ownerId);
    }

    @Override
    public void register(int ownerId, int messageId) {
        getSimpleJdbcTemplate().update(
                "INSERT INTO SelfIntroduction(OwnerId, MessageId) VALUES(?, ?)",
                ownerId, messageId);
    }
}
