package org.unitedfront2.domain.communication;

import java.util.Locale;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitedfront2.domain.accesscontrol.AccessControl;
import org.unitedfront2.domain.accesscontrol.OwnerOnly;
import org.unitedfront2.domain.accesscontrol.UserOnly;
import org.unitedfront2.test.TransactionalTestCaseWithInitialData;

public class CommunityTableTest extends TransactionalTestCaseWithInitialData {

    @Autowired private CommunityTable communityTable;

    @Test
    public void testFindVOXbhR~jeB() throws CommunityCodeUsedByOtherException {
        Community c = createCommunity(SingleThreadCommunity.class, 0);
        c.store();
        Community actual = communityTable.find(c.getId());
        Assert.assertEquals(c, actual);
        Assert.assertSame(SingleThreadCommunity.class, actual.getClass());
    }

    @Test
    public void testFind}`XbhR~jeB() throws CommunityCodeUsedByOtherException {
        Community c = createCommunity(MultiThreadCommunity.class, 0);
        c.store();
        Community actual = communityTable.find(c.getId());
        Assert.assertEquals(c, actual);
        Assert.assertSame(MultiThreadCommunity.class, actual.getClass());
    }

    private Community createCommunity(Class<? extends Community> clazz, int no) {
        AccessControl readAccessControl = domainFactory.prototype(UserOnly.class);
        AccessControl writeAccessControl = domainFactory.prototype(OwnerOnly.class);
        Community c = domainFactory.prototype(clazz);
        c.setCode("community-" + no);
        c.setOverview(createOverview(readAccessControl, writeAccessControl));
        c.setOwnerId(simpleUser1.getId());
        c.setReadAccessControl(readAccessControl);
        c.setWriteAccessControl(writeAccessControl);
        c.setPostAccessControl(domainFactory.prototype(UserOnly.class));
        return c;
    }

    private Message createOverview(AccessControl readAccessControl, AccessControl writeAccessControl) {
        Message o = domainFactory.prototype(new Message(null, null, simpleUser1.getId(), simpleUser1.getId(), readAccessControl, writeAccessControl));
        o.setSubject("eXgR~jeB", Locale.JAPANESE);
        o.setBody("̓eXgR~jeBłB", Locale.JAPANESE);
        return o;
    }
}
