<%@ page language="java" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/view/Include.jsp" %>
<div>

  <!-- Status Bar -->
  <div id="statusBar">
    <spring:message code="blog"/> &gt; <spring:message code="blog.EntryView.title"/>
  </div>

  <!-- Blog Overview -->
  <h4><a href="<c:url value="/blog/${blog.code}/index.html"/>"><uf2:messageSubject message="${blog.overview}"/></a></h4>
  <p class="smaller"><uf2:messageBody message="${blog.overview}"/></p>
  <div class="align-right smaller">
    <spring:message code="by"/>&nbsp;<uf2:user user="${blog.owner}"/>
  </div>

  <!-- Entry -->
  <div>
    <div>
      <h2><uf2:messageSubject message="${entry.entry}"/></h2>
      <p><uf2:messageBody message="${entry.entry}"/></p>
      <div>
        <table border="1" class="float-right smaller">
          <tr>
            <th><spring:message code="registrationDate"/></th>
            <td><uf2:formatDate date="${entry.registrationDate}" detail="true"/></td>
          </tr>
          <tr>
            <th><spring:message code="lastUpdateDate"/></th>
            <td><uf2:formatDate date="${entry.lastUpdateDate}" detail="true"/></td>
          </tr>
        </table>
        <div class="float-clear"></div>
      </div>
      <uf2:identity o2="${entry.owner}" o1="${_user}">
        <div class="margin-top">
          <div class="align-right">
            <a href="<c:url value="/blog/${blog.code}/entry-${entry.code}/update.html"/>"><spring:message code="blog.EntryView.updateLink"/></a>
          </div>
          <form action="<c:url value="/blog/entryDelete.html"/>" method="post" onsubmit="return confirm('<spring:message code="blog.EntryView.deleteLink.confirm"/>');" class="align-right">
            <input type="hidden" name="blogCode" value="${blog.code}"/>
            <input type="hidden" name="entryCode" value="${entry.code}"/>
            <input type="submit" name="" value="<spring:message code="blog.EntryView.deleteLink"/>"/>
          </form>
        </div>
      </uf2:identity>
    </div>
  </div>

  <!-- Comment -->
  <div>
    <c:if test="${canComment or not empty entry.comments}">
    <a name="comment"></a>
    <h3><spring:message code="comment"/></h3>
    </c:if>
    <c:if test="${canComment}">
    <div id="commentLink"><a href="javascript:enableCommentForm();"><spring:message code="blog.EntryView.commentPostLink"/></a></div>
    <form:form id="commentForm" commandName="comment">
      <input type="hidden" name="_eventId" value="submit"/>
      <input type="hidden" name="_flowExecutionKey" value="${flowExecutionKey}"/>
      <div class="element">
        <form:textarea path="text" rows="5" cols="40"/>
      </div>
      <div class="element">
        <input type="submit" value="<spring:message code="doPost"/>" class="button" onclick="this.disabled='disabled';this.form.submit();"/>
      </div>
    </form:form>
    </c:if>
    <c:forEach var="comment" items="${entry.comments}">
    <div class="radius border padding margin-top">
      <a name="comment${comment.id}"></a>
      <div class="smaller">
        <div class="thin float-left">
          <uf2:formatDate date="${comment.lastUpdateDate}" detail="true"/>
        </div>
        <div class="float-right">
          <uf2:identity o2="${blog.owner}" o1="${_user}">
            <form action="<c:url value="/blog/commentDelete.html"/>" mathod="post" onsubmit="return confirm('<spring:message code="blog.EntryView.comment.deleteConfirm"/>');">
              <input type="hidden" name="blogCode" value="${blog.code}"/>
              <input type="hidden" name="entryCode" value="${entry.code}"/>
              <input type="hidden" name="commentId" value="${comment.id}"/>
              <input type="submit" name="" value="<spring:message code="delete"/>"/>
            </form>
          </uf2:identity>
        </div>
        <div class="float-clear"></div>
      </div>
      <p><uf2:multiLine value="${comment.text}"/></p>
      <div class="align-right smaller">
        <spring:message code="by"/>&nbsp;<uf2:user user="${comment.commenter}"/>
      </div>
    </div>
    </c:forEach>
  </div>
  <uf2:script>
  document.getElementById("commentForm").style.display = "none";
  function enableCommentForm() {
      document.getElementById('commentForm').style.display = '';
      document.getElementById('commentLink').style.display = 'none';
      document.getElementById('commentForm').text.focus();
  }
  </uf2:script>

</div>
