<%@ page language="java" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/view/Include.jsp" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">

<tiles:importAttribute name="cssCodes"/>
<tiles:importAttribute name="cssNames"/>
<tiles:importAttribute name="dojoRequires"/>
<tiles:importAttribute name="focusedInputId"/>

<html lang="${_locale.language}">
<head>
  <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <uf2:pc><meta http-equiv="content-style-type" content="text/css"></uf2:pc>
  <uf2:pc><meta name="description" content="<spring:message code="Layout.description"/>"></uf2:pc>
  <uf2:pc><meta name="keywords" content="<spring:message code="Layout.keywords"/>"></uf2:pc>
  <title><spring:message code="Layout.title"/><c:if test="${not empty title}"> - <c:out value="${title}"/></c:if></title>
  <uf2:pc><link rel="shortcut icon" href="<c:url value="/favicon.ico"/>"></uf2:pc>
  <uf2:pc>
  <c:if test="${_theme != 'none'}">
  <style type="text/css">
    @import "<c:url value="/theme/${_theme}/common.css"/>";
    @import "<c:url value="/theme/${_theme}/layout.css"/>";
    <c:forEach var="code" items="${cssCodes}">
    @import "<%= request.getContextPath() %><spring:theme code="${code}"/>";
    </c:forEach>
    <c:forEach var="cssName" items="${cssNames}">
    @import "<c:url value="/theme/${_theme}/${cssName}.css"/>";
    </c:forEach>
  </style>
  </c:if>
  <c:if test="${not empty _feedUrl}">
    <link rel="alternate" type="application/rss+xml" title="RSS 2.0" href="<c:url value="${_feedUrl}"/>"/>
  </c:if>
  <script type="text/javascript" src="<c:url value="/js/dojo/dojo/dojo.js"/>" djConfig="parseOnLoad: true, isDebug: ${_dojoDebug}"></script>
  <script type="text/javascript">
    <c:forEach var="package" items="${dojoRequires}">
      dojo.require("${package}");
    </c:forEach>
  </script>
  </uf2:pc>
</head>
<body id="layout">
<!-- Header -->
<div id="layoutHeader">
  <h1 class="float-left"><a href="<c:url value="/index.html"/>"><spring:message code="Layout.title"/></a></h1>
  <uf2:pc>
  <table class="float-right margin-right smaller">
    <tr>
      <th><spring:message code="Layout.header.terminal"/></th>
      <td>
        <form action="" method="POST">
          <select name="terminal" class="smaller" onchange="this.form.submit();">
            <option value="pc"<uf2:pc> selected</uf2:pc>><spring:message code="Layout.header.terminal.pc"/></option>
            <option value="mobile"<uf2:mobile> selected</uf2:mobile>><spring:message code="Layout.header.terminal.mobile"/></option>
          </select>
        </form>
      </td>
    </tr>
    <tr>
      <th><spring:message code="Layout.header.design"/></th>
      <td>
        <form action="" method="POST">
          <select name="theme" class="smaller" onchange="this.form.submit();">
            <option value="default"<c:if test="${_theme == 'default'}"> selected</c:if>><spring:message code="Layout.header.design.default"/></option>
            <option value="none"<c:if test="${_theme == 'none'}"> selected</c:if>><spring:message code="Layout.header.design.none"/></option>
          </select>
        </form>
      </td>
    </tr>
    <tr>
      <th><spring:message code="Layout.header.language.title"/></th>
      <td>
        <form action="" method="POST">
          <select name="locale" class="smaller" onchange="this.form.submit();">
            <option value="ja"<c:if test="${_locale.language == 'ja'}"> selected</c:if>><spring:message code="language.ja"/></option>
            <option value="en"<c:if test="${_locale.language == 'en'}"> selected</c:if>><spring:message code="language.en"/></option>
          </select>
        </form>
      </td>
    </tr>
  </table>
  </uf2:pc>
</div>

<uf2:mobile><hr></uf2:mobile>

<!-- Menu -->
<div id="layoutMenu">
  <div>
    <ul>
      <security:authorize ifAnyGranted="ROLE_USER,ROLE_ADMIN"><li class="float-left"><a href="<c:url value="/mail/index.html"/>"><spring:message code="mail"/></a></li></security:authorize>
      <security:authorize ifAnyGranted="ROLE_USER,ROLE_ADMIN"><li class="float-left"><a href="<c:url value="/profile/${_user.code}/index.html"/>"><spring:message code="profile"/></a></li></security:authorize>
      <security:authorize ifAnyGranted="ROLE_USER,ROLE_ADMIN"><li class="float-left"><a href="<c:url value="/blog/index.html"/>"><spring:message code="blog"/></a></li></security:authorize>
      <security:authorize ifAnyGranted="ROLE_USER,ROLE_ADMIN"><li class="float-left"><a href="<c:url value="/community/index.html"/>"><spring:message code="community"/></a></li></security:authorize>
      <security:authorize ifNotGranted="ROLE_USER,ROLE_ADMIN"><li class="float-left"><a href="<c:url value="/registration.html"/>"><spring:message code="Registration"/></a></li></security:authorize>
      <security:authorize ifNotGranted="ROLE_USER,ROLE_ADMIN"><li class="float-left"><a href="<c:url value="/account/passwordReissue.html"/>"><spring:message code="account.PasswordReissueForm"/></a></li></security:authorize>
      <c:if test="${not _usingEmail}"><security:authorize ifAnyGranted="ROLE_ADMIN"><li class="float-left"><a href="<c:url value="/account/passwordReissueByAdmin.html"/>"><spring:message code="account.PasswordReissueByAdminForm"/></a></li></security:authorize></c:if>
      <security:authorize ifAnyGranted="ROLE_USER,ROLE_ADMIN"><li class="float-right"><a href="<c:url value="/settings.html"/>"><spring:message code="Settings"/></a></li></security:authorize>
      <li class="float-right"><a href="<c:url value="/mail/inquiry.html"/>"><spring:message code="mail.InquiryForm"/></a></li>
    </ul>
  </div>
</div>

<uf2:mobile><hr></uf2:mobile>

<!-- Main -->
<div id="layoutMain" class="overflow-hidden">

  <!-- Content -->
  <div id="layoutContent">
    <div id="layoutInnerContent">
      <uf2:pc>
      <div class="overflow-hidden"><jsp:include page="/theme/${_theme}/Banner_top.jsp" flush="true"/></div>
      </uf2:pc>
      <uf2:mobile>
      <div><jsp:include page="/theme/Banner_mobile.jsp" flush="true"/></div>
      </uf2:mobile>
      <div id="layoutBody">
        <tiles:insertAttribute name="body"/>
      </div>
    </div>
  </div>

  <!-- Side Bar -->
  <div id="layoutSideBar">
    <div id="layoutInnerSideBar">
      <uf2:pc>
        <security:authorize ifAnyGranted="ROLE_USER,ROLE_ADMIN">
      <div class="smaller margin align-center"><spring:message code="Layout.welcome.message" arguments="${_user.name}"/></div>
        </security:authorize>
      </uf2:pc>
      <security:authorize ifNotGranted="ROLE_USER,ROLE_ADMIN">
        <tiles:insertAttribute name="loginForm"/>
      </security:authorize>

      <!-- Widgets -->
      <tiles:insertAttribute name="widget.INFORMATION"/>
      <uf2:pc>
      <security:authorize ifAnyGranted="ROLE_USER,ROLE_ADMIN">
      <hr>
      </security:authorize>
      <c:forEach var="widget" items="${widgets}" varStatus="status">
        <c:if test="${status.index % 5 == 4}">
        <div class="overflow-hidden align-center">
          <jsp:include page="/theme/${_theme}/Banner_widget.jsp" flush="true"/>
        </div>
        </c:if>
        <tiles:insertAttribute name="widget.${widget}"/>
      </c:forEach>
      <security:authorize ifAnyGranted="ROLE_USER,ROLE_ADMIN">
      <div class="margin smaller align-center"><a href="<c:url value="/widget/update.html"/>"><spring:message code="Layout.changeWidget"/></a></div>
      <hr>
      </security:authorize>
      </uf2:pc>

      <!-- LogoutForm -->
      <uf2:mobile><hr></uf2:mobile>
      <security:authorize ifAnyGranted="ROLE_USER,ROLE_ADMIN">
        <tiles:insertAttribute name="logoutForm"/>
      </security:authorize>
    </div>
  </div>
</div>

<!-- Bottom Space -->
<div id="layoutBottom" class="overflow-hidden">
  <uf2:pc>
  <div><jsp:include page="/theme/${_theme}/Banner_bottom.jsp" flush="true"/></div>
  </uf2:pc>
</div>

<!-- Footer -->
<div id="layoutFooter">
  <uf2:pc>
  <div id="layoutInnerFooter">
  <div><spring:message code="Layout.footer.unitedfront2.appname" arguments="${_version}"/></div>
  <div><spring:message code="Layout.footer.unitedfront2.copyright"/></div>
  </div>
  </uf2:pc>
</div>
<uf2:script>
<c:if test="${not empty focusedInputId}">
  if (document.getElementById('${focusedInputId}') != null) {
      document.getElementById('${focusedInputId}').focus();
  }
</c:if>
</uf2:script>

</body>
</html>
