package org.unitedfront2.web.tags;

import java.io.IOException;
import java.io.Writer;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.commons.lang.SystemUtils;
import org.springframework.web.util.HtmlUtils;

/**
 * seLXgo͗p̃^OCułB\񕶎GXP[vAs̑O BR ^O}܂B
 *
 * @author kurokkie
 *
 */
public class MultiLineTag extends TagSupport {

    /** VAԍ */
    private static final long serialVersionUID = -5933370156184960848L;

    /** ϊΏۂ̕ */
    private String value;

    @Override
    public int doStartTag() throws JspException {
        String text = HtmlUtils.htmlEscape(value);
        text = text.replace(SystemUtils.LINE_SEPARATOR,
                "<br/>" + SystemUtils.LINE_SEPARATOR);
        Writer out = pageContext.getOut();
        try {
            out.write(text);
        } catch (IOException e) {
            throw new JspException(e);
        }
        return SKIP_BODY;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
