package org.unitedfront2.web.mail;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.apache.commons.jexl.parser.ParseException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.mail.SimpleMailMessage;
import org.xml.sax.SAXException;

/**
 * JEXL  XML [ev[gɋLqł郁[MGWłB
 * pbP[WɔzĂ email-rules.xml  XML [ev[g̒` Apache
 * Commons Digester ̒`ŋLqĂ܂B
 * [M Spring  {@link org.springframework.mail.MailSender} 𗘗pĂ܂B
 * <p>
 *
 * ev[gt@C͎̏ɂȂ܂B
 * <blockquote>
 * <i>pbP[W</i>.<i>t@C</i>_<i></i>.xml
 * </blockquote>
 *
 * <i>pbP[W</i>.<i>t@C</i> ̕[ev[gƌĂł܂B<p>
 *
 * Ⴆ΁Aorg.unitedfront2.mail
 * pbP[W Mail_ja.xml zuꍇ {@link #setMailTemplateName(String)} 
 * org.unitedfront2.mail.Mail ݒ肵܂B<p>
 *
 * ev[gt@C͈ȉ̏ŋLq܂B<br/>
 *
 * <blockquote>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;<br/>
 * &lt;email to="<i></i>" bcc="<i>Z~R؂BCC</i>"
 *     from="<i>ol</i>"&gt;<br/>
 * &nbsp;&nbsp;&lt;subject&gt;<i></i>&lt;/subject&gt;<br/>
 * &nbsp;&nbsp;&lt;text&gt;<i>{</i>&lt;/text&gt;<br/>
 * &lt;/email&gt;
 * </blockquote>
 *
 * fɑ΂Ă Commons JEXL ŃANZXł܂B<p>
 *
 * ݒ
 * <blockquote>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;<br/>
 * &lt;email to="${user.mailAddr}"
 *     bcc="bcc1@example.com; bcc2@example.com"&gt;<br/>
 * &nbsp;&nbsp;&lt;subject&gt;悤&lt;/subject&gt;<br/>
 * &nbsp;&nbsp;&lt;text&gt;悤 ${user.name} B&lt;/text&gt;<br/>
 * &lt;/email&gt;
 * </blockquote>
 *
 * @author kurokkie
 *
 * @see <a href="http://jakarta.apache.org/commons/jexl/">Commons
 *     JEXL Overview</a>
 *
 */
public class XmlTemplateSpringMailSender implements MailSender {

    /** ǂݍ񂾃[ݒt@CURL */
    private static final URL RULES;
    static {
        Log logger
            = LogFactory.getLog(XmlTemplateSpringMailSender.class);
        String ruleFilePath = '/'
            + XmlTemplateSpringMailSender.class.getPackage().getName()
                .replace('.', '/') + "/email-rules.xml";
        if (logger.isInfoEnabled()) {
            logger.info("Set rules [" + ruleFilePath + "]");
        }
        RULES = XmlTemplateSpringMailSender.class
            .getResource(ruleFilePath);
    }

    /** Oo */
    protected final Log logger = LogFactory.getLog(getClass());

    /** [ev[gXMLt@C̖O */
    private String mailTemplateName;

    /** Spring ̃[MGW */
    private org.springframework.mail.MailSender mailSender;

    /** ̐ړ */
    private String subjectPrefix;

    /**  */
    private String signature;

    /** [bZ[W؃NX */
    private SimpleMailMessageValidator simpleMailMessageValidator;

    public XmlTemplateSpringMailSender() {
        super();
    }

    public XmlTemplateSpringMailSender(String mailTemplateName) {
        this.mailTemplateName = mailTemplateName;
    }

    /**
     * w肵̃[ev[gT|[gĂ邩ǂ肵܂B
     *
     * @param mailTemplateName [ev[g
     * @return T|[gĂȂ <code>true</code> AĂȂȂ <code>false</code>
     */
    public boolean supports(String mailTemplateName) {
        return this.mailTemplateName.equals(mailTemplateName);
    }

    @Override
    public void send(Map<String, Object> model, Locale locale)
        throws MailSendException {
        SimpleMailMessage message;
        if (locale != null) {
            message = parseMailTemplate(locale);
        } else {
            message = parseMailTemplate(Locale.getDefault());
        }
        if (subjectPrefix != null) {
            message.setSubject(subjectPrefix + message.getSubject());
        }
        if (signature != null) {
            message.setText(message.getText() + signature);
        }
        message = evaluate(message, model);
        simpleMailMessageValidator.validate(message);
        logger.debug(message);
        try {
            mailSender.send(message);
        } catch (org.springframework.mail.MailSendException e) {
            logger.error(e.getMessage(), e);
            throw new MailSendException(e);
        }
    }

    /**
     * [ev[g߂A[bZ[WԂ܂B
     *
     * @param mailTemplateName
     * @param locale
     * @return [bZ[W
     */
    private SimpleMailMessage parseMailTemplate(Locale locale)
        throws IllegalArgumentException {

        Digester digester = DigesterLoader.createDigester(RULES);

        List<SimpleMailMessage> emails = new ArrayList<SimpleMailMessage>(1);
        digester.push(emails);

        URL input = getUrl(locale);
        try {
            if (logger.isInfoEnabled()) {
                logger.info("Parse input file [" + input.getPath() + "]");
            }
            digester.parse(input);
        } catch (IOException e) {
            logger.error(e.getMessage(), e);
            throw new IllegalStateException(e);
        } catch (SAXException e) {
            logger.error(e.getMessage(), e);
            throw new IllegalStateException(e);
        }

        if (emails.isEmpty()) {
            throw new IllegalStateException("This e-Mail is empty.");
        }

        SimpleMailMessage message = (SimpleMailMessage) emails.get(0);
        if (!ArrayUtils.isEmpty(message.getTo())) {
            message.setTo(StringUtils.split(message.getTo()[0], " ;"));
        }
        if (!ArrayUtils.isEmpty(message.getBcc())) {
            message.setBcc(StringUtils.split(message.getBcc()[0], " ;"));
        }
        if (!ArrayUtils.isEmpty(message.getCc())) {
            message.setCc(StringUtils.split(message.getCc()[0], " ;"));
        }

        return message;
    }

    /**
     * XML t@Cւ URL 擾܂B
     *
     * @param locale {@link Locale}
     * @return XML t@C URL
     * @throws IllegalArgumentException XML t@C݂Ȃ
     */
    protected URL getUrl(Locale locale) throws IllegalArgumentException {
        String path = "/" + mailTemplateName.replace(".", "/") + "_"
            + locale.getLanguage() + ".xml";
        URL input = XmlTemplateSpringMailSender.class.getResource(path);
        if (input == null) {
            String message = "The template file '" + path + "' not found.";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        return input;
    }

    /**
     * <code>message</code> ɋLqĂ ${} ̒g JEXL ŕ]܂B
     *
     * @param message [bZ[W
     * @param model f
     * @return ]̃[bZ[W
     * @see #evaluate(String, JexlContext)
     */
    private SimpleMailMessage evaluate(SimpleMailMessage message,
        Map<String, Object> model) {

        JexlContext context = JexlHelper.createContext();
        context.setVars(model);

        message.setTo(evaluate(message.getTo(), context));
        message.setBcc(evaluate(message.getBcc(), context));
        message.setCc(evaluate(message.getCc(), context));
        if (message.getFrom() != null) {
            message.setFrom(evaluate(message.getFrom(), context));
        }
        message.setSubject(evaluate(message.getSubject(), context));
        if (StringUtils.isNotBlank(message.getText())) {
            message.setText(evaluate(message.getText(), context));
        }

        return message;
    }

    private String[] evaluate(String[] values, JexlContext context) {
        if (values != null) {
            List<String> list = new ArrayList<String>(values.length);
            for (String v : values) {
                String result = evaluate(v, context);
                if (result != null) {
                    list.add(result);
                }
            }
            return list.toArray(new String[list.size()]);
        } else {
            return new String[0];
        }
    }

    /**
     * <code>expression</code> ɋLqĂ ${} ̒g@JEXL@ŕ]܂B
     *
     * @param expression ]Ώە
     * @param context JEXL ReLXg
     * @return@]̕A]̕񂪋󕶎̏ꍇ null
     */
    private String evaluate(String expression, JexlContext context)
        throws IllegalArgumentException {

        Pattern pattern = Pattern.compile("\\$\\{([^\\{\\}]*)\\}");
        Matcher matcher = pattern.matcher(expression);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String match = matcher.group(1);
            String message;
            try {
                Expression expr
                    = ExpressionFactory.createExpression(match);
                Object o = expr.evaluate(context);
                if (o == null) {
                    message = "";
                } else {
                    message = o.toString();
                }
            } catch (ParseException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn(e.getMessage(), e);
                } else if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), e);
                }
                message = "";
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                throw new IllegalArgumentException(e);
            }
            matcher.appendReplacement(sb, message);
        }
        matcher.appendTail(sb);
        String result = sb.toString();
        if (StringUtils.isBlank(result)) {
            return null;
        } else {
            return result;
        }
    }

    protected org.springframework.mail.MailSender getMailSender() {
        return mailSender;
    }

    public void setMailSender(org.springframework.mail.MailSender mailSender) {
        this.mailSender = mailSender;
    }

    public String getMailTemplateName() {
        return mailTemplateName;
    }

    public void setMailTemplateName(String mailTemplateName) {
        this.mailTemplateName = mailTemplateName;
    }

    public void setSubjectPrefix(String subjectPrefix) {
        this.subjectPrefix = subjectPrefix;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setSimpleMailMessageValidator(
        SimpleMailMessageValidator simpleMailMessageValidator) {

        this.simpleMailMessageValidator = simpleMailMessageValidator;
    }
}
