package org.unitedfront2.web.controller.mail;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.validation.Errors;
import org.unitedfront2.domain.SimpleUserTable;
import org.unitedfront2.domain.communication.Mail;
import org.unitedfront2.domain.communication.MailValidator;
import org.unitedfront2.validation.SpringValidatorSupport;
import org.unitedfront2.validation.Validate;
import org.unitedfront2.validation.ValidationException;

/**
 * [쐬tH[̌؃NXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "mail.createValidator")
public class CreateValidator
    extends SpringValidatorSupport<MailValidator, Mail> {

    /** [Ue[u */
    @Autowired private SimpleUserTable simpleUserTable;

    @Override
    protected void doValidate(Mail mail, Errors errors) {
        try {
            getOriginalValidator().validateSubject(mail);
        } catch (ValidationException e) {
            rejectValue("subject", e, errors);
        }

        try {
            Validate.notNull(mail.getTo());
            Validate.notBlank(mail.getTo().getName());
            if (!simpleUserTable.existsByName(mail.getTo().getName())) {
                errors.rejectValue("to.name",
                        "mail.CreateForm.validation.error.toUserNotFound");
            }
        } catch (ValidationException e) {
            rejectValue("to.name", e, errors);
        }
    }

    @Override
    @Autowired
    public void setOriginalValidator(MailValidator originalValidator) {
        super.setOriginalValidator(originalValidator);
    }
}
