package org.unitedfront2.web.controller.community;

import java.util.Collections;
import java.util.Comparator;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.web.util.HtmlUtils;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.CommunityTable;
import org.unitedfront2.domain.communication.MultiThreadCommunity;
import org.unitedfront2.domain.communication.SingleThreadCommunity;
import org.unitedfront2.domain.communication.Thread;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.flow.AccessDeniedException;
import org.unitedfront2.web.flow.PageNotFoundException;
import org.unitedfront2.web.handler.TitleInterceptor;
import org.unitedfront2.web.tags.PagingTag;

/**
 * R~jeB{ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "community.viewAction")
public class ViewAction extends MultiAction {

    /** VOXbh̏ꍇAPy[Wɕ\L */
    public static final int DISPLAY_COUNT = PagingTag.DEFAULT_DISPLAY_COUNT;

    /** R~jeBe[u */
    @Autowired private CommunityTable communityTable;

    /**
     * R~jeBʂ̕\s܂B
     *
     * @param context {@link RequestContext}
     * @return {@link SingleThreadCommunity} Ȃ 'SingleThreadCommunity' Ԃ
     * B
     * @throws PageNotFoundException y[W݂Ȃ
     * @throws AccessDeniedException {Ȃ
     */
    public Event view(RequestContext context)
        throws PageNotFoundException, AccessDeniedException {
        Community c = Utils.findCommunityAndReadAccess(context, this,
                communityTable, "code");

        // L҂̕
        c.retrieveOwner();

        // Tv̒҂̕
        c.getOverview().retrieveAuthor();
        c.getOverview().getAuthor().retrieveProfile();

        // }CR~jeB̕
        c.retrieveMyCommunity(WebUtils.findUser(context));

        context.getFlowScope().put("community", c);
        context.getRequestScope().put("community", c);
        context.getRequestScope().put(
                TitleInterceptor.TITLE_CODE_PARAM_NAME, "community.View.title");
        context.getRequestScope().put(
                TitleInterceptor.TITLE_ARGS_PARAM_NAME,
                new Object[] {
                        HtmlUtils.htmlEscape(c.getOverview().getSubject(
                                WebUtils.getLocale(context))),
                });
        context.getRequestScope().put("_feedUrl", "/community/"
                + c.getCode() + "/index.xml");
        return result(c.getClass().getSimpleName());
    }

    /**
     * VOXbhR~jeB̕\s܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @throws PageNotFoundException y[W݂Ȃ
     */
    public Event viewSingleThreadCommunity(RequestContext context)
        throws PageNotFoundException {
        SingleThreadCommunity c = (SingleThreadCommunity) context.getFlowScope()
            .get("community");
        c.retrieveThread();

        // \͈͂̌
        int page = context.getRequestParameters().getInteger("page", 0);
        c.retrieveEntries(page * DISPLAY_COUNT, DISPLAY_COUNT);
        c.retrieveCount();
        if (c.getEntries().size() == 0 && c.getCount() > 0) {
            String message = "The page " + page + " not found.";
            logger.warn(message);
            throw new PageNotFoundException(context, this, message);
        }

        // L̒҂̕
        c.retrieveEntryAuthors();

        context.getRequestScope().put("displayCount", DISPLAY_COUNT);

        return success();
    }

    /**
     * }`XbhR~jeB\܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event viewMultiThreadCommunity(RequestContext context) {
        MultiThreadCommunity c = (MultiThreadCommunity) context.getFlowScope()
            .get("community");
        c.retrieveThreads();
        Thread.retrieveLastUpdateDate(c.getThreads());
        Collections.sort(c.getThreads(), new Comparator<Thread>() {
            @Override
            public int compare(Thread t1, Thread t2) {
                return t2.getLastUpdateDate().compareTo(t1.getLastUpdateDate());
            }
        });
        return success();
    }
}
