package org.unitedfront2.web.controller.community;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.stereotype.Repository;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.CannotChangeCommunityException;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.CommunityCodeUsedByOtherException;
import org.unitedfront2.domain.communication.MultiThreadCommunity;
import org.unitedfront2.domain.communication.SingleThreadCommunity;
import org.unitedfront2.web.controller.SubflowUtils;
import org.unitedfront2.web.flow.BadRequestException;

/**
 * R~jeB쐬/ҏWp̃ANVNXłBR[hȊO͕ҏWł܂B
 *
 * @author kurokkie
 *
 */
@Repository(value = "community.formAction")
public class FormAction extends org.unitedfront2.web.controller.FormAction {

    /** t[XR[vɐݒ肷R~jeBIuWFNg̕ϐ (community) */
    public static final String COMMUNITY_PARAM_NAME = "community";

    /** ʑJڂ̍Ō̉ʂ̃{^̃bZ[WR[h̕ϐ (lastSubmitCode) */
    public static final String LAST_SUBMIT_CODE_PARAM_NAME = "lastSubmitCode";

    /** R~jeBhCpbP[W */
    private static final String COMMUNITY_PACKAGE
        = "org.unitedfront2.domain.communication";

    @Override
    protected void initAction() {
        super.initAction();
        setFormObjectClass(SingleThreadCommunity.class);
        setFormObjectName(COMMUNITY_PARAM_NAME);
    }

    @Override
    protected void initBinder(RequestContext context, DataBinder binder) {
        super.initBinder(context, binder);
        binder.setAllowedFields(new String[] {"code"});
    }

    /**
     * s܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    @Override
    public Event init(RequestContext context) {
        super.init(context);
        context.getFlowScope().put("formReadAccessControlDescription",
                "community.FormAction.formReadAccessControl.description");
        context.getFlowScope().put("formPostAccessControlDescription",
                "community.FormAction.formPostAccessControl.description");
        context.getFlowScope().put("formMessageDescription",
                "community.FormAction.formMessage.description");
        context.getFlowScope().put(org.unitedfront2.web.controller.message
                .FormAction.SUBJECT_REQUIRED_PARAM_NAME, true);
        context.getFlowScope().put(SubflowUtils.FORM_SUBMIT_CODE_PARAM_NAME,
                "toNext");
        return success();
    }

    @Override
    public Event setupForm(RequestContext context) throws Exception {
        Event event =  super.setupForm(context);
        SubflowUtils.setupMessages(context);

        Community c = (Community) getFormObject(context);
        Map<String, Boolean> canChange = new HashMap<String, Boolean>();
        canChange.put(SingleThreadCommunity.class.getSimpleName(),
                c.canChangeTo(SingleThreadCommunity.class));
        canChange.put(MultiThreadCommunity.class.getSimpleName(),
                c.canChangeTo(MultiThreadCommunity.class));
        context.getRequestScope().put("canChange", canChange);

        return event;
    }

    /**
     * KvɉČ^ύX܂B
     *
     * @throws BadRequestException R~jeB̃^CvύXłȂ
     */
    @Override
    protected void doBind(RequestContext context, DataBinder binder)
        throws Exception, BadRequestException {
        Community c = (Community) getFormObject(context);
        Class<? extends Community> clazz;
        try {
            clazz = (Class<? extends Community>) Class.forName(
                    COMMUNITY_PACKAGE + "."
                    + context.getRequestParameters().get("class"));
        } catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), e);
            throw new BadRequestException(context, this, e);
        }
        if (c.getClass() != clazz) {
            try {
                c = c.changeTo(clazz);
            } catch (CannotChangeCommunityException e) {
                logger.warn(e.getMessage(), e);
                throw new BadRequestException(context, this, e);
            }
        }
        putFormObject(context, c);
        super.doBind(context, createBinder(context, c));
    }

    @Override
    protected void doValidate(RequestContext context, Object formObject,
            Errors errors) throws Exception {
        super.doValidate(context, getFormObject(context), errors);
    }

    /**
     * R~jeBۑ܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @throws CommunityCodeUsedByOtherException R[hɎgpĂ
     */
    public Event store(RequestContext context)
        throws CommunityCodeUsedByOtherException {
        Community c = (Community) context.getFlowScope().get(
                COMMUNITY_PARAM_NAME);
        try {
            c.store();
        } catch (CommunityCodeUsedByOtherException e) {
            logger.warn(e.getMessage());
            Errors errors = getBindingErrors(context, c);
            errors.rejectValue("code",
                    "community.CommunityCodeUsedByOtherException");
            throw e;
        }
        return success();
    }

    @Override
    @Resource(name = "community.formValidator")
    public void setValidator(Validator validator) {
        super.setValidator(validator);
    }
}
