package org.unitedfront2.web.controller.community;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.CannotEntryCommunityException;
import org.unitedfront2.domain.communication.Community;
import org.unitedfront2.domain.communication.CommunityTable;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.flow.BadRequestException;

/**
 * }CR~jeBɒǉANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "community.entryAction")
public class EntryAction extends AbstractAction {

    /** R~jeBe[u */
    @Autowired
    private CommunityTable communityTable;

    @Override
    protected Event doExecute(RequestContext context) {
        Community c = Utils.findCommunityAndReadAccess(context, this,
                communityTable, "code");
        try {
            c.entry(WebUtils.findUser(context));
        } catch (CannotEntryCommunityException e) {
            throw new BadRequestException(context, this, e);
        }

        context.getFlowScope().put("community", c);
        return success();
    }
}
