package org.unitedfront2.web.controller.blog;

import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.communication.Blog;
import org.unitedfront2.domain.communication.BlogEntry;
import org.unitedfront2.domain.communication.BlogEntryTable;
import org.unitedfront2.domain.communication.BlogTable;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.flow.AccessDeniedException;
import org.unitedfront2.web.flow.PageNotFoundException;

/**
 * uO֘Ã[eBeBNXłB
 *
 * @author kurokkie
 *
 */
final class Utils {

    /**
     * uO̎擾Ɖ{`FbNs܂B
     *
     * @param context {@link RequestContext}
     * @param action {@link Action}
     * @param blogTable {@link BlogTable}
     * @param codeParamName R[h̃p[^
     * @return uO
     * @throws PageNotFoundException uO݂Ȃ
     * @throws AccessDeniedException {Ȃ
     */
    public static Blog findAndReadAccessByCode(RequestContext context,
            Action action, BlogTable blogTable, String codeParamName)
        throws PageNotFoundException, AccessDeniedException {
        Blog blog = findBlogByCode(context, action, blogTable, codeParamName);
        User user = WebUtils.findUser(context);
        try {
            blog.readAccess(user);
        } catch (org.unitedfront2.domain.accesscontrol
                .AccessDeniedException e) {
            throw new org.unitedfront2.web.flow.AccessDeniedException(context,
                    action, e.getMessage(), e);
        }
        return blog;
    }

    /**
     * uO̎擾ƕҏW`FbNs܂B
     *
     * @param context {@link RequestContext}
     * @param action {@link Action}
     * @param blogTable {@link BlogTable}
     * @param codeParamName R[h̃p[^
     * @return uO
     * @throws PageNotFoundException uO݂Ȃ
     * @throws AccessDeniedException ҏWȂ
     */
    public static Blog findAndWriteAccessByCode(RequestContext context,
            Action action, BlogTable blogTable, String codeParamName)
        throws PageNotFoundException, AccessDeniedException {
        Blog blog = findBlogByCode(context, action, blogTable, codeParamName);
        User user = WebUtils.getUser(context);
        try {
            blog.writeAccess(user.getId());
        } catch (org.unitedfront2.domain.accesscontrol
                .AccessDeniedException e) {
            throw new AccessDeniedException(context, action, e);
        }
        return blog;
    }

    private static Blog findBlogByCode(RequestContext context, Action action,
        BlogTable blogTable, String codeParamName)
        throws PageNotFoundException {

        String code = context.getRequestParameters().get(codeParamName);
        if (code == null) {
            code = context.getFlowScope().getString(codeParamName);
        }
        Blog blog = blogTable.findByCode(code);
        if (blog == null) {
            String message = "The blog [Code='" + code + "'] not found.";
            throw new PageNotFoundException(context, action, message);
        }
        return blog;
    }

    /**
     * uOL擾̎擾Ɖ{`FbNs܂B
     *
     * @param context {@link RequestContext}
     * @param action {@link Action}
     * @param blogEntryTable {@link BlogEntryTable}
     * @param codeParamName R[h̃p[^
     * @return uOL
     * @throws PageNotFoundException uOL݂Ȃ
     * @throws AccessDeniedException {Ȃ
     */
    public static BlogEntry findAndReadAccessByCode(RequestContext context,
            Action action, BlogEntryTable blogEntryTable, String codeParamName)
        throws PageNotFoundException, AccessDeniedException {
        BlogEntry blogEntry = findBlogEntryByCode(context, action,
                blogEntryTable, codeParamName);
        User user = WebUtils.findUser(context);
        try {
            if (user == null) {
                blogEntry.readAccess();
            } else {
                blogEntry.readAccess(user.getId());
            }
        } catch (org.unitedfront2.domain.accesscontrol
                .AccessDeniedException e) {
            throw new org.unitedfront2.web.flow.AccessDeniedException(context,
                    action, e.getMessage(), e);
        }
        return blogEntry;
    }

    /**
     * uOL̎擾ƕҏW`FbNs܂B
     *
     * @param context {@link RequestContext}
     * @param action {@link Action}
     * @param blogEntryTable {@link BlogEntryTable}
     * @param codeParamName R[h̃p[^
     * @return uOL
     * @throws PageNotFoundException uOL݂Ȃ
     * @throws AccessDeniedException ҏWȂ
     */
    public static BlogEntry findAndWriteAccessByCode(RequestContext context,
            Action action, BlogEntryTable blogEntryTable, String codeParamName)
        throws PageNotFoundException, AccessDeniedException {
        BlogEntry blogEntry = findBlogEntryByCode(context, action,
                blogEntryTable, codeParamName);
        User user = WebUtils.getUser(context);
        try {
            blogEntry.writeAccess(user.getId());
        } catch (org.unitedfront2.domain.accesscontrol
                .AccessDeniedException e) {
            throw new AccessDeniedException(context, action, e);
        }
        return blogEntry;
    }

    private static BlogEntry findBlogEntryByCode(RequestContext context,
            Action action, BlogEntryTable blogEntryTable, String codeParamName)
        throws PageNotFoundException {
        String code = context.getRequestParameters().get(codeParamName);
        if (code == null) {
            code = context.getFlowScope().getString(codeParamName);
        }
        BlogEntry blogEntry = blogEntryTable.findByCode(code);
        if (blogEntry == null) {
            String message = "The blog [Code='" + code + "'] not found.";
            throw new PageNotFoundException(context, action, message);
        }
        return blogEntry;
    }

    private Utils() {
        super();
    }
}
