package org.unitedfront2.web.controller.blog;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.Blog;
import org.unitedfront2.domain.communication.BlogTable;
import org.unitedfront2.web.WebUtils;

/**
 * ̃uOQƂ@\̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "blog.indexAction")
public class IndexAction extends AbstractAction {

    /** uOe[u */
    @Autowired private BlogTable blogTable;

    /**
     * uOXgƃuOݒ肵܂B
     *
     * @param context {@link RequestContext}
     * @return uOXg
     */
    @Override
    public Event doExecute(RequestContext context) {
        int ownerId = WebUtils.getAccount(context).getId();
        List<Blog> blogList = blogTable.findByOwnerId(ownerId);
        context.getFlowScope().put("blogs", blogList);
        context.getFlowScope().put("blogNum", blogList.size());
        return success();
    }
}
