package org.unitedfront2.web.controller.blog;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.domain.communication.BlogEntry;
import org.unitedfront2.domain.communication.BlogEntryTable;
import org.unitedfront2.domain.communication.Message;
import org.unitedfront2.web.controller.SubflowUtils;
import org.unitedfront2.web.controller.message.FormAction;
import org.unitedfront2.web.flow.PageNotFoundException;

/**
 * uOLXVp̃ANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "blog.entryUpdateAction")
public class EntryUpdateAction extends MultiAction {

    /** uOLe[u */
    @Autowired private BlogEntryTable blogEntryTable;

    /**
     * s܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     * @throws PageNotFoundException ݂ȂuOL
     */
    public Event init(RequestContext context)
        throws PageNotFoundException {
        String blogCode = context.getRequestParameters().getRequired(
            "blogCode");
        String entryCode = context.getRequestParameters().getRequired(
            "entryCode");

        // uOL擾
        BlogEntry entry = Utils.findAndWriteAccessByCode(context, this,
                blogEntryTable, "entryCode");

        context.getFlowScope().put("blogCode", blogCode);
        context.getFlowScope().put("entryCode", entryCode);
        context.getFlowScope().put(FormAction.MESSAGE_PARAM_NAME,
                entry.getEntry());
        context.getFlowScope().put(FormAction.SUBJECT_REQUIRED_PARAM_NAME,
                true);
        context.getFlowScope().put(SubflowUtils.PAGE_TITLE_CODE_PARAM_NAME,
                "blog.EntryUpdate");
        context.getFlowScope().put(SubflowUtils.FORM_SUBMIT_CODE_PARAM_NAME,
            "doUpdate");
        return success();
    }

    /**
     * uOLXV܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event update(RequestContext context) {
        String entryCode = context.getFlowScope().getRequiredString(
                "entryCode");
        BlogEntry blogEntry = blogEntryTable.findByCode(entryCode);
        Message entry = (Message) context.getFlowScope().get(
                FormAction.MESSAGE_PARAM_NAME);
        blogEntry.setEntry(entry);
        blogEntry.store();
        return success();
    }
}
