package org.unitedfront2.web.controller;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.util.HtmlUtils;
import org.unitedfront2.domain.communication.Blog;
import org.unitedfront2.domain.communication.BlogEntry;
import org.unitedfront2.domain.communication.BlogTable;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.view.RssView;

/**
 * gbvy[W RSS \p̃Rg[łB
 *
 * @author kurokkie
 *
 */
@Repository(value = "rssController")
public class RssController extends AbstractController {

    /** Ǘ҂̃uOR[h */
    private String adminBlogCode;

    /** uOe[u */
    @Autowired
    private BlogTable blogTable;

    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request,
            HttpServletResponse response) {
        Blog adminBlog = blogTable.getByCode(adminBlogCode);
        adminBlog.retrieveEntries(0, IndexAction.ADMIN_BLOG_ENTRY_DISPLAY_NUM);

        // Rg̕
        for (BlogEntry entry : adminBlog.getEntries()) {
            entry.retrieveCommentCount();
        }

        // L҂̕
        adminBlog.retrieveOwner();
        adminBlog.getOwner().retrieveProfile();

        SyndFeed feed = toFeed(request, adminBlog);
        ModelAndView mav = new ModelAndView(new RssView());
        mav.addObject(RssView.FEED_PARAM_NAME, feed);
        return mav;
    }

    private SyndFeed toFeed(HttpServletRequest request, Blog blog) {
        SyndFeed feed = new SyndFeedImpl();

        // Tv
        feed.setTitle(WebUtils.getMessage("Layout.title", request));
        feed.setLink("/index.html");
        feed.setDescription(WebUtils.getMessage("Index.description", request));
        feed.setAuthor(HtmlUtils.htmlEscape(blog.getOwner().getName()));

        // L
        List<SyndEntry> entries = new ArrayList<SyndEntry>(blog.getEntries()
                .size());
        for (BlogEntry be : blog.getEntries()) {
            SyndEntry entry = new SyndEntryImpl();
            entry.setTitle(be.getEntry().getSubject(WebUtils.getLocale(
                    request)));
            entry.setLink("/blog/" + blog.getCode() + "/entry-"
                    + be.getCode() + ".html");
            SyndContent description = new SyndContentImpl();
            description.setType("text/html");
            description.setValue(be.getEntry().getBody(WebUtils.getLocale(
                    request)));
            entry.setDescription(description);
            entry.setPublishedDate(be.getEntry().getRegistrationDate());
            entry.setUpdatedDate(be.getEntry().getLastUpdateDate());
            entries.add(entry);
        }
        feed.setEntries(entries);
        return feed;
    }

    public void setAdminBlogCode(String adminBlogCode) {
        this.adminBlogCode = adminBlogCode;
    }
}
