package org.unitedfront2.web.controller;

import com.octo.captcha.service.CaptchaServiceException;

import org.springframework.stereotype.Repository;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.unitedfront2.util.CaptchaServiceSingleton;
import org.unitedfront2.web.WebUtils;
import org.unitedfront2.web.flow.BadRequestException;

/**
 * 摜F؂sANVNXłB
 *
 * @author kurokkie
 *
 */
@Repository(value = "captchaAction")
public class CaptchaAction extends MultiAction {

    /** F؍ς݂ł邩ǂZbVɊi[ϐ */
    private static final String AUTH_PARAM_NAME
        = CaptchaAction.class.getName() + ".auth";

    /**
     * s܂Bɉ摜F؍ς݁AOCς݂ł΂̃t[͎sȂ悤ɐݒ肵܂B
     *
     * @param context {@link RequestContext}
     * @return Cxg
     */
    public Event init(RequestContext context) {
        Object o = WebUtils.getSession(context).getAttribute(AUTH_PARAM_NAME);
        if (WebUtils.findAccount(context) != null) {
            context.getFlowScope().put("authenticated", true);
        } else if (o != null && ((Boolean) o)) {
            context.getFlowScope().put("authenticated", true);
        } else {
            context.getFlowScope().put("authenticated", false);
        }
        return success();
    }

    /**
     * 摜F؂s܂B
     *
     * @param context {@link RequestContext}
     * @return F؂ɐΐCxgAsΎsCxg
     * @throws BadRequestException NGXgs
     */
    public Event authenticate(RequestContext context)
        throws BadRequestException {
        String captcha = context.getRequestParameters().get("captcha");
        String sessionId = WebUtils.getSession(context).getId();
        boolean isCorrect;
        try {
            isCorrect = CaptchaServiceSingleton.getInstance()
                .validateResponseForID(sessionId, captcha);
        } catch (CaptchaServiceException e) {
            if (logger.isWarnEnabled()) {
                logger.warn(e.getMessage());
            }
            throw new BadRequestException(context, this, e);
        }
        if (isCorrect) {
            WebUtils.getSession(context).setAttribute(AUTH_PARAM_NAME, true);
            return success();
        } else {
            context.getRequestScope().put("isError", true);
            return error();
        }
    }
}
