package org.unitedfront2.domain.communication;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.unitedfront2.dao.ThreadDao;
import org.unitedfront2.domain.Deletable;
import org.unitedfront2.domain.Domain;
import org.unitedfront2.domain.DomainFactory;
import org.unitedfront2.domain.Identifiable;
import org.unitedfront2.domain.Storable;
import org.unitedfront2.domain.User;
import org.unitedfront2.domain.accesscontrol.AbstractResource;
import org.unitedfront2.domain.accesscontrol.AccessControl;
import org.unitedfront2.domain.accesscontrol.AccessDeniedException;
import org.unitedfront2.domain.accesscontrol.AuthorOnly;

/**
 * Xbh\hCfłB
 *
 * @invariant ${this.readAccessControl} is ${this.overview.readAccessControl}
 * @invariant ${this.writeAccessControl} is ${this.overview.writeAccessControl}
 * @invariant L݂Xbh͍폜łȂB
 * @author kurokkie
 *
 */
public class Thread extends AbstractResource implements Serializable,
    Identifiable<Thread>, Storable, Deletable, Domain {

    /** Xbh̃Xe[^X */
    public static enum Status {

        /** p\ */
        AVAILABLE,

        /**  */
        LOCKED;

        /**
         * w肵ɑΉXe[^X݂邩ǂ肵܂B
         *
         * @param status Xe[^X
         * @return ݂ true AȂ false
         */
        public static boolean contains(String status) {
            try {
                valueOf(status);
                return true;
            } catch (IllegalArgumentException e) {
                return false;
            }
        }
    }

    /**
     * SẴXbh {@link #retrieveLastUpdateDate()} \bhĂяo܂B
     *
     * @param threads XbhXg
     */
    public static void retrieveLastUpdateDate(Collection<Thread> threads) {
        for (Thread t : threads) {
            t.retrieveLastUpdateDate();
        }
    }

    /** VAԍ */
    private static final long serialVersionUID = 2664292669643144192L;

    /** ID */
    private Integer id;

    /** Tv */
    private Message overview;

    /** Xe[^XBftHg {@link Status#AVAILABLE}B */
    private Status status = Status.AVAILABLE;

    /** eɑ΂ANZX */
    private AccessControl postAccessControl;

    /** LXg */
    private transient List<Message> entries;

    /** L */
    private transient int count;

    /** ŏIXVBŐVL̓o^̂ƁB*/
    private transient Date lastUpdateDate;

    /** Xbhf[^ANZXIuWFNg */
    private transient ThreadDao threadDao;

    /** hCt@Ng */
    private transient DomainFactory domainFactory;

    /** bZ[We[u */
    private transient MessageTable messageTable;

    public Thread() {
        super();
    }

    public Thread(Message overview, Status status, Integer ownerId,
            AccessControl readAccessControl, AccessControl writeAccessControl,
            AccessControl postAccessControl) {
        super(ownerId, readAccessControl, writeAccessControl);
        this.overview = overview;
        this.status = status;
        this.postAccessControl = postAccessControl;
    }

    public Thread(Integer id, Message overview, Status status, Integer ownerId,
            AccessControl readAccessControl, AccessControl writeAccessControl,
            AccessControl postAccessControl) {
        this(overview, status, ownerId, readAccessControl, writeAccessControl,
                postAccessControl);
        this.id = id;
    }

    @Override
    protected boolean buildEqualsBuilder(EqualsBuilder eb, Object other) {
        if (!(other instanceof Thread)) {
            return false;
        }
        Thread castOther = (Thread) other;
        eb.append(id, castOther.id)
            .append(overview, castOther.overview);
        if (!super.buildEqualsBuilder(eb, other)) {
            return false;
        }
        eb.append(postAccessControl, castOther.postAccessControl);
        return true;
    }

    @Override
    protected void buildHashCodeBuilder(HashCodeBuilder hcb) {
        hcb.append(id).append(overview);
        super.buildHashCodeBuilder(hcb);
        hcb.append(postAccessControl);
    }

    @Override
    protected void buildToStringBuilder(ToStringBuilder tsb) {
        tsb.append("id", id).append("overview", overview);
        super.buildToStringBuilder(tsb);
        tsb.append("postAccessControl", postAccessControl);
    }

    /**
     * ${thread.overview.ownerId} ɂ ${thread.ownerId} ݒ肳܂B
     * ${thread.overview.authorId} ɂ ${thread.ownerId} ݒ肳܂B
     * ${thread.overview.readAccessControl} ɂ ${thread.readAccessControl} 
     * 肳܂B${thread.overview.writeAccessControl} ɂ
     * ${thread.writeAccessControl} ݒ肳܂B
     */
    @Override
    public void store() {
        if (this.id == null) {
            threadDao.register(this);
        } else {
            threadDao.update(this);
        }
    }

    @Override
    public boolean identify(Thread thread) {
        if (id == null) {
            return false;
        }
        return id.equals(thread.getId());
    }

    /**
     * w肵L擾܂B
     *
     * @param entryId L ID
     * @return LAL݂Ȃ <code>null</code>
     */
    public Message findEntry(int entryId) {
        return threadDao.findEntry(this.id, entryId);
    }

    /**
     * w肵L擾܂B
     *
     * @param entryCode L ID
     * @return LAL݂Ȃ <code>null</code>
     */
    public Message findEntryByEntryCode(String entryCode) {
        Message m = messageTable.findByCode(entryCode);
        if (m == null) {
            return null;
        }
        return threadDao.findEntry(this.id, m.getId());
    }

    /**
     * w肵͈͂̋L𕜌܂BLԍ͂On܂鐮ŁAID ̍~ɂȂ܂B
     *
     * @param no Jn_ƂȂLԍ
     * @param num 
     */
    public void retrieveEntries(int no, int num) {
        entries = threadDao.findEntries(id, no, num);
    }

    /**
     * L̑SĂ̒҂Ƃ̃vtB[𕜌܂B{@link #retrieveEntries(int, int)} 
     * L𕜌ĂĂяoĂB
     */
    public void retrieveEntryAuthors() {
        for (Message e : this.entries) {
            e.retrieveAuthor();
            if (e.getAuthor() != null) {
                e.getAuthor().retrieveProfile();
            }
        }
    }

    /**
     * L𕜌܂B
     */
    public void retrieveCount() {
        count = threadDao.countEntry(id);
    }

    /**
     * L𓊍e܂Bw肵LۑÃXbhƊ֘At܂BbZ[W̏L҂ɂ́A
     * Xbh̏L҂ݒ肳܂B${entry.readAccessControl} ɂ
     * ${this.readAccessControl} ݒ肳܂B${entry.writeAccessControl.type}
     * ͕K {@link AuthorOnly} ƂȂ܂B
     *
     * @param entry L
     * @require ${entry.code} must be null.
     */
    public void post(Message entry) {
        entry.setOwnerId(this.getOwnerId());
        entry.setReadAccessControl(this.getReadAccessControl());
        entry.setWriteAccessControl(domainFactory.prototype(
                AuthorOnly.class));
        try {
            entry.store();
        } catch (MessageCodeUsedByOtherException e) {
            // NȂBR[h͎
            logger.error(e.getMessage(), e);
            throw new IllegalStateException(e);
        }
        threadDao.registerEntry(id, entry.getId());
    }

    /**
     * [UœeANZX݂܂B
     *
     * @throws AccessDeniedException ANZX
     */
    public void postAccess() throws AccessDeniedException {
        postAccessControl.access(this);
    }

    /**
     * eANZX݂܂B
     *
     * @param userId [U ID
     * @throws AccessDeniedException ANZX
     */
    public void postAccess(int userId) throws AccessDeniedException {
        postAccessControl.access(this, userId);
    }

    /**
     * eANZX݂܂B${user}  <code>null</code> łΓ[UƂ݂Ȃ܂B
     *
     * @param user [U
     * @throws AccessDeniedException ANZX
     */
    public void postAccess(User user) throws AccessDeniedException {
        if (user == null) {
            postAccess();
        } else {
            postAccess(user.getId());
        }
    }

    /**
     * [UɓeANZX邩肵܂B
     *
     * @return  <code>true</code> AȂ <code>false</code>
     */
    public boolean canPost() {
        try {
            postAccess();
            return true;
        } catch (AccessDeniedException e) {
            return false;
        }
    }

    /**
     * eANZX邩肵܂B
     *
     * @param userId [U ID
     * @return  <code>true</code> AȂ <code>false</code>
     */
    public boolean canPost(int userId) {
        try {
            postAccess(userId);
            return true;
        } catch (AccessDeniedException e) {
            return false;
        }
    }

    /**
     * eANZX邩肵܂B${user}  <code>null</code> łΓ[UƂ
     * Ȃ܂B
     *
     * @param user [U
     * @return  <code>true</code> AȂ <code>false</code>
     */
    public boolean canPost(User user) {
        if (user == null) {
            return canPost();
        } else {
            return canPost(user.getId());
        }
    }

    /**
     * @throws EntryExistException L݂Ă
     */
    @Override
    public void delete() throws EntryExistException {
        retrieveCount();
        if (count > 0) {
            String message = "The thread [ID=" + id + "] has " + count
                + " entries.";
            logger.warn(message);
            throw new EntryExistException(message);
        }
        threadDao.delete(id);
    }

    /**
     * ̃Xbh폜\ǂ肵܂B
     *
     * @return 폜\Ȃ <code>true</code> As\Ȃ <code>false</code>
     * @require {@link #retrieveCount()} ĂяoĂ
     */
    public boolean isDeletable() {
        return this.count == 0;
    }

    /**
     * ŏIXV𕜌܂B
     */
    public void retrieveLastUpdateDate() {
        retrieveEntries(0, 1);
        if (this.entries.isEmpty()) {
            this.lastUpdateDate = getOverview().getRegistrationDate();
        } else {
            this.lastUpdateDate = this.entries.get(0).getRegistrationDate();
        }
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Message getOverview() {
        return overview;
    }

    public void setOverview(Message overview) {
        this.overview = overview;
    }

    public Status getStatus() {
        return status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public AccessControl getPostAccessControl() {
        return postAccessControl;
    }

    public void setPostAccessControl(AccessControl postAccessControl) {
        this.postAccessControl = postAccessControl;
    }

    public List<Message> getEntries() {
        return entries;
    }

    public int getCount() {
        return count;
    }

    public Date getLastUpdateDate() {
        return (Date) lastUpdateDate.clone();
    }

    public Profile getOwnerProfile() {
        return getOwner().getProfile();
    }

    public void setThreadDao(ThreadDao threadDao) {
        this.threadDao = threadDao;
    }

    public void setDomainFactory(DomainFactory domainFactory) {
        this.domainFactory = domainFactory;
    }

    public void setMessageTable(MessageTable messageTable) {
        this.messageTable = messageTable;
    }
}
