package org.unitedfront2.domain.accesscontrol;

import java.io.Serializable;

import org.unitedfront2.domain.Deletable;
import org.unitedfront2.domain.Domain;
import org.unitedfront2.domain.Identifiable;
import org.unitedfront2.domain.Storable;

/**
 * ɑ΂ANZX䃍WbN邽߂̃C^[tF[XłBANZX̑ΏۂƂȂ鎑
 * {@link Resource} C^[tF[XKv܂B<p>
 *
 * ̏L҂́A̎ɑ΂SĂ̌Ă܂B
 *
 * @author kurokkie
 *
 * @see org.unitedfront2.domain.accesscontrol
 */
public interface AccessControl extends Serializable,
    Identifiable<AccessControl>, Storable, Deletable, Domain {

    /**
     * s胆[UƂĎɃANZX܂B
     *
     * @param resource 
     * @throws AccessDeniedException ANZX
     */
    void access(Resource resource) throws AccessDeniedException;

    /**
     * [UɃANZX܂B
     *
     * @param resource 
     * @param userId [U ID
     * @require ${userId} exists.
     * @throws AccessDeniedException ANZX
     */
    void access(Resource resource, int userId) throws AccessDeniedException;

    /**
     * s胆[UƂĒ앨ɃANZX܂B
     *
     * @param resource 앨
     * @throws AccessDeniedException ANZX
     */
    void access(CopyrightedResource resource) throws AccessDeniedException;

    /**
     * [U앨ɃTNZX܂B
     *
     * @param resource 앨
     * @param userId [U ID
     * @require ${userId} exists.
     * @throws AccessDeniedException ANZX
     */
    void access(CopyrightedResource resource, int userId)
        throws AccessDeniedException;

    @Override
    void store();

    @Override
    void delete();

    /**
     * w肵ANZX^CvɕύX܂B
     *
     * @param clazz ANZXNX
     */
    void changeTo(Class<? extends AccessControl> clazz);

    /**
     * ̃ANZX^Ԃ܂BANZX̏ɂ {@link Object#getClass()} ł͂Ȃ
     * ̃\bhgpĂBvLV {@link AccessControlProxy} ɂĕی삳Ă
     * ANZXNXłẴ\bh
     *
     * @return ANZX^Cv
     */
    Class<? extends AccessControl> getType();

    Integer getId();

    void setId(Integer id);
}
