package org.unitedfront2.domain.accesscontrol;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.unitedfront2.domain.SimpleUser;

/**
 * ҂\ۃNXłB
 *
 * @author kurokkie
 *
 */
public abstract class AbstractCopyrightedResource extends AbstractResource
    implements CopyrightedResource {

    /** ҂̃[U ID */
    private Integer authorId;

    /**  */
    private transient SimpleUser author;

    public AbstractCopyrightedResource() {
        super();
    }

    public AbstractCopyrightedResource(Integer ownerId, Integer authorId,
            AccessControl readAccessControl, AccessControl writeAccessControl) {
        super(ownerId, readAccessControl, writeAccessControl);
        this.authorId = authorId;
    }

    @Override
    protected void buildToStringBuilder(ToStringBuilder tsb) {
        tsb.append("ownerId", getOwnerId())
            .append("authorId", getAuthorId())
            .append("readAccessControl", getReadAccessControl())
            .append("writeAccessControl", getWriteAccessControl());
    }

    @Override
    protected boolean buildEqualsBuilder(EqualsBuilder eb, Object other) {
        if (!(other instanceof AbstractCopyrightedResource)) {
            return false;
        }
        AbstractCopyrightedResource castOther
            = (AbstractCopyrightedResource) other;
        eb.append(getOwnerId(), castOther.getOwnerId())
            .append(authorId, castOther.authorId)
            .append(getReadAccessControl(), castOther.getReadAccessControl())
            .append(getWriteAccessControl(), castOther.getWriteAccessControl());
        return true;
    }

    @Override
    protected void buildHashCodeBuilder(HashCodeBuilder hcb) {
        hcb.append(getOwnerId())
            .append(authorId)
            .append(getReadAccessControl())
            .append(getWriteAccessControl());
    }

    @Override
    public Integer getAuthorId() {
        return authorId;
    }

    /**
     * ҂𕜌܂B
     */
    public void retrieveAuthor() {
        this.author = getSimpleUserTable().find(this.authorId);
    }

    public void setAuthorId(Integer authorId) {
        this.authorId = authorId;
    }

    public SimpleUser getAuthor() {
        return author;
    }

    public void setAuthor(SimpleUser author) {
        this.author = author;
    }
}
