package org.unitedfront2.dao.jdbc;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.Resource;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Repository;
import org.unitedfront2.dao.FriendSubscriptionDao;
import org.unitedfront2.domain.SimpleUser;

/**
 * {@link FriendSubscriptionDao}  JDBC łB
 *
 * @author kurokkie
 *
 */
@Repository(value = "friendSubscriptionDao")
public class FriendSubscriptionDaoImpl extends DaoSupport implements
        FriendSubscriptionDao {

    /** [U}bp[t@Ng */
    @Resource(name = "simpleUserDao")
    private RowMapperFactory<SimpleUser> simpleUserRowMapperFactory;

    @Override
    public void delete(int fromId, int toId) {
        getSimpleJdbcTemplate().update(
                "DELETE FROM FriendSubscription WHERE FromId = ? AND ToId = ?",
                fromId, toId);
    }

    @Override
    public SimpleUser find(int fromId, int toId) {
        try {
            return getSimpleJdbcTemplate().queryForObject(
                    "SELECT * FROM FriendSubscription, User WHERE "
                    + "FriendSubscription.FromId = ? AND "
                    + "FriendSubscription.ToId = ? AND "
                    + "FriendSubscription.ToId = User.Id",
                    simpleUserRowMapperFactory.createRowMapper(), fromId, toId);
        } catch (EmptyResultDataAccessException e) {
            logger.debug(e.getMessage());
            return null;
        }
    }

    @Override
    public Set<SimpleUser> findByFromId(int userId) {
        return new HashSet<SimpleUser>(getSimpleJdbcTemplate().query(
                "SELECT * FROM FriendSubscription, User WHERE "
                + "FriendSubscription.FromId = ? AND "
                + "FriendSubscription.ToId = User.Id",
                simpleUserRowMapperFactory.createRowMapper(), userId));
    }

    @Override
    public Set<SimpleUser> findByToId(int toId) {
        return new HashSet<SimpleUser>(getSimpleJdbcTemplate().query(
                "SELECT * FROM FriendSubscription, User WHERE "
                + "FriendSubscription.ToId = ? AND "
                + "FriendSubscription.FromId = User.Id",
                simpleUserRowMapperFactory.createRowMapper(), toId));
    }

    @Override
    public void register(int fromId, int toId) {
        if (fromId == toId) {
            String message = "Cannot to subscribe to myself. [userId=" + fromId
                + ",toId=" + toId + "]";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        getSimpleJdbcTemplate().update(
                "INSERT INTO FriendSubscription(FromId, ToId) VALUES(?, ?)",
                fromId, toId);
    }
}
