package org.unitedfront2.dao;

import java.util.Date;
import java.util.List;

import org.unitedfront2.domain.SimpleUser;

/**
 * [Uf[^փANZX邽߂̃C^[tF[XłB
 *
 * @author kurokkie
 *
 */
public interface SimpleUserDao extends Registerable<SimpleUser>,
    SimpleFindable<SimpleUser>, Updatable<SimpleUser>, Dao {

    /**
     * @require ${user.code} ͈ӂȒlł
     * @require ${user.name} ͈ӂ͒lł
     */
    @Override
    void register(SimpleUser user);

    /**
     * @require ${user.code} ͈ӂȒlł
     * @require ${user.name} ͈ӂ͒lł
     */
    @Override
    void update(SimpleUser user);

    /**
     * ŏIANZX擾܂B
     *
     * @param id ID
     * @return ŏIANZXAȂ <code>null</code>
     */
    Date findLastAccessDate(int id);

    /**
     * R[h烆[U擾܂B
     *
     * @param code [UR[h
     * @return [U
     */
    SimpleUser findByCode(String code);

    /**
     * [U烆[U擾܂B
     *
     * @param name [U
     * @return [U
     */
    SimpleUser findByName(String name);

    /**
     * w肵Ȍ̍ŏIANZX[U擾܂B
     *
     * @param date 
     * @return [UXg
     */
    List<SimpleUser> findByLastAccessDateAfter(Date date);

    /**
     * w肵Ȍ̍ŏIANZX[U擾܂B
     *
     * @param date 
     * @return [U
     */
    int countByLastAccessDateAfter(Date date);

    /**
     * ŏIANZXXV܂B
     *
     * @param id [U ID
     * @param date 
     * @ensure ${this.findLastAccessDate(id)} equals ${date}
     */
    void updateLastAccessDate(int id, Date date);
}
