/* imklog.h
 * These are the definitions for the klog message generation module.
 *
 * File begun on 2007-12-17 by RGerhards
 *
 * Copyright 2007 Rainer Gerhards and Adiscon GmbH.
 *
 * This file is part of rsyslog.
 *
 * Rsyslog is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Rsyslog is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Rsyslog.  If not, see <http://www.gnu.org/licenses/>.
 *
 * A copy of the GPL can be found in the file "COPYING" in this distribution.
 */
#ifndef	IMKLOG_H_INCLUDED
#define	IMKLOG_H_INCLUDED 1

#include <stdarg.h>
#include "rsyslog.h"
#include "syslogd.h"

/* global variables */
extern int dbgPrintSymbols;

/* prototypes */
extern int InitKsyms(char *);
extern void DeinitKsyms(void);
extern int InitMsyms(void);
extern void DeinitMsyms(void);
extern char * ExpandKadds(char *, char *);
extern void SetParanoiaLevel(int);
extern void vsyslog(int pri, const char *fmt, va_list ap);
rsRetVal Syslog(int priority, char *fmt, ...) __attribute__((format(printf,2, 3)));

#endif /* #ifndef IMKLOG_H_INCLUDED */
/* vi:set ai:
 */
