/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE OggVorbis 'TREMOR' CODEC SOURCE CODE.   *
 *                                                                  *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE OggVorbis 'TREMOR' SOURCE CODE IS (C) COPYRIGHT 1994-2002    *
 * BY THE Xiph.Org FOUNDATION http://www.xiph.org/                  *
 *                                                                  *
 ********************************************************************

 function: window functions

 ********************************************************************/

#include <stdlib.h>
#include <math.h>
#include "os.h"
#include "misc.h"

static ogg_int32_t vwin64[32]={
  0x001f0003, 0x01168c98, 0x030333c8, 0x05dfe3a4, 
  0x09a49562, 0x0e45df18, 0x13b47ef2, 0x19dcf676, 
  0x20a74d83, 0x27f7137c, 0x2fabb05a, 0x37a11059, 
  0x3fb0ab28, 0x47b2dcd0, 0x4f807bc6, 0x56f48e6f, 
  0x5dedfc78, 0x64511652, 0x6a08cffe, 0x6f079327, 
  0x734796f3, 0x76cab7f1, 0x7999d6e7, 0x7bc3cf9e, 
  0x7d5c20c0, 0x7e7961de, 0x7f33a566, 0x7fa2e1cf, 
  0x7fdd78a4, 0x7ff6ec6c, 0x7ffed0e8, 0x7ffffc3e, 
};

static ogg_int32_t vwin128[64]={
  0x0007c04d, 0x0045bb89, 0x00c18b87, 0x017ae294, 
  0x02714a4e, 0x03a4217a, 0x05129952, 0x06bbb24f, 
  0x089e38a1, 0x0ab8c073, 0x0d09a228, 0x0f8ef6bd, 
  0x12469488, 0x152e0c7a, 0x1842a81b, 0x1b81686d, 
  0x1ee705d9, 0x226ff15d, 0x26185704, 0x29dc21cc, 
  0x2db700fd, 0x31a46f08, 0x359fb9c1, 0x39a40c0b, 
  0x3dac78b6, 0x41b40674, 0x45b5bcb0, 0x49acb109, 
  0x4d94152a, 0x516744bc, 0x5521d320, 0x58bf98a5, 
  0x5c3cbef3, 0x5f95cc5c, 0x62c7add6, 0x65cfbf63, 
  0x68abd2b9, 0x6b5a3404, 0x6dd9acaa, 0x7029840c, 
  0x72497e37, 0x7439d8ab, 0x75fb4531, 0x778ee309, 
  0x78f6367d, 0x7a331f19, 0x7b47cccc, 0x7c36b415, 
  0x7d028191, 0x7dae0d18, 0x7e3c4ca9, 0x7eb04762, 
  0x7f0d08a6, 0x7f5593b6, 0x7f8cd7d4, 0x7fb5a512, 
  0x7fd2a1fb, 0x7fe64211, 0x7ff2bd4b, 0x7ffa088f, 
  0x7ffdcf38, 0x7fff6dab, 0x7fffed00, 0x7fffffc3, 
};

static ogg_int32_t vwin256[128]={
  0x0001f018, 0x00117066, 0x00306e9e, 0x005ee5f1, 
  0x009ccf26, 0x00ea208b, 0x0146cdea, 0x01b2c87f, 
  0x022dfedf, 0x02b85ced, 0x0351cbbd, 0x03fa317f, 
  0x04b17167, 0x05776b8f, 0x064bfcdc, 0x072efedd, 
  0x082047b4, 0x091fa9f1, 0x0a2cf477, 0x0b47f25d, 
  0x0c706ad2, 0x0da620ff, 0x0ee8d3ef, 0x10383e75, 
  0x11941715, 0x12fc0ff6, 0x146fd6c8, 0x15ef14c1, 
  0x17796e8e, 0x190e844f, 0x1aadf196, 0x1c574d6e, 
  0x1e0a2a61, 0x1fc61688, 0x218a9b9b, 0x23573f12, 
  0x252b823c, 0x2706e269, 0x28e8d913, 0x2ad0dc0d, 
  0x2cbe5dc0, 0x2eb0cd60, 0x30a79732, 0x32a224d4, 
  0x349fdd8a, 0x36a0268f, 0x38a2636e, 0x3aa5f65d, 
  0x3caa409e, 0x3eaea2df, 0x40b27da6, 0x42b531b8, 
  0x44b62085, 0x46b4ac99, 0x48b03a05, 0x4aa82ed5, 
  0x4c9bf37d, 0x4e8af348, 0x50749cca, 0x52586245, 
  0x5435ba1b, 0x560c1f31, 0x57db1151, 0x59a21591, 
  0x5b60b6a3, 0x5d168534, 0x5ec31839, 0x60660d35, 
  0x61ff0885, 0x638db594, 0x6511c716, 0x668af733, 
  0x67f907af, 0x695bc206, 0x6ab2f786, 0x6bfe815a, 
  0x6d3e408f, 0x6e721e15, 0x6f9a0ab4, 0x70b5fef8, 
  0x71c5fb15, 0x72ca06cc, 0x73c2313c, 0x74ae90b2, 
  0x758f4274, 0x76646a85, 0x772e335b, 0x77eccd9f, 
  0x78a06fd6, 0x79495612, 0x79e7c19b, 0x7a7bf893, 
  0x7b064595, 0x7b86f756, 0x7bfe6043, 0x7c6cd614, 
  0x7cd2b16d, 0x7d304d70, 0x7d860755, 0x7dd43e05, 
  0x7e1b51ac, 0x7e5ba354, 0x7e95947d, 0x7ec986ba, 
  0x7ef7db49, 0x7f20f2b8, 0x7f452c7e, 0x7f64e6a6, 
  0x7f807d70, 0x7f984afe, 0x7faca6ff, 0x7fbde661, 
  0x7fcc5b03, 0x7fd85371, 0x7fe21a98, 0x7fe9f790, 
  0x7ff02d57, 0x7ff4fa9d, 0x7ff8998f, 0x7ffb3fa9, 
  0x7ffd1d8a, 0x7ffe5ecb, 0x7fff29df, 0x7fff9ff2, 
  0x7fffdcd1, 0x7ffff6d5, 0x7ffffecf, 0x7ffffffb, 
};

static ogg_int32_t vwin512[256]={
  0x00007c06, 0x00045c32, 0x000c1c62, 0x0017bc4c, 
  0x00273b7a, 0x003a9955, 0x0051d51c, 0x006cede7, 
  0x008be2a9, 0x00aeb22a, 0x00d55b0d, 0x00ffdbcc, 
  0x012e32b6, 0x01605df5, 0x01965b85, 0x01d02939, 
  0x020dc4ba, 0x024f2b83, 0x02945ae6, 0x02dd5004, 
  0x032a07d3, 0x037a7f19, 0x03ceb26e, 0x04269e37, 
  0x04823eab, 0x04e18fcc, 0x05448d6d, 0x05ab3329, 
  0x06157c68, 0x0683645e, 0x06f4e607, 0x0769fc25, 
  0x07e2a146, 0x085ecfbc, 0x08de819f, 0x0961b0cc, 
  0x09e856e2, 0x0a726d46, 0x0affed1d, 0x0b90cf4c, 
  0x0c250c79, 0x0cbc9d0b, 0x0d577926, 0x0df598aa, 
  0x0e96f337, 0x0f3b8026, 0x0fe3368f, 0x108e0d42, 
  0x113bfac9, 0x11ecf56b, 0x12a0f324, 0x1357e9ac, 
  0x1411ce70, 0x14ce9698, 0x158e3702, 0x1650a444, 
  0x1715d2a9, 0x17ddb638, 0x18a842aa, 0x19756b72, 
  0x1a4523b9, 0x1b175e61, 0x1bec0e03, 0x1cc324f0, 
  0x1d9c9531, 0x1e78508a, 0x1f564876, 0x20366e2d, 
  0x2118b2a1, 0x21fd0681, 0x22e35a37, 0x23cb9dee, 
  0x24b5c18d, 0x25a1b4c0, 0x268f66f1, 0x277ec74e, 
  0x286fc4cb, 0x29624e23, 0x2a5651d7, 0x2b4bbe33, 
  0x2c428150, 0x2d3a8913, 0x2e33c332, 0x2f2e1d35, 
  0x30298477, 0x3125e62d, 0x32232f61, 0x33214cfb, 
  0x34202bc1, 0x351fb85a, 0x361fdf4e, 0x37208d0f, 
  0x3821adf6, 0x39232e49, 0x3a24fa3b, 0x3b26fdf5, 
  0x3c292593, 0x3d2b5d29, 0x3e2d90c7, 0x3f2fac7e, 
  0x40319c5f, 0x41334c81, 0x4234a904, 0x43359e16, 
  0x443617f3, 0x453602eb, 0x46354b64, 0x4733dde1, 
  0x4831a6fe, 0x492e937e, 0x4a2a9045, 0x4b258a5f, 
  0x4c1f6f06, 0x4d182ba2, 0x4e0fadce, 0x4f05e35a, 
  0x4ffaba52, 0x50ee20fc, 0x51e005e1, 0x52d057ca, 
  0x53bf05c9, 0x54abff3b, 0x559733c7, 0x56809365, 
  0x57680e61, 0x584d955d, 0x59311952, 0x5a128b95, 
  0x5af1dddc, 0x5bcf023a, 0x5ca9eb27, 0x5d828b80, 
  0x5e58d68d, 0x5f2cbffb, 0x5ffe3be8, 0x60cd3edf, 
  0x6199bdd9, 0x6263ae44, 0x632b0601, 0x63efbb66, 
  0x64b1c53e, 0x65711acf, 0x662db3d6, 0x66e7888c, 
  0x679e91a4, 0x6852c84d, 0x69042634, 0x69b2a581, 
  0x6a5e40dd, 0x6b06f36b, 0x6bacb8d1, 0x6c4f8d2f, 
  0x6cef6d26, 0x6d8c55d3, 0x6e2644d3, 0x6ebd383f, 
  0x6f512eac, 0x6fe2272d, 0x7070214e, 0x70fb1d16, 
  0x71831b05, 0x72081c15, 0x728a21b4, 0x73092dc7, 
  0x738542a5, 0x73fe631a, 0x74749260, 0x74e7d420, 
  0x75582c71, 0x75c59fd4, 0x76303332, 0x7697ebdc, 
  0x76fccf84, 0x775ee442, 0x77be3089, 0x781abb2d, 
  0x78748b58, 0x78cba88d, 0x79201aa6, 0x7971e9cc, 
  0x79c11e78, 0x7a0dc16f, 0x7a57dbc1, 0x7a9f76c0, 
  0x7ae49c06, 0x7b27556a, 0x7b67ad01, 0x7ba5ad1a, 
  0x7be16039, 0x7c1ad117, 0x7c520a9d, 0x7c8717e0, 
  0x7cba0420, 0x7ceadac2, 0x7d19a74e, 0x7d46756d, 
  0x7d7150e4, 0x7d9a4591, 0x7dc15f68, 0x7de6aa70, 
  0x7e0a32bf, 0x7e2c0478, 0x7e4c2bc6, 0x7e6ab4da, 
  0x7e87abe8, 0x7ea31d23, 0x7ebd14bd, 0x7ed59edc, 
  0x7eecc7a2, 0x7f029b20, 0x7f172559, 0x7f2a723e, 
  0x7f3c8da9, 0x7f4d835c, 0x7f5d5eff, 0x7f6c2c1a, 
  0x7f79f616, 0x7f86c839, 0x7f92ada1, 0x7f9db145, 
  0x7fa7ddf2, 0x7fb13e45, 0x7fb9dcaf, 0x7fc1c36b, 
  0x7fc8fc82, 0x7fcf91c6, 0x7fd58cd1, 0x7fdaf701, 
  0x7fdfd978, 0x7fe43d1b, 0x7fe82a8a, 0x7febaa28, 
  0x7feec411, 0x7ff1801b, 0x7ff3e5d5, 0x7ff5fc85, 
  0x7ff7cb28, 0x7ff9586e, 0x7ffaaab9, 0x7ffbc81d, 
  0x7ffcb65f, 0x7ffd7af2, 0x7ffe1af9, 0x7ffe9b41, 
  0x7fff0046, 0x7fff4e2e, 0x7fff88c8, 0x7fffb38f, 
  0x7fffd1a5, 0x7fffe5d6, 0x7ffff295, 0x7ffff9fc, 
  0x7ffffdcc, 0x7fffff6c, 0x7fffffec, 0x7fffffff, 
  };

static ogg_int32_t vwin1024[512]={
  0x00001f02, 0x0001170e, 0x00030724, 0x0005ef40, 
  0x0009cf59, 0x000ea767, 0x0014775e, 0x001b3f2e, 
  0x0022fec8, 0x002bb618, 0x00356508, 0x00400b81, 
  0x004ba968, 0x00583ea0, 0x0065cb0a, 0x00744e84, 
  0x0083c8ea, 0x00943a14, 0x00a5a1da, 0x00b80010, 
  0x00cb5488, 0x00df9f10, 0x00f4df76, 0x010b1584, 
  0x01224101, 0x013a61b2, 0x01537759, 0x016d81b6, 
  0x01888087, 0x01a47385, 0x01c15a69, 0x01df34e6, 
  0x01fe02b1, 0x021dc377, 0x023e76e7, 0x02601ca9, 
  0x0282b466, 0x02a63dc1, 0x02cab85c, 0x02f023d6, 
  0x03167fcb, 0x033dcbd3, 0x03660783, 0x038f3270, 
  0x03b94c29, 0x03e4543a, 0x04104a2e, 0x043d2d8b, 
  0x046afdd5, 0x0499ba8c, 0x04c9632d, 0x04f9f733, 
  0x052b7615, 0x055ddf46, 0x05913237, 0x05c56e53, 
  0x05fa9306, 0x06309fb6, 0x066793c5, 0x069f6e93, 
  0x06d82f7c, 0x0711d5d9, 0x074c60fe, 0x0787d03d, 
  0x07c422e4, 0x0801583e, 0x083f6f91, 0x087e681f, 
  0x08be4129, 0x08fef9ea, 0x0940919a, 0x0983076d, 
  0x09c65a92, 0x0a0a8a38, 0x0a4f9585, 0x0a957b9f, 
  0x0adc3ba7, 0x0b23d4b9, 0x0b6c45ed, 0x0bb58e5a, 
  0x0bffad0f, 0x0c4aa11a, 0x0c966982, 0x0ce3054d, 
  0x0d30737b, 0x0d7eb307, 0x0dcdc2eb, 0x0e1da21a, 
  0x0e6e4f82, 0x0ebfca11, 0x0f1210ad, 0x0f652238, 
  0x0fb8fd91, 0x100da192, 0x10630d11, 0x10b93ee0, 
  0x111035ca, 0x1167f09a, 0x11c06e13, 0x1219acf5, 
  0x1273abfb, 0x12ce69db, 0x1329e549, 0x13861cf2, 
  0x13e30f80, 0x1440bb97, 0x149f1fd8, 0x14fe3add, 
  0x155e0b40, 0x15be8f92, 0x161fc662, 0x1681ae38, 
  0x16e4459b, 0x17478b0b, 0x17ab7d03, 0x181019fb, 
  0x18756066, 0x18db4eb3, 0x1941e34a, 0x19a91c91, 
  0x1a10f8ea, 0x1a7976af, 0x1ae29439, 0x1b4c4fda, 
  0x1bb6a7e2, 0x1c219a9a, 0x1c8d2648, 0x1cf9492e, 
  0x1d660187, 0x1dd34d8d, 0x1e412b74, 0x1eaf996a, 
  0x1f1e959b, 0x1f8e1e2e, 0x1ffe3146, 0x206ecd01, 
  0x20dfef78, 0x215196c2, 0x21c3c0f0, 0x22366c0f, 
  0x22a9962a, 0x231d3d44, 0x23915f60, 0x2405fa7a, 
  0x247b0c8b, 0x24f09389, 0x25668d65, 0x25dcf80c, 
  0x2653d167, 0x26cb175d, 0x2742c7d0, 0x27bae09e, 
  0x28335fa2, 0x28ac42b3, 0x292587a5, 0x299f2c48, 
  0x2a192e68, 0x2a938bd1, 0x2b0e4246, 0x2b894f8d, 
  0x2c04b163, 0x2c806587, 0x2cfc69b2, 0x2d78bb9a, 
  0x2df558f3, 0x2e723f6f, 0x2eef6cbb, 0x2f6cde83, 
  0x2fea926f, 0x30688627, 0x30e6b74d, 0x31652384, 
  0x31e3c86b, 0x3262a39e, 0x32e1b2b8, 0x3360f352, 
  0x33e06302, 0x345fff5e, 0x34dfc5f8, 0x355fb462, 
  0x35dfc82a, 0x365ffee0, 0x36e0560f, 0x3760cb42, 
  0x37e15c05, 0x386205de, 0x38e2c657, 0x39639af5, 
  0x39e4813d, 0x3a6576b6, 0x3ae678e2, 0x3b678547, 
  0x3be89965, 0x3c69b2c0, 0x3ceacedb, 0x3d6beb37, 
  0x3ded0556, 0x3e6e1aba, 0x3eef28e5, 0x3f702d5a, 
  0x3ff1259a, 0x40720f28, 0x40f2e788, 0x4173ac3f, 
  0x41f45ad0, 0x4274f0c1, 0x42f56b99, 0x4375c8df, 
  0x43f6061d, 0x447620db, 0x44f616a5, 0x4575e508, 
  0x45f58993, 0x467501d5, 0x46f44b61, 0x477363ca, 
  0x47f248a6, 0x4870f78d, 0x48ef6e19, 0x496da9e7, 
  0x49eba896, 0x4a6967c8, 0x4ae6e520, 0x4b641e46, 
  0x4be110e4, 0x4c5dbaa7, 0x4cda193e, 0x4d562a5e, 
  0x4dd1ebbd, 0x4e4d5b14, 0x4ec87622, 0x4f433aa8, 
  0x4fbda66b, 0x5037b734, 0x50b16acf, 0x512abf0d, 
  0x51a3b1c4, 0x521c40cd, 0x52946a05, 0x530c2b4f, 
  0x53838292, 0x53fa6db8, 0x5470eab2, 0x54e6f775, 
  0x555c91fb, 0x55d1b843, 0x56466851, 0x56baa02e, 
  0x572e5dea, 0x57a19f98, 0x58146352, 0x5886a737, 
  0x58f8696c, 0x5969a81c, 0x59da6177, 0x5a4a93b4, 
  0x5aba3d0f, 0x5b295bca, 0x5b97ee2f, 0x5c05f28d, 
  0x5c736738, 0x5ce04a8c, 0x5d4c9aec, 0x5db856c0, 
  0x5e237c77, 0x5e8e0a88, 0x5ef7ff6f, 0x5f6159af, 
  0x5fca17d4, 0x6032386d, 0x6099ba15, 0x61009b69, 
  0x6166db10, 0x61cc77b9, 0x62317017, 0x6295c2e7, 
  0x62f96eec, 0x635c72f1, 0x63becdc8, 0x64207e4a, 
  0x64818359, 0x64e1dbdd, 0x654186c7, 0x65a0830e, 
  0x65fecfb0, 0x665c6bb7, 0x66b9562f, 0x67158e2f, 
  0x677112d7, 0x67cbe34a, 0x6825feb8, 0x687f6456, 
  0x68d81360, 0x69300b1d, 0x69874ad9, 0x69ddd1e9, 
  0x6a339faa, 0x6a88b381, 0x6add0cda, 0x6b30ab29, 
  0x6b838deb, 0x6bd5b4a5, 0x6c271ee1, 0x6c77cc35, 
  0x6cc7bc3c, 0x6d16ee9a, 0x6d6562fa, 0x6db31911, 
  0x6e001098, 0x6e4c4954, 0x6e97c310, 0x6ee27d9e, 
  0x6f2c78d8, 0x6f75b4a1, 0x6fbe30e3, 0x7005ed90, 
  0x704ceaa0, 0x70932815, 0x70d8a5f7, 0x711d6456, 
  0x7161634a, 0x71a4a2f2, 0x71e72374, 0x7228e4ff, 
  0x7269e7c7, 0x72aa2c09, 0x72e9b209, 0x73287a11, 
  0x73668476, 0x73a3d18e, 0x73e061bb, 0x741c3565, 
  0x74574cf9, 0x7491a8ed, 0x74cb49bd, 0x75042feb, 
  0x753c5c02, 0x7573ce91, 0x75aa882f, 0x75e08979, 
  0x7615d312, 0x764a65a6, 0x767e41e4, 0x76b16883, 
  0x76e3da3f, 0x771597db, 0x7746a220, 0x7776f9dc, 
  0x77a69fe5, 0x77d59514, 0x7803da48, 0x78317069, 
  0x785e5861, 0x788a931f, 0x78b6219b, 0x78e104ce, 
  0x790b3dba, 0x7934cd63, 0x795db4d4, 0x7985f51c, 
  0x79ad8f4f, 0x79d48485, 0x79fad5dd, 0x7a208477, 
  0x7a45917a, 0x7a69fe11, 0x7a8dcb6b, 0x7ab0faba, 
  0x7ad38d35, 0x7af58419, 0x7b16e0a2, 0x7b37a415, 
  0x7b57cfb7, 0x7b7764d3, 0x7b9664b5, 0x7bb4d0af, 
  0x7bd2aa13, 0x7beff23a, 0x7c0caa7e, 0x7c28d43b, 
  0x7c4470d2, 0x7c5f81a4, 0x7c7a0819, 0x7c940597, 
  0x7cad7b8a, 0x7cc66b5d, 0x7cded67f, 0x7cf6be63, 
  0x7d0e247a, 0x7d250a3b, 0x7d3b711b, 0x7d515a94, 
  0x7d66c821, 0x7d7bbb3b, 0x7d903562, 0x7da43813, 
  0x7db7c4cf, 0x7dcadd15, 0x7ddd8269, 0x7defb64c, 
  0x7e017a43, 0x7e12cfd2, 0x7e23b87e, 0x7e3435cc, 
  0x7e444942, 0x7e53f466, 0x7e6338bf, 0x7e7217d4, 
  0x7e80932a, 0x7e8eac48, 0x7e9c64b6, 0x7ea9bdf7, 
  0x7eb6b993, 0x7ec3590f, 0x7ecf9dee, 0x7edb89b5, 
  0x7ee71de8, 0x7ef25c08, 0x7efd4597, 0x7f07dc15, 
  0x7f122102, 0x7f1c15db, 0x7f25bc1e, 0x7f2f1546, 
  0x7f3822cc, 0x7f40e62a, 0x7f4960d5, 0x7f519442, 
  0x7f5981e6, 0x7f612b30, 0x7f689190, 0x7f6fb673, 
  0x7f769b44, 0x7f7d416b, 0x7f83aa50, 0x7f89d756, 
  0x7f8fc9de, 0x7f958347, 0x7f9b04ee, 0x7fa0502d, 
  0x7fa56658, 0x7faa48c6, 0x7faef8c6, 0x7fb377a6, 
  0x7fb7c6b2, 0x7fbbe731, 0x7fbfda66, 0x7fc3a195, 
  0x7fc73df9, 0x7fcab0cd, 0x7fcdfb49, 0x7fd11e9f, 
  0x7fd41bff, 0x7fd6f495, 0x7fd9a988, 0x7fdc3bfe, 
  0x7fdead16, 0x7fe0fded, 0x7fe32f9c, 0x7fe54336, 
  0x7fe739cd, 0x7fe9146b, 0x7fead41a, 0x7fec79dc, 
  0x7fee06b1, 0x7fef7b93, 0x7ff0d97a, 0x7ff22157, 
  0x7ff35416, 0x7ff472a2, 0x7ff57ddf, 0x7ff676ab, 
  0x7ff75de2, 0x7ff83459, 0x7ff8fae3, 0x7ff9b24a, 
  0x7ffa5b57, 0x7ffaf6cc, 0x7ffb8567, 0x7ffc07e1, 
  0x7ffc7eec, 0x7ffceb37, 0x7ffd4d6c, 0x7ffda630, 
  0x7ffdf620, 0x7ffe3dd7, 0x7ffe7de9, 0x7ffeb6e6, 
  0x7ffee958, 0x7fff15c3, 0x7fff3ca8, 0x7fff5e7f, 
  0x7fff7bbf, 0x7fff94d5, 0x7fffaa2c, 0x7fffbc28, 
  0x7fffcb28, 0x7fffd785, 0x7fffe194, 0x7fffe9a2, 
  0x7fffeff9, 0x7ffff4dc, 0x7ffff888, 0x7ffffb36, 
  0x7ffffd19, 0x7ffffe5c, 0x7fffff28, 0x7fffff9f, 
  0x7fffffdc, 0x7ffffff6, 0x7ffffffe, 0x7fffffff, 
};

static ogg_int32_t vwin2048[1024]={
  0x000007c0, 0x000045c4, 0x0000c1ca, 0x00017bd3, 
  0x000273de, 0x0003a9eb, 0x00051df9, 0x0006d007, 
  0x0008c014, 0x000aee1e, 0x000d5a25, 0x00100428, 
  0x0012ec23, 0x00161216, 0x001975fe, 0x001d17da, 
  0x0020f7a8, 0x00251564, 0x0029710c, 0x002e0a9e, 
  0x0032e217, 0x0037f773, 0x003d4ab0, 0x0042dbca, 
  0x0048aabe, 0x004eb788, 0x00550224, 0x005b8a8f, 
  0x006250c5, 0x006954c1, 0x0070967e, 0x007815f9, 
  0x007fd32c, 0x0087ce13, 0x009006a9, 0x00987ce9, 
  0x00a130cc, 0x00aa224f, 0x00b3516b, 0x00bcbe1a, 
  0x00c66856, 0x00d0501a, 0x00da755f, 0x00e4d81f, 
  0x00ef7853, 0x00fa55f4, 0x010570fc, 0x0110c963, 
  0x011c5f22, 0x01283232, 0x0134428c, 0x01409027, 
  0x014d1afb, 0x0159e302, 0x0166e831, 0x01742a82, 
  0x0181a9ec, 0x018f6665, 0x019d5fe5, 0x01ab9663, 
  0x01ba09d6, 0x01c8ba34, 0x01d7a775, 0x01e6d18d, 
  0x01f63873, 0x0205dc1e, 0x0215bc82, 0x0225d997, 
  0x02363350, 0x0246c9a3, 0x02579c86, 0x0268abed, 
  0x0279f7cc, 0x028b801a, 0x029d44c9, 0x02af45ce, 
  0x02c1831d, 0x02d3fcaa, 0x02e6b269, 0x02f9a44c, 
  0x030cd248, 0x03203c4f, 0x0333e255, 0x0347c44b, 
  0x035be225, 0x03703bd5, 0x0384d14d, 0x0399a280, 
  0x03aeaf5e, 0x03c3f7d9, 0x03d97be4, 0x03ef3b6e, 
  0x0405366a, 0x041b6cc8, 0x0431de78, 0x04488b6c, 
  0x045f7393, 0x047696dd, 0x048df53b, 0x04a58e9b, 
  0x04bd62ee, 0x04d57223, 0x04edbc28, 0x050640ed, 
  0x051f0060, 0x0537fa70, 0x05512f0a, 0x056a9e1e, 
  0x05844798, 0x059e2b67, 0x05b84978, 0x05d2a1b8, 
  0x05ed3414, 0x06080079, 0x062306d3, 0x063e470f, 
  0x0659c119, 0x067574dd, 0x06916247, 0x06ad8941, 
  0x06c9e9b8, 0x06e68397, 0x070356c8, 0x07206336, 
  0x073da8cb, 0x075b2772, 0x0778df15, 0x0796cf9c, 
  0x07b4f8f3, 0x07d35b01, 0x07f1f5b1, 0x0810c8eb, 
  0x082fd497, 0x084f189e, 0x086e94e8, 0x088e495e, 
  0x08ae35e6, 0x08ce5a68, 0x08eeb6cc, 0x090f4af8, 
  0x093016d3, 0x09511a43, 0x09725530, 0x0993c77f, 
  0x09b57115, 0x09d751d8, 0x09f969ae, 0x0a1bb87c, 
  0x0a3e3e26, 0x0a60fa91, 0x0a83eda2, 0x0aa7173c, 
  0x0aca7743, 0x0aee0d9b, 0x0b11da28, 0x0b35dccc, 
  0x0b5a156a, 0x0b7e83e5, 0x0ba3281f, 0x0bc801fa, 
  0x0bed1158, 0x0c12561c, 0x0c37d025, 0x0c5d7f55, 
  0x0c83638d, 0x0ca97cae, 0x0ccfca97, 0x0cf64d29, 
  0x0d1d0444, 0x0d43efc7, 0x0d6b0f92, 0x0d926383, 
  0x0db9eb79, 0x0de1a752, 0x0e0996ee, 0x0e31ba29, 
  0x0e5a10e2, 0x0e829af5, 0x0eab5841, 0x0ed448a2, 
  0x0efd6bf4, 0x0f26c214, 0x0f504ade, 0x0f7a062e, 
  0x0fa3f3df, 0x0fce13cd, 0x0ff865d2, 0x1022e9ca, 
  0x104d9f8e, 0x107886f9, 0x10a39fe5, 0x10ceea2c, 
  0x10fa65a6, 0x1126122d, 0x1151ef9a, 0x117dfdc5, 
  0x11aa3c86, 0x11d6abb6, 0x12034b2c, 0x12301ac0, 
  0x125d1a48, 0x128a499b, 0x12b7a891, 0x12e536ff, 
  0x1312f4bb, 0x1340e19b, 0x136efd75, 0x139d481e, 
  0x13cbc16a, 0x13fa692f, 0x14293f40, 0x14584371, 
  0x14877597, 0x14b6d585, 0x14e6630d, 0x15161e04, 
  0x1546063b, 0x15761b84, 0x15a65db3, 0x15d6cc99, 
  0x16076806, 0x16382fcd, 0x166923be, 0x169a43ab, 
  0x16cb8f62, 0x16fd06b5, 0x172ea973, 0x1760776b, 
  0x1792706d, 0x17c49448, 0x17f6e2cb, 0x18295bc3, 
  0x185bfeff, 0x188ecc4c, 0x18c1c379, 0x18f4e451, 
  0x19282ea4, 0x195ba23c, 0x198f3ee6, 0x19c3046e, 
  0x19f6f2a1, 0x1a2b0949, 0x1a5f4833, 0x1a93af28, 
  0x1ac83df3, 0x1afcf460, 0x1b31d237, 0x1b66d744, 
  0x1b9c034e, 0x1bd15621, 0x1c06cf84, 0x1c3c6f40, 
  0x1c72351e, 0x1ca820e6, 0x1cde3260, 0x1d146953, 
  0x1d4ac587, 0x1d8146c3, 0x1db7eccd, 0x1deeb76c, 
  0x1e25a666, 0x1e5cb982, 0x1e93f084, 0x1ecb4b33, 
  0x1f02c953, 0x1f3a6aa9, 0x1f722efa, 0x1faa160b, 
  0x1fe21f9e, 0x201a4b78, 0x2052995d, 0x208b0910, 
  0x20c39a53, 0x20fc4cea, 0x21352097, 0x216e151b, 
  0x21a72a3a, 0x21e05fb5, 0x2219b54c, 0x22532ac2, 
  0x228cbfd7, 0x22c6744c, 0x230047e2, 0x233a3a57, 
  0x23744b6d, 0x23ae7ae3, 0x23e8c878, 0x242333ec, 
  0x245dbcfc, 0x24986369, 0x24d326f0, 0x250e0750, 
  0x25490446, 0x25841d90, 0x25bf52ec, 0x25faa416, 
  0x263610cd, 0x267198cb, 0x26ad3bcf, 0x26e8f994, 
  0x2724d1d6, 0x2760c450, 0x279cd0c0, 0x27d8f6e0, 
  0x2815366a, 0x28518f1b, 0x288e00ac, 0x28ca8ad8, 
  0x29072d5a, 0x2943e7eb, 0x2980ba45, 0x29bda422, 
  0x29faa53b, 0x2a37bd4a, 0x2a74ec07, 0x2ab2312b, 
  0x2aef8c6f, 0x2b2cfd8b, 0x2b6a8437, 0x2ba8202b, 
  0x2be5d120, 0x2c2396cc, 0x2c6170e7, 0x2c9f5f28, 
  0x2cdd6147, 0x2d1b76f9, 0x2d599ff6, 0x2d97dbf5, 
  0x2dd62aab, 0x2e148bce, 0x2e52ff15, 0x2e918436, 
  0x2ed01ae5, 0x2f0ec2d9, 0x2f4d7bc6, 0x2f8c4562, 
  0x2fcb1f62, 0x300a097a, 0x3049035f, 0x30880cc6, 
  0x30c72563, 0x31064ce9, 0x3145830e, 0x3184c785, 
  0x31c41a02, 0x32037a38, 0x3242e7db, 0x3282629f, 
  0x32c1ea35, 0x33017e52, 0x33411ea9, 0x3380caec, 
  0x33c082ce, 0x34004601, 0x34401439, 0x347fed27, 
  0x34bfd07e, 0x34ffbdef, 0x353fb52e, 0x357fb5eb, 
  0x35bfbfd9, 0x35ffd2aa, 0x363fee0e, 0x368011b8, 
  0x36c03d5a, 0x370070a4, 0x3740ab47, 0x3780ecf6, 
  0x37c13561, 0x3801843a, 0x3841d930, 0x388233f6, 
  0x38c2943c, 0x3902f9b3, 0x3943640c, 0x3983d2f7, 
  0x39c44626, 0x3a04bd48, 0x3a45380e, 0x3a85b629, 
  0x3ac63749, 0x3b06bb1f, 0x3b47415b, 0x3b87c9ae, 
  0x3bc853c7, 0x3c08df57, 0x3c496c0f, 0x3c89f99e, 
  0x3cca87b5, 0x3d0b1605, 0x3d4ba43d, 0x3d8c320d, 
  0x3dccbf27, 0x3e0d4b3a, 0x3e4dd5f6, 0x3e8e5f0b, 
  0x3ecee62b, 0x3f0f6b04, 0x3f4fed48, 0x3f906ca7, 
  0x3fd0e8d1, 0x40116177, 0x4051d648, 0x409246f5, 
  0x40d2b32f, 0x41131aa7, 0x41537d0c, 0x4193da0f, 
  0x41d43162, 0x421482b4, 0x4254cdb6, 0x4295121a, 
  0x42d54f90, 0x431585c9, 0x4355b476, 0x4395db48, 
  0x43d5f9f1, 0x44161021, 0x44561d89, 0x449621dd, 
  0x44d61ccc, 0x45160e08, 0x4555f543, 0x4595d230, 
  0x45d5a47f, 0x46156be3, 0x4655280e, 0x4694d8b2, 
  0x46d47d81, 0x4714162f, 0x4753a26d, 0x479321ee, 
  0x47d29466, 0x4811f987, 0x48515104, 0x48909a90, 
  0x48cfd5e0, 0x490f02a6, 0x494e2097, 0x498d2f66, 
  0x49cc2ec7, 0x4a0b1e6e, 0x4a49fe10, 0x4a88cd62, 
  0x4ac78c17, 0x4b0639e6, 0x4b44d682, 0x4b8361a2, 
  0x4bc1dafa, 0x4c004240, 0x4c3e972b, 0x4c7cd970, 
  0x4cbb08c5, 0x4cf924e0, 0x4d372d79, 0x4d752247, 
  0x4db302ff, 0x4df0cf5a, 0x4e2e870f, 0x4e6c29d5, 
  0x4ea9b765, 0x4ee72f77, 0x4f2491c3, 0x4f61de02, 
  0x4f9f13ec, 0x4fdc333b, 0x50193ba8, 0x50562ced, 
  0x509306c3, 0x50cfc8e5, 0x510c730d, 0x514904f5, 
  0x51857e59, 0x51c1def4, 0x51fe2681, 0x523a54bc, 
  0x52766960, 0x52b2642b, 0x52ee44d9, 0x532a0b25, 
  0x5365b6cf, 0x53a14793, 0x53dcbd2e, 0x5418175f, 
  0x545355e4, 0x548e787c, 0x54c97ee6, 0x550468e0, 
  0x553f362b, 0x5579e687, 0x55b479b3, 0x55eeef6f, 
  0x5629477e, 0x566381a0, 0x569d9d97, 0x56d79b24, 
  0x57117a09, 0x574b3a0a, 0x5784dae8, 0x57be5c68, 
  0x57f7be4c, 0x5831005a, 0x586a2254, 0x58a323ff, 
  0x58dc0521, 0x5914c57f, 0x594d64de, 0x5985e304, 
  0x59be3fb9, 0x59f67ac3, 0x5a2e93e8, 0x5a668af1, 
  0x5a9e5fa5, 0x5ad611ce, 0x5b0da132, 0x5b450d9d, 
  0x5b7c56d6, 0x5bb37ca8, 0x5bea7edd, 0x5c215d41, 
  0x5c58179d, 0x5c8eadbd, 0x5cc51f6e, 0x5cfb6c7b, 
  0x5d3194b1, 0x5d6797de, 0x5d9d75ce, 0x5dd32e50, 
  0x5e08c132, 0x5e3e2e42, 0x5e737551, 0x5ea8962d, 
  0x5edd90a6, 0x5f12648d, 0x5f4711b3, 0x5f7b97e9, 
  0x5faff701, 0x5fe42ecd, 0x60183f20, 0x604c27cc, 
  0x607fe8a5, 0x60b3817f, 0x60e6f22e, 0x611a3a88, 
  0x614d5a61, 0x6180518f, 0x61b31fe9, 0x61e5c544, 
  0x62184178, 0x624a945c, 0x627cbdc9, 0x62aebd97, 
  0x62e0939e, 0x63123fb9, 0x6343c1c0, 0x6375198e, 
  0x63a646fe, 0x63d749ec, 0x64082231, 0x6438cfac, 
  0x64695238, 0x6499a9b2, 0x64c9d5f8, 0x64f9d6e9, 
  0x6529ac62, 0x65595642, 0x6588d469, 0x65b826b7, 
  0x65e74d0d, 0x6616474a, 0x66451551, 0x6673b703, 
  0x66a22c43, 0x66d074f3, 0x66fe90f7, 0x672c8032, 
  0x675a4289, 0x6787d7e1, 0x67b5401e, 0x67e27b26, 
  0x680f88e0, 0x683c6933, 0x68691c05, 0x6895a13e, 
  0x68c1f8c6, 0x68ee2286, 0x691a1e67, 0x6945ec53, 
  0x69718c34, 0x699cfdf4, 0x69c8417e, 0x69f356bf, 
  0x6a1e3da2, 0x6a48f614, 0x6a738002, 0x6a9ddb59, 
  0x6ac80807, 0x6af205fc, 0x6b1bd526, 0x6b457574, 
  0x6b6ee6d7, 0x6b98293f, 0x6bc13c9e, 0x6bea20e4, 
  0x6c12d604, 0x6c3b5bf0, 0x6c63b29c, 0x6c8bd9fa, 
  0x6cb3d1ff, 0x6cdb9a9f, 0x6d0333cf, 0x6d2a9d85, 
  0x6d51d7b6, 0x6d78e25a, 0x6d9fbd66, 0x6dc668d2, 
  0x6dece497, 0x6e1330ad, 0x6e394d0c, 0x6e5f39ad, 
  0x6e84f68c, 0x6eaa83a1, 0x6ecfe0e9, 0x6ef50e5d, 
  0x6f1a0bfb, 0x6f3ed9be, 0x6f6377a3, 0x6f87e5a7, 
  0x6fac23c9, 0x6fd03205, 0x6ff4105b, 0x7017becb, 
  0x703b3d53, 0x705e8bf4, 0x7081aaae, 0x70a49983, 
  0x70c75874, 0x70e9e782, 0x710c46b2, 0x712e7604, 
  0x7150757e, 0x71724522, 0x7193e4f5, 0x71b554fd, 
  0x71d6953d, 0x71f7a5bc, 0x72188681, 0x72393791, 
  0x7259b8f4, 0x727a0ab1, 0x729a2cd1, 0x72ba1f5c, 
  0x72d9e25b, 0x72f975d7, 0x7318d9da, 0x73380e6f, 
  0x7357139f, 0x7375e977, 0x73949002, 0x73b3074b, 
  0x73d14f61, 0x73ef684e, 0x740d5221, 0x742b0ce8, 
  0x744898b0, 0x7465f588, 0x74832381, 0x74a022a8, 
  0x74bcf30d, 0x74d994c2, 0x74f607d8, 0x75124c5e, 
  0x752e6267, 0x754a4a05, 0x7566034a, 0x75818e49, 
  0x759ceb15, 0x75b819c3, 0x75d31a65, 0x75eded11, 
  0x760891db, 0x762308d9, 0x763d5220, 0x76576dc7, 
  0x76715be3, 0x768b1c8b, 0x76a4afd8, 0x76be15df, 
  0x76d74eba, 0x76f05a81, 0x7709394c, 0x7721eb34, 
  0x773a7053, 0x7752c8c3, 0x776af49e, 0x7782f3ff, 
  0x779ac700, 0x77b26dbc, 0x77c9e850, 0x77e136d7, 
  0x77f8596e, 0x780f5031, 0x78261b3e, 0x783cbab2, 
  0x78532ea9, 0x78697744, 0x787f949f, 0x789586db, 
  0x78ab4e14, 0x78c0ea6c, 0x78d65c02, 0x78eba2f6, 
  0x7900bf67, 0x7915b178, 0x792a7949, 0x793f16fa, 
  0x79538aae, 0x7967d487, 0x797bf4a7, 0x798feb30, 
  0x79a3b845, 0x79b75c09, 0x79cad6a0, 0x79de282d, 
  0x79f150d4, 0x7a0450ba, 0x7a172802, 0x7a29d6d3, 
  0x7a3c5d4f, 0x7a4ebb9f, 0x7a60f1e5, 0x7a73004a, 
  0x7a84e6f1, 0x7a96a603, 0x7aa83da6, 0x7ab9ae00, 
  0x7acaf739, 0x7adc1978, 0x7aed14e5, 0x7afde9a7, 
  0x7b0e97e7, 0x7b1f1fcc, 0x7b2f8181, 0x7b3fbd2c, 
  0x7b4fd2f8, 0x7b5fc30e, 0x7b6f8d97, 0x7b7f32bc, 
  0x7b8eb2a8, 0x7b9e0d84, 0x7bad437c, 0x7bbc54b8, 
  0x7bcb4165, 0x7bda09ad, 0x7be8adbb, 0x7bf72dbb, 
  0x7c0589d7, 0x7c13c23c, 0x7c21d715, 0x7c2fc88e, 
  0x7c3d96d4, 0x7c4b4213, 0x7c58ca77, 0x7c66302c, 
  0x7c737361, 0x7c809442, 0x7c8d92fb, 0x7c9a6fbb, 
  0x7ca72aae, 0x7cb3c403, 0x7cc03be7, 0x7ccc9287, 
  0x7cd8c813, 0x7ce4dcb8, 0x7cf0d0a4, 0x7cfca405, 
  0x7d08570b, 0x7d13e9e4, 0x7d1f5cbe, 0x7d2aafc9, 
  0x7d35e334, 0x7d40f72d, 0x7d4bebe3, 0x7d56c187, 
  0x7d617847, 0x7d6c1053, 0x7d7689da, 0x7d80e50d, 
  0x7d8b221a, 0x7d954132, 0x7d9f4285, 0x7da92642, 
  0x7db2ec9a, 0x7dbc95bc, 0x7dc621d9, 0x7dcf9122, 
  0x7dd8e3c5, 0x7de219f5, 0x7deb33e1, 0x7df431b9, 
  0x7dfd13ae, 0x7e05d9f1, 0x7e0e84b3, 0x7e171423, 
  0x7e1f8873, 0x7e27e1d3, 0x7e302074, 0x7e384486, 
  0x7e404e3b, 0x7e483dc3, 0x7e50134f, 0x7e57cf10, 
  0x7e5f7137, 0x7e66f9f3, 0x7e6e6978, 0x7e75bff4, 
  0x7e7cfd99, 0x7e842297, 0x7e8b2f21, 0x7e922365, 
  0x7e98ff96, 0x7e9fc3e3, 0x7ea6707e, 0x7ead0597, 
  0x7eb3835f, 0x7eb9ea06, 0x7ec039be, 0x7ec672b6, 
  0x7ecc9520, 0x7ed2a12b, 0x7ed89709, 0x7ede76e9, 
  0x7ee440fc, 0x7ee9f572, 0x7eef947c, 0x7ef51e4a, 
  0x7efa930c, 0x7efff2f1, 0x7f053e2a, 0x7f0a74e7, 
  0x7f0f9757, 0x7f14a5ab, 0x7f19a012, 0x7f1e86bb, 
  0x7f2359d7, 0x7f281994, 0x7f2cc622, 0x7f315fb0, 
  0x7f35e66d, 0x7f3a5a89, 0x7f3ebc32, 0x7f430b97, 
  0x7f4748e6, 0x7f4b744f, 0x7f4f8e00, 0x7f539628, 
  0x7f578cf4, 0x7f5b7292, 0x7f5f4731, 0x7f630aff, 
  0x7f66be2a, 0x7f6a60de, 0x7f6df34a, 0x7f71759a, 
  0x7f74e7fd, 0x7f784a9f, 0x7f7b9dae, 0x7f7ee155, 
  0x7f8215c2, 0x7f853b21, 0x7f88519e, 0x7f8b5966, 
  0x7f8e52a5, 0x7f913d86, 0x7f941a35, 0x7f96e8de, 
  0x7f99a9ac, 0x7f9c5cca, 0x7f9f0264, 0x7fa19aa4, 
  0x7fa425b4, 0x7fa6a3c0, 0x7fa914f2, 0x7fab7973, 
  0x7fadd16e, 0x7fb01d0c, 0x7fb25c77, 0x7fb48fd8, 
  0x7fb6b759, 0x7fb8d322, 0x7fbae35c, 0x7fbce830, 
  0x7fbee1c6, 0x7fc0d046, 0x7fc2b3d8, 0x7fc48ca4, 
  0x7fc65ad2, 0x7fc81e87, 0x7fc9d7ed, 0x7fcb8729, 
  0x7fcd2c62, 0x7fcec7be, 0x7fd05965, 0x7fd1e17b, 
  0x7fd36026, 0x7fd4d58c, 0x7fd641d2, 0x7fd7a51d, 
  0x7fd8ff93, 0x7fda5156, 0x7fdb9a8d, 0x7fdcdb5a, 
  0x7fde13e1, 0x7fdf4447, 0x7fe06cae, 0x7fe18d3a, 
  0x7fe2a60d, 0x7fe3b74a, 0x7fe4c113, 0x7fe5c38a, 
  0x7fe6bed1, 0x7fe7b309, 0x7fe8a054, 0x7fe986d3, 
  0x7fea66a6, 0x7feb3fef, 0x7fec12cc, 0x7fecdf5e, 
  0x7feda5c4, 0x7fee661f, 0x7fef208c, 0x7fefd52b, 
  0x7ff0841b, 0x7ff12d79, 0x7ff1d163, 0x7ff26ff8, 
  0x7ff30954, 0x7ff39d95, 0x7ff42cd8, 0x7ff4b738, 
  0x7ff53cd3, 0x7ff5bdc4, 0x7ff63a27, 0x7ff6b216, 
  0x7ff725ae, 0x7ff79509, 0x7ff80042, 0x7ff86772, 
  0x7ff8cab3, 0x7ff92a20, 0x7ff985d0, 0x7ff9ddde, 
  0x7ffa3261, 0x7ffa8373, 0x7ffad12b, 0x7ffb1ba0, 
  0x7ffb62eb, 0x7ffba722, 0x7ffbe85b, 0x7ffc26af, 
  0x7ffc6232, 0x7ffc9afa, 0x7ffcd11d, 0x7ffd04b0, 
  0x7ffd35c8, 0x7ffd647a, 0x7ffd90d9, 0x7ffdbaf9, 
  0x7ffde2ef, 0x7ffe08cd, 0x7ffe2ca6, 0x7ffe4e8d, 
  0x7ffe6e94, 0x7ffe8ccd, 0x7ffea949, 0x7ffec41a, 
  0x7ffedd51, 0x7ffef4fe, 0x7fff0b32, 0x7fff1ffc, 
  0x7fff336d, 0x7fff4592, 0x7fff567c, 0x7fff6639, 
  0x7fff74d7, 0x7fff8264, 0x7fff8eed, 0x7fff9a80, 
  0x7fffa52a, 0x7fffaef7, 0x7fffb7f4, 0x7fffc02c, 
  0x7fffc7aa, 0x7fffce7b, 0x7fffd4a8, 0x7fffda3d, 
  0x7fffdf43, 0x7fffe3c5, 0x7fffe7cb, 0x7fffeb5f, 
  0x7fffee89, 0x7ffff152, 0x7ffff3c3, 0x7ffff5e2, 
  0x7ffff7b7, 0x7ffff94a, 0x7ffffaa0, 0x7ffffbc0, 
  0x7ffffcb1, 0x7ffffd77, 0x7ffffe18, 0x7ffffe99, 
  0x7ffffefe, 0x7fffff4d, 0x7fffff88, 0x7fffffb2, 
  0x7fffffd1, 0x7fffffe5, 0x7ffffff2, 0x7ffffff9, 
  0x7ffffffd, 0x7ffffffe, 0x7fffffff, 0x7fffffff, 
};

static ogg_int32_t vwin4096[2048]={
  0x000001f0, 0x00001171, 0x00003072, 0x00005ef5, 
  0x00009cf8, 0x0000ea7c, 0x00014780, 0x0001b405, 
  0x0002300b, 0x0002bb91, 0x00035698, 0x0004011e, 
  0x0004bb25, 0x000584ac, 0x00065db3, 0x0007463a, 
  0x00083e41, 0x000945c7, 0x000a5ccc, 0x000b8350, 
  0x000cb954, 0x000dfed7, 0x000f53d8, 0x0010b857, 
  0x00122c55, 0x0013afd1, 0x001542ca, 0x0016e541, 
  0x00189735, 0x001a58a7, 0x001c2995, 0x001e09ff, 
  0x001ff9e6, 0x0021f948, 0x00240826, 0x00262680, 
  0x00285454, 0x002a91a3, 0x002cde6c, 0x002f3aaf, 
  0x0031a66b, 0x003421a0, 0x0036ac4f, 0x00394675, 
  0x003bf014, 0x003ea92a, 0x004171b7, 0x004449bb, 
  0x00473135, 0x004a2824, 0x004d2e8a, 0x00504463, 
  0x005369b2, 0x00569e74, 0x0059e2aa, 0x005d3652, 
  0x0060996d, 0x00640bf9, 0x00678df7, 0x006b1f66, 
  0x006ec045, 0x00727093, 0x00763051, 0x0079ff7d, 
  0x007dde16, 0x0081cc1d, 0x0085c991, 0x0089d671, 
  0x008df2bc, 0x00921e71, 0x00965991, 0x009aa41a, 
  0x009efe0c, 0x00a36766, 0x00a7e028, 0x00ac6850, 
  0x00b0ffde, 0x00b5a6d1, 0x00ba5d28, 0x00bf22e4, 
  0x00c3f802, 0x00c8dc83, 0x00cdd065, 0x00d2d3a8, 
  0x00d7e64a, 0x00dd084c, 0x00e239ac, 0x00e77a69, 
  0x00ecca83, 0x00f229f9, 0x00f798ca, 0x00fd16f5, 
  0x0102a479, 0x01084155, 0x010ded89, 0x0113a913, 
  0x011973f3, 0x011f4e27, 0x012537af, 0x012b308a, 
  0x013138b7, 0x01375035, 0x013d7702, 0x0143ad1f, 
  0x0149f289, 0x01504741, 0x0156ab44, 0x015d1e92, 
  0x0163a12a, 0x016a330b, 0x0170d433, 0x017784a3, 
  0x017e4458, 0x01851351, 0x018bf18e, 0x0192df0d, 
  0x0199dbcd, 0x01a0e7cd, 0x01a8030c, 0x01af2d89, 
  0x01b66743, 0x01bdb038, 0x01c50867, 0x01cc6fd0, 
  0x01d3e670, 0x01db6c47, 0x01e30153, 0x01eaa593, 
  0x01f25907, 0x01fa1bac, 0x0201ed81, 0x0209ce86, 
  0x0211beb8, 0x0219be17, 0x0221cca2, 0x0229ea56, 
  0x02321733, 0x023a5337, 0x02429e60, 0x024af8af, 
  0x02536220, 0x025bdab3, 0x02646267, 0x026cf93a, 
  0x02759f2a, 0x027e5436, 0x0287185d, 0x028feb9d, 
  0x0298cdf4, 0x02a1bf62, 0x02aabfe5, 0x02b3cf7b, 
  0x02bcee23, 0x02c61bdb, 0x02cf58a2, 0x02d8a475, 
  0x02e1ff55, 0x02eb693e, 0x02f4e230, 0x02fe6a29, 
  0x03080127, 0x0311a729, 0x031b5c2d, 0x03252031, 
  0x032ef334, 0x0338d534, 0x0342c630, 0x034cc625, 
  0x0356d512, 0x0360f2f6, 0x036b1fce, 0x03755b99, 
  0x037fa655, 0x038a0001, 0x0394689a, 0x039ee020, 
  0x03a9668f, 0x03b3fbe6, 0x03bea024, 0x03c95347, 
  0x03d4154d, 0x03dee633, 0x03e9c5f9, 0x03f4b49b, 
  0x03ffb219, 0x040abe71, 0x0415d9a0, 0x042103a5, 
  0x042c3c7d, 0x04378428, 0x0442daa2, 0x044e3fea, 
  0x0459b3fd, 0x046536db, 0x0470c880, 0x047c68eb, 
  0x0488181a, 0x0493d60b, 0x049fa2bc, 0x04ab7e2a, 
  0x04b76854, 0x04c36137, 0x04cf68d1, 0x04db7f21, 
  0x04e7a424, 0x04f3d7d8, 0x05001a3b, 0x050c6b4a, 
  0x0518cb04, 0x05253966, 0x0531b66e, 0x053e421a, 
  0x054adc68, 0x05578555, 0x05643cdf, 0x05710304, 
  0x057dd7c1, 0x058abb15, 0x0597acfd, 0x05a4ad76, 
  0x05b1bc7f, 0x05beda14, 0x05cc0635, 0x05d940dd, 
  0x05e68a0b, 0x05f3e1bd, 0x060147f0, 0x060ebca1, 
  0x061c3fcf, 0x0629d176, 0x06377194, 0x06452027, 
  0x0652dd2c, 0x0660a8a1, 0x066e8284, 0x067c6ad1, 
  0x068a6186, 0x069866a0, 0x06a67a1e, 0x06b49bfc, 
  0x06c2cc38, 0x06d10acf, 0x06df57bf, 0x06edb304, 
  0x06fc1c9d, 0x070a9487, 0x07191abe, 0x0727af40, 
  0x0736520b, 0x0745031c, 0x0753c270, 0x07629004, 
  0x07716bd6, 0x078055e2, 0x078f4e26, 0x079e549f, 
  0x07ad694b, 0x07bc8c26, 0x07cbbd2e, 0x07dafc5f, 
  0x07ea49b7, 0x07f9a533, 0x08090ed1, 0x0818868c, 
  0x08280c62, 0x0837a051, 0x08474255, 0x0856f26b, 
  0x0866b091, 0x08767cc3, 0x088656fe, 0x08963f3f, 
  0x08a63583, 0x08b639c8, 0x08c64c09, 0x08d66c45, 
  0x08e69a77, 0x08f6d69d, 0x090720b3, 0x091778b7, 
  0x0927dea5, 0x0938527a, 0x0948d433, 0x095963cc, 
  0x096a0143, 0x097aac93, 0x098b65bb, 0x099c2cb6, 
  0x09ad0182, 0x09bde41a, 0x09ced47c, 0x09dfd2a5, 
  0x09f0de90, 0x0a01f83b, 0x0a131fa3, 0x0a2454c3, 
  0x0a359798, 0x0a46e820, 0x0a584656, 0x0a69b237, 
  0x0a7b2bbf, 0x0a8cb2ec, 0x0a9e47ba, 0x0aafea24, 
  0x0ac19a28, 0x0ad357c3, 0x0ae522ef, 0x0af6fbab, 
  0x0b08e1f1, 0x0b1ad5c0, 0x0b2cd712, 0x0b3ee5e5, 
  0x0b510234, 0x0b632bfd, 0x0b75633b, 0x0b87a7ea, 
  0x0b99fa08, 0x0bac5990, 0x0bbec67e, 0x0bd140cf, 
  0x0be3c87e, 0x0bf65d89, 0x0c08ffeb, 0x0c1bafa1, 
  0x0c2e6ca6, 0x0c4136f6, 0x0c540e8f, 0x0c66f36c, 
  0x0c79e588, 0x0c8ce4e1, 0x0c9ff172, 0x0cb30b37, 
  0x0cc6322c, 0x0cd9664d, 0x0ceca797, 0x0cfff605, 
  0x0d135193, 0x0d26ba3d, 0x0d3a2fff, 0x0d4db2d5, 
  0x0d6142ba, 0x0d74dfac, 0x0d8889a5, 0x0d9c40a1, 
  0x0db0049c, 0x0dc3d593, 0x0dd7b380, 0x0deb9e60, 
  0x0dff962f, 0x0e139ae7, 0x0e27ac85, 0x0e3bcb05, 
  0x0e4ff662, 0x0e642e98, 0x0e7873a2, 0x0e8cc57d, 
  0x0ea12423, 0x0eb58f91, 0x0eca07c2, 0x0ede8cb1, 
  0x0ef31e5b, 0x0f07bcba, 0x0f1c67cb, 0x0f311f88, 
  0x0f45e3ee, 0x0f5ab4f7, 0x0f6f929f, 0x0f847ce3, 
  0x0f9973bc, 0x0fae7726, 0x0fc3871e, 0x0fd8a39d, 
  0x0fedcca1, 0x10030223, 0x1018441f, 0x102d9291, 
  0x1042ed74, 0x105854c3, 0x106dc879, 0x10834892, 
  0x1098d508, 0x10ae6dd8, 0x10c412fc, 0x10d9c46f, 
  0x10ef822d, 0x11054c30, 0x111b2274, 0x113104f4, 
  0x1146f3ab, 0x115cee95, 0x1172f5ab, 0x118908e9, 
  0x119f284a, 0x11b553ca, 0x11cb8b62, 0x11e1cf0f, 
  0x11f81eca, 0x120e7a90, 0x1224e25a, 0x123b5624, 
  0x1251d5e9, 0x126861a3, 0x127ef94e, 0x12959ce3, 
  0x12ac4c5e, 0x12c307bb, 0x12d9cef2, 0x12f0a200, 
  0x130780df, 0x131e6b89, 0x133561fa, 0x134c642c, 
  0x1363721a, 0x137a8bbe, 0x1391b113, 0x13a8e213, 
  0x13c01eba, 0x13d76702, 0x13eebae5, 0x14061a5d, 
  0x141d8567, 0x1434fbfb, 0x144c7e14, 0x14640bad, 
  0x147ba4c1, 0x14934949, 0x14aaf941, 0x14c2b4a2, 
  0x14da7b67, 0x14f24d8a, 0x150a2b06, 0x152213d5, 
  0x153a07f1, 0x15520755, 0x156a11fb, 0x158227dd, 
  0x159a48f5, 0x15b2753d, 0x15caacb1, 0x15e2ef49, 
  0x15fb3d01, 0x161395d1, 0x162bf9b6, 0x164468a7, 
  0x165ce2a1, 0x1675679c, 0x168df793, 0x16a6927f, 
  0x16bf385c, 0x16d7e922, 0x16f0a4cc, 0x17096b54, 
  0x17223cb4, 0x173b18e5, 0x1753ffe2, 0x176cf1a5, 
  0x1785ee27, 0x179ef562, 0x17b80750, 0x17d123eb, 
  0x17ea4b2d, 0x18037d10, 0x181cb98c, 0x1836009d, 
  0x184f523c, 0x1868ae62, 0x1882150a, 0x189b862c, 
  0x18b501c3, 0x18ce87c9, 0x18e81836, 0x1901b305, 
  0x191b582e, 0x193507ad, 0x194ec17a, 0x1968858e, 
  0x198253e4, 0x199c2c75, 0x19b60f3a, 0x19cffc2d, 
  0x19e9f347, 0x1a03f482, 0x1a1dffd7, 0x1a381540, 
  0x1a5234b5, 0x1a6c5e31, 0x1a8691ac, 0x1aa0cf21, 
  0x1abb1687, 0x1ad567d9, 0x1aefc310, 0x1b0a2826, 
  0x1b249712, 0x1b3f0fcf, 0x1b599256, 0x1b741ea0, 
  0x1b8eb4a7, 0x1ba95462, 0x1bc3fdcc, 0x1bdeb0de, 
  0x1bf96d90, 0x1c1433dc, 0x1c2f03bc, 0x1c49dd26, 
  0x1c64c016, 0x1c7fac84, 0x1c9aa269, 0x1cb5a1be, 
  0x1cd0aa7c, 0x1cebbc9b, 0x1d06d816, 0x1d21fce4, 
  0x1d3d2aff, 0x1d58625f, 0x1d73a2fe, 0x1d8eecd4, 
  0x1daa3fda, 0x1dc59c09, 0x1de10159, 0x1dfc6fc4, 
  0x1e17e742, 0x1e3367cc, 0x1e4ef15b, 0x1e6a83e7, 
  0x1e861f69, 0x1ea1c3da, 0x1ebd7132, 0x1ed9276b, 
  0x1ef4e67c, 0x1f10ae5e, 0x1f2c7f0a, 0x1f485878, 
  0x1f643aa2, 0x1f80257f, 0x1f9c1908, 0x1fb81536, 
  0x1fd41a00, 0x1ff02760, 0x200c3d4e, 0x20285bc3, 
  0x204482b6, 0x2060b221, 0x207ce9fb, 0x20992a3d, 
  0x20b572e0, 0x20d1c3db, 0x20ee1d28, 0x210a7ebd, 
  0x2126e895, 0x21435aa6, 0x215fd4e9, 0x217c5757, 
  0x2198e1e7, 0x21b57493, 0x21d20f51, 0x21eeb21a, 
  0x220b5ce7, 0x22280faf, 0x2244ca6b, 0x22618d13, 
  0x227e579f, 0x229b2a06, 0x22b80442, 0x22d4e649, 
  0x22f1d015, 0x230ec19d, 0x232bbad8, 0x2348bbc0, 
  0x2365c44c, 0x2382d474, 0x239fec30, 0x23bd0b78, 
  0x23da3243, 0x23f7608b, 0x24149645, 0x2431d36c, 
  0x244f17f5, 0x246c63d9, 0x2489b711, 0x24a71193, 
  0x24c47358, 0x24e1dc56, 0x24ff4c87, 0x251cc3e2, 
  0x253a425e, 0x2557c7f3, 0x25755499, 0x2592e848, 
  0x25b082f7, 0x25ce249e, 0x25ebcd34, 0x26097cb2, 
  0x2627330e, 0x2644f040, 0x2662b441, 0x26807f06, 
  0x269e5089, 0x26bc28c1, 0x26da07a4, 0x26f7ed2b, 
  0x2715d94d, 0x2733cc02, 0x2751c540, 0x276fc500, 
  0x278dcb39, 0x27abd7e2, 0x27c9eaf3, 0x27e80463, 
  0x28062429, 0x28244a3d, 0x28427697, 0x2860a92d, 
  0x287ee1f6, 0x289d20eb, 0x28bb6602, 0x28d9b133, 
  0x28f80275, 0x291659bf, 0x2934b709, 0x29531a49, 
  0x29718377, 0x298ff28b, 0x29ae677a, 0x29cce23d, 
  0x29eb62cb, 0x2a09e91b, 0x2a287523, 0x2a4706dc, 
  0x2a659e3b, 0x2a843b39, 0x2aa2ddcc, 0x2ac185ec, 
  0x2ae0338f, 0x2afee6ac, 0x2b1d9f3b, 0x2b3c5d33, 
  0x2b5b208a, 0x2b79e938, 0x2b98b734, 0x2bb78a73, 
  0x2bd662ef, 0x2bf5409d, 0x2c142374, 0x2c330b6b, 
  0x2c51f87a, 0x2c70ea97, 0x2c8fe1b8, 0x2caeddd6, 
  0x2ccddee6, 0x2cece4e0, 0x2d0befbb, 0x2d2aff6c, 
  0x2d4a13ec, 0x2d692d31, 0x2d884b31, 0x2da76de4, 
  0x2dc69540, 0x2de5c13c, 0x2e04f1cf, 0x2e2426f0, 
  0x2e436094, 0x2e629eb4, 0x2e81e145, 0x2ea1283f, 
  0x2ec07398, 0x2edfc346, 0x2eff1741, 0x2f1e6f7f, 
  0x2f3dcbf7, 0x2f5d2c9f, 0x2f7c916f, 0x2f9bfa5b, 
  0x2fbb675c, 0x2fdad868, 0x2ffa4d75, 0x3019c67b, 
  0x3039436f, 0x3058c447, 0x307848fc, 0x3097d183, 
  0x30b75dd2, 0x30d6ede1, 0x30f681a6, 0x31161917, 
  0x3135b42a, 0x315552d7, 0x3174f514, 0x31949ad7, 
  0x31b44417, 0x31d3f0c9, 0x31f3a0e6, 0x32135462, 
  0x32330b35, 0x3252c554, 0x327282b7, 0x32924353, 
  0x32b20720, 0x32d1ce13, 0x32f19823, 0x33116546, 
  0x33313572, 0x3351089f, 0x3370dec1, 0x3390b7d1, 
  0x33b093c3, 0x33d0728e, 0x33f05429, 0x3410388a, 
  0x34301fa7, 0x34500976, 0x346ff5ef, 0x348fe506, 
  0x34afd6b2, 0x34cfcaeb, 0x34efc1a5, 0x350fbad7, 
  0x352fb677, 0x354fb47c, 0x356fb4dc, 0x358fb78d, 
  0x35afbc85, 0x35cfc3bb, 0x35efcd25, 0x360fd8b8, 
  0x362fe66b, 0x364ff635, 0x3670080c, 0x36901be5, 
  0x36b031b7, 0x36d04978, 0x36f0631e, 0x37107e9f, 
  0x37309bf2, 0x3750bb0d, 0x3770dbe6, 0x3790fe72, 
  0x37b122a9, 0x37d14880, 0x37f16fee, 0x381198e8, 
  0x3831c364, 0x3851ef5a, 0x38721cbe, 0x38924b87, 
  0x38b27bab, 0x38d2ad21, 0x38f2dfdd, 0x391313d8, 
  0x39334905, 0x39537f5c, 0x3973b6d3, 0x3993ef60, 
  0x39b428f8, 0x39d46393, 0x39f49f25, 0x3a14dba5, 
  0x3a351909, 0x3a555748, 0x3a759657, 0x3a95d62c, 
  0x3ab616bd, 0x3ad65801, 0x3af699ed, 0x3b16dc78, 
  0x3b371f97, 0x3b576341, 0x3b77a76b, 0x3b97ec0c, 
  0x3bb8311a, 0x3bd8768b, 0x3bf8bc54, 0x3c19026c, 
  0x3c3948c9, 0x3c598f61, 0x3c79d62a, 0x3c9a1d1a, 
  0x3cba6427, 0x3cdaab47, 0x3cfaf270, 0x3d1b3998, 
  0x3d3b80b5, 0x3d5bc7be, 0x3d7c0ea7, 0x3d9c5568, 
  0x3dbc9bf6, 0x3ddce247, 0x3dfd2852, 0x3e1d6e0c, 
  0x3e3db36b, 0x3e5df866, 0x3e7e3cf2, 0x3e9e8105, 
  0x3ebec496, 0x3edf079b, 0x3eff4a09, 0x3f1f8bd7, 
  0x3f3fccfa, 0x3f600d69, 0x3f804d19, 0x3fa08c02, 
  0x3fc0ca18, 0x3fe10752, 0x400143a6, 0x40217f0a, 
  0x4041b974, 0x4061f2da, 0x40822b32, 0x40a26272, 
  0x40c29890, 0x40e2cd83, 0x41030140, 0x412333bd, 
  0x414364f1, 0x416394d1, 0x4183c354, 0x41a3f070, 
  0x41c41c1a, 0x41e44649, 0x42046ef4, 0x4224960f, 
  0x4244bb92, 0x4264df71, 0x428501a5, 0x42a52221, 
  0x42c540dd, 0x42e55dcf, 0x430578ed, 0x4325922c, 
  0x4345a984, 0x4365beea, 0x4385d254, 0x43a5e3b9, 
  0x43c5f30f, 0x43e6004b, 0x44060b64, 0x44261451, 
  0x44461b06, 0x44661f7b, 0x448621a6, 0x44a6217d, 
  0x44c61ef5, 0x44e61a06, 0x450612a6, 0x452608ca, 
  0x4545fc69, 0x4565ed79, 0x4585dbf0, 0x45a5c7c5, 
  0x45c5b0ee, 0x45e59761, 0x46057b14, 0x46255bfe, 
  0x46453a14, 0x4665154e, 0x4684eda2, 0x46a4c304, 
  0x46c4956d, 0x46e464d3, 0x4704312b, 0x4723fa6c, 
  0x4743c08c, 0x47638382, 0x47834344, 0x47a2ffc8, 
  0x47c2b905, 0x47e26ef1, 0x48022183, 0x4821d0b0, 
  0x48417c70, 0x486124b8, 0x4880c980, 0x48a06abd, 
  0x48c00866, 0x48dfa272, 0x48ff38d6, 0x491ecb8a, 
  0x493e5a83, 0x495de5b9, 0x497d6d21, 0x499cf0b3, 
  0x49bc7065, 0x49dbec2d, 0x49fb6402, 0x4a1ad7da, 
  0x4a3a47ac, 0x4a59b36f, 0x4a791b19, 0x4a987ea1, 
  0x4ab7ddfd, 0x4ad73923, 0x4af6900c, 0x4b15e2ac, 
  0x4b3530fc, 0x4b547af1, 0x4b73c082, 0x4b9301a5, 
  0x4bb23e53, 0x4bd17680, 0x4bf0aa24, 0x4c0fd937, 
  0x4c2f03ad, 0x4c4e297f, 0x4c6d4aa2, 0x4c8c670e, 
  0x4cab7eba, 0x4cca919c, 0x4ce99fab, 0x4d08a8de, 
  0x4d27ad2b, 0x4d46ac8b, 0x4d65a6f2, 0x4d849c59, 
  0x4da38cb7, 0x4dc27801, 0x4de15e30, 0x4e003f39, 
  0x4e1f1b15, 0x4e3df1b9, 0x4e5cc31e, 0x4e7b8f39, 
  0x4e9a5602, 0x4eb91770, 0x4ed7d37a, 0x4ef68a17, 
  0x4f153b3e, 0x4f33e6e7, 0x4f528d07, 0x4f712d97, 
  0x4f8fc88d, 0x4fae5de1, 0x4fcced89, 0x4feb777e, 
  0x5009fbb6, 0x50287a28, 0x5046f2cb, 0x50656597, 
  0x5083d283, 0x50a23987, 0x50c09a99, 0x50def5b1, 
  0x50fd4ac6, 0x511b99cf, 0x5139e2c5, 0x5158259d, 
  0x51766250, 0x519498d6, 0x51b2c924, 0x51d0f333, 
  0x51ef16fb, 0x520d3472, 0x522b4b91, 0x52495c4e, 
  0x526766a1, 0x52856a82, 0x52a367e9, 0x52c15ecc, 
  0x52df4f24, 0x52fd38e7, 0x531b1c0f, 0x5338f892, 
  0x5356ce68, 0x53749d88, 0x539265eb, 0x53b02788, 
  0x53cde256, 0x53eb964f, 0x54094368, 0x5426e99b, 
  0x544488df, 0x5462212b, 0x547fb278, 0x549d3cbd, 
  0x54babff3, 0x54d83c11, 0x54f5b110, 0x55131ee6, 
  0x5530858d, 0x554de4fb, 0x556b3d2a, 0x55888e11, 
  0x55a5d7a8, 0x55c319e7, 0x55e054c6, 0x55fd883e, 
  0x561ab446, 0x5637d8d7, 0x5654f5e9, 0x56720b74, 
  0x568f1971, 0x56ac1fd6, 0x56c91e9e, 0x56e615bf, 
  0x57030533, 0x571fecf1, 0x573cccf2, 0x5759a52f, 
  0x5776759f, 0x57933e3b, 0x57affefc, 0x57ccb7da, 
  0x57e968cd, 0x580611ce, 0x5822b2d6, 0x583f4bdc, 
  0x585bdcda, 0x587865c8, 0x5894e69f, 0x58b15f57, 
  0x58cdcfe8, 0x58ea384d, 0x5906987d, 0x5922f070, 
  0x593f4021, 0x595b8787, 0x5977c69b, 0x5993fd56, 
  0x59b02bb2, 0x59cc51a6, 0x59e86f2b, 0x5a04843c, 
  0x5a2090cf, 0x5a3c94df, 0x5a589065, 0x5a748358, 
  0x5a906db3, 0x5aac4f6f, 0x5ac82884, 0x5ae3f8eb, 
  0x5affc09e, 0x5b1b7f97, 0x5b3735cc, 0x5b52e33a, 
  0x5b6e87d7, 0x5b8a239e, 0x5ba5b688, 0x5bc1408e, 
  0x5bdcc1aa, 0x5bf839d4, 0x5c13a906, 0x5c2f0f3a, 
  0x5c4a6c69, 0x5c65c08c, 0x5c810b9d, 0x5c9c4d96, 
  0x5cb7866f, 0x5cd2b622, 0x5ceddcaa, 0x5d08f9ff, 
  0x5d240e1b, 0x5d3f18f7, 0x5d5a1a8e, 0x5d7512d9, 
  0x5d9001d2, 0x5daae773, 0x5dc5c3b4, 0x5de09691, 
  0x5dfb6003, 0x5e162003, 0x5e30d68c, 0x5e4b8398, 
  0x5e662720, 0x5e80c11e, 0x5e9b518d, 0x5eb5d866, 
  0x5ed055a3, 0x5eeac93f, 0x5f053334, 0x5f1f937b, 
  0x5f39ea0e, 0x5f5436e9, 0x5f6e7a05, 0x5f88b35c, 
  0x5fa2e2e9, 0x5fbd08a5, 0x5fd7248c, 0x5ff13697, 
  0x600b3ec1, 0x60253d04, 0x603f315b, 0x60591bbf, 
  0x6072fc2d, 0x608cd29d, 0x60a69f0b, 0x60c06171, 
  0x60da19c9, 0x60f3c80f, 0x610d6c3c, 0x6127064c, 
  0x61409639, 0x615a1bfe, 0x61739796, 0x618d08fb, 
  0x61a67028, 0x61bfcd19, 0x61d91fc7, 0x61f2682e, 
  0x620ba649, 0x6224da12, 0x623e0385, 0x6257229c, 
  0x62703754, 0x628941a5, 0x62a2418d, 0x62bb3705, 
  0x62d42209, 0x62ed0295, 0x6305d8a3, 0x631ea42e, 
  0x63376532, 0x63501baa, 0x6368c792, 0x638168e5, 
  0x6399ff9d, 0x63b28bb7, 0x63cb0d2f, 0x63e383fe, 
  0x63fbf021, 0x64145194, 0x642ca852, 0x6444f456, 
  0x645d359d, 0x64756c21, 0x648d97df, 0x64a5b8d2, 
  0x64bdcef6, 0x64d5da46, 0x64eddabf, 0x6505d05c, 
  0x651dbb19, 0x65359af1, 0x654d6fe2, 0x656539e7, 
  0x657cf8fb, 0x6594ad1a, 0x65ac5642, 0x65c3f46d, 
  0x65db8798, 0x65f30fc0, 0x660a8cdf, 0x6621fef2, 
  0x663965f6, 0x6650c1e7, 0x666812c0, 0x667f587f, 
  0x6696931f, 0x66adc29e, 0x66c4e6f6, 0x66dc0025, 
  0x66f30e28, 0x670a10fa, 0x67210898, 0x6737f4fe, 
  0x674ed62a, 0x6765ac18, 0x677c76c4, 0x6793362b, 
  0x67a9ea4a, 0x67c0931e, 0x67d730a2, 0x67edc2d5, 
  0x680449b3, 0x681ac538, 0x68313561, 0x68479a2c, 
  0x685df396, 0x6874419a, 0x688a8437, 0x68a0bb69, 
  0x68b6e72e, 0x68cd0781, 0x68e31c62, 0x68f925cc, 
  0x690f23bd, 0x69251632, 0x693afd28, 0x6950d89d, 
  0x6966a88e, 0x697c6cf8, 0x699225d8, 0x69a7d32c, 
  0x69bd74f2, 0x69d30b26, 0x69e895c7, 0x69fe14d2, 
  0x6a138843, 0x6a28f01a, 0x6a3e4c53, 0x6a539ced, 
  0x6a68e1e4, 0x6a7e1b36, 0x6a9348e2, 0x6aa86ae5, 
  0x6abd813c, 0x6ad28be7, 0x6ae78ae1, 0x6afc7e2a, 
  0x6b1165bf, 0x6b26419e, 0x6b3b11c6, 0x6b4fd633, 
  0x6b648ee5, 0x6b793bd9, 0x6b8ddd0e, 0x6ba27280, 
  0x6bb6fc30, 0x6bcb7a1a, 0x6bdfec3d, 0x6bf45298, 
  0x6c08ad28, 0x6c1cfbec, 0x6c313ee3, 0x6c45760a, 
  0x6c59a160, 0x6c6dc0e3, 0x6c81d492, 0x6c95dc6c, 
  0x6ca9d86e, 0x6cbdc899, 0x6cd1ace9, 0x6ce5855e, 
  0x6cf951f6, 0x6d0d12b0, 0x6d20c78b, 0x6d347086, 
  0x6d480d9f, 0x6d5b9ed5, 0x6d6f2427, 0x6d829d93, 
  0x6d960b19, 0x6da96cb8, 0x6dbcc26f, 0x6dd00c3c, 
  0x6de34a1e, 0x6df67c15, 0x6e09a220, 0x6e1cbc3e, 
  0x6e2fca6d, 0x6e42ccae, 0x6e55c2ff, 0x6e68ad5f, 
  0x6e7b8bcf, 0x6e8e5e4c, 0x6ea124d7, 0x6eb3df6f, 
  0x6ec68e13, 0x6ed930c2, 0x6eebc77c, 0x6efe5241, 
  0x6f10d110, 0x6f2343e9, 0x6f35aaca, 0x6f4805b4, 
  0x6f5a54a7, 0x6f6c97a1, 0x6f7ecea3, 0x6f90f9ad, 
  0x6fa318be, 0x6fb52bd5, 0x6fc732f3, 0x6fd92e18, 
  0x6feb1d43, 0x6ffd0075, 0x700ed7ad, 0x7020a2ea, 
  0x7032622f, 0x70441579, 0x7055bcc9, 0x70675820, 
  0x7078e77d, 0x708a6ae1, 0x709be24b, 0x70ad4dbc, 
  0x70bead35, 0x70d000b4, 0x70e1483c, 0x70f283cb, 
  0x7103b363, 0x7114d703, 0x7125eeac, 0x7136fa5f, 
  0x7147fa1c, 0x7158ede3, 0x7169d5b5, 0x717ab192, 
  0x718b817c, 0x719c4572, 0x71acfd76, 0x71bda987, 
  0x71ce49a7, 0x71deddd7, 0x71ef6616, 0x71ffe267, 
  0x721052c9, 0x7220b73d, 0x72310fc5, 0x72415c61, 
  0x72519d13, 0x7261d1da, 0x7271fab9, 0x728217b0, 
  0x729228bf, 0x72a22dea, 0x72b2272f, 0x72c21491, 
  0x72d1f610, 0x72e1cbae, 0x72f1956c, 0x7301534b, 
  0x7311054c, 0x7320ab71, 0x733045bb, 0x733fd42c, 
  0x734f56c4, 0x735ecd85, 0x736e3871, 0x737d9789, 
  0x738ceace, 0x739c3242, 0x73ab6de6, 0x73ba9dbd, 
  0x73c9c1c8, 0x73d8da07, 0x73e7e67e, 0x73f6e72d, 
  0x7405dc16, 0x7414c53b, 0x7423a29e, 0x74327441, 
  0x74413a25, 0x744ff44c, 0x745ea2b8, 0x746d456b, 
  0x747bdc67, 0x748a67ad, 0x7498e741, 0x74a75b22, 
  0x74b5c355, 0x74c41fdb, 0x74d270b5, 0x74e0b5e6, 
  0x74eeef70, 0x74fd1d56, 0x750b3f99, 0x7519563b, 
  0x7527613f, 0x753560a8, 0x75435476, 0x75513cad, 
  0x755f1950, 0x756cea5f, 0x757aafde, 0x758869d0, 
  0x75961836, 0x75a3bb13, 0x75b15269, 0x75bede3b, 
  0x75cc5e8c, 0x75d9d35e, 0x75e73cb4, 0x75f49a90, 
  0x7601ecf5, 0x760f33e5, 0x761c6f64, 0x76299f73, 
  0x7636c416, 0x7643dd50, 0x7650eb23, 0x765ded92, 
  0x766ae49f, 0x7677d04f, 0x7684b0a3, 0x7691859e, 
  0x769e4f44, 0x76ab0d97, 0x76b7c09b, 0x76c46851, 
  0x76d104be, 0x76dd95e5, 0x76ea1bc8, 0x76f6966a, 
  0x770305cf, 0x770f69fa, 0x771bc2ee, 0x772810ae, 
  0x7734533d, 0x77408a9f, 0x774cb6d6, 0x7758d7e7, 
  0x7764edd4, 0x7770f8a1, 0x777cf851, 0x7788ece7, 
  0x7794d667, 0x77a0b4d4, 0x77ac8832, 0x77b85084, 
  0x77c40dcd, 0x77cfc012, 0x77db6755, 0x77e7039a, 
  0x77f294e5, 0x77fe1b3a, 0x7809969b, 0x7815070d, 
  0x78206c92, 0x782bc730, 0x783716e9, 0x78425bc2, 
  0x784d95bd, 0x7858c4e0, 0x7863e92c, 0x786f02a8, 
  0x787a1155, 0x78851538, 0x78900e55, 0x789afcb0, 
  0x78a5e04c, 0x78b0b92e, 0x78bb875a, 0x78c64ad3, 
  0x78d1039d, 0x78dbb1bd, 0x78e65536, 0x78f0ee0d, 
  0x78fb7c45, 0x7905ffe3, 0x791078eb, 0x791ae761, 
  0x79254b49, 0x792fa4a7, 0x7939f37f, 0x794437d6, 
  0x794e71af, 0x7958a110, 0x7962c5fc, 0x796ce077, 
  0x7976f087, 0x7980f62e, 0x798af172, 0x7994e257, 
  0x799ec8e1, 0x79a8a514, 0x79b276f6, 0x79bc3e8a, 
  0x79c5fbd5, 0x79cfaedb, 0x79d957a1, 0x79e2f62b, 
  0x79ec8a7e, 0x79f6149e, 0x79ff9491, 0x7a090a59, 
  0x7a1275fd, 0x7a1bd780, 0x7a252ee8, 0x7a2e7c38, 
  0x7a37bf76, 0x7a40f8a6, 0x7a4a27cd, 0x7a534cf0, 
  0x7a5c6812, 0x7a65793a, 0x7a6e806c, 0x7a777dac, 
  0x7a8070ff, 0x7a895a6a, 0x7a9239f3, 0x7a9b0f9d, 
  0x7aa3db6e, 0x7aac9d6a, 0x7ab55596, 0x7abe03f8, 
  0x7ac6a894, 0x7acf436f, 0x7ad7d48e, 0x7ae05bf5, 
  0x7ae8d9ab, 0x7af14db4, 0x7af9b814, 0x7b0218d1, 
  0x7b0a6ff1, 0x7b12bd77, 0x7b1b0169, 0x7b233bcd, 
  0x7b2b6ca6, 0x7b3393fb, 0x7b3bb1d0, 0x7b43c62b, 
  0x7b4bd110, 0x7b53d285, 0x7b5bca8f, 0x7b63b934, 
  0x7b6b9e77, 0x7b737a60, 0x7b7b4cf2, 0x7b831633, 
  0x7b8ad628, 0x7b928cd7, 0x7b9a3a44, 0x7ba1de76, 
  0x7ba97971, 0x7bb10b3b, 0x7bb893d8, 0x7bc0134f, 
  0x7bc789a5, 0x7bcef6df, 0x7bd65b02, 0x7bddb615, 
  0x7be5081b, 0x7bec511b, 0x7bf3911a, 0x7bfac81e, 
  0x7c01f62b, 0x7c091b48, 0x7c10377a, 0x7c174ac6, 
  0x7c1e5531, 0x7c2556c3, 0x7c2c4f7f, 0x7c333f6b, 
  0x7c3a268d, 0x7c4104eb, 0x7c47da89, 0x7c4ea76e, 
  0x7c556ba0, 0x7c5c2723, 0x7c62d9fd, 0x7c698434, 
  0x7c7025ce, 0x7c76becf, 0x7c7d4f3f, 0x7c83d722, 
  0x7c8a567e, 0x7c90cd59, 0x7c973bb8, 0x7c9da1a1, 
  0x7ca3ff1a, 0x7caa5429, 0x7cb0a0d2, 0x7cb6e51d, 
  0x7cbd210e, 0x7cc354ab, 0x7cc97ffb, 0x7ccfa303, 
  0x7cd5bdc8, 0x7cdbd050, 0x7ce1daa2, 0x7ce7dcc2, 
  0x7cedd6b7, 0x7cf3c887, 0x7cf9b237, 0x7cff93ce, 
  0x7d056d50, 0x7d0b3ec4, 0x7d11082f, 0x7d16c999, 
  0x7d1c8305, 0x7d22347b, 0x7d27ddff, 0x7d2d7f99, 
  0x7d33194e, 0x7d38ab23, 0x7d3e351e, 0x7d43b747, 
  0x7d4931a1, 0x7d4ea434, 0x7d540f05, 0x7d59721a, 
  0x7d5ecd7a, 0x7d642129, 0x7d696d2e, 0x7d6eb18f, 
  0x7d73ee52, 0x7d79237d, 0x7d7e5116, 0x7d837722, 
  0x7d8895a8, 0x7d8dacad, 0x7d92bc39, 0x7d97c450, 
  0x7d9cc4f8, 0x7da1be38, 0x7da6b016, 0x7dab9a98, 
  0x7db07dc3, 0x7db5599d, 0x7dba2e2e, 0x7dbefb7a, 
  0x7dc3c188, 0x7dc8805d, 0x7dcd3801, 0x7dd1e878, 
  0x7dd691c9, 0x7ddb33fa, 0x7ddfcf11, 0x7de46314, 
  0x7de8f009, 0x7ded75f7, 0x7df1f4e2, 0x7df66cd2, 
  0x7dfaddcc, 0x7dff47d6, 0x7e03aaf7, 0x7e080734, 
  0x7e0c5c94, 0x7e10ab1d, 0x7e14f2d4, 0x7e1933c0, 
  0x7e1d6de7, 0x7e21a14f, 0x7e25cdfe, 0x7e29f3fb, 
  0x7e2e134b, 0x7e322bf4, 0x7e363dfc, 0x7e3a496a, 
  0x7e3e4e44, 0x7e424c8f, 0x7e464453, 0x7e4a3594, 
  0x7e4e2059, 0x7e5204a9, 0x7e55e288, 0x7e59b9fe, 
  0x7e5d8b11, 0x7e6155c6, 0x7e651a23, 0x7e68d830, 
  0x7e6c8ff1, 0x7e70416d, 0x7e73ecab, 0x7e7791af, 
  0x7e7b3081, 0x7e7ec926, 0x7e825ba5, 0x7e85e803, 
  0x7e896e47, 0x7e8cee76, 0x7e906898, 0x7e93dcb1, 
  0x7e974ac9, 0x7e9ab2e4, 0x7e9e150a, 0x7ea17140, 
  0x7ea4c78d, 0x7ea817f6, 0x7eab6282, 0x7eaea736, 
  0x7eb1e619, 0x7eb51f32, 0x7eb85284, 0x7ebb8018, 
  0x7ebea7f3, 0x7ec1ca1c, 0x7ec4e697, 0x7ec7fd6c, 
  0x7ecb0ea0, 0x7ece1a39, 0x7ed1203e, 0x7ed420b5, 
  0x7ed71ba3, 0x7eda110e, 0x7edd00fe, 0x7edfeb77, 
  0x7ee2d080, 0x7ee5b01e, 0x7ee88a59, 0x7eeb5f35, 
  0x7eee2eb9, 0x7ef0f8ec, 0x7ef3bdd2, 0x7ef67d72, 
  0x7ef937d2, 0x7efbecf8, 0x7efe9cea, 0x7f0147ad, 
  0x7f03ed49, 0x7f068dc3, 0x7f092921, 0x7f0bbf68, 
  0x7f0e50a0, 0x7f10dccd, 0x7f1363f6, 0x7f15e621, 
  0x7f186354, 0x7f1adb94, 0x7f1d4ee8, 0x7f1fbd56, 
  0x7f2226e3, 0x7f248b95, 0x7f26eb73, 0x7f294682, 
  0x7f2b9cc8, 0x7f2dee4c, 0x7f303b12, 0x7f328321, 
  0x7f34c67f, 0x7f370532, 0x7f393f3f, 0x7f3b74ac, 
  0x7f3da580, 0x7f3fd1c0, 0x7f41f971, 0x7f441c9b, 
  0x7f463b42, 0x7f48556c, 0x7f4a6b20, 0x7f4c7c63, 
  0x7f4e893b, 0x7f5091ad, 0x7f5295c0, 0x7f549579, 
  0x7f5690df, 0x7f5887f6, 0x7f5a7ac4, 0x7f5c6950, 
  0x7f5e539f, 0x7f6039b7, 0x7f621b9d, 0x7f63f957, 
  0x7f65d2ec, 0x7f67a860, 0x7f6979b9, 0x7f6b46fe, 
  0x7f6d1033, 0x7f6ed55f, 0x7f709686, 0x7f7253b0, 
  0x7f740ce0, 0x7f75c21e, 0x7f77736f, 0x7f7920d7, 
  0x7f7aca5e, 0x7f7c7007, 0x7f7e11da, 0x7f7fafdc, 
  0x7f814a12, 0x7f82e081, 0x7f847330, 0x7f860223, 
  0x7f878d61, 0x7f8914ef, 0x7f8a98d3, 0x7f8c1911, 
  0x7f8d95af, 0x7f8f0eb4, 0x7f908424, 0x7f91f604, 
  0x7f93645b, 0x7f94cf2e, 0x7f963682, 0x7f979a5c, 
  0x7f98fac3, 0x7f9a57ba, 0x7f9bb149, 0x7f9d0774, 
  0x7f9e5a40, 0x7f9fa9b3, 0x7fa0f5d2, 0x7fa23ea3, 
  0x7fa3842a, 0x7fa4c66e, 0x7fa60574, 0x7fa74140, 
  0x7fa879d8, 0x7fa9af41, 0x7faae181, 0x7fac109d, 
  0x7fad3c99, 0x7fae657c, 0x7faf8b4b, 0x7fb0ae0a, 
  0x7fb1cdbf, 0x7fb2ea6f, 0x7fb4041f, 0x7fb51ad4, 
  0x7fb62e94, 0x7fb73f63, 0x7fb84d47, 0x7fb95845, 
  0x7fba6061, 0x7fbb65a1, 0x7fbc680b, 0x7fbd67a2, 
  0x7fbe646c, 0x7fbf5e6f, 0x7fc055ae, 0x7fc14a30, 
  0x7fc23bf8, 0x7fc32b0c, 0x7fc41772, 0x7fc5012d, 
  0x7fc5e843, 0x7fc6ccb9, 0x7fc7ae93, 0x7fc88dd7, 
  0x7fc96a89, 0x7fca44ae, 0x7fcb1c4b, 0x7fcbf166, 
  0x7fccc402, 0x7fcd9424, 0x7fce61d2, 0x7fcf2d10, 
  0x7fcff5e2, 0x7fd0bc4e, 0x7fd18059, 0x7fd24206, 
  0x7fd3015b, 0x7fd3be5c, 0x7fd4790f, 0x7fd53177, 
  0x7fd5e79a, 0x7fd69b7b, 0x7fd74d20, 0x7fd7fc8d, 
  0x7fd8a9c7, 0x7fd954d3, 0x7fd9fdb4, 0x7fdaa470, 
  0x7fdb490a, 0x7fdbeb88, 0x7fdc8bee, 0x7fdd2a41, 
  0x7fddc684, 0x7fde60bd, 0x7fdef8ef, 0x7fdf8f1f, 
  0x7fe02352, 0x7fe0b58c, 0x7fe145d2, 0x7fe1d427, 
  0x7fe26090, 0x7fe2eb11, 0x7fe373af, 0x7fe3fa6e, 
  0x7fe47f52, 0x7fe5025f, 0x7fe5839a, 0x7fe60307, 
  0x7fe680aa, 0x7fe6fc87, 0x7fe776a3, 0x7fe7ef01, 
  0x7fe865a6, 0x7fe8da96, 0x7fe94dd5, 0x7fe9bf67, 
  0x7fea2f50, 0x7fea9d94, 0x7feb0a38, 0x7feb753f, 
  0x7febdead, 0x7fec4686, 0x7fecacce, 0x7fed118a, 
  0x7fed74bd, 0x7fedd66b, 0x7fee3697, 0x7fee9547, 
  0x7feef27d, 0x7fef4e3e, 0x7fefa88d, 0x7ff0016e, 
  0x7ff058e6, 0x7ff0aef7, 0x7ff103a5, 0x7ff156f5, 
  0x7ff1a8ea, 0x7ff1f987, 0x7ff248d1, 0x7ff296cb, 
  0x7ff2e379, 0x7ff32ede, 0x7ff378fe, 0x7ff3c1dd, 
  0x7ff4097d, 0x7ff44fe4, 0x7ff49514, 0x7ff4d910, 
  0x7ff51bdd, 0x7ff55d7e, 0x7ff59df6, 0x7ff5dd49, 
  0x7ff61b7a, 0x7ff6588c, 0x7ff69484, 0x7ff6cf64, 
  0x7ff7092f, 0x7ff741ea, 0x7ff77997, 0x7ff7b03a, 
  0x7ff7e5d6, 0x7ff81a6e, 0x7ff84e05, 0x7ff880a0, 
  0x7ff8b240, 0x7ff8e2e9, 0x7ff9129f, 0x7ff94164, 
  0x7ff96f3c, 0x7ff99c2a, 0x7ff9c830, 0x7ff9f353, 
  0x7ffa1d94, 0x7ffa46f8, 0x7ffa6f80, 0x7ffa9730, 
  0x7ffabe0c, 0x7ffae415, 0x7ffb0950, 0x7ffb2dbe, 
  0x7ffb5163, 0x7ffb7441, 0x7ffb965c, 0x7ffbb7b7, 
  0x7ffbd853, 0x7ffbf835, 0x7ffc175e, 0x7ffc35d2, 
  0x7ffc5393, 0x7ffc70a4, 0x7ffc8d08, 0x7ffca8c1, 
  0x7ffcc3d3, 0x7ffcde3e, 0x7ffcf808, 0x7ffd1131, 
  0x7ffd29bd, 0x7ffd41ad, 0x7ffd5906, 0x7ffd6fc8, 
  0x7ffd85f8, 0x7ffd9b96, 0x7ffdb0a6, 0x7ffdc52a, 
  0x7ffdd925, 0x7ffdec98, 0x7ffdff87, 0x7ffe11f3, 
  0x7ffe23df, 0x7ffe354e, 0x7ffe4641, 0x7ffe56bb, 
  0x7ffe66be, 0x7ffe764d, 0x7ffe8569, 0x7ffe9415, 
  0x7ffea253, 0x7ffeb025, 0x7ffebd8d, 0x7ffeca8e, 
  0x7ffed729, 0x7ffee361, 0x7ffeef37, 0x7ffefaae, 
  0x7fff05c8, 0x7fff1086, 0x7fff1aeb, 0x7fff24f8, 
  0x7fff2eb0, 0x7fff3815, 0x7fff4127, 0x7fff49ea, 
  0x7fff525f, 0x7fff5a87, 0x7fff6265, 0x7fff69fb, 
  0x7fff714a, 0x7fff7853, 0x7fff7f19, 0x7fff859e, 
  0x7fff8be2, 0x7fff91e9, 0x7fff97b2, 0x7fff9d40, 
  0x7fffa295, 0x7fffa7b2, 0x7fffac98, 0x7fffb14a, 
  0x7fffb5c8, 0x7fffba14, 0x7fffbe30, 0x7fffc21c, 
  0x7fffc5db, 0x7fffc96e, 0x7fffccd7, 0x7fffd015, 
  0x7fffd32c, 0x7fffd61b, 0x7fffd8e6, 0x7fffdb8c, 
  0x7fffde0e, 0x7fffe070, 0x7fffe2b0, 0x7fffe4d1, 
  0x7fffe6d4, 0x7fffe8ba, 0x7fffea84, 0x7fffec33, 
  0x7fffedc8, 0x7fffef44, 0x7ffff0a9, 0x7ffff1f6, 
  0x7ffff32f, 0x7ffff452, 0x7ffff561, 0x7ffff65e, 
  0x7ffff748, 0x7ffff822, 0x7ffff8eb, 0x7ffff9a5, 
  0x7ffffa50, 0x7ffffaed, 0x7ffffb7d, 0x7ffffc01, 
  0x7ffffc79, 0x7ffffce6, 0x7ffffd49, 0x7ffffda2, 
  0x7ffffdf3, 0x7ffffe3b, 0x7ffffe7b, 0x7ffffeb5, 
  0x7ffffee7, 0x7fffff14, 0x7fffff3b, 0x7fffff5d, 
  0x7fffff7a, 0x7fffff94, 0x7fffffa9, 0x7fffffbb, 
  0x7fffffca, 0x7fffffd6, 0x7fffffe1, 0x7fffffe9, 
  0x7fffffef, 0x7ffffff4, 0x7ffffff8, 0x7ffffffa, 
  0x7ffffffc, 0x7ffffffd, 0x7ffffffe, 0x7fffffff, 
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff, 
};

static ogg_int32_t vwin8192[4096]={
  0x0000007c, 0x0000045c, 0x00000c1d, 0x000017bd, 
  0x0000273e, 0x00003a9f, 0x000051e0, 0x00006d02, 
  0x00008c03, 0x0000aee5, 0x0000d5a7, 0x00010049, 
  0x00012ecb, 0x0001612d, 0x00019770, 0x0001d193, 
  0x00020f96, 0x00025178, 0x0002973c, 0x0002e0df, 
  0x00032e62, 0x00037fc5, 0x0003d509, 0x00042e2c, 
  0x00048b30, 0x0004ec13, 0x000550d7, 0x0005b97a, 
  0x000625fe, 0x00069661, 0x00070aa4, 0x000782c8, 
  0x0007fecb, 0x00087eae, 0x00090271, 0x00098a14, 
  0x000a1597, 0x000aa4f9, 0x000b383b, 0x000bcf5d, 
  0x000c6a5f, 0x000d0941, 0x000dac02, 0x000e52a3, 
  0x000efd23, 0x000fab84, 0x00105dc3, 0x001113e3, 
  0x0011cde2, 0x00128bc0, 0x00134d7e, 0x0014131b, 
  0x0014dc98, 0x0015a9f4, 0x00167b30, 0x0017504a, 
  0x00182945, 0x0019061e, 0x0019e6d7, 0x001acb6f, 
  0x001bb3e6, 0x001ca03c, 0x001d9071, 0x001e8485, 
  0x001f7c79, 0x0020784b, 0x002177fc, 0x00227b8c, 
  0x002382fb, 0x00248e49, 0x00259d76, 0x0026b081, 
  0x0027c76b, 0x0028e234, 0x002a00dc, 0x002b2361, 
  0x002c49c6, 0x002d7409, 0x002ea22a, 0x002fd42a, 
  0x00310a08, 0x003243c5, 0x00338160, 0x0034c2d9, 
  0x00360830, 0x00375165, 0x00389e78, 0x0039ef6a, 
  0x003b4439, 0x003c9ce6, 0x003df971, 0x003f59da, 
  0x0040be20, 0x00422645, 0x00439247, 0x00450226, 
  0x004675e3, 0x0047ed7e, 0x004968f5, 0x004ae84b, 
  0x004c6b7d, 0x004df28d, 0x004f7d7a, 0x00510c44, 
  0x00529eeb, 0x00543570, 0x0055cfd1, 0x00576e0f, 
  0x00591029, 0x005ab621, 0x005c5ff5, 0x005e0da6, 
  0x005fbf33, 0x0061749d, 0x00632de4, 0x0064eb06, 
  0x0066ac05, 0x006870e0, 0x006a3998, 0x006c062b, 
  0x006dd69b, 0x006faae6, 0x0071830d, 0x00735f10, 
  0x00753eef, 0x007722a9, 0x00790a3f, 0x007af5b1, 
  0x007ce4fe, 0x007ed826, 0x0080cf29, 0x0082ca08, 
  0x0084c8c2, 0x0086cb57, 0x0088d1c7, 0x008adc11, 
  0x008cea37, 0x008efc37, 0x00911212, 0x00932bc7, 
  0x00954957, 0x00976ac2, 0x00999006, 0x009bb925, 
  0x009de61e, 0x00a016f1, 0x00a24b9e, 0x00a48425, 
  0x00a6c086, 0x00a900c0, 0x00ab44d4, 0x00ad8cc2, 
  0x00afd889, 0x00b22829, 0x00b47ba2, 0x00b6d2f5, 
  0x00b92e21, 0x00bb8d26, 0x00bdf004, 0x00c056ba, 
  0x00c2c149, 0x00c52fb1, 0x00c7a1f1, 0x00ca180a, 
  0x00cc91fb, 0x00cf0fc5, 0x00d19166, 0x00d416df, 
  0x00d6a031, 0x00d92d5a, 0x00dbbe5b, 0x00de5333, 
  0x00e0ebe3, 0x00e3886b, 0x00e628c9, 0x00e8ccff, 
  0x00eb750c, 0x00ee20f0, 0x00f0d0ab, 0x00f3843d, 
  0x00f63ba5, 0x00f8f6e4, 0x00fbb5fa, 0x00fe78e5, 
  0x01013fa7, 0x01040a3f, 0x0106d8ae, 0x0109aaf2, 
  0x010c810c, 0x010f5afb, 0x011238c0, 0x01151a5b, 
  0x0117ffcb, 0x011ae910, 0x011dd62a, 0x0120c719, 
  0x0123bbdd, 0x0126b476, 0x0129b0e4, 0x012cb126, 
  0x012fb53c, 0x0132bd27, 0x0135c8e6, 0x0138d879, 
  0x013bebdf, 0x013f031a, 0x01421e28, 0x01453d0a, 
  0x01485fbf, 0x014b8648, 0x014eb0a4, 0x0151ded2, 
  0x015510d4, 0x015846a8, 0x015b8050, 0x015ebdc9, 
  0x0161ff15, 0x01654434, 0x01688d24, 0x016bd9e6, 
  0x016f2a7b, 0x01727ee1, 0x0175d718, 0x01793321, 
  0x017c92fc, 0x017ff6a7, 0x01835e24, 0x0186c972, 
  0x018a3890, 0x018dab7f, 0x0191223f, 0x01949ccf, 
  0x01981b2f, 0x019b9d5f, 0x019f235f, 0x01a2ad2f, 
  0x01a63acf, 0x01a9cc3e, 0x01ad617c, 0x01b0fa8a, 
  0x01b49767, 0x01b83813, 0x01bbdc8d, 0x01bf84d6, 
  0x01c330ee, 0x01c6e0d4, 0x01ca9488, 0x01ce4c0b, 
  0x01d2075b, 0x01d5c679, 0x01d98964, 0x01dd501d, 
  0x01e11aa3, 0x01e4e8f6, 0x01e8bb17, 0x01ec9104, 
  0x01f06abd, 0x01f44844, 0x01f82996, 0x01fc0eb5, 
  0x01fff7a0, 0x0203e456, 0x0207d4d9, 0x020bc926, 
  0x020fc140, 0x0213bd24, 0x0217bcd4, 0x021bc04e, 
  0x021fc793, 0x0223d2a3, 0x0227e17d, 0x022bf421, 
  0x02300a90, 0x023424c8, 0x023842ca, 0x023c6495, 
  0x02408a2a, 0x0244b389, 0x0248e0b0, 0x024d11a0, 
  0x02514659, 0x02557eda, 0x0259bb24, 0x025dfb35, 
  0x02623f0f, 0x026686b1, 0x026ad21a, 0x026f214b, 
  0x02737443, 0x0277cb02, 0x027c2588, 0x028083d5, 
  0x0284e5e9, 0x02894bc2, 0x028db562, 0x029222c8, 
  0x029693f4, 0x029b08e6, 0x029f819d, 0x02a3fe19, 
  0x02a87e5b, 0x02ad0261, 0x02b18a2c, 0x02b615bb, 
  0x02baa50f, 0x02bf3827, 0x02c3cf03, 0x02c869a3, 
  0x02cd0807, 0x02d1aa2d, 0x02d65017, 0x02daf9c4, 
  0x02dfa734, 0x02e45866, 0x02e90d5b, 0x02edc612, 
  0x02f2828b, 0x02f742c6, 0x02fc06c2, 0x0300ce80, 
  0x030599ff, 0x030a6940, 0x030f3c40, 0x03141302, 
  0x0318ed84, 0x031dcbc6, 0x0322adc8, 0x0327938a, 
  0x032c7d0c, 0x03316a4c, 0x03365b4c, 0x033b500c, 
  0x03404889, 0x034544c6, 0x034a44c0, 0x034f4879, 
  0x03544ff0, 0x03595b24, 0x035e6a16, 0x03637cc5, 
  0x03689331, 0x036dad5a, 0x0372cb40, 0x0377ece2, 
  0x037d1240, 0x03823b5a, 0x03876830, 0x038c98c1, 
  0x0391cd0e, 0x03970516, 0x039c40d8, 0x03a18055, 
  0x03a6c38d, 0x03ac0a7f, 0x03b1552b, 0x03b6a390, 
  0x03bbf5af, 0x03c14b88, 0x03c6a519, 0x03cc0263, 
  0x03d16366, 0x03d6c821, 0x03dc3094, 0x03e19cc0, 
  0x03e70ca2, 0x03ec803d, 0x03f1f78e, 0x03f77296, 
  0x03fcf155, 0x040273cb, 0x0407f9f7, 0x040d83d9, 
  0x04131170, 0x0418a2bd, 0x041e37c0, 0x0423d077, 
  0x04296ce4, 0x042f0d04, 0x0434b0da, 0x043a5863, 
  0x044003a0, 0x0445b290, 0x044b6534, 0x04511b8b, 
  0x0456d595, 0x045c9352, 0x046254c1, 0x046819e1, 
  0x046de2b4, 0x0473af38, 0x04797f6e, 0x047f5355, 
  0x04852aec, 0x048b0635, 0x0490e52d, 0x0496c7d5, 
  0x049cae2e, 0x04a29836, 0x04a885ed, 0x04ae7753, 
  0x04b46c68, 0x04ba652b, 0x04c0619d, 0x04c661bc, 
  0x04cc658a, 0x04d26d04, 0x04d8782c, 0x04de8701, 
  0x04e49983, 0x04eaafb0, 0x04f0c98a, 0x04f6e710, 
  0x04fd0842, 0x05032d1e, 0x050955a6, 0x050f81d8, 
  0x0515b1b5, 0x051be53d, 0x05221c6e, 0x05285748, 
  0x052e95cc, 0x0534d7fa, 0x053b1dd0, 0x0541674e, 
  0x0547b475, 0x054e0544, 0x055459bb, 0x055ab1d8, 
  0x05610d9e, 0x05676d0a, 0x056dd01c, 0x057436d5, 
  0x057aa134, 0x05810f38, 0x058780e2, 0x058df631, 
  0x05946f25, 0x059aebbe, 0x05a16bfa, 0x05a7efdb, 
  0x05ae775f, 0x05b50287, 0x05bb9152, 0x05c223c0, 
  0x05c8b9d0, 0x05cf5382, 0x05d5f0d6, 0x05dc91cc, 
  0x05e33663, 0x05e9de9c, 0x05f08a74, 0x05f739ee, 
  0x05fded07, 0x0604a3c0, 0x060b5e19, 0x06121c11, 
  0x0618dda8, 0x061fa2dd, 0x06266bb1, 0x062d3822, 
  0x06340831, 0x063adbde, 0x0641b327, 0x06488e0e, 
  0x064f6c90, 0x06564eaf, 0x065d346a, 0x06641dc0, 
  0x066b0ab1, 0x0671fb3d, 0x0678ef64, 0x067fe724, 
  0x0686e27f, 0x068de173, 0x0694e400, 0x069bea27, 
  0x06a2f3e6, 0x06aa013d, 0x06b1122c, 0x06b826b3, 
  0x06bf3ed1, 0x06c65a85, 0x06cd79d1, 0x06d49cb3, 
  0x06dbc32b, 0x06e2ed38, 0x06ea1adb, 0x06f14c13, 
  0x06f880df, 0x06ffb940, 0x0706f535, 0x070e34bd, 
  0x071577d9, 0x071cbe88, 0x072408c9, 0x072b569c, 
  0x0732a802, 0x0739fcf9, 0x07415582, 0x0748b19b, 
  0x07501145, 0x0757747f, 0x075edb49, 0x076645a3, 
  0x076db38c, 0x07752503, 0x077c9a09, 0x0784129e, 
  0x078b8ec0, 0x07930e6f, 0x079a91ac, 0x07a21876, 
  0x07a9a2cb, 0x07b130ad, 0x07b8c21b, 0x07c05714, 
  0x07c7ef98, 0x07cf8ba6, 0x07d72b3f, 0x07dece61, 
  0x07e6750e, 0x07ee1f43, 0x07f5cd01, 0x07fd7e48, 
  0x08053316, 0x080ceb6d, 0x0814a74a, 0x081c66af, 
  0x0824299a, 0x082bf00c, 0x0833ba03, 0x083b8780, 
  0x08435882, 0x084b2d09, 0x08530514, 0x085ae0a3, 
  0x0862bfb6, 0x086aa24c, 0x08728865, 0x087a7201, 
  0x08825f1e, 0x088a4fbe, 0x089243de, 0x089a3b80, 
  0x08a236a2, 0x08aa3545, 0x08b23767, 0x08ba3d09, 
  0x08c2462a, 0x08ca52c9, 0x08d262e7, 0x08da7682, 
  0x08e28d9c, 0x08eaa832, 0x08f2c645, 0x08fae7d4, 
  0x09030cdf, 0x090b3566, 0x09136168, 0x091b90e5, 
  0x0923c3dc, 0x092bfa4d, 0x09343437, 0x093c719b, 
  0x0944b277, 0x094cf6cc, 0x09553e99, 0x095d89dd, 
  0x0965d898, 0x096e2acb, 0x09768073, 0x097ed991, 
  0x09873625, 0x098f962e, 0x0997f9ac, 0x09a0609e, 
  0x09a8cb04, 0x09b138dd, 0x09b9aa29, 0x09c21ee8, 
  0x09ca9719, 0x09d312bc, 0x09db91d0, 0x09e41456, 
  0x09ec9a4b, 0x09f523b1, 0x09fdb087, 0x0a0640cc, 
  0x0a0ed47f, 0x0a176ba1, 0x0a200632, 0x0a28a42f, 
  0x0a31459a, 0x0a39ea72, 0x0a4292b5, 0x0a4b3e65, 
  0x0a53ed80, 0x0a5ca006, 0x0a6555f7, 0x0a6e0f51, 
  0x0a76cc16, 0x0a7f8c43, 0x0a884fda, 0x0a9116d9, 
  0x0a99e140, 0x0aa2af0e, 0x0aab8043, 0x0ab454df, 
  0x0abd2ce1, 0x0ac60849, 0x0acee716, 0x0ad7c948, 
  0x0ae0aede, 0x0ae997d9, 0x0af28437, 0x0afb73f7, 
  0x0b04671b, 0x0b0d5da0, 0x0b165788, 0x0b1f54d0, 
  0x0b285579, 0x0b315983, 0x0b3a60ec, 0x0b436bb5, 
  0x0b4c79dd, 0x0b558b63, 0x0b5ea048, 0x0b67b88a, 
  0x0b70d429, 0x0b79f324, 0x0b83157c, 0x0b8c3b30, 
  0x0b95643e, 0x0b9e90a8, 0x0ba7c06c, 0x0bb0f38a, 
  0x0bba2a01, 0x0bc363d1, 0x0bcca0f9, 0x0bd5e17a, 
  0x0bdf2552, 0x0be86c81, 0x0bf1b706, 0x0bfb04e2, 
  0x0c045613, 0x0c0daa99, 0x0c170274, 0x0c205da2, 
  0x0c29bc25, 0x0c331dfb, 0x0c3c8323, 0x0c45eb9e, 
  0x0c4f576a, 0x0c58c688, 0x0c6238f6, 0x0c6baeb5, 
  0x0c7527c3, 0x0c7ea421, 0x0c8823cd, 0x0c91a6c8, 
  0x0c9b2d10, 0x0ca4b6a6, 0x0cae4389, 0x0cb7d3b8, 
  0x0cc16732, 0x0ccafdf8, 0x0cd49809, 0x0cde3564, 
  0x0ce7d609, 0x0cf179f7, 0x0cfb212e, 0x0d04cbad, 
  0x0d0e7974, 0x0d182a83, 0x0d21ded8, 0x0d2b9673, 
  0x0d355154, 0x0d3f0f7a, 0x0d48d0e5, 0x0d529595, 
  0x0d5c5d88, 0x0d6628be, 0x0d6ff736, 0x0d79c8f1, 
  0x0d839dee, 0x0d8d762c, 0x0d9751aa, 0x0da13068, 
  0x0dab1266, 0x0db4f7a3, 0x0dbee01e, 0x0dc8cbd7, 
  0x0dd2bace, 0x0ddcad02, 0x0de6a272, 0x0df09b1e, 
  0x0dfa9705, 0x0e049627, 0x0e0e9883, 0x0e189e19, 
  0x0e22a6e8, 0x0e2cb2f0, 0x0e36c230, 0x0e40d4a7, 
  0x0e4aea56, 0x0e55033b, 0x0e5f1f56, 0x0e693ea6, 
  0x0e73612c, 0x0e7d86e5, 0x0e87afd3, 0x0e91dbf3, 
  0x0e9c0b46, 0x0ea63dcc, 0x0eb07383, 0x0ebaac6b, 
  0x0ec4e883, 0x0ecf27cc, 0x0ed96a44, 0x0ee3afea, 
  0x0eedf8bf, 0x0ef844c2, 0x0f0293f1, 0x0f0ce64e, 
  0x0f173bd6, 0x0f21948a, 0x0f2bf069, 0x0f364f72, 
  0x0f40b1a5, 0x0f4b1701, 0x0f557f86, 0x0f5feb32, 
  0x0f6a5a07, 0x0f74cc02, 0x0f7f4124, 0x0f89b96b, 
  0x0f9434d8, 0x0f9eb369, 0x0fa9351e, 0x0fb3b9f7, 
  0x0fbe41f3, 0x0fc8cd11, 0x0fd35b51, 0x0fddecb2, 
  0x0fe88134, 0x0ff318d5, 0x0ffdb397, 0x10085177, 
  0x1012f275, 0x101d9691, 0x10283dca, 0x1032e81f, 
  0x103d9591, 0x1048461e, 0x1052f9c5, 0x105db087, 
  0x10686a62, 0x10732756, 0x107de762, 0x1088aa87, 
  0x109370c2, 0x109e3a14, 0x10a9067c, 0x10b3d5f9, 
  0x10bea88b, 0x10c97e31, 0x10d456eb, 0x10df32b8, 
  0x10ea1197, 0x10f4f387, 0x10ffd889, 0x110ac09b, 
  0x1115abbe, 0x112099ef, 0x112b8b2f, 0x11367f7d, 
  0x114176d9, 0x114c7141, 0x11576eb6, 0x11626f36, 
  0x116d72c1, 0x11787957, 0x118382f6, 0x118e8f9e, 
  0x11999f4f, 0x11a4b207, 0x11afc7c7, 0x11bae08e, 
  0x11c5fc5a, 0x11d11b2c, 0x11dc3d02, 0x11e761dc, 
  0x11f289ba, 0x11fdb49b, 0x1208e27e, 0x12141362, 
  0x121f4747, 0x122a7e2d, 0x1235b812, 0x1240f4f6, 
  0x124c34d9, 0x125777b9, 0x1262bd96, 0x126e066f, 
  0x12795245, 0x1284a115, 0x128ff2e0, 0x129b47a5, 
  0x12a69f62, 0x12b1fa19, 0x12bd57c7, 0x12c8b86c, 
  0x12d41c08, 0x12df829a, 0x12eaec21, 0x12f6589c, 
  0x1301c80c, 0x130d3a6f, 0x1318afc4, 0x1324280b, 
  0x132fa344, 0x133b216d, 0x1346a286, 0x1352268e, 
  0x135dad85, 0x1369376a, 0x1374c43c, 0x138053fb, 
  0x138be6a5, 0x13977c3b, 0x13a314bb, 0x13aeb026, 
  0x13ba4e79, 0x13c5efb5, 0x13d193d9, 0x13dd3ae4, 
  0x13e8e4d6, 0x13f491ad, 0x14004169, 0x140bf40a, 
  0x1417a98f, 0x142361f7, 0x142f1d41, 0x143adb6d, 
  0x14469c79, 0x14526067, 0x145e2733, 0x1469f0df, 
  0x1475bd69, 0x14818cd0, 0x148d5f15, 0x14993435, 
  0x14a50c31, 0x14b0e707, 0x14bcc4b8, 0x14c8a542, 
  0x14d488a5, 0x14e06edf, 0x14ec57f1, 0x14f843d9, 
  0x15043297, 0x1510242a, 0x151c1892, 0x15280fcd, 
  0x153409db, 0x154006bc, 0x154c066e, 0x155808f1, 
  0x15640e43, 0x15701666, 0x157c2157, 0x15882f16, 
  0x15943fa2, 0x15a052fa, 0x15ac691f, 0x15b8820e, 
  0x15c49dc8, 0x15d0bc4c, 0x15dcdd98, 0x15e901ac, 
  0x15f52888, 0x1601522b, 0x160d7e93, 0x1619adc1, 
  0x1625dfb3, 0x16321469, 0x163e4be2, 0x164a861d, 
  0x1656c31a, 0x166302d8, 0x166f4555, 0x167b8a92, 
  0x1687d28e, 0x16941d47, 0x16a06abd, 0x16acbaf0, 
  0x16b90ddf, 0x16c56388, 0x16d1bbeb, 0x16de1707, 
  0x16ea74dd, 0x16f6d56a, 0x170338ae, 0x170f9ea8, 
  0x171c0758, 0x172872bd, 0x1734e0d6, 0x174151a2, 
  0x174dc520, 0x175a3b51, 0x1766b432, 0x17732fc3, 
  0x177fae04, 0x178c2ef4, 0x1798b292, 0x17a538dd, 
  0x17b1c1d4, 0x17be4d77, 0x17cadbc5, 0x17d76cbc, 
  0x17e4005d, 0x17f096a7, 0x17fd2f98, 0x1809cb31, 
  0x1816696f, 0x18230a53, 0x182faddc, 0x183c5408, 
  0x1848fcd7, 0x1855a849, 0x1862565c, 0x186f0710, 
  0x187bba64, 0x18887057, 0x189528e9, 0x18a1e417, 
  0x18aea1e3, 0x18bb624b, 0x18c8254d, 0x18d4eaea, 
  0x18e1b321, 0x18ee7df1, 0x18fb4b58, 0x19081b57, 
  0x1914edec, 0x1921c316, 0x192e9ad6, 0x193b7529, 
  0x19485210, 0x19553188, 0x19621393, 0x196ef82e, 
  0x197bdf59, 0x1988c913, 0x1995b55c, 0x19a2a432, 
  0x19af9594, 0x19bc8983, 0x19c97ffc, 0x19d67900, 
  0x19e3748d, 0x19f072a3, 0x19fd7341, 0x1a0a7665, 
  0x1a177c10, 0x1a248440, 0x1a318ef4, 0x1a3e9c2c, 
  0x1a4babe7, 0x1a58be24, 0x1a65d2e2, 0x1a72ea20, 
  0x1a8003de, 0x1a8d201a, 0x1a9a3ed4, 0x1aa7600c, 
  0x1ab483bf, 0x1ac1a9ee, 0x1aced297, 0x1adbfdba, 
  0x1ae92b56, 0x1af65b69, 0x1b038df4, 0x1b10c2f5, 
  0x1b1dfa6b, 0x1b2b3456, 0x1b3870b5, 0x1b45af87, 
  0x1b52f0ca, 0x1b60347f, 0x1b6d7aa4, 0x1b7ac339, 
  0x1b880e3c, 0x1b955bad, 0x1ba2ab8b, 0x1baffdd5, 
  0x1bbd528a, 0x1bcaa9a9, 0x1bd80332, 0x1be55f24, 
  0x1bf2bd7d, 0x1c001e3d, 0x1c0d8163, 0x1c1ae6ef, 
  0x1c284ede, 0x1c35b931, 0x1c4325e7, 0x1c5094fe, 
  0x1c5e0676, 0x1c6b7a4e, 0x1c78f085, 0x1c86691b, 
  0x1c93e40d, 0x1ca1615c, 0x1caee107, 0x1cbc630c, 
  0x1cc9e76b, 0x1cd76e23, 0x1ce4f733, 0x1cf2829a, 
  0x1d001057, 0x1d0da06a, 0x1d1b32d1, 0x1d28c78c, 
  0x1d365e9a, 0x1d43f7f9, 0x1d5193a9, 0x1d5f31aa, 
  0x1d6cd1f9, 0x1d7a7497, 0x1d881982, 0x1d95c0b9, 
  0x1da36a3c, 0x1db1160a, 0x1dbec422, 0x1dcc7482, 
  0x1dda272a, 0x1de7dc1a, 0x1df5934f, 0x1e034cca, 
  0x1e110889, 0x1e1ec68c, 0x1e2c86d1, 0x1e3a4958, 
  0x1e480e1f, 0x1e55d527, 0x1e639e6d, 0x1e7169f1, 
  0x1e7f37b2, 0x1e8d07af, 0x1e9ad9e8, 0x1ea8ae5b, 
  0x1eb68507, 0x1ec45dec, 0x1ed23908, 0x1ee0165b, 
  0x1eedf5e4, 0x1efbd7a1, 0x1f09bb92, 0x1f17a1b6, 
  0x1f258a0c, 0x1f337494, 0x1f41614b, 0x1f4f5032, 
  0x1f5d4146, 0x1f6b3489, 0x1f7929f7, 0x1f872191, 
  0x1f951b56, 0x1fa31744, 0x1fb1155b, 0x1fbf159a, 
  0x1fcd17ff, 0x1fdb1c8a, 0x1fe9233b, 0x1ff72c0f, 
  0x20053706, 0x2013441f, 0x2021535a, 0x202f64b4, 
  0x203d782e, 0x204b8dc6, 0x2059a57c, 0x2067bf4d, 
  0x2075db3b, 0x2083f942, 0x20921964, 0x20a03b9d, 
  0x20ae5fef, 0x20bc8657, 0x20caaed5, 0x20d8d967, 
  0x20e7060e, 0x20f534c7, 0x21036592, 0x2111986d, 
  0x211fcd59, 0x212e0454, 0x213c3d5d, 0x214a7872, 
  0x2158b594, 0x2166f4c1, 0x217535f8, 0x21837938, 
  0x2191be81, 0x21a005d0, 0x21ae4f26, 0x21bc9a81, 
  0x21cae7e0, 0x21d93742, 0x21e788a7, 0x21f5dc0e, 
  0x22043174, 0x221288da, 0x2220e23e, 0x222f3da0, 
  0x223d9afe, 0x224bfa58, 0x225a5bac, 0x2268bef9, 
  0x2277243f, 0x22858b7c, 0x2293f4b0, 0x22a25fda, 
  0x22b0ccf7, 0x22bf3c09, 0x22cdad0d, 0x22dc2002, 
  0x22ea94e8, 0x22f90bbd, 0x23078481, 0x2315ff33, 
  0x23247bd1, 0x2332fa5b, 0x23417acf, 0x234ffd2c, 
  0x235e8172, 0x236d07a0, 0x237b8fb4, 0x238a19ae, 
  0x2398a58c, 0x23a7334d, 0x23b5c2f1, 0x23c45477, 
  0x23d2e7dd, 0x23e17d22, 0x23f01446, 0x23fead47, 
  0x240d4824, 0x241be4dd, 0x242a8370, 0x243923dd, 
  0x2447c622, 0x24566a3e, 0x24651030, 0x2473b7f8, 
  0x24826194, 0x24910d03, 0x249fba44, 0x24ae6956, 
  0x24bd1a39, 0x24cbccea, 0x24da816a, 0x24e937b6, 
  0x24f7efcf, 0x2506a9b2, 0x25156560, 0x252422d6, 
  0x2532e214, 0x2541a319, 0x255065e4, 0x255f2a74, 
  0x256df0c7, 0x257cb8dd, 0x258b82b4, 0x259a4e4c, 
  0x25a91ba4, 0x25b7eaba, 0x25c6bb8d, 0x25d58e1d, 
  0x25e46269, 0x25f3386e, 0x2602102d, 0x2610e9a4, 
  0x261fc4d2, 0x262ea1b7, 0x263d8050, 0x264c609d, 
  0x265b429e, 0x266a2650, 0x26790bb3, 0x2687f2c6, 
  0x2696db87, 0x26a5c5f6, 0x26b4b212, 0x26c39fda, 
  0x26d28f4b, 0x26e18067, 0x26f0732a, 0x26ff6795, 
  0x270e5da6, 0x271d555d, 0x272c4eb7, 0x273b49b5, 
  0x274a4654, 0x27594494, 0x27684474, 0x277745f3, 
  0x27864910, 0x27954dc9, 0x27a4541e, 0x27b35c0d, 
  0x27c26595, 0x27d170b6, 0x27e07d6e, 0x27ef8bbd, 
  0x27fe9ba0, 0x280dad17, 0x281cc021, 0x282bd4be, 
  0x283aeaea, 0x284a02a7, 0x28591bf2, 0x286836ca, 
  0x2877532f, 0x28867120, 0x2895909a, 0x28a4b19e, 
  0x28b3d42a, 0x28c2f83c, 0x28d21dd5, 0x28e144f2, 
  0x28f06d94, 0x28ff97b7, 0x290ec35c, 0x291df082, 
  0x292d1f27, 0x293c4f4a, 0x294b80ea, 0x295ab407, 
  0x2969e89e, 0x29791eaf, 0x29885639, 0x29978f3a, 
  0x29a6c9b2, 0x29b605a0, 0x29c54301, 0x29d481d6, 
  0x29e3c21d, 0x29f303d5, 0x2a0246fd, 0x2a118b94, 
  0x2a20d198, 0x2a301909, 0x2a3f61e5, 0x2a4eac2c, 
  0x2a5df7dc, 0x2a6d44f4, 0x2a7c9373, 0x2a8be358, 
  0x2a9b34a2, 0x2aaa874f, 0x2ab9db5f, 0x2ac930d1, 
  0x2ad887a2, 0x2ae7dfd3, 0x2af73962, 0x2b06944e, 
  0x2b15f096, 0x2b254e38, 0x2b34ad34, 0x2b440d88, 
  0x2b536f34, 0x2b62d236, 0x2b72368d, 0x2b819c38, 
  0x2b910336, 0x2ba06b85, 0x2bafd525, 0x2bbf4015, 
  0x2bceac53, 0x2bde19de, 0x2bed88b5, 0x2bfcf8d7, 
  0x2c0c6a42, 0x2c1bdcf7, 0x2c2b50f3, 0x2c3ac635, 
  0x2c4a3cbc, 0x2c59b488, 0x2c692d97, 0x2c78a7e7, 
  0x2c882378, 0x2c97a048, 0x2ca71e57, 0x2cb69da4, 
  0x2cc61e2c, 0x2cd59fef, 0x2ce522ec, 0x2cf4a722, 
  0x2d042c90, 0x2d13b333, 0x2d233b0c, 0x2d32c419, 
  0x2d424e59, 0x2d51d9cb, 0x2d61666e, 0x2d70f440, 
  0x2d808340, 0x2d90136d, 0x2d9fa4c7, 0x2daf374c, 
  0x2dbecafa, 0x2dce5fd1, 0x2dddf5cf, 0x2ded8cf3, 
  0x2dfd253d, 0x2e0cbeaa, 0x2e1c593b, 0x2e2bf4ed, 
  0x2e3b91bf, 0x2e4b2fb1, 0x2e5acec1, 0x2e6a6eee, 
  0x2e7a1037, 0x2e89b29a, 0x2e995617, 0x2ea8faad, 
  0x2eb8a059, 0x2ec8471c, 0x2ed7eef3, 0x2ee797de, 
  0x2ef741dc, 0x2f06eceb, 0x2f16990a, 0x2f264638, 
  0x2f35f474, 0x2f45a3bd, 0x2f555411, 0x2f650570, 
  0x2f74b7d8, 0x2f846b47, 0x2f941fbe, 0x2fa3d53a, 
  0x2fb38bbb, 0x2fc3433f, 0x2fd2fbc5, 0x2fe2b54c, 
  0x2ff26fd3, 0x30022b58, 0x3011e7db, 0x3021a55a, 
  0x303163d4, 0x30412348, 0x3050e3b4, 0x3060a518, 
  0x30706773, 0x30802ac2, 0x308fef06, 0x309fb43c, 
  0x30af7a64, 0x30bf417d, 0x30cf0984, 0x30ded27a, 
  0x30ee9c5c, 0x30fe672a, 0x310e32e3, 0x311dff85, 
  0x312dcd0f, 0x313d9b80, 0x314d6ad6, 0x315d3b11, 
  0x316d0c30, 0x317cde31, 0x318cb112, 0x319c84d4, 
  0x31ac5974, 0x31bc2ef1, 0x31cc054a, 0x31dbdc7f, 
  0x31ebb48d, 0x31fb8d74, 0x320b6732, 0x321b41c7, 
  0x322b1d30, 0x323af96e, 0x324ad67e, 0x325ab45f, 
  0x326a9310, 0x327a7291, 0x328a52df, 0x329a33fa, 
  0x32aa15e1, 0x32b9f892, 0x32c9dc0b, 0x32d9c04d, 
  0x32e9a555, 0x32f98b22, 0x330971b4, 0x33195908, 
  0x3329411f, 0x333929f6, 0x3349138c, 0x3358fde1, 
  0x3368e8f2, 0x3378d4bf, 0x3388c147, 0x3398ae88, 
  0x33a89c81, 0x33b88b32, 0x33c87a97, 0x33d86ab2, 
  0x33e85b7f, 0x33f84cff, 0x34083f30, 0x34183210, 
  0x3428259f, 0x343819da, 0x34480ec2, 0x34580455, 
  0x3467fa91, 0x3477f176, 0x3487e902, 0x3497e133, 
  0x34a7da0a, 0x34b7d384, 0x34c7cda0, 0x34d7c85d, 
  0x34e7c3bb, 0x34f7bfb6, 0x3507bc50, 0x3517b985, 
  0x3527b755, 0x3537b5bf, 0x3547b4c2, 0x3557b45c, 
  0x3567b48c, 0x3577b551, 0x3587b6aa, 0x3597b895, 
  0x35a7bb11, 0x35b7be1d, 0x35c7c1b8, 0x35d7c5e1, 
  0x35e7ca96, 0x35f7cfd6, 0x3607d5a0, 0x3617dbf2, 
  0x3627e2cc, 0x3637ea2c, 0x3647f211, 0x3657fa7a, 
  0x36680365, 0x36780cd2, 0x368816bf, 0x3698212a, 
  0x36a82c13, 0x36b83779, 0x36c84359, 0x36d84fb4, 
  0x36e85c87, 0x36f869d2, 0x37087793, 0x371885c9, 
  0x37289473, 0x3738a38f, 0x3748b31c, 0x3758c31a, 
  0x3768d386, 0x3778e461, 0x3788f5a7, 0x37990759, 
  0x37a91974, 0x37b92bf8, 0x37c93ee4, 0x37d95236, 
  0x37e965ed, 0x37f97a07, 0x38098e84, 0x3819a363, 
  0x3829b8a1, 0x3839ce3f, 0x3849e439, 0x3859fa91, 
  0x386a1143, 0x387a284f, 0x388a3fb4, 0x389a5770, 
  0x38aa6f82, 0x38ba87e9, 0x38caa0a4, 0x38dab9b2, 
  0x38ead310, 0x38faecbf, 0x390b06bc, 0x391b2107, 
  0x392b3b9e, 0x393b5680, 0x394b71ab, 0x395b8d20, 
  0x396ba8db, 0x397bc4dd, 0x398be123, 0x399bfdad, 
  0x39ac1a7a, 0x39bc3787, 0x39cc54d4, 0x39dc7260, 
  0x39ec902a, 0x39fcae2f, 0x3a0ccc6f, 0x3a1ceae9, 
  0x3a2d099c, 0x3a3d2885, 0x3a4d47a4, 0x3a5d66f9, 
  0x3a6d8680, 0x3a7da63a, 0x3a8dc624, 0x3a9de63f, 
  0x3aae0688, 0x3abe26fe, 0x3ace47a0, 0x3ade686c, 
  0x3aee8963, 0x3afeaa81, 0x3b0ecbc7, 0x3b1eed32, 
  0x3b2f0ec2, 0x3b3f3075, 0x3b4f524a, 0x3b5f7440, 
  0x3b6f9655, 0x3b7fb889, 0x3b8fdad9, 0x3b9ffd46, 
  0x3bb01fcd, 0x3bc0426d, 0x3bd06526, 0x3be087f5, 
  0x3bf0aada, 0x3c00cdd3, 0x3c10f0df, 0x3c2113fe, 
  0x3c31372c, 0x3c415a6a, 0x3c517db6, 0x3c61a10f, 
  0x3c71c474, 0x3c81e7e3, 0x3c920b5b, 0x3ca22edb, 
  0x3cb25262, 0x3cc275ee, 0x3cd2997e, 0x3ce2bd11, 
  0x3cf2e0a6, 0x3d03043b, 0x3d1327cf, 0x3d234b61, 
  0x3d336ef0, 0x3d43927a, 0x3d53b5fe, 0x3d63d97b, 
  0x3d73fcf0, 0x3d84205c, 0x3d9443bc, 0x3da46711, 
  0x3db48a58, 0x3dc4ad90, 0x3dd4d0b9, 0x3de4f3d1, 
  0x3df516d6, 0x3e0539c8, 0x3e155ca5, 0x3e257f6c, 
  0x3e35a21c, 0x3e45c4b4, 0x3e55e731, 0x3e660993, 
  0x3e762bda, 0x3e864e02, 0x3e96700c, 0x3ea691f6, 
  0x3eb6b3bf, 0x3ec6d565, 0x3ed6f6e7, 0x3ee71845, 
  0x3ef7397c, 0x3f075a8c, 0x3f177b73, 0x3f279c30, 
  0x3f37bcc2, 0x3f47dd27, 0x3f57fd5f, 0x3f681d67, 
  0x3f783d40, 0x3f885ce7, 0x3f987c5b, 0x3fa89b9c, 
  0x3fb8baa7, 0x3fc8d97c, 0x3fd8f819, 0x3fe9167d, 
  0x3ff934a7, 0x40095296, 0x40197048, 0x40298dbc, 
  0x4039aaf1, 0x4049c7e6, 0x4059e499, 0x406a0109, 
  0x407a1d36, 0x408a391c, 0x409a54bd, 0x40aa7015, 
  0x40ba8b24, 0x40caa5e9, 0x40dac063, 0x40eada8f, 
  0x40faf46e, 0x410b0dfd, 0x411b273c, 0x412b4029, 
  0x413b58c3, 0x414b7109, 0x415b88f9, 0x416ba093, 
  0x417bb7d5, 0x418bcebd, 0x419be54b, 0x41abfb7d, 
  0x41bc1153, 0x41cc26ca, 0x41dc3be2, 0x41ec5099, 
  0x41fc64ee, 0x420c78e0, 0x421c8c6e, 0x422c9f96, 
  0x423cb258, 0x424cc4b1, 0x425cd6a1, 0x426ce827, 
  0x427cf940, 0x428d09ed, 0x429d1a2c, 0x42ad29fb, 
  0x42bd3959, 0x42cd4845, 0x42dd56be, 0x42ed64c3, 
  0x42fd7252, 0x430d7f6a, 0x431d8c0a, 0x432d9831, 
  0x433da3dd, 0x434daf0d, 0x435db9c0, 0x436dc3f5, 
  0x437dcdaa, 0x438dd6df, 0x439ddf91, 0x43ade7c0, 
  0x43bdef6b, 0x43cdf690, 0x43ddfd2f, 0x43ee0345, 
  0x43fe08d2, 0x440e0dd4, 0x441e124a, 0x442e1633, 
  0x443e198e, 0x444e1c5a, 0x445e1e95, 0x446e203d, 
  0x447e2153, 0x448e21d4, 0x449e21c0, 0x44ae2114, 
  0x44be1fd1, 0x44ce1df4, 0x44de1b7c, 0x44ee1869, 
  0x44fe14b9, 0x450e106b, 0x451e0b7d, 0x452e05ee, 
  0x453dffbe, 0x454df8eb, 0x455df173, 0x456de955, 
  0x457de091, 0x458dd725, 0x459dcd10, 0x45adc250, 
  0x45bdb6e5, 0x45cdaacc, 0x45dd9e06, 0x45ed9090, 
  0x45fd826a, 0x460d7392, 0x461d6407, 0x462d53c8, 
  0x463d42d3, 0x464d3128, 0x465d1ec5, 0x466d0ba9, 
  0x467cf7d3, 0x468ce341, 0x469ccdf3, 0x46acb7e7, 
  0x46bca11b, 0x46cc898f, 0x46dc7142, 0x46ec5832, 
  0x46fc3e5f, 0x470c23c6, 0x471c0866, 0x472bec3f, 
  0x473bcf4f, 0x474bb196, 0x475b9311, 0x476b73c0, 
  0x477b53a1, 0x478b32b3, 0x479b10f5, 0x47aaee66, 
  0x47bacb05, 0x47caa6d0, 0x47da81c6, 0x47ea5be6, 
  0x47fa352f, 0x480a0da0, 0x4819e537, 0x4829bbf3, 
  0x483991d3, 0x484966d6, 0x48593afa, 0x48690e3f, 
  0x4878e0a3, 0x4888b225, 0x489882c3, 0x48a8527e, 
  0x48b82152, 0x48c7ef40, 0x48d7bc46, 0x48e78863, 
  0x48f75395, 0x49071ddc, 0x4916e736, 0x4926afa2, 
  0x4936771f, 0x49463dab, 0x49560346, 0x4965c7ef, 
  0x49758ba3, 0x49854e62, 0x4995102b, 0x49a4d0fd, 
  0x49b490d6, 0x49c44fb5, 0x49d40d99, 0x49e3ca81, 
  0x49f3866c, 0x4a034158, 0x4a12fb44, 0x4a22b430, 
  0x4a326c19, 0x4a4222ff, 0x4a51d8e0, 0x4a618dbc, 
  0x4a714191, 0x4a80f45f, 0x4a90a623, 0x4aa056dc, 
  0x4ab0068a, 0x4abfb52c, 0x4acf62bf, 0x4adf0f44, 
  0x4aeebab8, 0x4afe651b, 0x4b0e0e6b, 0x4b1db6a8, 
  0x4b2d5dd0, 0x4b3d03e2, 0x4b4ca8dc, 0x4b5c4cbf, 
  0x4b6bef87, 0x4b7b9135, 0x4b8b31c7, 0x4b9ad13c, 
  0x4baa6f93, 0x4bba0cca, 0x4bc9a8e1, 0x4bd943d6, 
  0x4be8dda9, 0x4bf87657, 0x4c080de0, 0x4c17a443, 
  0x4c27397e, 0x4c36cd91, 0x4c46607a, 0x4c55f238, 
  0x4c6582ca, 0x4c75122f, 0x4c84a065, 0x4c942d6c, 
  0x4ca3b942, 0x4cb343e6, 0x4cc2cd57, 0x4cd25594, 
  0x4ce1dc9b, 0x4cf1626d, 0x4d00e706, 0x4d106a67, 
  0x4d1fec8e, 0x4d2f6d7a, 0x4d3eed2a, 0x4d4e6b9c, 
  0x4d5de8d0, 0x4d6d64c5, 0x4d7cdf78, 0x4d8c58ea, 
  0x4d9bd119, 0x4dab4804, 0x4dbabda9, 0x4dca3208, 
  0x4dd9a51f, 0x4de916ee, 0x4df88773, 0x4e07f6ad, 
  0x4e17649b, 0x4e26d13c, 0x4e363c8e, 0x4e45a691, 
  0x4e550f43, 0x4e6476a4, 0x4e73dcb2, 0x4e83416b, 
  0x4e92a4d0, 0x4ea206df, 0x4eb16796, 0x4ec0c6f5, 
  0x4ed024fa, 0x4edf81a4, 0x4eeedcf3, 0x4efe36e4, 
  0x4f0d8f78, 0x4f1ce6ad, 0x4f2c3c81, 0x4f3b90f4, 
  0x4f4ae404, 0x4f5a35b1, 0x4f6985f9, 0x4f78d4db, 
  0x4f882256, 0x4f976e6a, 0x4fa6b914, 0x4fb60253, 
  0x4fc54a28, 0x4fd49090, 0x4fe3d58a, 0x4ff31916, 
  0x50025b32, 0x50119bdd, 0x5020db16, 0x503018dc, 
  0x503f552e, 0x504e900b, 0x505dc971, 0x506d0160, 
  0x507c37d6, 0x508b6cd2, 0x509aa054, 0x50a9d25a, 
  0x50b902e4, 0x50c831ef, 0x50d75f7b, 0x50e68b87, 
  0x50f5b611, 0x5104df1a, 0x5114069f, 0x51232c9f, 
  0x5132511a, 0x5141740e, 0x5150957a, 0x515fb55e, 
  0x516ed3b8, 0x517df086, 0x518d0bc9, 0x519c257f, 
  0x51ab3da6, 0x51ba543e, 0x51c96946, 0x51d87cbc, 
  0x51e78ea0, 0x51f69ef1, 0x5205adac, 0x5214bad2, 
  0x5223c662, 0x5232d059, 0x5241d8b8, 0x5250df7d, 
  0x525fe4a7, 0x526ee834, 0x527dea25, 0x528cea78, 
  0x529be92b, 0x52aae63e, 0x52b9e1b0, 0x52c8db7f, 
  0x52d7d3ab, 0x52e6ca33, 0x52f5bf15, 0x5304b250, 
  0x5313a3e4, 0x532293cf, 0x53318211, 0x53406ea8, 
  0x534f5993, 0x535e42d1, 0x536d2a61, 0x537c1043, 
  0x538af474, 0x5399d6f5, 0x53a8b7c4, 0x53b796df, 
  0x53c67447, 0x53d54ff9, 0x53e429f5, 0x53f3023a, 
  0x5401d8c7, 0x5410ad9b, 0x541f80b4, 0x542e5213, 
  0x543d21b5, 0x544bef99, 0x545abbc0, 0x54698627, 
  0x54784ecd, 0x548715b2, 0x5495dad5, 0x54a49e35, 
  0x54b35fd0, 0x54c21fa5, 0x54d0ddb5, 0x54df99fc, 
  0x54ee547b, 0x54fd0d31, 0x550bc41d, 0x551a793c, 
  0x55292c90, 0x5537de16, 0x55468dcd, 0x55553bb5, 
  0x5563e7cd, 0x55729213, 0x55813a86, 0x558fe126, 
  0x559e85f2, 0x55ad28e8, 0x55bbca08, 0x55ca6950, 
  0x55d906c0, 0x55e7a256, 0x55f63c12, 0x5604d3f3, 
  0x561369f7, 0x5621fe1e, 0x56309067, 0x563f20d0, 
  0x564daf59, 0x565c3c01, 0x566ac6c7, 0x56794fa9, 
  0x5687d6a7, 0x56965bc0, 0x56a4def3, 0x56b3603f, 
  0x56c1dfa3, 0x56d05d1e, 0x56ded8af, 0x56ed5255, 
  0x56fbca0f, 0x570a3fdc, 0x5718b3bb, 0x572725ab, 
  0x573595ac, 0x574403bc, 0x57526fdb, 0x5760da06, 
  0x576f423f, 0x577da882, 0x578c0cd1, 0x579a6f29, 
  0x57a8cf89, 0x57b72df1, 0x57c58a60, 0x57d3e4d5, 
  0x57e23d4f, 0x57f093cc, 0x57fee84d, 0x580d3ad0, 
  0x581b8b54, 0x5829d9d8, 0x5838265b, 0x584670dd, 
  0x5854b95c, 0x5862ffd7, 0x5871444e, 0x587f86c0, 
  0x588dc72c, 0x589c0590, 0x58aa41ec, 0x58b87c3f, 
  0x58c6b488, 0x58d4eac6, 0x58e31ef8, 0x58f1511e, 
  0x58ff8136, 0x590daf40, 0x591bdb3a, 0x592a0523, 
  0x59382cfb, 0x594652c2, 0x59547675, 0x59629814, 
  0x5970b79e, 0x597ed513, 0x598cf070, 0x599b09b7, 
  0x59a920e4, 0x59b735f9, 0x59c548f3, 0x59d359d2, 
  0x59e16895, 0x59ef753b, 0x59fd7fc3, 0x5a0b882c, 
  0x5a198e76, 0x5a2792a0, 0x5a3594a8, 0x5a43948e, 
  0x5a519251, 0x5a5f8def, 0x5a6d8769, 0x5a7b7ebe, 
  0x5a8973eb, 0x5a9766f1, 0x5aa557cf, 0x5ab34684, 
  0x5ac1330f, 0x5acf1d6e, 0x5add05a2, 0x5aeaeba9, 
  0x5af8cf83, 0x5b06b12e, 0x5b1490aa, 0x5b226df6, 
  0x5b304912, 0x5b3e21fb, 0x5b4bf8b2, 0x5b59cd35, 
  0x5b679f84, 0x5b756f9d, 0x5b833d81, 0x5b91092e, 
  0x5b9ed2a3, 0x5bac99df, 0x5bba5ee2, 0x5bc821ab, 
  0x5bd5e239, 0x5be3a08b, 0x5bf15ca0, 0x5bff1678, 
  0x5c0cce11, 0x5c1a836c, 0x5c283686, 0x5c35e75f, 
  0x5c4395f6, 0x5c51424b, 0x5c5eec5d, 0x5c6c942b, 
  0x5c7a39b3, 0x5c87dcf6, 0x5c957df2, 0x5ca31ca7, 
  0x5cb0b914, 0x5cbe5338, 0x5ccbeb11, 0x5cd980a1, 
  0x5ce713e4, 0x5cf4a4dc, 0x5d023386, 0x5d0fbfe3, 
  0x5d1d49f1, 0x5d2ad1b0, 0x5d38571e, 0x5d45da3c, 
  0x5d535b07, 0x5d60d980, 0x5d6e55a6, 0x5d7bcf78, 
  0x5d8946f4, 0x5d96bc1b, 0x5da42eeb, 0x5db19f64, 
  0x5dbf0d85, 0x5dcc794d, 0x5dd9e2bc, 0x5de749d0, 
  0x5df4ae89, 0x5e0210e6, 0x5e0f70e6, 0x5e1cce89, 
  0x5e2a29ce, 0x5e3782b3, 0x5e44d939, 0x5e522d5e, 
  0x5e5f7f23, 0x5e6cce85, 0x5e7a1b84, 0x5e876620, 
  0x5e94ae57, 0x5ea1f429, 0x5eaf3796, 0x5ebc789c, 
  0x5ec9b73b, 0x5ed6f372, 0x5ee42d40, 0x5ef164a4, 
  0x5efe999f, 0x5f0bcc2e, 0x5f18fc51, 0x5f262a09, 
  0x5f335553, 0x5f407e2f, 0x5f4da49c, 0x5f5ac89a, 
  0x5f67ea28, 0x5f750945, 0x5f8225f1, 0x5f8f402a, 
  0x5f9c57f1, 0x5fa96d44, 0x5fb68022, 0x5fc3908b, 
  0x5fd09e7f, 0x5fdda9fb, 0x5feab301, 0x5ff7b98f, 
  0x6004bda4, 0x6011bf40, 0x601ebe61, 0x602bbb08, 
  0x6038b534, 0x6045ace3, 0x6052a215, 0x605f94ca, 
  0x606c8501, 0x607972b9, 0x60865df1, 0x609346a9, 
  0x60a02ce0, 0x60ad1095, 0x60b9f1c8, 0x60c6d078, 
  0x60d3aca4, 0x60e0864c, 0x60ed5d6f, 0x60fa320c, 
  0x61070423, 0x6113d3b3, 0x6120a0bb, 0x612d6b3b, 
  0x613a3331, 0x6146f89e, 0x6153bb81, 0x61607bd9, 
  0x616d39a5, 0x6179f4e4, 0x6186ad97, 0x619363bc, 
  0x61a01753, 0x61acc85a, 0x61b976d3, 0x61c622bb, 
  0x61d2cc12, 0x61df72d8, 0x61ec170b, 0x61f8b8ac, 
  0x620557ba, 0x6211f433, 0x621e8e18, 0x622b2567, 
  0x6237ba21, 0x62444c44, 0x6250dbcf, 0x625d68c3, 
  0x6269f31f, 0x62767ae2, 0x6283000b, 0x628f8299, 
  0x629c028d, 0x62a87fe5, 0x62b4faa2, 0x62c172c1, 
  0x62cde843, 0x62da5b28, 0x62e6cb6e, 0x62f33914, 
  0x62ffa41b, 0x630c0c82, 0x63187248, 0x6324d56c, 
  0x633135ee, 0x633d93ce, 0x6349ef0a, 0x635647a2, 
  0x63629d96, 0x636ef0e5, 0x637b418e, 0x63878f91, 
  0x6393daee, 0x63a023a3, 0x63ac69b0, 0x63b8ad15, 
  0x63c4edd0, 0x63d12be2, 0x63dd674a, 0x63e9a007, 
  0x63f5d619, 0x6402097f, 0x640e3a38, 0x641a6845, 
  0x642693a4, 0x6432bc55, 0x643ee257, 0x644b05aa, 
  0x6457264d, 0x64634440, 0x646f5f83, 0x647b7813, 
  0x64878df2, 0x6493a11f, 0x649fb198, 0x64abbf5e, 
  0x64b7ca70, 0x64c3d2ce, 0x64cfd876, 0x64dbdb68, 
  0x64e7dba5, 0x64f3d92b, 0x64ffd3f9, 0x650bcc10, 
  0x6517c16e, 0x6523b414, 0x652fa401, 0x653b9133, 
  0x65477bac, 0x65536369, 0x655f486c, 0x656b2ab2, 
  0x65770a3c, 0x6582e70a, 0x658ec11a, 0x659a986c, 
  0x65a66d00, 0x65b23ed5, 0x65be0dea, 0x65c9da40, 
  0x65d5a3d6, 0x65e16aab, 0x65ed2ebe, 0x65f8f010, 
  0x6604aea0, 0x66106a6d, 0x661c2377, 0x6627d9bd, 
  0x66338d3f, 0x663f3dfc, 0x664aebf5, 0x66569727, 
  0x66623f94, 0x666de53b, 0x6679881a, 0x66852832, 
  0x6690c582, 0x669c600a, 0x66a7f7c9, 0x66b38cbf, 
  0x66bf1eec, 0x66caae4e, 0x66d63ae6, 0x66e1c4b2, 
  0x66ed4bb3, 0x66f8cfe9, 0x67045152, 0x670fcfee, 
  0x671b4bbd, 0x6726c4bf, 0x67323af2, 0x673dae57, 
  0x67491eed, 0x67548cb4, 0x675ff7ab, 0x676b5fd1, 
  0x6776c527, 0x678227ad, 0x678d8760, 0x6798e442, 
  0x67a43e52, 0x67af958e, 0x67bae9f8, 0x67c63b8f, 
  0x67d18a51, 0x67dcd63f, 0x67e81f58, 0x67f3659d, 
  0x67fea90b, 0x6809e9a4, 0x68152767, 0x68206253, 
  0x682b9a68, 0x6836cfa5, 0x6842020b, 0x684d3198, 
  0x68585e4d, 0x68638828, 0x686eaf2b, 0x6879d353, 
  0x6884f4a2, 0x68901316, 0x689b2eaf, 0x68a6476d, 
  0x68b15d4f, 0x68bc7055, 0x68c7807f, 0x68d28dcc, 
  0x68dd983d, 0x68e89fd0, 0x68f3a485, 0x68fea65c, 
  0x6909a554, 0x6914a16e, 0x691f9aa8, 0x692a9104, 
  0x6935847f, 0x6940751a, 0x694b62d4, 0x69564dae, 
  0x696135a6, 0x696c1abd, 0x6976fcf2, 0x6981dc45, 
  0x698cb8b5, 0x69979242, 0x69a268ed, 0x69ad3cb3, 
  0x69b80d96, 0x69c2db95, 0x69cda6af, 0x69d86ee5, 
  0x69e33435, 0x69edf6a0, 0x69f8b625, 0x6a0372c4, 
  0x6a0e2c7d, 0x6a18e350, 0x6a23973b, 0x6a2e483f, 
  0x6a38f65c, 0x6a43a191, 0x6a4e49dd, 0x6a58ef42, 
  0x6a6391bd, 0x6a6e3150, 0x6a78cdf9, 0x6a8367b9, 
  0x6a8dfe8f, 0x6a98927b, 0x6aa3237c, 0x6aadb193, 
  0x6ab83cbf, 0x6ac2c4ff, 0x6acd4a54, 0x6ad7ccbe, 
  0x6ae24c3b, 0x6aecc8cc, 0x6af74271, 0x6b01b928, 
  0x6b0c2cf3, 0x6b169dd0, 0x6b210bc0, 0x6b2b76c2, 
  0x6b35ded5, 0x6b4043fb, 0x6b4aa632, 0x6b55057a, 
  0x6b5f61d2, 0x6b69bb3c, 0x6b7411b6, 0x6b7e6540, 
  0x6b88b5db, 0x6b930384, 0x6b9d4e3e, 0x6ba79607, 
  0x6bb1dade, 0x6bbc1cc5, 0x6bc65bba, 0x6bd097be, 
  0x6bdad0cf, 0x6be506ef, 0x6bef3a1c, 0x6bf96a57, 
  0x6c03979f, 0x6c0dc1f5, 0x6c17e957, 0x6c220dc5, 
  0x6c2c2f40, 0x6c364dc8, 0x6c40695b, 0x6c4a81fb, 
  0x6c5497a6, 0x6c5eaa5c, 0x6c68ba1e, 0x6c72c6eb, 
  0x6c7cd0c2, 0x6c86d7a5, 0x6c90db92, 0x6c9adc89, 
  0x6ca4da8a, 0x6caed595, 0x6cb8cdaa, 0x6cc2c2c9, 
  0x6cccb4f1, 0x6cd6a423, 0x6ce0905d, 0x6cea79a1, 
  0x6cf45fed, 0x6cfe4341, 0x6d08239f, 0x6d120104, 
  0x6d1bdb72, 0x6d25b2e7, 0x6d2f8764, 0x6d3958e9, 
  0x6d432776, 0x6d4cf30a, 0x6d56bba5, 0x6d608147, 
  0x6d6a43f0, 0x6d74039f, 0x6d7dc056, 0x6d877a12, 
  0x6d9130d5, 0x6d9ae49f, 0x6da4956e, 0x6dae4344, 
  0x6db7ee1f, 0x6dc19600, 0x6dcb3ae6, 0x6dd4dcd2, 
  0x6dde7bc4, 0x6de817ba, 0x6df1b0b6, 0x6dfb46b6, 
  0x6e04d9bc, 0x6e0e69c6, 0x6e17f6d5, 0x6e2180e8, 
  0x6e2b0800, 0x6e348c1c, 0x6e3e0d3c, 0x6e478b61, 
  0x6e510689, 0x6e5a7eb6, 0x6e63f3e6, 0x6e6d661a, 
  0x6e76d552, 0x6e80418d, 0x6e89aacc, 0x6e93110e, 
  0x6e9c7453, 0x6ea5d49c, 0x6eaf31e8, 0x6eb88c37, 
  0x6ec1e388, 0x6ecb37dd, 0x6ed48935, 0x6eddd790, 
  0x6ee722ed, 0x6ef06b4d, 0x6ef9b0af, 0x6f02f314, 
  0x6f0c327b, 0x6f156ee5, 0x6f1ea852, 0x6f27dec0, 
  0x6f311231, 0x6f3a42a4, 0x6f437019, 0x6f4c9a90, 
  0x6f55c209, 0x6f5ee685, 0x6f680802, 0x6f712681, 
  0x6f7a4202, 0x6f835a85, 0x6f8c700a, 0x6f958290, 
  0x6f9e9219, 0x6fa79ea3, 0x6fb0a82f, 0x6fb9aebc, 
  0x6fc2b24b, 0x6fcbb2dc, 0x6fd4b06e, 0x6fddab02, 
  0x6fe6a298, 0x6fef972f, 0x6ff888c8, 0x70017762, 
  0x700a62fe, 0x70134b9b, 0x701c313a, 0x702513db, 
  0x702df37d, 0x7036d021, 0x703fa9c6, 0x7048806c, 
  0x70515415, 0x705a24be, 0x7062f26a, 0x706bbd17, 
  0x707484c5, 0x707d4975, 0x70860b27, 0x708ec9db, 
  0x70978590, 0x70a03e47, 0x70a8f3ff, 0x70b1a6ba, 
  0x70ba5676, 0x70c30334, 0x70cbacf4, 0x70d453b5, 
  0x70dcf779, 0x70e5983f, 0x70ee3606, 0x70f6d0d0, 
  0x70ff689c, 0x7107fd6a, 0x71108f3a, 0x71191e0c, 
  0x7121a9e1, 0x712a32b8, 0x7132b891, 0x713b3b6d, 
  0x7143bb4b, 0x714c382c, 0x7154b210, 0x715d28f6, 
  0x71659cdf, 0x716e0dcb, 0x71767bba, 0x717ee6ab, 
  0x71874ea0, 0x718fb398, 0x71981593, 0x71a07492, 
  0x71a8d093, 0x71b12999, 0x71b97fa1, 0x71c1d2ae, 
  0x71ca22be, 0x71d26fd2, 0x71dab9e9, 0x71e30105, 
  0x71eb4525, 0x71f38649, 0x71fbc471, 0x7203ff9d, 
  0x720c37ce, 0x72146d04, 0x721c9f3e, 0x7224ce7d, 
  0x722cfac1, 0x7235240a, 0x723d4a58, 0x72456dac, 
  0x724d8e04, 0x7255ab63, 0x725dc5c6, 0x7265dd30, 
  0x726df19f, 0x72760314, 0x727e1190, 0x72861d11, 
  0x728e2599, 0x72962b27, 0x729e2dbc, 0x72a62d58, 
  0x72ae29fb, 0x72b623a5, 0x72be1a55, 0x72c60e0e, 
  0x72cdfecd, 0x72d5ec94, 0x72ddd763, 0x72e5bf3a, 
  0x72eda419, 0x72f58600, 0x72fd64f0, 0x730540e8, 
  0x730d19e8, 0x7314eff2, 0x731cc304, 0x73249320, 
  0x732c6045, 0x73342a74, 0x733bf1ac, 0x7343b5ee, 
  0x734b773a, 0x73533590, 0x735af0f1, 0x7362a95c, 
  0x736a5ed2, 0x73721153, 0x7379c0de, 0x73816d75, 
  0x73891718, 0x7390bdc6, 0x73986180, 0x73a00246, 
  0x73a7a019, 0x73af3af7, 0x73b6d2e3, 0x73be67db, 
  0x73c5f9e0, 0x73cd88f2, 0x73d51512, 0x73dc9e40, 
  0x73e4247b, 0x73eba7c4, 0x73f3281c, 0x73faa581, 
  0x74021ff6, 0x7409977a, 0x74110c0c, 0x74187dae, 
  0x741fec60, 0x74275821, 0x742ec0f2, 0x743626d4, 
  0x743d89c6, 0x7444e9c8, 0x744c46dc, 0x7453a100, 
  0x745af836, 0x74624c7e, 0x74699dd7, 0x7470ec43, 
  0x747837c1, 0x747f8051, 0x7486c5f5, 0x748e08ab, 
  0x74954874, 0x749c8552, 0x74a3bf42, 0x74aaf647, 
  0x74b22a61, 0x74b95b8f, 0x74c089d1, 0x74c7b529, 
  0x74cedd96, 0x74d60319, 0x74dd25b1, 0x74e44560, 
  0x74eb6225, 0x74f27c01, 0x74f992f4, 0x7500a6fe, 
  0x7507b81f, 0x750ec658, 0x7515d1a9, 0x751cda13, 
  0x7523df95, 0x752ae230, 0x7531e1e4, 0x7538deb2, 
  0x753fd899, 0x7546cf9a, 0x754dc3b6, 0x7554b4ec, 
  0x755ba33d, 0x75628ea9, 0x75697731, 0x75705cd4, 
  0x75773f94, 0x757e1f70, 0x7584fc69, 0x758bd67e, 
  0x7592adb1, 0x75998202, 0x75a05370, 0x75a721fd, 
  0x75adeda8, 0x75b4b672, 0x75bb7c5b, 0x75c23f64, 
  0x75c8ff8c, 0x75cfbcd5, 0x75d6773e, 0x75dd2ec7, 
  0x75e3e372, 0x75ea953e, 0x75f1442c, 0x75f7f03c, 
  0x75fe996f, 0x76053fc4, 0x760be33c, 0x761283d7, 
  0x76192197, 0x761fbc7a, 0x76265482, 0x762ce9ae, 
  0x76337c00, 0x763a0b77, 0x76409813, 0x764721d6, 
  0x764da8c0, 0x76542cd0, 0x765aae07, 0x76612c66, 
  0x7667a7ed, 0x766e209c, 0x76749674, 0x767b0974, 
  0x7681799e, 0x7687e6f2, 0x768e516f, 0x7694b918, 
  0x769b1dea, 0x76a17fe8, 0x76a7df12, 0x76ae3b67, 
  0x76b494e9, 0x76baeb97, 0x76c13f73, 0x76c7907b, 
  0x76cddeb2, 0x76d42a17, 0x76da72aa, 0x76e0b86c, 
  0x76e6fb5d, 0x76ed3b7e, 0x76f378d0, 0x76f9b351, 
  0x76ffeb04, 0x77061fe7, 0x770c51fd, 0x77128144, 
  0x7718adbe, 0x771ed76b, 0x7724fe4b, 0x772b225e, 
  0x773143a6, 0x77376222, 0x773d7dd3, 0x774396b9, 
  0x7749acd4, 0x774fc026, 0x7755d0ae, 0x775bde6e, 
  0x7761e964, 0x7767f192, 0x776df6f9, 0x7773f997, 
  0x7779f96f, 0x777ff681, 0x7785f0cc, 0x778be851, 
  0x7791dd11, 0x7797cf0c, 0x779dbe42, 0x77a3aab5, 
  0x77a99464, 0x77af7b4f, 0x77b55f78, 0x77bb40df, 
  0x77c11f84, 0x77c6fb67, 0x77ccd489, 0x77d2aaeb, 
  0x77d87e8c, 0x77de4f6e, 0x77e41d91, 0x77e9e8f5, 
  0x77efb19a, 0x77f57782, 0x77fb3aac, 0x7800fb19, 
  0x7806b8c9, 0x780c73be, 0x78122bf6, 0x7817e174, 
  0x781d9437, 0x78234440, 0x7828f18e, 0x782e9c24, 
  0x78344400, 0x7839e924, 0x783f8b91, 0x78452b45, 
  0x784ac843, 0x7850628a, 0x7855fa1b, 0x785b8ef7, 
  0x7861211d, 0x7866b08f, 0x786c3d4c, 0x7871c756, 
  0x78774ead, 0x787cd350, 0x78825542, 0x7887d482, 
  0x788d5110, 0x7892caee, 0x7898421b, 0x789db699, 
  0x78a32867, 0x78a89786, 0x78ae03f7, 0x78b36dba, 
  0x78b8d4d0, 0x78be3939, 0x78c39af5, 0x78c8fa05, 
  0x78ce566b, 0x78d3b025, 0x78d90735, 0x78de5b9b, 
  0x78e3ad57, 0x78e8fc6b, 0x78ee48d6, 0x78f3929a, 
  0x78f8d9b6, 0x78fe1e2b, 0x79035ffa, 0x79089f23, 
  0x790ddba7, 0x79131586, 0x79184cc1, 0x791d8158, 
  0x7922b34c, 0x7927e29d, 0x792d0f4c, 0x79323959, 
  0x793760c5, 0x793c8590, 0x7941a7bc, 0x7946c748, 
  0x794be434, 0x7950fe83, 0x79561633, 0x795b2b46, 
  0x79603dbb, 0x79654d95, 0x796a5ad3, 0x796f6575, 
  0x79746d7d, 0x797972ea, 0x797e75be, 0x798375f8, 
  0x7988739a, 0x798d6ea4, 0x79926716, 0x79975cf2, 
  0x799c5036, 0x79a140e5, 0x79a62eff, 0x79ab1a84, 
  0x79b00375, 0x79b4e9d2, 0x79b9cd9c, 0x79beaed3, 
  0x79c38d79, 0x79c8698c, 0x79cd430f, 0x79d21a02, 
  0x79d6ee65, 0x79dbc039, 0x79e08f7e, 0x79e55c35, 
  0x79ea265e, 0x79eeedfb, 0x79f3b30b, 0x79f8758f, 
  0x79fd3588, 0x7a01f2f6, 0x7a06addb, 0x7a0b6635, 
  0x7a101c07, 0x7a14cf51, 0x7a198012, 0x7a1e2e4c, 
  0x7a22da00, 0x7a27832e, 0x7a2c29d6, 0x7a30cdf9, 
  0x7a356f98, 0x7a3a0eb3, 0x7a3eab4b, 0x7a434560, 
  0x7a47dcf4, 0x7a4c7206, 0x7a510497, 0x7a5594a8, 
  0x7a5a2239, 0x7a5ead4c, 0x7a6335df, 0x7a67bbf5, 
  0x7a6c3f8e, 0x7a70c0aa, 0x7a753f4a, 0x7a79bb6f, 
  0x7a7e3518, 0x7a82ac47, 0x7a8720fd, 0x7a8b933a, 
  0x7a9002fe, 0x7a94704a, 0x7a98db1f, 0x7a9d437d, 
  0x7aa1a966, 0x7aa60cd8, 0x7aaa6dd6, 0x7aaecc60, 
  0x7ab32876, 0x7ab7821a, 0x7abbd94a, 0x7ac02e09, 
  0x7ac48057, 0x7ac8d034, 0x7acd1da2, 0x7ad168a0, 
  0x7ad5b12f, 0x7ad9f751, 0x7ade3b04, 0x7ae27c4b, 
  0x7ae6bb26, 0x7aeaf795, 0x7aef3199, 0x7af36933, 
  0x7af79e63, 0x7afbd12b, 0x7b000189, 0x7b042f80, 
  0x7b085b0f, 0x7b0c8438, 0x7b10aafc, 0x7b14cf59, 
  0x7b18f152, 0x7b1d10e7, 0x7b212e19, 0x7b2548e8, 
  0x7b296154, 0x7b2d7760, 0x7b318b0a, 0x7b359c54, 
  0x7b39ab3f, 0x7b3db7ca, 0x7b41c1f7, 0x7b45c9c7, 
  0x7b49cf3a, 0x7b4dd250, 0x7b51d30a, 0x7b55d16a, 
  0x7b59cd6f, 0x7b5dc71a, 0x7b61be6c, 0x7b65b366, 
  0x7b69a607, 0x7b6d9652, 0x7b718446, 0x7b756fe4, 
  0x7b79592d, 0x7b7d4021, 0x7b8124c2, 0x7b85070f, 
  0x7b88e709, 0x7b8cc4b2, 0x7b90a009, 0x7b947910, 
  0x7b984fc7, 0x7b9c242e, 0x7b9ff647, 0x7ba3c611, 
  0x7ba7938f, 0x7bab5ec0, 0x7baf27a4, 0x7bb2ee3e, 
  0x7bb6b28d, 0x7bba7492, 0x7bbe344d, 0x7bc1f1c0, 
  0x7bc5aceb, 0x7bc965ce, 0x7bcd1c6b, 0x7bd0d0c2, 
  0x7bd482d3, 0x7bd832a0, 0x7bdbe029, 0x7bdf8b6f, 
  0x7be33472, 0x7be6db33, 0x7bea7fb3, 0x7bee21f3, 
  0x7bf1c1f2, 0x7bf55fb2, 0x7bf8fb34, 0x7bfc9478, 
  0x7c002b7e, 0x7c03c049, 0x7c0752d7, 0x7c0ae32a, 
  0x7c0e7143, 0x7c11fd22, 0x7c1586c8, 0x7c190e35, 
  0x7c1c936b, 0x7c20166a, 0x7c239732, 0x7c2715c5, 
  0x7c2a9223, 0x7c2e0c4d, 0x7c318443, 0x7c34fa06, 
  0x7c386d97, 0x7c3bdef7, 0x7c3f4e25, 0x7c42bb24, 
  0x7c4625f3, 0x7c498e94, 0x7c4cf506, 0x7c50594b, 
  0x7c53bb64, 0x7c571b51, 0x7c5a7912, 0x7c5dd4a9, 
  0x7c612e16, 0x7c64855a, 0x7c67da75, 0x7c6b2d69, 
  0x7c6e7e36, 0x7c71ccdc, 0x7c75195d, 0x7c7863b9, 
  0x7c7babf0, 0x7c7ef205, 0x7c8235f6, 0x7c8577c5, 
  0x7c88b773, 0x7c8bf501, 0x7c8f306e, 0x7c9269bc, 
  0x7c95a0eb, 0x7c98d5fd, 0x7c9c08f2, 0x7c9f39ca, 
  0x7ca26886, 0x7ca59527, 0x7ca8bfaf, 0x7cabe81c, 
  0x7caf0e71, 0x7cb232ae, 0x7cb554d3, 0x7cb874e1, 
  0x7cbb92da, 0x7cbeaebd, 0x7cc1c88c, 0x7cc4e046, 
  0x7cc7f5ee, 0x7ccb0983, 0x7cce1b07, 0x7cd12a7a, 
  0x7cd437dc, 0x7cd7432f, 0x7cda4c73, 0x7cdd53a9, 
  0x7ce058d2, 0x7ce35bee, 0x7ce65cfe, 0x7ce95c03, 
  0x7cec58fe, 0x7cef53ef, 0x7cf24cd6, 0x7cf543b6, 
  0x7cf8388e, 0x7cfb2b5f, 0x7cfe1c2a, 0x7d010af0, 
  0x7d03f7b1, 0x7d06e26e, 0x7d09cb28, 0x7d0cb1df, 
  0x7d0f9695, 0x7d12794a, 0x7d1559fe, 0x7d1838b3, 
  0x7d1b1569, 0x7d1df021, 0x7d20c8dc, 0x7d239f9a, 
  0x7d26745d, 0x7d294724, 0x7d2c17f0, 0x7d2ee6c3, 
  0x7d31b39e, 0x7d347e80, 0x7d37476a, 0x7d3a0e5e, 
  0x7d3cd35c, 0x7d3f9664, 0x7d425778, 0x7d451698, 
  0x7d47d3c6, 0x7d4a8f00, 0x7d4d484a, 0x7d4fffa2, 
  0x7d52b50b, 0x7d556884, 0x7d581a0e, 0x7d5ac9ab, 
  0x7d5d775b, 0x7d60231e, 0x7d62ccf5, 0x7d6574e2, 
  0x7d681ae5, 0x7d6abefe, 0x7d6d612e, 0x7d700177, 
  0x7d729fd8, 0x7d753c53, 0x7d77d6e8, 0x7d7a6f99, 
  0x7d7d0665, 0x7d7f9b4e, 0x7d822e54, 0x7d84bf78, 
  0x7d874ebb, 0x7d89dc1d, 0x7d8c67a0, 0x7d8ef143, 
  0x7d917909, 0x7d93fef1, 0x7d9682fc, 0x7d99052c, 
  0x7d9b8580, 0x7d9e03fa, 0x7da0809a, 0x7da2fb61, 
  0x7da57450, 0x7da7eb67, 0x7daa60a8, 0x7dacd412, 
  0x7daf45a8, 0x7db1b569, 0x7db42356, 0x7db68f70, 
  0x7db8f9b8, 0x7dbb622f, 0x7dbdc8d5, 0x7dc02dab, 
  0x7dc290b2, 0x7dc4f1ea, 0x7dc75155, 0x7dc9aef3, 
  0x7dcc0ac4, 0x7dce64cb, 0x7dd0bd06, 0x7dd31378, 
  0x7dd56820, 0x7dd7bb00, 0x7dda0c19, 0x7ddc5b6a, 
  0x7ddea8f6, 0x7de0f4bc, 0x7de33ebd, 0x7de586fb, 
  0x7de7cd75, 0x7dea122d, 0x7dec5524, 0x7dee9659, 
  0x7df0d5cf, 0x7df31385, 0x7df54f7d, 0x7df789b7, 
  0x7df9c234, 0x7dfbf8f4, 0x7dfe2dfa, 0x7e006144, 
  0x7e0292d4, 0x7e04c2ab, 0x7e06f0ca, 0x7e091d31, 
  0x7e0b47e0, 0x7e0d70da, 0x7e0f981e, 0x7e11bdae, 
  0x7e13e189, 0x7e1603b2, 0x7e182428, 0x7e1a42ec, 
  0x7e1c6000, 0x7e1e7b63, 0x7e209517, 0x7e22ad1c, 
  0x7e24c374, 0x7e26d81e, 0x7e28eb1c, 0x7e2afc6f, 
  0x7e2d0c16, 0x7e2f1a14, 0x7e312669, 0x7e333115, 
  0x7e353a19, 0x7e374176, 0x7e39472d, 0x7e3b4b3e, 
  0x7e3d4dab, 0x7e3f4e74, 0x7e414d99, 0x7e434b1d, 
  0x7e4546fe, 0x7e47413f, 0x7e4939df, 0x7e4b30e1, 
  0x7e4d2643, 0x7e4f1a08, 0x7e510c2f, 0x7e52fcbb, 
  0x7e54ebaa, 0x7e56d8ff, 0x7e58c4ba, 0x7e5aaedc, 
  0x7e5c9765, 0x7e5e7e56, 0x7e6063b1, 0x7e624775, 
  0x7e6429a4, 0x7e660a3e, 0x7e67e944, 0x7e69c6b7, 
  0x7e6ba298, 0x7e6d7ce6, 0x7e6f55a4, 0x7e712cd2, 
  0x7e730271, 0x7e74d681, 0x7e76a903, 0x7e7879f8, 
  0x7e7a4961, 0x7e7c173e, 0x7e7de391, 0x7e7fae59, 
  0x7e817798, 0x7e833f4f, 0x7e85057e, 0x7e86ca26, 
  0x7e888d48, 0x7e8a4ee4, 0x7e8c0efc, 0x7e8dcd90, 
  0x7e8f8aa0, 0x7e91462f, 0x7e93003b, 0x7e94b8c7, 
  0x7e966fd3, 0x7e98255f, 0x7e99d96d, 0x7e9b8bfd, 
  0x7e9d3d0f, 0x7e9eeca6, 0x7ea09ac1, 0x7ea24761, 
  0x7ea3f287, 0x7ea59c34, 0x7ea74469, 0x7ea8eb26, 
  0x7eaa906b, 0x7eac343b, 0x7eadd695, 0x7eaf777a, 
  0x7eb116ec, 0x7eb2b4ea, 0x7eb45176, 0x7eb5ec90, 
  0x7eb7863a, 0x7eb91e73, 0x7ebab53d, 0x7ebc4a98, 
  0x7ebdde86, 0x7ebf7106, 0x7ec1021a, 0x7ec291c2, 
  0x7ec42000, 0x7ec5acd4, 0x7ec7383e, 0x7ec8c240, 
  0x7eca4ada, 0x7ecbd20c, 0x7ecd57d9, 0x7ecedc40, 
  0x7ed05f43, 0x7ed1e0e1, 0x7ed3611c, 0x7ed4dff5, 
  0x7ed65d6c, 0x7ed7d982, 0x7ed95437, 0x7edacd8e, 
  0x7edc4585, 0x7eddbc1f, 0x7edf315b, 0x7ee0a53b, 
  0x7ee217c0, 0x7ee388e9, 0x7ee4f8b8, 0x7ee6672e, 
  0x7ee7d44b, 0x7ee94011, 0x7eeaaa7f, 0x7eec1396, 
  0x7eed7b58, 0x7eeee1c5, 0x7ef046de, 0x7ef1aaa4, 
  0x7ef30d17, 0x7ef46e38, 0x7ef5ce08, 0x7ef72c87, 
  0x7ef889b7, 0x7ef9e598, 0x7efb402b, 0x7efc9971, 
  0x7efdf16a, 0x7eff4817, 0x7f009d78, 0x7f01f190, 
  0x7f03445e, 0x7f0495e3, 0x7f05e61f, 0x7f073515, 
  0x7f0882c4, 0x7f09cf2c, 0x7f0b1a50, 0x7f0c642f, 
  0x7f0daccb, 0x7f0ef424, 0x7f103a3a, 0x7f117f10, 
  0x7f12c2a4, 0x7f1404f9, 0x7f15460e, 0x7f1685e5, 
  0x7f17c47e, 0x7f1901da, 0x7f1a3dfb, 0x7f1b78df, 
  0x7f1cb289, 0x7f1deaf9, 0x7f1f2230, 0x7f20582e, 
  0x7f218cf4, 0x7f22c084, 0x7f23f2dd, 0x7f252400, 
  0x7f2653ef, 0x7f2782aa, 0x7f28b031, 0x7f29dc86, 
  0x7f2b07a9, 0x7f2c319b, 0x7f2d5a5d, 0x7f2e81ef, 
  0x7f2fa852, 0x7f30cd87, 0x7f31f18e, 0x7f331469, 
  0x7f343618, 0x7f35569b, 0x7f3675f5, 0x7f379424, 
  0x7f38b12b, 0x7f39cd09, 0x7f3ae7bf, 0x7f3c014f, 
  0x7f3d19b9, 0x7f3e30fd, 0x7f3f471d, 0x7f405c19, 
  0x7f416ff2, 0x7f4282a8, 0x7f43943d, 0x7f44a4b1, 
  0x7f45b404, 0x7f46c238, 0x7f47cf4d, 0x7f48db44, 
  0x7f49e61e, 0x7f4aefdb, 0x7f4bf87d, 0x7f4d0003, 
  0x7f4e066f, 0x7f4f0bc1, 0x7f500ffa, 0x7f51131b, 
  0x7f521524, 0x7f531617, 0x7f5415f3, 0x7f5514ba, 
  0x7f56126d, 0x7f570f0b, 0x7f580a97, 0x7f590510, 
  0x7f59fe77, 0x7f5af6cd, 0x7f5bee13, 0x7f5ce449, 
  0x7f5dd971, 0x7f5ecd8a, 0x7f5fc096, 0x7f60b295, 
  0x7f61a388, 0x7f62936f, 0x7f63824d, 0x7f647020, 
  0x7f655cea, 0x7f6648ac, 0x7f673366, 0x7f681d19, 
  0x7f6905c5, 0x7f69ed6c, 0x7f6ad40e, 0x7f6bb9ac, 
  0x7f6c9e47, 0x7f6d81df, 0x7f6e6474, 0x7f6f4609, 
  0x7f70269c, 0x7f710630, 0x7f71e4c5, 0x7f72c25b, 
  0x7f739ef3, 0x7f747a8e, 0x7f75552d, 0x7f762ed0, 
  0x7f770778, 0x7f77df26, 0x7f78b5da, 0x7f798b96, 
  0x7f7a6059, 0x7f7b3424, 0x7f7c06f9, 0x7f7cd8d8, 
  0x7f7da9c1, 0x7f7e79b6, 0x7f7f48b7, 0x7f8016c4, 
  0x7f80e3df, 0x7f81b008, 0x7f827b3f, 0x7f834587, 
  0x7f840ede, 0x7f84d746, 0x7f859ec0, 0x7f86654c, 
  0x7f872aeb, 0x7f87ef9d, 0x7f88b364, 0x7f897640, 
  0x7f8a3831, 0x7f8af939, 0x7f8bb958, 0x7f8c788f, 
  0x7f8d36de, 0x7f8df447, 0x7f8eb0c9, 0x7f8f6c66, 
  0x7f90271d, 0x7f90e0f1, 0x7f9199e1, 0x7f9251ef, 
  0x7f93091a, 0x7f93bf64, 0x7f9474cd, 0x7f952957, 
  0x7f95dd00, 0x7f968fcc, 0x7f9741b9, 0x7f97f2c9, 
  0x7f98a2fc, 0x7f995253, 0x7f9a00cf, 0x7f9aae70, 
  0x7f9b5b37, 0x7f9c0725, 0x7f9cb23a, 0x7f9d5c77, 
  0x7f9e05dd, 0x7f9eae6d, 0x7f9f5626, 0x7f9ffd0a, 
  0x7fa0a31a, 0x7fa14855, 0x7fa1ecbe, 0x7fa29053, 
  0x7fa33317, 0x7fa3d50a, 0x7fa4762b, 0x7fa5167d, 
  0x7fa5b600, 0x7fa654b4, 0x7fa6f29a, 0x7fa78fb2, 
  0x7fa82bfe, 0x7fa8c77e, 0x7fa96233, 0x7fa9fc1d, 
  0x7faa953d, 0x7fab2d93, 0x7fabc521, 0x7fac5be7, 
  0x7facf1e5, 0x7fad871c, 0x7fae1b8e, 0x7faeaf3a, 
  0x7faf4221, 0x7fafd444, 0x7fb065a3, 0x7fb0f640, 
  0x7fb1861a, 0x7fb21533, 0x7fb2a38b, 0x7fb33123, 
  0x7fb3bdfa, 0x7fb44a13, 0x7fb4d56e, 0x7fb5600b, 
  0x7fb5e9eb, 0x7fb6730e, 0x7fb6fb75, 0x7fb78322, 
  0x7fb80a14, 0x7fb8904c, 0x7fb915cb, 0x7fb99a91, 
  0x7fba1e9f, 0x7fbaa1f6, 0x7fbb2496, 0x7fbba680, 
  0x7fbc27b4, 0x7fbca834, 0x7fbd2800, 0x7fbda718, 
  0x7fbe257d, 0x7fbea330, 0x7fbf2031, 0x7fbf9c81, 
  0x7fc01820, 0x7fc09310, 0x7fc10d51, 0x7fc186e3, 
  0x7fc1ffc7, 0x7fc277fe, 0x7fc2ef88, 0x7fc36666, 
  0x7fc3dc99, 0x7fc45220, 0x7fc4c6fe, 0x7fc53b32, 
  0x7fc5aebd, 0x7fc6219f, 0x7fc693da, 0x7fc7056e, 
  0x7fc7765b, 0x7fc7e6a2, 0x7fc85644, 0x7fc8c541, 
  0x7fc9339a, 0x7fc9a14f, 0x7fca0e62, 0x7fca7ad2, 
  0x7fcae6a1, 0x7fcb51ce, 0x7fcbbc5b, 0x7fcc2648, 
  0x7fcc8f96, 0x7fccf845, 0x7fcd6057, 0x7fcdc7ca, 
  0x7fce2ea1, 0x7fce94dc, 0x7fcefa7a, 0x7fcf5f7e, 
  0x7fcfc3e7, 0x7fd027b6, 0x7fd08aec, 0x7fd0ed8a, 
  0x7fd14f8f, 0x7fd1b0fc, 0x7fd211d3, 0x7fd27213, 
  0x7fd2d1be, 0x7fd330d3, 0x7fd38f54, 0x7fd3ed40, 
  0x7fd44a99, 0x7fd4a760, 0x7fd50394, 0x7fd55f36, 
  0x7fd5ba47, 0x7fd614c8, 0x7fd66eb9, 0x7fd6c81a, 
  0x7fd720ec, 0x7fd77931, 0x7fd7d0e7, 0x7fd82811, 
  0x7fd87ead, 0x7fd8d4be, 0x7fd92a44, 0x7fd97f3f, 
  0x7fd9d3af, 0x7fda2796, 0x7fda7af4, 0x7fdacdc9, 
  0x7fdb2017, 0x7fdb71dc, 0x7fdbc31b, 0x7fdc13d4, 
  0x7fdc6407, 0x7fdcb3b5, 0x7fdd02de, 0x7fdd5183, 
  0x7fdd9fa4, 0x7fdded43, 0x7fde3a5f, 0x7fde86fa, 
  0x7fded313, 0x7fdf1eab, 0x7fdf69c3, 0x7fdfb45c, 
  0x7fdffe75, 0x7fe04810, 0x7fe0912d, 0x7fe0d9cd, 
  0x7fe121ef, 0x7fe16995, 0x7fe1b0c0, 0x7fe1f76f, 
  0x7fe23da3, 0x7fe2835e, 0x7fe2c89e, 0x7fe30d66, 
  0x7fe351b4, 0x7fe3958b, 0x7fe3d8eb, 0x7fe41bd3, 
  0x7fe45e45, 0x7fe4a041, 0x7fe4e1c7, 0x7fe522d9, 
  0x7fe56377, 0x7fe5a3a0, 0x7fe5e357, 0x7fe6229a, 
  0x7fe6616c, 0x7fe69fcb, 0x7fe6ddba, 0x7fe71b38, 
  0x7fe75846, 0x7fe794e4, 0x7fe7d113, 0x7fe80cd4, 
  0x7fe84826, 0x7fe8830b, 0x7fe8bd83, 0x7fe8f78e, 
  0x7fe9312e, 0x7fe96a61, 0x7fe9a32a, 0x7fe9db89, 
  0x7fea137d, 0x7fea4b08, 0x7fea822a, 0x7feab8e4, 
  0x7feaef36, 0x7feb2520, 0x7feb5aa3, 0x7feb8fc0, 
  0x7febc477, 0x7febf8c9, 0x7fec2cb5, 0x7fec603d, 
  0x7fec9362, 0x7fecc622, 0x7fecf880, 0x7fed2a7b, 
  0x7fed5c15, 0x7fed8d4d, 0x7fedbe23, 0x7fedee9a, 
  0x7fee1eb0, 0x7fee4e67, 0x7fee7dbf, 0x7feeacb8, 
  0x7feedb53, 0x7fef0990, 0x7fef3770, 0x7fef64f4, 
  0x7fef921c, 0x7fefbee7, 0x7fefeb58, 0x7ff0176e, 
  0x7ff04329, 0x7ff06e8b, 0x7ff09994, 0x7ff0c443, 
  0x7ff0ee9b, 0x7ff1189a, 0x7ff14242, 0x7ff16b93, 
  0x7ff1948d, 0x7ff1bd31, 0x7ff1e580, 0x7ff20d7a, 
  0x7ff2351e, 0x7ff25c6f, 0x7ff2836c, 0x7ff2aa16, 
  0x7ff2d06c, 0x7ff2f671, 0x7ff31c23, 0x7ff34184, 
  0x7ff36694, 0x7ff38b54, 0x7ff3afc3, 0x7ff3d3e3, 
  0x7ff3f7b3, 0x7ff41b34, 0x7ff43e68, 0x7ff4614d, 
  0x7ff483e5, 0x7ff4a630, 0x7ff4c82e, 0x7ff4e9e0, 
  0x7ff50b46, 0x7ff52c61, 0x7ff54d32, 0x7ff56db8, 
  0x7ff58df4, 0x7ff5ade6, 0x7ff5cd8f, 0x7ff5ecf0, 
  0x7ff60c08, 0x7ff62ad9, 0x7ff64962, 0x7ff667a4, 
  0x7ff685a0, 0x7ff6a356, 0x7ff6c0c6, 0x7ff6ddf0, 
  0x7ff6fad6, 0x7ff71777, 0x7ff733d5, 0x7ff74fee, 
  0x7ff76bc5, 0x7ff78758, 0x7ff7a2aa, 0x7ff7bdb9, 
  0x7ff7d887, 0x7ff7f314, 0x7ff80d60, 0x7ff8276b, 
  0x7ff84137, 0x7ff85ac3, 0x7ff87411, 0x7ff88d1f, 
  0x7ff8a5ef, 0x7ff8be81, 0x7ff8d6d6, 0x7ff8eeee, 
  0x7ff906c8, 0x7ff91e67, 0x7ff935ca, 0x7ff94cf1, 
  0x7ff963dc, 0x7ff97a8e, 0x7ff99104, 0x7ff9a741, 
  0x7ff9bd44, 0x7ff9d30e, 0x7ff9e89f, 0x7ff9fdf8, 
  0x7ffa1319, 0x7ffa2802, 0x7ffa3cb3, 0x7ffa512e, 
  0x7ffa6572, 0x7ffa7980, 0x7ffa8d58, 0x7ffaa0fb, 
  0x7ffab469, 0x7ffac7a2, 0x7ffadaa7, 0x7ffaed77, 
  0x7ffb0014, 0x7ffb127e, 0x7ffb24b5, 0x7ffb36ba, 
  0x7ffb488c, 0x7ffb5a2d, 0x7ffb6b9c, 0x7ffb7cda, 
  0x7ffb8de8, 0x7ffb9ec5, 0x7ffbaf72, 0x7ffbbff0, 
  0x7ffbd03e, 0x7ffbe05d, 0x7ffbf04e, 0x7ffc0011, 
  0x7ffc0fa5, 0x7ffc1f0c, 0x7ffc2e46, 0x7ffc3d53, 
  0x7ffc4c34, 0x7ffc5ae8, 0x7ffc6970, 0x7ffc77cd, 
  0x7ffc85ff, 0x7ffc9406, 0x7ffca1e3, 0x7ffcaf95, 
  0x7ffcbd1e, 0x7ffcca7d, 0x7ffcd7b3, 0x7ffce4c0, 
  0x7ffcf1a4, 0x7ffcfe61, 0x7ffd0af5, 0x7ffd1762, 
  0x7ffd23a8, 0x7ffd2fc7, 0x7ffd3bc0, 0x7ffd4792, 
  0x7ffd533e, 0x7ffd5ec4, 0x7ffd6a26, 0x7ffd7562, 
  0x7ffd8079, 0x7ffd8b6d, 0x7ffd963c, 0x7ffda0e7, 
  0x7ffdab6f, 0x7ffdb5d4, 0x7ffdc016, 0x7ffdca35, 
  0x7ffdd433, 0x7ffdde0e, 0x7ffde7c8, 0x7ffdf160, 
  0x7ffdfad7, 0x7ffe042e, 0x7ffe0d64, 0x7ffe167a, 
  0x7ffe1f70, 0x7ffe2847, 0x7ffe30fe, 0x7ffe3996, 
  0x7ffe4210, 0x7ffe4a6b, 0x7ffe52a8, 0x7ffe5ac7, 
  0x7ffe62c8, 0x7ffe6aad, 0x7ffe7274, 0x7ffe7a1e, 
  0x7ffe81ac, 0x7ffe891e, 0x7ffe9074, 0x7ffe97af, 
  0x7ffe9ecd, 0x7ffea5d1, 0x7ffeacba, 0x7ffeb389, 
  0x7ffeba3d, 0x7ffec0d7, 0x7ffec757, 0x7ffecdbe, 
  0x7ffed40c, 0x7ffeda40, 0x7ffee05c, 0x7ffee65f, 
  0x7ffeec4a, 0x7ffef21e, 0x7ffef7d9, 0x7ffefd7d, 
  0x7fff030a, 0x7fff0880, 0x7fff0ddf, 0x7fff1327, 
  0x7fff185a, 0x7fff1d76, 0x7fff227d, 0x7fff276e, 
  0x7fff2c4a, 0x7fff3111, 0x7fff35c3, 0x7fff3a61, 
  0x7fff3eea, 0x7fff435f, 0x7fff47c1, 0x7fff4c0e, 
  0x7fff5049, 0x7fff5470, 0x7fff5884, 0x7fff5c86, 
  0x7fff6075, 0x7fff6451, 0x7fff681c, 0x7fff6bd5, 
  0x7fff6f7c, 0x7fff7312, 0x7fff7697, 0x7fff7a0b, 
  0x7fff7d6e, 0x7fff80c1, 0x7fff8403, 0x7fff8735, 
  0x7fff8a57, 0x7fff8d6a, 0x7fff906d, 0x7fff9361, 
  0x7fff9645, 0x7fff991b, 0x7fff9be2, 0x7fff9e9b, 
  0x7fffa145, 0x7fffa3e1, 0x7fffa670, 0x7fffa8f0, 
  0x7fffab64, 0x7fffadc9, 0x7fffb022, 0x7fffb26e, 
  0x7fffb4ad, 0x7fffb6df, 0x7fffb905, 0x7fffbb1f, 
  0x7fffbd2d, 0x7fffbf2f, 0x7fffc125, 0x7fffc310, 
  0x7fffc4f0, 0x7fffc6c4, 0x7fffc88e, 0x7fffca4c, 
  0x7fffcc00, 0x7fffcdaa, 0x7fffcf49, 0x7fffd0df, 
  0x7fffd26a, 0x7fffd3eb, 0x7fffd563, 0x7fffd6d1, 
  0x7fffd837, 0x7fffd992, 0x7fffdae5, 0x7fffdc30, 
  0x7fffdd71, 0x7fffdeaa, 0x7fffdfda, 0x7fffe103, 
  0x7fffe223, 0x7fffe33b, 0x7fffe44c, 0x7fffe555, 
  0x7fffe656, 0x7fffe750, 0x7fffe843, 0x7fffe92f, 
  0x7fffea14, 0x7fffeaf2, 0x7fffebc9, 0x7fffec9a, 
  0x7fffed65, 0x7fffee29, 0x7fffeee7, 0x7fffef9f, 
  0x7ffff052, 0x7ffff0fe, 0x7ffff1a5, 0x7ffff246, 
  0x7ffff2e3, 0x7ffff379, 0x7ffff40b, 0x7ffff498, 
  0x7ffff51f, 0x7ffff5a2, 0x7ffff620, 0x7ffff69a, 
  0x7ffff70f, 0x7ffff780, 0x7ffff7ed, 0x7ffff856, 
  0x7ffff8ba, 0x7ffff91b, 0x7ffff978, 0x7ffff9d1, 
  0x7ffffa26, 0x7ffffa78, 0x7ffffac7, 0x7ffffb12, 
  0x7ffffb5a, 0x7ffffb9f, 0x7ffffbe1, 0x7ffffc20, 
  0x7ffffc5c, 0x7ffffc95, 0x7ffffccc, 0x7ffffd00, 
  0x7ffffd31, 0x7ffffd60, 0x7ffffd8d, 0x7ffffdb7, 
  0x7ffffddf, 0x7ffffe06, 0x7ffffe2a, 0x7ffffe4c, 
  0x7ffffe6c, 0x7ffffe8a, 0x7ffffea7, 0x7ffffec2, 
  0x7ffffedb, 0x7ffffef3, 0x7fffff09, 0x7fffff1e, 
  0x7fffff32, 0x7fffff44, 0x7fffff55, 0x7fffff65, 
  0x7fffff74, 0x7fffff81, 0x7fffff8e, 0x7fffff99, 
  0x7fffffa4, 0x7fffffae, 0x7fffffb7, 0x7fffffbf, 
  0x7fffffc7, 0x7fffffcd, 0x7fffffd4, 0x7fffffd9, 
  0x7fffffde, 0x7fffffe3, 0x7fffffe7, 0x7fffffea, 
  0x7fffffee, 0x7ffffff0, 0x7ffffff3, 0x7ffffff5, 
  0x7ffffff7, 0x7ffffff8, 0x7ffffffa, 0x7ffffffb, 
  0x7ffffffc, 0x7ffffffc, 0x7ffffffd, 0x7ffffffe, 
  0x7ffffffe, 0x7ffffffe, 0x7fffffff, 0x7fffffff, 
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff, 
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0x7fffffff, 
};

ogg_int32_t *_vorbis_window(int type, int left){

  switch(type){
  case 0:

    switch(left){
    case 32:
      return vwin64;
    case 64:
      return vwin128;
    case 128:
      return vwin256;
    case 256:
      return vwin512;
    case 512:
      return vwin1024;
    case 1024:
      return vwin2048;
    case 2048:
      return vwin4096;
    case 4096:
      return vwin8192;
    default:
      return(NULL);
    }
    break;
  default:
    return(NULL);
  }
}

void _vorbis_apply_window(ogg_int32_t *d,ogg_int32_t *window[2],long *blocksizes,
			  int lW,int W,int nW){

  long n=blocksizes[W];
  long ln=blocksizes[lW];
  long rn=blocksizes[nW];

  long leftbegin=n/4-ln/4;
  long leftend=leftbegin+ln/2;

  long rightbegin=n/2+n/4-rn/4;
  long rightend=rightbegin+rn/2;
  
  int i,p;

  for(i=0;i<leftbegin;i++)
    d[i]=0;

  for(p=0;i<leftend;i++,p++)
    d[i]=MULT31(d[i],window[lW][p]);

  for(i=rightbegin,p=rn/2-1;i<rightend;i++,p--)
    d[i]=MULT31(d[i],window[nW][p]);

  for(;i<n;i++)
    d[i]=0;
}
