#
# (C) Tenable Network Security
#
if(description)
{
 script_id(17161);
 script_version ("$Revision: 1.2 $");
 name["english"] = "Sybase TCP/IP listener is running";
 script_name(english:name["english"]);
 
 desc["english"] = "
A Sybase SQL server is running on this port.

This port should not be reachable from non-authorized hosts.

Solution : Filter incoming traffic to this host
Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Sybase SQL TCP/IP listener is running";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is Copyright (C) 2005 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 script_dependencie("find_service.nes", "find_service2.nasl");
 exit(0);
}

include("misc_func.inc");
include('global_settings.inc');
pkt = "0200020000000200000000000000000000000000000000000000000000000000000000000000004e65737375732d546573742d557365720000000000000000000000000000105858585858585858585858585858585858585858000000000000000000001430303030303061300000000000000000000000000000000000201881b82c080301060a090101000000000000000000737175656c646120312e30000000000000000000000000000000000000000b0000000000000000000000000000000000000000000000000000000000000000145858585858585858585858585858585858585858000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000040200004d5344424c49420000000706000000000d110000000000000000000000000000000000000000000000000201004700000200000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000030303000000003000000";

if (thorough_tests)
{
 port = get_kb_item("Services/unknown");
 if (! port) port = 5000;
}
else
 port = 5000;

if ( ! get_port_state(port) ) exit(0);
soc = open_sock_tcp(port);
if ( ! soc ) exit(0);
send(socket:soc, data:hex2raw(s:pkt));
r = recv(socket:soc, length:1024);
if ( "Login failed" >< r )
	{
	register_service(proto:"sybase", port:port);
	security_note(port);
	}
