# -*- Fundamental -*-
#
# 
# (C) 2006 Tenable Network Security
#
# This script is released under one of the Tenable Script Licenses and may not
# be used from within scripts released under another license without the
# authorization from Tenable Network Security Inc.
#
# See the following licenses for details :
#  http://www.nessus.org/plugins/RegisteredFeed.pdf
#  http://www.nessus.org/plugins/TenableCommercial.pdf
#  http://www.nessus.org/plugins/DirectFeed.pdf
#  http://www.nessus.org/plugins/DirectFeedCommercial.pdf
#
#
#
# @NOGPL@
#
# smb_header.inc 
# $Revision: 1.13 $
#


# Supported Protocol
supported_protocol = 6;

protocol[0] = "PC NETWORK PROGRAM 1.0";
protocol[1] = "LANMAN1.0";
protocol[2] = "Windows for Workgroups 3.1a";
protocol[3] = "LM1.2X002";
protocol[4] = "LANMAN2.1";
protocol[5] = "NT LM 0.12";

nes_native_os = "Windows 2002 Service Pack 2 2600";
nes_native_lanman = "Windows 2002 5.1";

#---------------------------------------------------------#
# SMB HEADER                                              #
#---------------------------------------------------------#

# SMB Header size : 32 bytes
SMB_HDR_SIZE = 32;

# FLAGS field bitmasks.
SMB_FLAGS_SERVER_TO_REDIR       = 0x80;
SMB_FLAGS_REQUEST_BATCH_OPLOCK  = 0x40;
SMB_FLAGS_REQUEST_OPLOCK        = 0x20;
SMB_FLAGS_CANONICAL_PATHNAMES   = 0x10;
SMB_FLAGS_CASELESS_PATHNAMES    = 0x08;
SMB_FLAGS_RESERVED              = 0x04;
SMB_FLAGS_CLIENT_BUF_AVAIL      = 0x02;
SMB_FLAGS_SUPPORT_LOCKREAD      = 0x01;
SMB_FLAGS_MASK                  = 0xFB;

# FLAGS2 field bitmasks.
SMB_FLAGS2_UNICODE_STRINGS      = 0x8000;
SMB_FLAGS2_32BIT_STATUS         = 0x4000;
SMB_FLAGS2_READ_IF_EXECUTE      = 0x2000;
SMB_FLAGS2_DFS_PATHNAME         = 0x1000;
SMB_FLAGS2_EXTENDED_SECURITY    = 0x0800;
SMB_FLAGS2_RESERVED_01          = 0x0400;
SMB_FLAGS2_RESERVED_02          = 0x0200;
SMB_FLAGS2_RESERVED_03          = 0x0100;
SMB_FLAGS2_RESERVED_04          = 0x0080;
SMB_FLAGS2_IS_LONG_NAME         = 0x0040;
SMB_FLAGS2_RESERVED_05          = 0x0020;
SMB_FLAGS2_RESERVED_06          = 0x0010;
SMB_FLAGS2_RESERVED_07          = 0x0008;
SMB_FLAGS2_SECURITY_SIGNATURE   = 0x0004;
SMB_FLAGS2_EAS                  = 0x0002;
SMB_FLAGS2_KNOWS_LONG_NAMES     = 0x0001;
SMB_FLAGS2_MASK                 = 0xF847;


# Capabilities bitmasks.
CAP_UNICODE           = 0x00000004;
CAP_STATUS32          = 0x00000040;
CAP_LEVEL_II_OPLOCKS  = 0x00000080;
CAP_NT_FIND           = 0x00000200;
CAP_NT_SMBS           = 0x00000010;
CAP_LARGE_FILES       = 0x00000008;
CAP_EXTENDED_SECURITY = 0x80000000;

# Security Mode
NEGOTIATE_SECURITY_SIGNATURES_REQUIRED = 0x08;
NEGOTIATE_SECURITY_SIGNATURES_ENABLED = 0x04;
NEGOTIATE_SECURITY_CHALLENGE_RESPONSE = 0x02;

# SMB commands
SMB_COM_CREATE_DIRECTORY        = 0x00;
SMB_COM_DELETE_DIRECTORY        = 0x01;
SMB_COM_OPEN                    = 0x02;
SMB_COM_CREATE                  = 0x03;
SMB_COM_CLOSE                   = 0x04;
SMB_COM_FLUSH                   = 0x05;
SMB_COM_DELETE                  = 0x06;
SMB_COM_RENAME                  = 0x07;
SMB_COM_QUERY_INFORMATION       = 0x08;
SMB_COM_SET_INFORMATION         = 0x09;
SMB_COM_READ                    = 0x0A;
SMB_COM_WRITE                   = 0x0B;
SMB_COM_LOCK_BYTE_RANGE         = 0x0C;
SMB_COM_UNLOCK_BYTE_RANGE       = 0x0D;
SMB_COM_CREATE_TEMPORARY        = 0x0E;
SMB_COM_CREATE_NEW              = 0x0F;
SMB_COM_CHECK_DIRECTORY         = 0x10;
SMB_COM_PROCESS_EXIT            = 0x11;
SMB_COM_SEEK                    = 0x12;
SMB_COM_LOCK_AND_READ           = 0x13;
SMB_COM_WRITE_AND_UNLOCK        = 0x14;
SMB_COM_READ_RAW                = 0x1A;
SMB_COM_READ_MPX                = 0x1B;
SMB_COM_READ_MPX_SECONDARY      = 0x1C;
SMB_COM_WRITE_RAW               = 0x1D;
SMB_COM_WRITE_MPX               = 0x1E;
SMB_COM_WRITE_COMPLETE          = 0x20;
SMB_COM_SET_INFORMATION2        = 0x22;
SMB_COM_QUERY_INFORMATION2      = 0x23;
SMB_COM_LOCKING_ANDX            = 0x24;
SMB_COM_TRANSACTION             = 0x25;
SMB_COM_TRANSACTION_SECONDARY   = 0x26;
SMB_COM_IOCTL                   = 0x27;
SMB_COM_IOCTL_SECONDARY         = 0x28;
SMB_COM_COPY                    = 0x29;
SMB_COM_MOVE                    = 0x2A;
SMB_COM_ECHO                    = 0x2B;
SMB_COM_WRITE_AND_CLOSE         = 0x2C;
SMB_COM_OPEN_ANDX               = 0x2D;
SMB_COM_READ_ANDX               = 0x2E;
SMB_COM_WRITE_ANDX              = 0x2F;
SMB_COM_CLOSE_AND_TREE_DISC     = 0x31;
SMB_COM_TRANSACTION2            = 0x32;
SMB_COM_TRANSACTION2_SECONDARY  = 0x33;
SMB_COM_FIND_CLOSE2             = 0x34;
SMB_COM_FIND_NOTIFY_CLOSE       = 0x35;
SMB_COM_TREE_CONNECT            = 0x70;
SMB_COM_TREE_DISCONNECT         = 0x71;
SMB_COM_NEGOTIATE               = 0x72;
SMB_COM_SESSION_SETUP_ANDX      = 0x73;
SMB_COM_LOGOFF_ANDX             = 0x74;
SMB_COM_TREE_CONNECT_ANDX       = 0x75;
SMB_COM_QUERY_INFORMATION_DISK  = 0x80;
SMB_COM_SEARCH                  = 0x81;
SMB_COM_FIND                    = 0x82;
SMB_COM_FIND_UNIQUE             = 0x83;
SMB_COM_NT_TRANSACT             = 0xA0;
SMB_COM_NT_TRANSACT_SECONDARY   = 0xA1;
SMB_COM_NT_CREATE_ANDX          = 0xA2;
SMB_COM_NT_CANCEL               = 0xA4;
SMB_COM_OPEN_PRINT_FILE         = 0xC0;
SMB_COM_WRITE_PRINT_FILE        = 0xC1;
SMB_COM_CLOSE_PRINT_FILE        = 0xC2;
SMB_COM_GET_PRINT_QUEUE         = 0xC3;
SMB_COM_READ_BULK               = 0xD8;
SMB_COM_WRITE_BULK              = 0xD9;
SMB_COM_WRITE_BULK_DATA         = 0xDA;


# ERROR code
NO_ERROR                                     = 0;
ERROR_SUCCESS                                = 0;
ERROR_INVALID_FUNCTION                       = 1;
ERROR_FILE_NOT_FOUND                         = 2;
ERROR_PATH_NOT_FOUND                         = 3;
ERROR_TOO_MANY_OPEN_FILES                    = 4;
ERROR_ACCESS_DENIED                          = 5;
ERROR_INVALID_HANDLE                         = 6;
ERROR_ARENA_TRASHED                          = 7;
ERROR_NOT_ENOUGH_MEMORY                      = 8;
ERROR_INVALID_BLOCK                          = 9;
ERROR_BAD_ENVIRONMENT                        = 10;
ERROR_BAD_FORMAT                             = 11;
ERROR_INVALID_ACCESS                         = 12;
ERROR_INVALID_DATA                           = 13;
ERROR_OUTOFMEMORY                            = 14;
ERROR_INVALID_DRIVE                          = 15;
ERROR_CURRENT_DIRECTORY                      = 16;
ERROR_NOT_SAME_DEVICE                        = 17;
ERROR_NO_MORE_FILES                          = 18;
ERROR_WRITE_PROTECT                          = 19;
ERROR_BAD_UNIT                               = 20;
ERROR_NOT_READY                              = 21;
ERROR_BAD_COMMAND                            = 22;
ERROR_CRC                                    = 23;
ERROR_BAD_LENGTH                             = 24;
ERROR_SEEK                                   = 25;
ERROR_NOT_DOS_DISK                           = 26;
ERROR_SECTOR_NOT_FOUND                       = 27;
ERROR_OUT_OF_PAPER                           = 28;
ERROR_WRITE_FAULT                            = 29;
ERROR_READ_FAULT                             = 30;
ERROR_GEN_FAILURE                            = 31;
ERROR_SHARING_VIOLATION                      = 32;
ERROR_LOCK_VIOLATION                         = 33;
ERROR_WRONG_DISK                             = 34;
ERROR_SHARING_BUFFER_EXCEEDED                = 36;
ERROR_HANDLE_EOF                             = 38;
ERROR_HANDLE_DISK_FULL                       = 39;
ERROR_NOT_SUPPORTED                          = 50;
ERROR_REM_NOT_LIST                           = 51;
ERROR_DUP_NAME                               = 52;
ERROR_BAD_NETPATH                            = 53;
ERROR_NETWORK_BUSY                           = 54;
ERROR_DEV_NOT_EXIST                          = 55;
ERROR_TOO_MANY_CMDS                          = 56;
ERROR_ADAP_HDW_ERR                           = 57;
ERROR_BAD_NET_RESP                           = 58;
ERROR_UNEXP_NET_ERR                          = 59;
ERROR_BAD_REM_ADAP                           = 60;
ERROR_PRINTQ_FULL                            = 61;
ERROR_NO_SPOOL_SPACE                         = 62;
ERROR_PRINT_CANCELLED                        = 63;
ERROR_NETNAME_DELETED                        = 64;
ERROR_NETWORK_ACCESS_DENIED                  = 65;
ERROR_BAD_DEV_TYPE                           = 66;
ERROR_BAD_NET_NAME                           = 67;
ERROR_TOO_MANY_NAMES                         = 68;
ERROR_TOO_MANY_SESS                          = 69;
ERROR_SHARING_PAUSED                         = 70;
ERROR_REQ_NOT_ACCEP                          = 71;
ERROR_REDIR_PAUSED                           = 72;
ERROR_FILE_EXISTS                            = 80;
ERROR_CANNOT_MAKE                            = 82;
ERROR_FAIL_I24                               = 83;
ERROR_OUT_OF_STRUCTURES                      = 84;
ERROR_ALREADY_ASSIGNED                       = 85;
ERROR_INVALID_PASSWORD                       = 86;
ERROR_INVALID_PARAMETER                      = 87;
ERROR_NET_WRITE_FAULT                        = 88;
ERROR_NO_PROC_SLOTS                          = 89;
ERROR_TOO_MANY_SEMAPHORES                    = 100;
ERROR_EXCL_SEM_ALREADY_OWNED                 = 101;
ERROR_SEM_IS_SET                             = 102;
ERROR_TOO_MANY_SEM_REQUESTS                  = 103;
ERROR_INVALID_AT_INTERRUPT_TIME              = 104;
ERROR_SEM_OWNER_DIED                         = 105;
ERROR_SEM_USER_LIMIT                         = 106;
ERROR_DISK_CHANGE                            = 107;
ERROR_DRIVE_LOCKED                           = 108;
ERROR_BROKEN_PIPE                            = 109;
ERROR_OPEN_FAILED                            = 110;
ERROR_BUFFER_OVERFLOW                        = 111;
ERROR_DISK_FULL                              = 112;
ERROR_NO_MORE_SEARCH_HANDLES                 = 113;
ERROR_INVALID_TARGET_HANDLE                  = 114;
ERROR_INVALID_CATEGORY                       = 117;
ERROR_INVALID_VERIFY_SWITCH                  = 118;
ERROR_BAD_DRIVER_LEVEL                       = 119;
ERROR_CALL_NOT_IMPLEMENTED                   = 120;
ERROR_SEM_TIMEOUT                            = 121;
ERROR_INSUFFICIENT_BUFFER                    = 122;
ERROR_INVALID_NAME                           = 123;
ERROR_INVALID_LEVEL                          = 124;
ERROR_NO_VOLUME_LABEL                        = 125;
ERROR_MOD_NOT_FOUND                          = 126;
ERROR_PROC_NOT_FOUND                         = 127;
ERROR_WAIT_NO_CHILDREN                       = 128;
ERROR_CHILD_NOT_COMPLETE                     = 129;
ERROR_DIRECT_ACCESS_HANDLE                   = 130;
ERROR_NEGATIVE_SEEK                          = 131;
ERROR_SEEK_ON_DEVICE                         = 132;
ERROR_IS_JOIN_TARGET                         = 133;
ERROR_IS_JOINED                              = 134;
ERROR_IS_SUBSTED                             = 135;
ERROR_NOT_JOINED                             = 136;
ERROR_NOT_SUBSTED                            = 137;
ERROR_JOIN_TO_JOIN                           = 138;
ERROR_SUBST_TO_SUBST                         = 139;
ERROR_JOIN_TO_SUBST                          = 140;
ERROR_SUBST_TO_JOIN                          = 141;
ERROR_BUSY_DRIVE                             = 142;
ERROR_SAME_DRIVE                             = 143;
ERROR_DIR_NOT_ROOT                           = 144;
ERROR_DIR_NOT_EMPTY                          = 145;
ERROR_IS_SUBST_PATH                          = 146;
ERROR_IS_JOIN_PATH                           = 147;
ERROR_PATH_BUSY                              = 148;
ERROR_IS_SUBST_TARGET                        = 149;
ERROR_SYSTEM_TRACE                           = 150;
ERROR_INVALID_EVENT_COUNT                    = 151;
ERROR_TOO_MANY_MUXWAITERS                    = 152;
ERROR_INVALID_LIST_FORMAT                    = 153;
ERROR_LABEL_TOO_LONG                         = 154;
ERROR_TOO_MANY_TCBS                          = 155;
ERROR_SIGNAL_REFUSED                         = 156;
ERROR_DISCARDED                              = 157;
ERROR_NOT_LOCKED                             = 158;
ERROR_BAD_THREADID_ADDR                      = 159;
ERROR_BAD_ARGUMENTS                          = 160;
ERROR_BAD_PATHNAME                           = 161;
ERROR_SIGNAL_PENDING                         = 162;
ERROR_MAX_THRDS_REACHED                      = 164;
ERROR_LOCK_FAILED                            = 167;
ERROR_BUSY                                   = 170;
ERROR_CANCEL_VIOLATION                       = 173;
ERROR_ATOMIC_LOCKS_NOT_SUPPORTED             = 174;
ERROR_INVALID_SEGMENT_NUMBER                 = 180;
ERROR_INVALID_ORDINAL                        = 182;
ERROR_ALREADY_EXISTS                         = 183;
ERROR_INVALID_FLAG_NUMBER                    = 186;
ERROR_SEM_NOT_FOUND                          = 187;
ERROR_INVALID_STARTING_CODESEG               = 188;
ERROR_INVALID_STACKSEG                       = 189;
ERROR_INVALID_MODULETYPE                     = 190;
ERROR_INVALID_EXE_SIGNATURE                  = 191;
ERROR_EXE_MARKED_INVALID                     = 192;
ERROR_BAD_EXE_FORMAT                         = 193;
ERROR_ITERATED_DATA_EXCEEDS_64k              = 194;
ERROR_INVALID_MINALLOCSIZE                   = 195;
ERROR_DYNLINK_FROM_INVALID_RING              = 196;
ERROR_IOPL_NOT_ENABLED                       = 197;
ERROR_INVALID_SEGDPL                         = 198;
ERROR_AUTODATASEG_EXCEEDS_64k                = 199;
ERROR_RING2SEG_MUST_BE_MOVABLE               = 200;
ERROR_RELOC_CHAIN_XEEDS_SEGLIM               = 201;
ERROR_INFLOOP_IN_RELOC_CHAIN                 = 202;
ERROR_ENVVAR_NOT_FOUND                       = 203;
ERROR_NO_SIGNAL_SENT                         = 205;
ERROR_FILENAME_EXCED_RANGE                   = 206;
ERROR_RING2_STACK_IN_USE                     = 207;
ERROR_META_EXPANSION_TOO_LONG                = 208;
ERROR_INVALID_SIGNAL_NUMBER                  = 209;
ERROR_THREAD_1_INACTIVE                      = 210;
ERROR_LOCKED                                 = 212;
ERROR_TOO_MANY_MODULES                       = 214;
ERROR_NESTING_NOT_ALLOWED                    = 215;
ERROR_BAD_PIPE                               = 230;
ERROR_PIPE_BUSY                              = 231;
ERROR_NO_DATA                                = 232;
ERROR_PIPE_NOT_CONNECTED                     = 233;
ERROR_MORE_DATA                              = 234;
ERROR_VC_DISCONNECTED                        = 240;
ERROR_INVALID_EA_NAME                        = 254;
ERROR_EA_LIST_INCONSISTENT                   = 255;
ERROR_NO_MORE_ITEMS                          = 259;
ERROR_CANNOT_COPY                            = 266;
ERROR_DIRECTORY                              = 267;
ERROR_EAS_DIDNT_FIT                          = 275;
ERROR_EA_FILE_CORRUPT                        = 276;
ERROR_EA_TABLE_FULL                          = 277;
ERROR_INVALID_EA_HANDLE                      = 278;
ERROR_EAS_NOT_SUPPORTED                      = 282;
ERROR_NOT_OWNER                              = 288;
ERROR_TOO_MANY_POSTS                         = 298;
ERROR_MR_MID_NOT_FOUND                       = 317;
ERROR_INVALID_ADDRESS                        = 487;
ERROR_ARITHMETIC_OVERFLOW                    = 534;
ERROR_PIPE_CONNECTED                         = 535;
ERROR_PIPE_LISTENING                         = 536;
ERROR_EA_ACCESS_DENIED                       = 994;
ERROR_OPERATION_ABORTED                      = 995;
ERROR_IO_INCOMPLETE                          = 996;
ERROR_IO_PENDING                             = 997;
ERROR_NOACCESS                               = 998;
ERROR_SWAPERROR                              = 999;
ERROR_STACK_OVERFLOW                         = 1001;
ERROR_INVALID_MESSAGE                        = 1002;
ERROR_CAN_NOT_COMPLETE                       = 1003;
ERROR_INVALID_FLAGS                          = 1004;
ERROR_UNRECOGNIZED_VOLUME                    = 1005;
ERROR_FILE_INVALID                           = 1006;
ERROR_FULLSCREEN_MODE                        = 1007;
ERROR_NO_TOKEN                               = 1008;
ERROR_BADDB                                  = 1009;
ERROR_BADKEY                                 = 1010;
ERROR_CANTOPEN                               = 1011;
ERROR_CANTREAD                               = 1012;
ERROR_CANTWRITE                              = 1013;
ERROR_REGISTRY_RECOVERED                     = 1014;
ERROR_REGISTRY_CORRUPT                       = 1015;
ERROR_REGISTRY_IO_FAILED                     = 1016;
ERROR_NOT_REGISTRY_FILE                      = 1017;
ERROR_KEY_DELETED                            = 1018;
ERROR_NO_LOG_SPACE                           = 1019;
ERROR_KEY_HAS_CHILDREN                       = 1020;
ERROR_CHILD_MUST_BE_VOLATILE                 = 1021;
ERROR_NOTIFY_ENUM_DIR                        = 1022;
ERROR_DEPENDENT_SERVICES_RUNNING             = 1051;
ERROR_INVALID_SERVICE_CONTROL                = 1052;
ERROR_SERVICE_REQUEST_TIMEOUT                = 1053;
ERROR_SERVICE_NO_THREAD                      = 1054;
ERROR_SERVICE_DATABASE_LOCKED                = 1055;
ERROR_SERVICE_ALREADY_RUNNING                = 1056;
ERROR_INVALID_SERVICE_ACCOUNT                = 1057;
ERROR_SERVICE_DISABLED                       = 1058;
ERROR_CIRCULAR_DEPENDENCY                    = 1059;
ERROR_SERVICE_DOES_NOT_EXIST                 = 1060;
ERROR_SERVICE_CANNOT_ACCEPT_CTRL             = 1061;
ERROR_SERVICE_NOT_ACTIVE                     = 1062;
ERROR_FAILED_SERVICE_CONTROLLER_CONNECT      = 1063;
ERROR_EXCEPTION_IN_SERVICE                   = 1064;
ERROR_DATABASE_DOES_NOT_EXIST                = 1065;
ERROR_SERVICE_SPECIFIC_ERROR                 = 1066;
ERROR_PROCESS_ABORTED                        = 1067;
ERROR_SERVICE_DEPENDENCY_FAIL                = 1068;
ERROR_SERVICE_LOGON_FAILED                   = 1069;
ERROR_SERVICE_START_HANG                     = 1070;
ERROR_INVALID_SERVICE_LOCK                   = 1071;
ERROR_SERVICE_MARKED_FOR_DELETE              = 1072;
ERROR_SERVICE_EXISTS                         = 1073;
ERROR_ALREADY_RUNNING_LKG                    = 1074;
ERROR_SERVICE_DEPENDENCY_DELETED             = 1075;
ERROR_BOOT_ALREADY_ACCEPTED                  = 1076;
ERROR_SERVICE_NEVER_STARTED                  = 1077;
ERROR_DUPLICATE_SERVICE_NAME                 = 1078;
ERROR_END_OF_MEDIA                           = 1100;
ERROR_FILEMARK_DETECTED                      = 1101;
ERROR_BEGINNING_OF_MEDIA                     = 1102;
ERROR_SETMARK_DETECTED                       = 1103;
ERROR_NO_DATA_DETECTED                       = 1104;
ERROR_PARTITION_FAILURE                      = 1105;
ERROR_INVALID_BLOCK_LENGTH                   = 1106;
ERROR_DEVICE_NOT_PARTITIONED                 = 1107;
ERROR_UNABLE_TO_LOCK_MEDIA                   = 1108;
ERROR_UNABLE_TO_UNLOAD_MEDIA                 = 1109;
ERROR_MEDIA_CHANGED                          = 1110;
ERROR_BUS_RESET                              = 1111;
ERROR_NO_MEDIA_IN_DRIVE                      = 1112;
ERROR_NO_UNICODE_TRANSLATION                 = 1113;
ERROR_DLL_INIT_FAILED                        = 1114;
ERROR_SHUTDOWN_IN_PROGRESS                   = 1115;
ERROR_NO_SHUTDOWN_IN_PROGRESS                = 1116;
ERROR_IO_DEVICE                              = 1117;
ERROR_SERIAL_NO_DEVICE                       = 1118;
ERROR_IRQ_BUSY                               = 1119;
ERROR_MORE_WRITES                            = 1120;
ERROR_COUNTER_TIMEOUT                        = 1121;
ERROR_FLOPPY_ID_MARK_NOT_FOUND               = 1122;
ERROR_FLOPPY_WRONG_CYLINDER                  = 1123;
ERROR_FLOPPY_UNKNOWN_ERROR                   = 1124;
ERROR_FLOPPY_BAD_REGISTERS                   = 1125;
ERROR_DISK_RECALIBRATE_FAILED                = 1126;
ERROR_DISK_OPERATION_FAILED                  = 1127;
ERROR_DISK_RESET_FAILED                      = 1128;
ERROR_EOM_OVERFLOW                           = 1129;
ERROR_NOT_ENOUGH_SERVER_MEMORY               = 1130;
ERROR_POSSIBLE_DEADLOCK                      = 1131;
ERROR_MAPPED_ALIGNMENT                       = 1132;

#Nessus Error code
ERROR_SOCKET                                 = 1133;


#Status code
STATUS_SUCCESS = 0x00000000; 
FACILITY_DEBUGGER = 0x1;
FACILITY_RPC_RUNTIME = 0x2;
FACILITY_RPC_STUBS = 0x3;
FACILITY_IO_ERROR_CODE = 0x4;
FACILITY_TERMINAL_SERVER = 0xA;
FACILITY_USB_ERROR_CODE = 0x10;
FACILITY_HID_ERROR_CODE = 0x11;
FACILITY_FIREWIRE_ERROR_CODE = 0x12;
FACILITY_CLUSTER_ERROR_CODE = 0x13;
FACILITY_ACPI_ERROR_CODE = 0x14;
FACILITY_SXS_ERROR_CODE = 0x15;
STATUS_SEVERITY_SUCCESS = 0x0;
STATUS_SEVERITY_INFORMATIONAL = 0x1;
STATUS_SEVERITY_WARNING = 0x2;
STATUS_SEVERITY_ERROR = 0x3;
STATUS_WAIT_0 = 0x00000000;
STATUS_WAIT_1 = 0x00000001;
STATUS_WAIT_2 = 0x00000002;
STATUS_WAIT_3 = 0x00000003;
STATUS_WAIT_63 = 0x0000003F;
STATUS_ABANDONED = 0x00000080;
STATUS_ABANDONED_WAIT_0 = 0x00000080;  
STATUS_ABANDONED_WAIT_63 = 0x000000BF;
STATUS_USER_APC = 0x000000C0;  
STATUS_KERNEL_APC = 0x00000100;
STATUS_ALERTED = 0x00000101;
STATUS_TIMEOUT = 0x00000102;  
STATUS_PENDING = 0x00000103;  
STATUS_REPARSE = 0x00000104;
STATUS_MORE_ENTRIES = 0x00000105;
STATUS_NOT_ALL_ASSIGNED = 0x00000106;
STATUS_SOME_NOT_MAPPED = 0x00000107;
STATUS_OPLOCK_BREAK_IN_PROGRESS = 0x00000108;
STATUS_VOLUME_MOUNTED = 0x00000109;
STATUS_RXACT_COMMITTED = 0x0000010A;
STATUS_NOTIFY_CLEANUP = 0x0000010B;
STATUS_NOTIFY_ENUM_DIR = 0x0000010C;
STATUS_NO_QUOTAS_FOR_ACCOUNT = 0x0000010D;
STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED = 0x0000010E;
STATUS_PAGE_FAULT_TRANSITION = 0x00000110;
STATUS_PAGE_FAULT_DEMAND_ZERO = 0x00000111;
STATUS_PAGE_FAULT_COPY_ON_WRITE = 0x00000112;
STATUS_PAGE_FAULT_GUARD_PAGE = 0x00000113;
STATUS_PAGE_FAULT_PAGING_FILE = 0x00000114;
STATUS_CACHE_PAGE_LOCKED = 0x00000115;
STATUS_CRASH_DUMP = 0x00000116;
STATUS_BUFFER_ALL_ZEROS = 0x00000117;
STATUS_REPARSE_OBJECT = 0x00000118;
STATUS_RESOURCE_REQUIREMENTS_CHANGED = 0x00000119;
STATUS_TRANSLATION_COMPLETE = 0x00000120;
STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY = 0x00000121;
STATUS_NOTHING_TO_TERMINATE = 0x00000122;
STATUS_PROCESS_NOT_IN_JOB = 0x00000123;
STATUS_PROCESS_IN_JOB = 0x00000124;
STATUS_OBJECT_NAME_EXISTS = 0x40000000;
STATUS_THREAD_WAS_SUSPENDED = 0x40000001;
STATUS_WORKING_SET_LIMIT_RANGE = 0x40000002;
STATUS_IMAGE_NOT_AT_BASE = 0x40000003;
STATUS_RXACT_STATE_CREATED = 0x40000004;
STATUS_SEGMENT_NOTIFICATION = 0x40000005;  
STATUS_LOCAL_USER_SESSION_KEY = 0x40000006;
STATUS_BAD_CURRENT_DIRECTORY = 0x40000007;
STATUS_SERIAL_MORE_WRITES = 0x40000008;
STATUS_REGISTRY_RECOVERED = 0x40000009;
STATUS_FT_READ_RECOVERY_FROM_BACKUP = 0x4000000A;
STATUS_FT_WRITE_RECOVERY = 0x4000000B;
STATUS_SERIAL_COUNTER_TIMEOUT = 0x4000000C;
STATUS_NULL_LM_PASSWORD = 0x4000000D;
STATUS_IMAGE_MACHINE_TYPE_MISMATCH = 0x4000000E;
STATUS_RECEIVE_PARTIAL = 0x4000000F;
STATUS_RECEIVE_EXPEDITED = 0x40000010;
STATUS_RECEIVE_PARTIAL_EXPEDITED = 0x40000011;
STATUS_EVENT_DONE = 0x40000012;
STATUS_EVENT_PENDING = 0x40000013;
STATUS_CHECKING_FILE_SYSTEM = 0x40000014;
STATUS_FATAL_APP_EXIT = 0x40000015;
STATUS_PREDEFINED_HANDLE = 0x40000016;
STATUS_WAS_UNLOCKED = 0x40000017;
STATUS_SERVICE_NOTIFICATION = 0x40000018;
STATUS_WAS_LOCKED = 0x40000019;
STATUS_LOG_HARD_ERROR = 0x4000001A;
STATUS_ALREADY_WIN32 = 0x4000001B;
STATUS_WX86_UNSIMULATE = 0x4000001C;
STATUS_WX86_CONTINUE = 0x4000001D;
STATUS_WX86_SINGLE_STEP = 0x4000001E;
STATUS_WX86_BREAKPOINT = 0x4000001F;
STATUS_WX86_EXCEPTION_CONTINUE = 0x40000020;
STATUS_WX86_EXCEPTION_LASTCHANCE = 0x40000021;
STATUS_WX86_EXCEPTION_CHAIN = 0x40000022;
STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE = 0x40000023;
STATUS_NO_YIELD_PERFORMED = 0x40000024;
STATUS_TIMER_RESUME_IGNORED = 0x40000025;
STATUS_ARBITRATION_UNHANDLED = 0x40000026;
STATUS_CARDBUS_NOT_SUPPORTED = 0x40000027;
STATUS_WX86_CREATEWX86TIB = 0x40000028;
STATUS_MP_PROCESSOR_MISMATCH = 0x40000029;
STATUS_HIBERNATED = 0x4000002A;  
STATUS_RESUME_HIBERNATION = 0x4000002B;  
STATUS_GUARD_PAGE_VIOLATION = 0x80000001;  
STATUS_DATATYPE_MISALIGNMENT = 0x80000002;  
STATUS_BREAKPOINT = 0x80000003;  
STATUS_SINGLE_STEP = 0x80000004;  
STATUS_BUFFER_OVERFLOW = 0x80000005;
STATUS_NO_MORE_FILES = 0x80000006;
STATUS_WAKE_SYSTEM_DEBUGGER = 0x80000007;
STATUS_HANDLES_CLOSED = 0x8000000A;
STATUS_NO_INHERITANCE = 0x8000000B;
STATUS_GUID_SUBSTITUTION_MADE = 0x8000000C;
STATUS_PARTIAL_COPY = 0x8000000D;
STATUS_DEVICE_PAPER_EMPTY = 0x8000000E;
STATUS_DEVICE_POWERED_OFF = 0x8000000F;
STATUS_DEVICE_OFF_LINE = 0x80000010;
STATUS_DEVICE_BUSY = 0x80000011;
STATUS_NO_MORE_EAS = 0x80000012;
STATUS_INVALID_EA_NAME = 0x80000013;
STATUS_EA_LIST_INCONSISTENT = 0x80000014;
STATUS_INVALID_EA_FLAG = 0x80000015;
STATUS_VERIFY_REQUIRED = 0x80000016;
STATUS_EXTRANEOUS_INFORMATION = 0x80000017;
STATUS_RXACT_COMMIT_NECESSARY = 0x80000018;
STATUS_NO_MORE_ENTRIES = 0x8000001A;
STATUS_FILEMARK_DETECTED = 0x8000001B;
STATUS_MEDIA_CHANGED = 0x8000001C;
STATUS_BUS_RESET = 0x8000001D;
STATUS_END_OF_MEDIA = 0x8000001E;
STATUS_BEGINNING_OF_MEDIA = 0x8000001F;
STATUS_MEDIA_CHECK = 0x80000020;
STATUS_SETMARK_DETECTED = 0x80000021;
STATUS_NO_DATA_DETECTED = 0x80000022;
STATUS_REDIRECTOR_HAS_OPEN_HANDLES = 0x80000023;
STATUS_SERVER_HAS_OPEN_HANDLES = 0x80000024;
STATUS_ALREADY_DISCONNECTED = 0x80000025;
STATUS_LONGJUMP = 0x80000026;
STATUS_CLEANER_CARTRIDGE_INSTALLED = 0x80000027;
STATUS_PLUGPLAY_QUERY_VETOED = 0x80000028;
STATUS_UNWIND_CONSOLIDATE = 0x80000029;
STATUS_CLUSTER_NODE_ALREADY_UP = 0x80130001;
STATUS_CLUSTER_NODE_ALREADY_DOWN = 0x80130002;
STATUS_CLUSTER_NETWORK_ALREADY_ONLINE = 0x80130003;
STATUS_CLUSTER_NETWORK_ALREADY_OFFLINE = 0x80130004;
STATUS_CLUSTER_NODE_ALREADY_MEMBER = 0x80130005;
STATUS_UNSUCCESSFUL = 0xC0000001;
STATUS_NOT_IMPLEMENTED = 0xC0000002;
STATUS_INVALID_INFO_CLASS = 0xC0000003;  
STATUS_INFO_LENGTH_MISMATCH = 0xC0000004;
STATUS_ACCESS_VIOLATION = 0xC0000005;  
STATUS_IN_PAGE_ERROR = 0xC0000006;  
STATUS_PAGEFILE_QUOTA = 0xC0000007;
STATUS_INVALID_HANDLE = 0xC0000008;  
STATUS_BAD_INITIAL_STACK = 0xC0000009;
STATUS_BAD_INITIAL_PC = 0xC000000A;
STATUS_INVALID_CID = 0xC000000B;
STATUS_TIMER_NOT_CANCELED = 0xC000000C;
STATUS_INVALID_PARAMETER = 0xC000000D;
STATUS_NO_SUCH_DEVICE = 0xC000000E;
STATUS_NO_SUCH_FILE = 0xC000000F;
STATUS_INVALID_DEVICE_REQUEST = 0xC0000010;
STATUS_END_OF_FILE = 0xC0000011;
STATUS_WRONG_VOLUME = 0xC0000012;
STATUS_NO_MEDIA_IN_DEVICE = 0xC0000013;
STATUS_UNRECOGNIZED_MEDIA = 0xC0000014;
STATUS_NONEXISTENT_SECTOR = 0xC0000015;
STATUS_MORE_PROCESSING_REQUIRED = 0xC0000016;
STATUS_NO_MEMORY = 0xC0000017;  
STATUS_CONFLICTING_ADDRESSES = 0xC0000018;
STATUS_NOT_MAPPED_VIEW = 0xC0000019;
STATUS_UNABLE_TO_FREE_VM = 0xC000001A;
STATUS_UNABLE_TO_DELETE_SECTION = 0xC000001B;
STATUS_INVALID_SYSTEM_SERVICE = 0xC000001C;
STATUS_ILLEGAL_INSTRUCTION = 0xC000001D;  
STATUS_INVALID_LOCK_SEQUENCE = 0xC000001E;
STATUS_INVALID_VIEW_SIZE = 0xC000001F;
STATUS_INVALID_FILE_FOR_SECTION = 0xC0000020;
STATUS_ALREADY_COMMITTED = 0xC0000021;
STATUS_ACCESS_DENIED = 0xC0000022;
STATUS_BUFFER_TOO_SMALL = 0xC0000023;
STATUS_OBJECT_TYPE_MISMATCH = 0xC0000024;
STATUS_NONCONTINUABLE_EXCEPTION = 0xC0000025;  
STATUS_INVALID_DISPOSITION = 0xC0000026;  
STATUS_UNWIND = 0xC0000027;
STATUS_BAD_STACK = 0xC0000028;
STATUS_INVALID_UNWIND_TARGET = 0xC0000029;
STATUS_NOT_LOCKED = 0xC000002A;
STATUS_PARITY_ERROR = 0xC000002B;
STATUS_UNABLE_TO_DECOMMIT_VM = 0xC000002C;
STATUS_NOT_COMMITTED = 0xC000002D;
STATUS_INVALID_PORT_ATTRIBUTES = 0xC000002E;
STATUS_PORT_MESSAGE_TOO_LONG = 0xC000002F;
STATUS_INVALID_PARAMETER_MIX = 0xC0000030;
STATUS_INVALID_QUOTA_LOWER = 0xC0000031;
STATUS_DISK_CORRUPT_ERROR = 0xC0000032;
STATUS_OBJECT_NAME_INVALID = 0xC0000033;
STATUS_OBJECT_NAME_NOT_FOUND = 0xC0000034;
STATUS_OBJECT_NAME_COLLISION = 0xC0000035;
STATUS_PORT_DISCONNECTED = 0xC0000037;
STATUS_DEVICE_ALREADY_ATTACHED = 0xC0000038;
STATUS_OBJECT_PATH_INVALID = 0xC0000039;
STATUS_OBJECT_PATH_NOT_FOUND = 0xC000003A;
STATUS_OBJECT_PATH_SYNTAX_BAD = 0xC000003B;
STATUS_DATA_OVERRUN = 0xC000003C;
STATUS_DATA_LATE_ERROR = 0xC000003D;
STATUS_DATA_ERROR = 0xC000003E;
STATUS_CRC_ERROR = 0xC000003F;
STATUS_SECTION_TOO_BIG = 0xC0000040;
STATUS_PORT_CONNECTION_REFUSED = 0xC0000041;
STATUS_INVALID_PORT_HANDLE = 0xC0000042;
STATUS_SHARING_VIOLATION = 0xC0000043;
STATUS_QUOTA_EXCEEDED = 0xC0000044;
STATUS_INVALID_PAGE_PROTECTION = 0xC0000045;
STATUS_MUTANT_NOT_OWNED = 0xC0000046;
STATUS_SEMAPHORE_LIMIT_EXCEEDED = 0xC0000047;
STATUS_PORT_ALREADY_SET = 0xC0000048;
STATUS_SECTION_NOT_IMAGE = 0xC0000049;
STATUS_SUSPEND_COUNT_EXCEEDED = 0xC000004A;
STATUS_THREAD_IS_TERMINATING = 0xC000004B;
STATUS_BAD_WORKING_SET_LIMIT = 0xC000004C;
STATUS_INCOMPATIBLE_FILE_MAP = 0xC000004D;
STATUS_SECTION_PROTECTION = 0xC000004E;
STATUS_EAS_NOT_SUPPORTED = 0xC000004F;
STATUS_EA_TOO_LARGE = 0xC0000050;
STATUS_NONEXISTENT_EA_ENTRY = 0xC0000051;
STATUS_NO_EAS_ON_FILE = 0xC0000052;
STATUS_EA_CORRUPT_ERROR = 0xC0000053;
STATUS_FILE_LOCK_CONFLICT = 0xC0000054;
STATUS_LOCK_NOT_GRANTED = 0xC0000055;
STATUS_DELETE_PENDING = 0xC0000056;
STATUS_CTL_FILE_NOT_SUPPORTED = 0xC0000057;
STATUS_UNKNOWN_REVISION = 0xC0000058;
STATUS_REVISION_MISMATCH = 0xC0000059;
STATUS_INVALID_OWNER = 0xC000005A;
STATUS_INVALID_PRIMARY_GROUP = 0xC000005B;
STATUS_NO_IMPERSONATION_TOKEN = 0xC000005C;
STATUS_CANT_DISABLE_MANDATORY = 0xC000005D;
STATUS_NO_LOGON_SERVERS = 0xC000005E;
STATUS_NO_SUCH_LOGON_SESSION = 0xC000005F;
STATUS_NO_SUCH_PRIVILEGE = 0xC0000060;
STATUS_PRIVILEGE_NOT_HELD = 0xC0000061;
STATUS_INVALID_ACCOUNT_NAME = 0xC0000062;
STATUS_USER_EXISTS = 0xC0000063;
STATUS_NO_SUCH_USER = 0xC0000064;  
STATUS_GROUP_EXISTS = 0xC0000065;
STATUS_NO_SUCH_GROUP = 0xC0000066;
STATUS_MEMBER_IN_GROUP = 0xC0000067;
STATUS_MEMBER_NOT_IN_GROUP = 0xC0000068;
STATUS_LAST_ADMIN = 0xC0000069;
STATUS_WRONG_PASSWORD = 0xC000006A;  
STATUS_ILL_FORMED_PASSWORD = 0xC000006B;
STATUS_PASSWORD_RESTRICTION = 0xC000006C;  
STATUS_LOGON_FAILURE = 0xC000006D;  
STATUS_ACCOUNT_RESTRICTION = 0xC000006E;  
STATUS_INVALID_LOGON_HOURS = 0xC000006F;  
STATUS_INVALID_WORKSTATION = 0xC0000070;  
STATUS_PASSWORD_EXPIRED = 0xC0000071;  
STATUS_ACCOUNT_DISABLED = 0xC0000072;  
STATUS_NONE_MAPPED = 0xC0000073;
STATUS_TOO_MANY_LUIDS_REQUESTED = 0xC0000074;
STATUS_LUIDS_EXHAUSTED = 0xC0000075;
STATUS_INVALID_SUB_AUTHORITY = 0xC0000076;
STATUS_INVALID_ACL = 0xC0000077;
STATUS_INVALID_SID = 0xC0000078;
STATUS_INVALID_SECURITY_DESCR = 0xC0000079;
STATUS_PROCEDURE_NOT_FOUND = 0xC000007A;
STATUS_INVALID_IMAGE_FORMAT = 0xC000007B;
STATUS_NO_TOKEN = 0xC000007C;
STATUS_BAD_INHERITANCE_ACL = 0xC000007D;
STATUS_RANGE_NOT_LOCKED = 0xC000007E;
STATUS_DISK_FULL = 0xC000007F;
STATUS_SERVER_DISABLED = 0xC0000080;
STATUS_SERVER_NOT_DISABLED = 0xC0000081;
STATUS_TOO_MANY_GUIDS_REQUESTED = 0xC0000082;
STATUS_GUIDS_EXHAUSTED = 0xC0000083;
STATUS_INVALID_ID_AUTHORITY = 0xC0000084;
STATUS_AGENTS_EXHAUSTED = 0xC0000085;
STATUS_INVALID_VOLUME_LABEL = 0xC0000086;
STATUS_SECTION_NOT_EXTENDED = 0xC0000087;
STATUS_NOT_MAPPED_DATA = 0xC0000088;
STATUS_RESOURCE_DATA_NOT_FOUND = 0xC0000089;
STATUS_RESOURCE_TYPE_NOT_FOUND = 0xC000008A;
STATUS_RESOURCE_NAME_NOT_FOUND = 0xC000008B;
STATUS_ARRAY_BOUNDS_EXCEEDED = 0xC000008C;  
STATUS_FLOAT_DENORMAL_OPERAND = 0xC000008D;  
STATUS_FLOAT_DIVIDE_BY_ZERO = 0xC000008E;  
STATUS_FLOAT_INEXACT_RESULT = 0xC000008F;  
STATUS_FLOAT_INVALID_OPERATION = 0xC0000090;  
STATUS_FLOAT_OVERFLOW = 0xC0000091;  
STATUS_FLOAT_STACK_CHECK = 0xC0000092;  
STATUS_FLOAT_UNDERFLOW = 0xC0000093;  
STATUS_INTEGER_DIVIDE_BY_ZERO = 0xC0000094;  
STATUS_INTEGER_OVERFLOW = 0xC0000095;  
STATUS_PRIVILEGED_INSTRUCTION = 0xC0000096;  
STATUS_TOO_MANY_PAGING_FILES = 0xC0000097;
STATUS_FILE_INVALID = 0xC0000098;
STATUS_ALLOTTED_SPACE_EXCEEDED = 0xC0000099;
STATUS_INSUFFICIENT_RESOURCES = 0xC000009A;  
STATUS_DFS_EXIT_PATH_FOUND = 0xC000009B;
STATUS_DEVICE_DATA_ERROR = 0xC000009C;
STATUS_DEVICE_NOT_CONNECTED = 0xC000009D;
STATUS_DEVICE_POWER_FAILURE = 0xC000009E;
STATUS_FREE_VM_NOT_AT_BASE = 0xC000009F;
STATUS_MEMORY_NOT_ALLOCATED = 0xC00000A0;
STATUS_WORKING_SET_QUOTA = 0xC00000A1;
STATUS_MEDIA_WRITE_PROTECTED = 0xC00000A2;
STATUS_DEVICE_NOT_READY = 0xC00000A3;
STATUS_INVALID_GROUP_ATTRIBUTES = 0xC00000A4;
STATUS_BAD_IMPERSONATION_LEVEL = 0xC00000A5;
STATUS_CANT_OPEN_ANONYMOUS = 0xC00000A6;
STATUS_BAD_VALIDATION_CLASS = 0xC00000A7;
STATUS_BAD_TOKEN_TYPE = 0xC00000A8;
STATUS_BAD_MASTER_BOOT_RECORD = 0xC00000A9;
STATUS_INSTRUCTION_MISALIGNMENT = 0xC00000AA;
STATUS_INSTANCE_NOT_AVAILABLE = 0xC00000AB;
STATUS_PIPE_NOT_AVAILABLE = 0xC00000AC;
STATUS_INVALID_PIPE_STATE = 0xC00000AD;
STATUS_PIPE_BUSY = 0xC00000AE;
STATUS_ILLEGAL_FUNCTION = 0xC00000AF;
STATUS_PIPE_DISCONNECTED = 0xC00000B0;
STATUS_PIPE_CLOSING = 0xC00000B1;
STATUS_PIPE_CONNECTED = 0xC00000B2;
STATUS_PIPE_LISTENING = 0xC00000B3;
STATUS_INVALID_READ_MODE = 0xC00000B4;
STATUS_IO_TIMEOUT = 0xC00000B5;
STATUS_FILE_FORCED_CLOSED = 0xC00000B6;
STATUS_PROFILING_NOT_STARTED = 0xC00000B7;
STATUS_PROFILING_NOT_STOPPED = 0xC00000B8;
STATUS_COULD_NOT_INTERPRET = 0xC00000B9;
STATUS_FILE_IS_A_DIRECTORY = 0xC00000BA;
STATUS_NOT_SUPPORTED = 0xC00000BB;
STATUS_REMOTE_NOT_LISTENING = 0xC00000BC;
STATUS_DUPLICATE_NAME = 0xC00000BD;
STATUS_BAD_NETWORK_PATH = 0xC00000BE;
STATUS_NETWORK_BUSY = 0xC00000BF;
STATUS_DEVICE_DOES_NOT_EXIST = 0xC00000C0;
STATUS_TOO_MANY_COMMANDS = 0xC00000C1;
STATUS_ADAPTER_HARDWARE_ERROR = 0xC00000C2;
STATUS_INVALID_NETWORK_RESPONSE = 0xC00000C3;
STATUS_UNEXPECTED_NETWORK_ERROR = 0xC00000C4;
STATUS_BAD_REMOTE_ADAPTER = 0xC00000C5;
STATUS_PRINT_QUEUE_FULL = 0xC00000C6;
STATUS_NO_SPOOL_SPACE = 0xC00000C7;
STATUS_PRINT_CANCELLED = 0xC00000C8;
STATUS_NETWORK_NAME_DELETED = 0xC00000C9;
STATUS_NETWORK_ACCESS_DENIED = 0xC00000CA;
STATUS_BAD_DEVICE_TYPE = 0xC00000CB;
STATUS_BAD_NETWORK_NAME = 0xC00000CC;
STATUS_TOO_MANY_NAMES = 0xC00000CD;
STATUS_TOO_MANY_SESSIONS = 0xC00000CE;
STATUS_SHARING_PAUSED = 0xC00000CF;
STATUS_REQUEST_NOT_ACCEPTED = 0xC00000D0;
STATUS_REDIRECTOR_PAUSED = 0xC00000D1;
STATUS_NET_WRITE_FAULT = 0xC00000D2;
STATUS_PROFILING_AT_LIMIT = 0xC00000D3;
STATUS_NOT_SAME_DEVICE = 0xC00000D4;
STATUS_FILE_RENAMED = 0xC00000D5;
STATUS_VIRTUAL_CIRCUIT_CLOSED = 0xC00000D6;
STATUS_NO_SECURITY_ON_OBJECT = 0xC00000D7;
STATUS_CANT_WAIT = 0xC00000D8;
STATUS_PIPE_EMPTY = 0xC00000D9;
STATUS_CANT_ACCESS_DOMAIN_INFO = 0xC00000DA;
STATUS_CANT_TERMINATE_SELF = 0xC00000DB;
STATUS_INVALID_SERVER_STATE = 0xC00000DC;
STATUS_INVALID_DOMAIN_STATE = 0xC00000DD;
STATUS_INVALID_DOMAIN_ROLE = 0xC00000DE;
STATUS_NO_SUCH_DOMAIN = 0xC00000DF;
STATUS_DOMAIN_EXISTS = 0xC00000E0;
STATUS_DOMAIN_LIMIT_EXCEEDED = 0xC00000E1;
STATUS_OPLOCK_NOT_GRANTED = 0xC00000E2;
STATUS_INVALID_OPLOCK_PROTOCOL = 0xC00000E3;
STATUS_INTERNAL_DB_CORRUPTION = 0xC00000E4;
STATUS_INTERNAL_ERROR = 0xC00000E5;
STATUS_GENERIC_NOT_MAPPED = 0xC00000E6;
STATUS_BAD_DESCRIPTOR_FORMAT = 0xC00000E7;
STATUS_INVALID_USER_BUFFER = 0xC00000E8;
STATUS_UNEXPECTED_IO_ERROR = 0xC00000E9;
STATUS_UNEXPECTED_MM_CREATE_ERR = 0xC00000EA;
STATUS_UNEXPECTED_MM_MAP_ERROR = 0xC00000EB;
STATUS_UNEXPECTED_MM_EXTEND_ERR = 0xC00000EC;
STATUS_NOT_LOGON_PROCESS = 0xC00000ED;
STATUS_LOGON_SESSION_EXISTS = 0xC00000EE;
STATUS_INVALID_PARAMETER_1 = 0xC00000EF;
STATUS_INVALID_PARAMETER_2 = 0xC00000F0;
STATUS_INVALID_PARAMETER_3 = 0xC00000F1;
STATUS_INVALID_PARAMETER_4 = 0xC00000F2;
STATUS_INVALID_PARAMETER_5 = 0xC00000F3;
STATUS_INVALID_PARAMETER_6 = 0xC00000F4;
STATUS_INVALID_PARAMETER_7 = 0xC00000F5;
STATUS_INVALID_PARAMETER_8 = 0xC00000F6;
STATUS_INVALID_PARAMETER_9 = 0xC00000F7;
STATUS_INVALID_PARAMETER_10 = 0xC00000F8;
STATUS_INVALID_PARAMETER_11 = 0xC00000F9;
STATUS_INVALID_PARAMETER_12 = 0xC00000FA;
STATUS_REDIRECTOR_NOT_STARTED = 0xC00000FB;
STATUS_REDIRECTOR_STARTED = 0xC00000FC;
STATUS_STACK_OVERFLOW = 0xC00000FD;  
STATUS_NO_SUCH_PACKAGE = 0xC00000FE;
STATUS_BAD_FUNCTION_TABLE = 0xC00000FF;
STATUS_VARIABLE_NOT_FOUND = 0xC0000100;
STATUS_DIRECTORY_NOT_EMPTY = 0xC0000101;
STATUS_FILE_CORRUPT_ERROR = 0xC0000102;
STATUS_NOT_A_DIRECTORY = 0xC0000103;
STATUS_BAD_LOGON_SESSION_STATE = 0xC0000104;
STATUS_LOGON_SESSION_COLLISION = 0xC0000105;
STATUS_NAME_TOO_LONG = 0xC0000106;
STATUS_FILES_OPEN = 0xC0000107;
STATUS_CONNECTION_IN_USE = 0xC0000108;
STATUS_MESSAGE_NOT_FOUND = 0xC0000109;
STATUS_PROCESS_IS_TERMINATING = 0xC000010A;
STATUS_INVALID_LOGON_TYPE = 0xC000010B;
STATUS_NO_GUID_TRANSLATION = 0xC000010C;
STATUS_CANNOT_IMPERSONATE = 0xC000010D;
STATUS_IMAGE_ALREADY_LOADED = 0xC000010E;
STATUS_ABIOS_NOT_PRESENT = 0xC000010F;
STATUS_ABIOS_LID_NOT_EXIST = 0xC0000110;
STATUS_ABIOS_LID_ALREADY_OWNED = 0xC0000111;
STATUS_ABIOS_NOT_LID_OWNER = 0xC0000112;
STATUS_ABIOS_INVALID_COMMAND = 0xC0000113;
STATUS_ABIOS_INVALID_LID = 0xC0000114;
STATUS_ABIOS_SELECTOR_NOT_AVAILABLE = 0xC0000115;
STATUS_ABIOS_INVALID_SELECTOR = 0xC0000116;
STATUS_NO_LDT = 0xC0000117;
STATUS_INVALID_LDT_SIZE = 0xC0000118;
STATUS_INVALID_LDT_OFFSET = 0xC0000119;
STATUS_INVALID_LDT_DESCRIPTOR = 0xC000011A;
STATUS_INVALID_IMAGE_NE_FORMAT = 0xC000011B;
STATUS_RXACT_INVALID_STATE = 0xC000011C;
STATUS_RXACT_COMMIT_FAILURE = 0xC000011D;
STATUS_MAPPED_FILE_SIZE_ZERO = 0xC000011E;
STATUS_TOO_MANY_OPENED_FILES = 0xC000011F;
STATUS_CANCELLED = 0xC0000120;
STATUS_CANNOT_DELETE = 0xC0000121;
STATUS_INVALID_COMPUTER_NAME = 0xC0000122;
STATUS_FILE_DELETED = 0xC0000123;
STATUS_SPECIAL_ACCOUNT = 0xC0000124;
STATUS_SPECIAL_GROUP = 0xC0000125;
STATUS_SPECIAL_USER = 0xC0000126;
STATUS_MEMBERS_PRIMARY_GROUP = 0xC0000127;
STATUS_FILE_CLOSED = 0xC0000128;
STATUS_TOO_MANY_THREADS = 0xC0000129;
STATUS_THREAD_NOT_IN_PROCESS = 0xC000012A;
STATUS_TOKEN_ALREADY_IN_USE = 0xC000012B;
STATUS_PAGEFILE_QUOTA_EXCEEDED = 0xC000012C;
STATUS_COMMITMENT_LIMIT = 0xC000012D;
STATUS_INVALID_IMAGE_LE_FORMAT = 0xC000012E;
STATUS_INVALID_IMAGE_NOT_MZ = 0xC000012F;
STATUS_INVALID_IMAGE_PROTECT = 0xC0000130;
STATUS_INVALID_IMAGE_WIN_16 = 0xC0000131;
STATUS_LOGON_SERVER_CONFLICT = 0xC0000132;
STATUS_TIME_DIFFERENCE_AT_DC = 0xC0000133;
STATUS_SYNCHRONIZATION_REQUIRED = 0xC0000134;
STATUS_DLL_NOT_FOUND = 0xC0000135;
STATUS_OPEN_FAILED = 0xC0000136;
STATUS_IO_PRIVILEGE_FAILED = 0xC0000137;
STATUS_ORDINAL_NOT_FOUND = 0xC0000138;
STATUS_ENTRYPOINT_NOT_FOUND = 0xC0000139;
STATUS_CONTROL_C_EXIT = 0xC000013A;  
STATUS_LOCAL_DISCONNECT = 0xC000013B;
STATUS_REMOTE_DISCONNECT = 0xC000013C;
STATUS_REMOTE_RESOURCES = 0xC000013D;
STATUS_LINK_FAILED = 0xC000013E;
STATUS_LINK_TIMEOUT = 0xC000013F;
STATUS_INVALID_CONNECTION = 0xC0000140;
STATUS_INVALID_ADDRESS = 0xC0000141;
STATUS_DLL_INIT_FAILED = 0xC0000142;
STATUS_MISSING_SYSTEMFILE = 0xC0000143;
STATUS_UNHANDLED_EXCEPTION = 0xC0000144;
STATUS_APP_INIT_FAILURE = 0xC0000145;
STATUS_PAGEFILE_CREATE_FAILED = 0xC0000146;
STATUS_NO_PAGEFILE = 0xC0000147;
STATUS_INVALID_LEVEL = 0xC0000148;
STATUS_WRONG_PASSWORD_CORE = 0xC0000149;
STATUS_ILLEGAL_FLOAT_CONTEXT = 0xC000014A;
STATUS_PIPE_BROKEN = 0xC000014B;
STATUS_REGISTRY_CORRUPT = 0xC000014C;
STATUS_REGISTRY_IO_FAILED = 0xC000014D;
STATUS_NO_EVENT_PAIR = 0xC000014E;
STATUS_UNRECOGNIZED_VOLUME = 0xC000014F;
STATUS_SERIAL_NO_DEVICE_INITED = 0xC0000150;
STATUS_NO_SUCH_ALIAS = 0xC0000151;
STATUS_MEMBER_NOT_IN_ALIAS = 0xC0000152;
STATUS_MEMBER_IN_ALIAS = 0xC0000153;
STATUS_ALIAS_EXISTS = 0xC0000154;
STATUS_LOGON_NOT_GRANTED = 0xC0000155;
STATUS_TOO_MANY_SECRETS = 0xC0000156;
STATUS_SECRET_TOO_LONG = 0xC0000157;
STATUS_INTERNAL_DB_ERROR = 0xC0000158;
STATUS_FULLSCREEN_MODE = 0xC0000159;
STATUS_TOO_MANY_CONTEXT_IDS = 0xC000015A;
STATUS_LOGON_TYPE_NOT_GRANTED = 0xC000015B;
STATUS_NOT_REGISTRY_FILE = 0xC000015C;
STATUS_NT_CROSS_ENCRYPTION_REQUIRED = 0xC000015D;
STATUS_DOMAIN_CTRLR_CONFIG_ERROR = 0xC000015E;
STATUS_FT_MISSING_MEMBER = 0xC000015F;
STATUS_ILL_FORMED_SERVICE_ENTRY = 0xC0000160;
STATUS_ILLEGAL_CHARACTER = 0xC0000161;
STATUS_UNMAPPABLE_CHARACTER = 0xC0000162;
STATUS_UNDEFINED_CHARACTER = 0xC0000163;
STATUS_FLOPPY_VOLUME = 0xC0000164;
STATUS_FLOPPY_ID_MARK_NOT_FOUND = 0xC0000165;
STATUS_FLOPPY_WRONG_CYLINDER = 0xC0000166;
STATUS_FLOPPY_UNKNOWN_ERROR = 0xC0000167;
STATUS_FLOPPY_BAD_REGISTERS = 0xC0000168;
STATUS_DISK_RECALIBRATE_FAILED = 0xC0000169;
STATUS_DISK_OPERATION_FAILED = 0xC000016A;
STATUS_DISK_RESET_FAILED = 0xC000016B;
STATUS_SHARED_IRQ_BUSY = 0xC000016C;
STATUS_FT_ORPHANING = 0xC000016D;
STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT = 0xC000016E;
STATUS_PARTITION_FAILURE = 0xC0000172;
STATUS_INVALID_BLOCK_LENGTH = 0xC0000173;
STATUS_DEVICE_NOT_PARTITIONED = 0xC0000174;
STATUS_UNABLE_TO_LOCK_MEDIA = 0xC0000175;
STATUS_UNABLE_TO_UNLOAD_MEDIA = 0xC0000176;
STATUS_EOM_OVERFLOW = 0xC0000177;
STATUS_NO_MEDIA = 0xC0000178;
STATUS_NO_SUCH_MEMBER = 0xC000017A;
STATUS_INVALID_MEMBER = 0xC000017B;
STATUS_KEY_DELETED = 0xC000017C;
STATUS_NO_LOG_SPACE = 0xC000017D;
STATUS_TOO_MANY_SIDS = 0xC000017E;
STATUS_LM_CROSS_ENCRYPTION_REQUIRED = 0xC000017F;
STATUS_KEY_HAS_CHILDREN = 0xC0000180;
STATUS_CHILD_MUST_BE_VOLATILE = 0xC0000181;
STATUS_DEVICE_CONFIGURATION_ERROR = 0xC0000182;
STATUS_DRIVER_INTERNAL_ERROR = 0xC0000183;
STATUS_INVALID_DEVICE_STATE = 0xC0000184;
STATUS_IO_DEVICE_ERROR = 0xC0000185;
STATUS_DEVICE_PROTOCOL_ERROR = 0xC0000186;
STATUS_BACKUP_CONTROLLER = 0xC0000187;
STATUS_LOG_FILE_FULL = 0xC0000188;
STATUS_TOO_LATE = 0xC0000189;
STATUS_NO_TRUST_LSA_SECRET = 0xC000018A;
STATUS_NO_TRUST_SAM_ACCOUNT = 0xC000018B;
STATUS_TRUSTED_DOMAIN_FAILURE = 0xC000018C;
STATUS_TRUSTED_RELATIONSHIP_FAILURE = 0xC000018D;
STATUS_EVENTLOG_FILE_CORRUPT = 0xC000018E;
STATUS_EVENTLOG_CANT_START = 0xC000018F;
STATUS_TRUST_FAILURE = 0xC0000190;
STATUS_MUTANT_LIMIT_EXCEEDED = 0xC0000191;
STATUS_NETLOGON_NOT_STARTED = 0xC0000192;
STATUS_ACCOUNT_EXPIRED = 0xC0000193;  
STATUS_POSSIBLE_DEADLOCK = 0xC0000194;
STATUS_NETWORK_CREDENTIAL_CONFLICT = 0xC0000195;
STATUS_REMOTE_SESSION_LIMIT = 0xC0000196;
STATUS_EVENTLOG_FILE_CHANGED = 0xC0000197;
STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT = 0xC0000198;
STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT = 0xC0000199;
STATUS_NOLOGON_SERVER_TRUST_ACCOUNT = 0xC000019A;
STATUS_DOMAIN_TRUST_INCONSISTENT = 0xC000019B;
STATUS_FS_DRIVER_REQUIRED = 0xC000019C;
STATUS_NO_USER_SESSION_KEY = 0xC0000202;
STATUS_USER_SESSION_DELETED = 0xC0000203;
STATUS_RESOURCE_LANG_NOT_FOUND = 0xC0000204;
STATUS_INSUFF_SERVER_RESOURCES = 0xC0000205;
STATUS_INVALID_BUFFER_SIZE = 0xC0000206;
STATUS_INVALID_ADDRESS_COMPONENT = 0xC0000207;
STATUS_INVALID_ADDRESS_WILDCARD = 0xC0000208;
STATUS_TOO_MANY_ADDRESSES = 0xC0000209;
STATUS_ADDRESS_ALREADY_EXISTS = 0xC000020A;
STATUS_ADDRESS_CLOSED = 0xC000020B;
STATUS_CONNECTION_DISCONNECTED = 0xC000020C;
STATUS_CONNECTION_RESET = 0xC000020D;
STATUS_TOO_MANY_NODES = 0xC000020E;
STATUS_TRANSACTION_ABORTED = 0xC000020F;
STATUS_TRANSACTION_TIMED_OUT = 0xC0000210;
STATUS_TRANSACTION_NO_RELEASE = 0xC0000211;
STATUS_TRANSACTION_NO_MATCH = 0xC0000212;
STATUS_TRANSACTION_RESPONDED = 0xC0000213;
STATUS_TRANSACTION_INVALID_ID = 0xC0000214;
STATUS_TRANSACTION_INVALID_TYPE = 0xC0000215;
STATUS_NOT_SERVER_SESSION = 0xC0000216;
STATUS_NOT_CLIENT_SESSION = 0xC0000217;
STATUS_CANNOT_LOAD_REGISTRY_FILE = 0xC0000218;
STATUS_DEBUG_ATTACH_FAILED = 0xC0000219;
STATUS_SYSTEM_PROCESS_TERMINATED = 0xC000021A;
STATUS_DATA_NOT_ACCEPTED = 0xC000021B;
STATUS_NO_BROWSER_SERVERS_FOUND = 0xC000021C;
STATUS_VDM_HARD_ERROR = 0xC000021D;
STATUS_DRIVER_CANCEL_TIMEOUT = 0xC000021E;
STATUS_REPLY_MESSAGE_MISMATCH = 0xC000021F;
STATUS_MAPPED_ALIGNMENT = 0xC0000220;
STATUS_IMAGE_CHECKSUM_MISMATCH = 0xC0000221;
STATUS_LOST_WRITEBEHIND_DATA = 0xC0000222;
STATUS_CLIENT_SERVER_PARAMETERS_INVALID = 0xC0000223;
STATUS_PASSWORD_MUST_CHANGE = 0xC0000224;  
STATUS_NOT_FOUND = 0xC0000225;
STATUS_NOT_TINY_STREAM = 0xC0000226;
STATUS_RECOVERY_FAILURE = 0xC0000227;
STATUS_STACK_OVERFLOW_READ = 0xC0000228;
STATUS_FAIL_CHECK = 0xC0000229;
STATUS_DUPLICATE_OBJECTID = 0xC000022A;
STATUS_OBJECTID_EXISTS = 0xC000022B;
STATUS_CONVERT_TO_LARGE = 0xC000022C;
STATUS_RETRY = 0xC000022D;
STATUS_FOUND_OUT_OF_SCOPE = 0xC000022E;
STATUS_ALLOCATE_BUCKET = 0xC000022F;
STATUS_PROPSET_NOT_FOUND = 0xC0000230;
STATUS_MARSHALL_OVERFLOW = 0xC0000231;
STATUS_INVALID_VARIANT = 0xC0000232;
STATUS_DOMAIN_CONTROLLER_NOT_FOUND = 0xC0000233;
STATUS_ACCOUNT_LOCKED_OUT = 0xC0000234;  
STATUS_HANDLE_NOT_CLOSABLE = 0xC0000235;
STATUS_CONNECTION_REFUSED = 0xC0000236;
STATUS_GRACEFUL_DISCONNECT = 0xC0000237;
STATUS_ADDRESS_ALREADY_ASSOCIATED = 0xC0000238;
STATUS_ADDRESS_NOT_ASSOCIATED = 0xC0000239;
STATUS_CONNECTION_INVALID = 0xC000023A;
STATUS_CONNECTION_ACTIVE = 0xC000023B;
STATUS_NETWORK_UNREACHABLE = 0xC000023C;
STATUS_HOST_UNREACHABLE = 0xC000023D;
STATUS_PROTOCOL_UNREACHABLE = 0xC000023E;
STATUS_PORT_UNREACHABLE = 0xC000023F;
STATUS_REQUEST_ABORTED = 0xC0000240;
STATUS_CONNECTION_ABORTED = 0xC0000241;
STATUS_BAD_COMPRESSION_BUFFER = 0xC0000242;
STATUS_USER_MAPPED_FILE = 0xC0000243;
STATUS_AUDIT_FAILED = 0xC0000244;
STATUS_TIMER_RESOLUTION_NOT_SET = 0xC0000245;
STATUS_CONNECTION_COUNT_LIMIT = 0xC0000246;
STATUS_LOGIN_TIME_RESTRICTION = 0xC0000247;
STATUS_LOGIN_WKSTA_RESTRICTION = 0xC0000248;
STATUS_IMAGE_MP_UP_MISMATCH = 0xC0000249;
STATUS_INSUFFICIENT_LOGON_INFO = 0xC0000250;
STATUS_BAD_DLL_ENTRYPOINT = 0xC0000251;
STATUS_BAD_SERVICE_ENTRYPOINT = 0xC0000252;
STATUS_LPC_REPLY_LOST = 0xC0000253;
STATUS_IP_ADDRESS_CONFLICT1 = 0xC0000254;
STATUS_IP_ADDRESS_CONFLICT2 = 0xC0000255;
STATUS_REGISTRY_QUOTA_LIMIT = 0xC0000256;
STATUS_PATH_NOT_COVERED = 0xC0000257;
STATUS_NO_CALLBACK_ACTIVE = 0xC0000258;
STATUS_LICENSE_QUOTA_EXCEEDED = 0xC0000259;
STATUS_PWD_TOO_SHORT = 0xC000025A;
STATUS_PWD_TOO_RECENT = 0xC000025B;
STATUS_PWD_HISTORY_CONFLICT = 0xC000025C;
STATUS_PLUGPLAY_NO_DEVICE = 0xC000025E;
STATUS_UNSUPPORTED_COMPRESSION = 0xC000025F;
STATUS_INVALID_HW_PROFILE = 0xC0000260;
STATUS_INVALID_PLUGPLAY_DEVICE_PATH = 0xC0000261;
STATUS_DRIVER_ORDINAL_NOT_FOUND = 0xC0000262;
STATUS_DRIVER_ENTRYPOINT_NOT_FOUND = 0xC0000263;
STATUS_RESOURCE_NOT_OWNED = 0xC0000264;
STATUS_TOO_MANY_LINKS = 0xC0000265;
STATUS_QUOTA_LIST_INCONSISTENT = 0xC0000266;
STATUS_FILE_IS_OFFLINE = 0xC0000267;
STATUS_EVALUATION_EXPIRATION = 0xC0000268;
STATUS_ILLEGAL_DLL_RELOCATION = 0xC0000269;
STATUS_LICENSE_VIOLATION = 0xC000026A;
STATUS_DLL_INIT_FAILED_LOGOFF = 0xC000026B;
STATUS_DRIVER_UNABLE_TO_LOAD = 0xC000026C;
STATUS_DFS_UNAVAILABLE = 0xC000026D;
STATUS_VOLUME_DISMOUNTED = 0xC000026E;
STATUS_WX86_INTERNAL_ERROR = 0xC000026F;
STATUS_WX86_FLOAT_STACK_CHECK = 0xC0000270;
STATUS_VALIDATE_CONTINUE = 0xC0000271;
STATUS_NO_MATCH = 0xC0000272;
STATUS_NO_MORE_MATCHES = 0xC0000273;
STATUS_NOT_A_REPARSE_POINT = 0xC0000275;
STATUS_IO_REPARSE_TAG_INVALID = 0xC0000276;
STATUS_IO_REPARSE_TAG_MISMATCH = 0xC0000277;
STATUS_IO_REPARSE_DATA_INVALID = 0xC0000278;
STATUS_IO_REPARSE_TAG_NOT_HANDLED = 0xC0000279;
STATUS_REPARSE_POINT_NOT_RESOLVED = 0xC0000280;
STATUS_DIRECTORY_IS_A_REPARSE_POINT = 0xC0000281;
STATUS_RANGE_LIST_CONFLICT = 0xC0000282;
STATUS_SOURCE_ELEMENT_EMPTY = 0xC0000283;
STATUS_DESTINATION_ELEMENT_FULL = 0xC0000284;
STATUS_ILLEGAL_ELEMENT_ADDRESS = 0xC0000285;
STATUS_MAGAZINE_NOT_PRESENT = 0xC0000286;
STATUS_REINITIALIZATION_NEEDED = 0xC0000287;
STATUS_DEVICE_REQUIRES_CLEANING = 0x80000288;
STATUS_DEVICE_DOOR_OPEN = 0x80000289;
STATUS_ENCRYPTION_FAILED = 0xC000028A;
STATUS_DECRYPTION_FAILED = 0xC000028B;
STATUS_RANGE_NOT_FOUND = 0xC000028C;
STATUS_NO_RECOVERY_POLICY = 0xC000028D;
STATUS_NO_EFS = 0xC000028E;
STATUS_WRONG_EFS = 0xC000028F;
STATUS_NO_USER_KEYS = 0xC0000290;
STATUS_FILE_NOT_ENCRYPTED = 0xC0000291;
STATUS_NOT_EXPORT_FORMAT = 0xC0000292;
STATUS_FILE_ENCRYPTED = 0xC0000293;
STATUS_WAKE_SYSTEM = 0x40000294;
STATUS_WMI_GUID_NOT_FOUND = 0xC0000295;
STATUS_WMI_INSTANCE_NOT_FOUND = 0xC0000296;
STATUS_WMI_ITEMID_NOT_FOUND = 0xC0000297;
STATUS_WMI_TRY_AGAIN = 0xC0000298;
STATUS_SHARED_POLICY = 0xC0000299;
STATUS_POLICY_OBJECT_NOT_FOUND = 0xC000029A;
STATUS_POLICY_ONLY_IN_DS = 0xC000029B;
STATUS_VOLUME_NOT_UPGRADED = 0xC000029C;
STATUS_REMOTE_STORAGE_NOT_ACTIVE = 0xC000029D;
STATUS_REMOTE_STORAGE_MEDIA_ERROR = 0xC000029E;
STATUS_NO_TRACKING_SERVICE = 0xC000029F;
STATUS_SERVER_SID_MISMATCH = 0xC00002A0;
STATUS_DS_NO_ATTRIBUTE_OR_VALUE = 0xC00002A1;
STATUS_DS_INVALID_ATTRIBUTE_SYNTAX = 0xC00002A2;
STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED = 0xC00002A3;
STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS = 0xC00002A4;
STATUS_DS_BUSY = 0xC00002A5;
STATUS_DS_UNAVAILABLE = 0xC00002A6;
STATUS_DS_NO_RIDS_ALLOCATED = 0xC00002A7;
STATUS_DS_NO_MORE_RIDS = 0xC00002A8;
STATUS_DS_INCORRECT_ROLE_OWNER = 0xC00002A9;
STATUS_DS_RIDMGR_INIT_ERROR = 0xC00002AA;
STATUS_DS_OBJ_CLASS_VIOLATION = 0xC00002AB;
STATUS_DS_CANT_ON_NON_LEAF = 0xC00002AC;
STATUS_DS_CANT_ON_RDN = 0xC00002AD;
STATUS_DS_CANT_MOD_OBJ_CLASS = 0xC00002AE;
STATUS_DS_CROSS_DOM_MOVE_FAILED = 0xC00002AF;
STATUS_DS_GC_NOT_AVAILABLE = 0xC00002B0;
STATUS_DIRECTORY_SERVICE_REQUIRED = 0xC00002B1;
STATUS_REPARSE_ATTRIBUTE_CONFLICT = 0xC00002B2;
STATUS_CANT_ENABLE_DENY_ONLY = 0xC00002B3;
STATUS_FLOAT_MULTIPLE_FAULTS = 0xC00002B4;  
STATUS_FLOAT_MULTIPLE_TRAPS = 0xC00002B5;  
STATUS_DEVICE_REMOVED = 0xC00002B6;
STATUS_JOURNAL_DELETE_IN_PROGRESS = 0xC00002B7;
STATUS_JOURNAL_NOT_ACTIVE = 0xC00002B8;
STATUS_NOINTERFACE = 0xC00002B9;
STATUS_DS_ADMIN_LIMIT_EXCEEDED = 0xC00002C1;
STATUS_DRIVER_FAILED_SLEEP = 0xC00002C2;
STATUS_MUTUAL_AUTHENTICATION_FAILED = 0xC00002C3;
STATUS_CORRUPT_SYSTEM_FILE = 0xC00002C4;
STATUS_DATATYPE_MISALIGNMENT_ERROR = 0xC00002C5;  
STATUS_WMI_READ_ONLY = 0xC00002C6;
STATUS_WMI_SET_FAILURE = 0xC00002C7;
STATUS_COMMITMENT_MINIMUM = 0xC00002C8;
STATUS_REG_NAT_CONSUMPTION = 0xC00002C9;  
STATUS_TRANSPORT_FULL = 0xC00002CA;
STATUS_DS_SAM_INIT_FAILURE = 0xC00002CB;
STATUS_ONLY_IF_CONNECTED = 0xC00002CC;
STATUS_DS_SENSITIVE_GROUP_VIOLATION = 0xC00002CD;
STATUS_PNP_RESTART_ENUMERATION = 0xC00002CE;
STATUS_JOURNAL_ENTRY_DELETED = 0xC00002CF;
STATUS_DS_CANT_MOD_PRIMARYGROUPID = 0xC00002D0;
STATUS_SYSTEM_IMAGE_BAD_SIGNATURE = 0xC00002D1;
STATUS_PNP_REBOOT_REQUIRED = 0xC00002D2;
STATUS_POWER_STATE_INVALID = 0xC00002D3;
STATUS_DS_INVALID_GROUP_TYPE = 0xC00002D4;
STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN = 0xC00002D5;
STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN = 0xC00002D6;
STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER = 0xC00002D7;
STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER = 0xC00002D8;
STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER = 0xC00002D9;
STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER = 0xC00002DA;
STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER = 0xC00002DB;
STATUS_DS_HAVE_PRIMARY_MEMBERS = 0xC00002DC;
STATUS_WMI_NOT_SUPPORTED = 0xC00002DD;
STATUS_INSUFFICIENT_POWER = 0xC00002DE;
STATUS_SAM_NEED_BOOTKEY_PASSWORD = 0xC00002DF;
STATUS_SAM_NEED_BOOTKEY_FLOPPY = 0xC00002E0;
STATUS_DS_CANT_START = 0xC00002E1;
STATUS_DS_INIT_FAILURE = 0xC00002E2;
STATUS_SAM_INIT_FAILURE = 0xC00002E3;
STATUS_DS_GC_REQUIRED = 0xC00002E4;
STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY = 0xC00002E5;
STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS = 0xC00002E6;
STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED = 0xC00002E7;
STATUS_MULTIPLE_FAULT_VIOLATION = 0xC00002E8;
STATUS_CURRENT_DOMAIN_NOT_ALLOWED = 0xC00002E9;
STATUS_CANNOT_MAKE = 0xC00002EA;
STATUS_SYSTEM_SHUTDOWN = 0xC00002EB;
STATUS_DS_INIT_FAILURE_CONSOLE = 0xC00002EC;
STATUS_DS_SAM_INIT_FAILURE_CONSOLE = 0xC00002ED;
STATUS_UNFINISHED_CONTEXT_DELETED = 0xC00002EE;
STATUS_NO_TGT_REPLY = 0xC00002EF;
STATUS_OBJECTID_NOT_FOUND = 0xC00002F0;
STATUS_NO_IP_ADDRESSES = 0xC00002F1;
STATUS_WRONG_CREDENTIAL_HANDLE = 0xC00002F2;
STATUS_CRYPTO_SYSTEM_INVALID = 0xC00002F3;
STATUS_MAX_REFERRALS_EXCEEDED = 0xC00002F4;
STATUS_MUST_BE_KDC = 0xC00002F5;
STATUS_STRONG_CRYPTO_NOT_SUPPORTED = 0xC00002F6;
STATUS_TOO_MANY_PRINCIPALS = 0xC00002F7;
STATUS_NO_PA_DATA = 0xC00002F8;
STATUS_PKINIT_NAME_MISMATCH = 0xC00002F9;
STATUS_SMARTCARD_LOGON_REQUIRED = 0xC00002FA;
STATUS_KDC_INVALID_REQUEST = 0xC00002FB;
STATUS_KDC_UNABLE_TO_REFER = 0xC00002FC;
STATUS_KDC_UNKNOWN_ETYPE = 0xC00002FD;
STATUS_SHUTDOWN_IN_PROGRESS = 0xC00002FE;
STATUS_SERVER_SHUTDOWN_IN_PROGRESS = 0xC00002FF;
STATUS_NOT_SUPPORTED_ON_SBS = 0xC0000300;
STATUS_WMI_GUID_DISCONNECTED = 0xC0000301;
STATUS_WMI_ALREADY_DISABLED = 0xC0000302;
STATUS_WMI_ALREADY_ENABLED = 0xC0000303;
STATUS_MFT_TOO_FRAGMENTED = 0xC0000304;
STATUS_COPY_PROTECTION_FAILURE = 0xC0000305;
STATUS_CSS_AUTHENTICATION_FAILURE = 0xC0000306;
STATUS_CSS_KEY_NOT_PRESENT = 0xC0000307;
STATUS_CSS_KEY_NOT_ESTABLISHED = 0xC0000308;
STATUS_CSS_SCRAMBLED_SECTOR = 0xC0000309;
STATUS_CSS_REGION_MISMATCH = 0xC000030A;
STATUS_CSS_RESETS_EXHAUSTED = 0xC000030B;
STATUS_PKINIT_FAILURE = 0xC0000320;
STATUS_SMARTCARD_SUBSYSTEM_FAILURE = 0xC0000321;
STATUS_NO_KERB_KEY = 0xC0000322;
STATUS_HOST_DOWN = 0xC0000350;
STATUS_UNSUPPORTED_PREAUTH = 0xC0000351;
STATUS_EFS_ALG_BLOB_TOO_BIG = 0xC0000352;
STATUS_PORT_NOT_SET = 0xC0000353;
STATUS_DEBUGGER_INACTIVE = 0xC0000354;
STATUS_DS_VERSION_CHECK_FAILURE = 0xC0000355;
STATUS_AUDITING_DISABLED = 0xC0000356;
STATUS_PRENT4_MACHINE_ACCOUNT = 0xC0000357;
STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER = 0xC0000358;
STATUS_INVALID_IMAGE_WIN_32 = 0xC0000359;
STATUS_INVALID_IMAGE_WIN_64 = 0xC000035A;
STATUS_BAD_BINDINGS = 0xC000035B;
STATUS_NETWORK_SESSION_EXPIRED = 0xC000035C;
STATUS_APPHELP_BLOCK = 0xC000035D;
STATUS_ALL_SIDS_FILTERED = 0xC000035E;
STATUS_NOT_SAFE_MODE_DRIVER = 0xC000035F;
STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT = 0xC0000361;
STATUS_ACCESS_DISABLED_BY_POLICY_PATH = 0xC0000362;
STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER = 0xC0000363;
STATUS_ACCESS_DISABLED_BY_POLICY_OTHER = 0xC0000364;
STATUS_FAILED_DRIVER_ENTRY = 0xC0000365;
STATUS_DEVICE_ENUMERATION_ERROR = 0xC0000366;
STATUS_WAIT_FOR_OPLOCK = 0x00000367;
STATUS_MOUNT_POINT_NOT_RESOLVED = 0xC0000368;
STATUS_INVALID_DEVICE_OBJECT_PARAMETER = 0xC0000369;
STATUS_MCA_OCCURED = 0xC000036A;
STATUS_DRIVER_BLOCKED_CRITICAL = 0xC000036B;
STATUS_DRIVER_BLOCKED = 0xC000036C;
STATUS_DRIVER_DATABASE_ERROR = 0xC000036D;
STATUS_SYSTEM_HIVE_TOO_LARGE = 0xC000036E;
STATUS_INVALID_IMPORT_OF_NON_DLL = 0xC000036F;
STATUS_DS_SHUTTING_DOWN = 0x40000370;
STATUS_SMARTCARD_WRONG_PIN = 0xC0000380;
STATUS_SMARTCARD_CARD_BLOCKED = 0xC0000381;
STATUS_SMARTCARD_CARD_NOT_AUTHENTICATED = 0xC0000382;
STATUS_SMARTCARD_NO_CARD = 0xC0000383;
STATUS_SMARTCARD_NO_KEY_CONTAINER = 0xC0000384;
STATUS_SMARTCARD_NO_CERTIFICATE = 0xC0000385;
STATUS_SMARTCARD_NO_KEYSET = 0xC0000386;
STATUS_SMARTCARD_IO_ERROR = 0xC0000387;
STATUS_DOWNGRADE_DETECTED = 0xC0000388;
STATUS_SMARTCARD_CERT_REVOKED = 0xC0000389;
STATUS_ISSUING_CA_UNTRUSTED = 0xC000038A;
STATUS_REVOCATION_OFFLINE_C = 0xC000038B;
STATUS_PKINIT_CLIENT_FAILURE = 0xC000038C;
STATUS_SMARTCARD_CERT_EXPIRED = 0xC000038D;
STATUS_DRIVER_FAILED_PRIOR_UNLOAD = 0xC000038E;
STATUS_WOW_ASSERTION = 0xC0009898;
RPC_NT_INVALID_STRING_BINDING = 0xC0020001;
RPC_NT_WRONG_KIND_OF_BINDING = 0xC0020002;
RPC_NT_INVALID_BINDING = 0xC0020003;
RPC_NT_PROTSEQ_NOT_SUPPORTED = 0xC0020004;
RPC_NT_INVALID_RPC_PROTSEQ = 0xC0020005;
RPC_NT_INVALID_STRING_UUID = 0xC0020006;
RPC_NT_INVALID_ENDPOINT_FORMAT = 0xC0020007;
RPC_NT_INVALID_NET_ADDR = 0xC0020008;
RPC_NT_NO_ENDPOINT_FOUND = 0xC0020009;
RPC_NT_INVALID_TIMEOUT = 0xC002000A;
RPC_NT_OBJECT_NOT_FOUND = 0xC002000B;
RPC_NT_ALREADY_REGISTERED = 0xC002000C;
RPC_NT_TYPE_ALREADY_REGISTERED = 0xC002000D;
RPC_NT_ALREADY_LISTENING = 0xC002000E;
RPC_NT_NO_PROTSEQS_REGISTERED = 0xC002000F;
RPC_NT_NOT_LISTENING = 0xC0020010;
RPC_NT_UNKNOWN_MGR_TYPE = 0xC0020011;
RPC_NT_UNKNOWN_IF = 0xC0020012;
RPC_NT_NO_BINDINGS = 0xC0020013;
RPC_NT_NO_PROTSEQS = 0xC0020014;
RPC_NT_CANT_CREATE_ENDPOINT = 0xC0020015;
RPC_NT_OUT_OF_RESOURCES = 0xC0020016;
RPC_NT_SERVER_UNAVAILABLE = 0xC0020017;
RPC_NT_SERVER_TOO_BUSY = 0xC0020018;
RPC_NT_INVALID_NETWORK_OPTIONS = 0xC0020019;
RPC_NT_NO_CALL_ACTIVE = 0xC002001A;
RPC_NT_CALL_FAILED = 0xC002001B;
RPC_NT_CALL_FAILED_DNE = 0xC002001C;
RPC_NT_PROTOCOL_ERROR = 0xC002001D;
RPC_NT_UNSUPPORTED_TRANS_SYN = 0xC002001F;
RPC_NT_UNSUPPORTED_TYPE = 0xC0020021;
RPC_NT_INVALID_TAG = 0xC0020022;
RPC_NT_INVALID_BOUND = 0xC0020023;
RPC_NT_NO_ENTRY_NAME = 0xC0020024;
RPC_NT_INVALID_NAME_SYNTAX = 0xC0020025;
RPC_NT_UNSUPPORTED_NAME_SYNTAX = 0xC0020026;
RPC_NT_UUID_NO_ADDRESS = 0xC0020028;
RPC_NT_DUPLICATE_ENDPOINT = 0xC0020029;
RPC_NT_UNKNOWN_AUTHN_TYPE = 0xC002002A;
RPC_NT_MAX_CALLS_TOO_SMALL = 0xC002002B;
RPC_NT_STRING_TOO_LONG = 0xC002002C;
RPC_NT_PROTSEQ_NOT_FOUND = 0xC002002D;
RPC_NT_PROCNUM_OUT_OF_RANGE = 0xC002002E;
RPC_NT_BINDING_HAS_NO_AUTH = 0xC002002F;
RPC_NT_UNKNOWN_AUTHN_SERVICE = 0xC0020030;
RPC_NT_UNKNOWN_AUTHN_LEVEL = 0xC0020031;
RPC_NT_INVALID_AUTH_IDENTITY = 0xC0020032;
RPC_NT_UNKNOWN_AUTHZ_SERVICE = 0xC0020033;
EPT_NT_INVALID_ENTRY = 0xC0020034;
EPT_NT_CANT_PERFORM_OP = 0xC0020035;
EPT_NT_NOT_REGISTERED = 0xC0020036;
RPC_NT_NOTHING_TO_EXPORT = 0xC0020037;
RPC_NT_INCOMPLETE_NAME = 0xC0020038;
RPC_NT_INVALID_VERS_OPTION = 0xC0020039;
RPC_NT_NO_MORE_MEMBERS = 0xC002003A;
RPC_NT_NOT_ALL_OBJS_UNEXPORTED = 0xC002003B;
RPC_NT_INTERFACE_NOT_FOUND = 0xC002003C;
RPC_NT_ENTRY_ALREADY_EXISTS = 0xC002003D;
RPC_NT_ENTRY_NOT_FOUND = 0xC002003E;
RPC_NT_NAME_SERVICE_UNAVAILABLE = 0xC002003F;
RPC_NT_INVALID_NAF_ID = 0xC0020040;
RPC_NT_CANNOT_SUPPORT = 0xC0020041;
RPC_NT_NO_CONTEXT_AVAILABLE = 0xC0020042;
RPC_NT_INTERNAL_ERROR = 0xC0020043;
RPC_NT_ZERO_DIVIDE = 0xC0020044;
RPC_NT_ADDRESS_ERROR = 0xC0020045;
RPC_NT_FP_DIV_ZERO = 0xC0020046;
RPC_NT_FP_UNDERFLOW = 0xC0020047;
RPC_NT_FP_OVERFLOW = 0xC0020048;
RPC_NT_NO_MORE_ENTRIES = 0xC0030001;
RPC_NT_SS_CHAR_TRANS_OPEN_FAIL = 0xC0030002;
RPC_NT_SS_CHAR_TRANS_SHORT_FILE = 0xC0030003;
RPC_NT_SS_IN_NULL_CONTEXT = 0xC0030004;
RPC_NT_SS_CONTEXT_MISMATCH = 0xC0030005;
RPC_NT_SS_CONTEXT_DAMAGED = 0xC0030006;
RPC_NT_SS_HANDLES_MISMATCH = 0xC0030007;
RPC_NT_SS_CANNOT_GET_CALL_HANDLE = 0xC0030008;
RPC_NT_NULL_REF_POINTER = 0xC0030009;
RPC_NT_ENUM_VALUE_OUT_OF_RANGE = 0xC003000A;
RPC_NT_BYTE_COUNT_TOO_SMALL = 0xC003000B;
RPC_NT_BAD_STUB_DATA = 0xC003000C;
RPC_NT_CALL_IN_PROGRESS = 0xC0020049;
RPC_NT_NO_MORE_BINDINGS = 0xC002004A;
RPC_NT_GROUP_MEMBER_NOT_FOUND = 0xC002004B;
EPT_NT_CANT_CREATE = 0xC002004C;
RPC_NT_INVALID_OBJECT = 0xC002004D;
RPC_NT_NO_INTERFACES = 0xC002004F;
RPC_NT_CALL_CANCELLED = 0xC0020050;
RPC_NT_BINDING_INCOMPLETE = 0xC0020051;
RPC_NT_COMM_FAILURE = 0xC0020052;
RPC_NT_UNSUPPORTED_AUTHN_LEVEL = 0xC0020053;
RPC_NT_NO_PRINC_NAME = 0xC0020054;
RPC_NT_NOT_RPC_ERROR = 0xC0020055;
RPC_NT_UUID_LOCAL_ONLY = 0x40020056;
RPC_NT_SEC_PKG_ERROR = 0xC0020057;
RPC_NT_NOT_CANCELLED = 0xC0020058;
RPC_NT_INVALID_ES_ACTION = 0xC0030059;
RPC_NT_WRONG_ES_VERSION = 0xC003005A;
RPC_NT_WRONG_STUB_VERSION = 0xC003005B;
RPC_NT_INVALID_PIPE_OBJECT = 0xC003005C;
RPC_NT_INVALID_PIPE_OPERATION = 0xC003005D;
RPC_NT_WRONG_PIPE_VERSION = 0xC003005E;
RPC_NT_PIPE_CLOSED = 0xC003005F;
RPC_NT_PIPE_DISCIPLINE_ERROR = 0xC0030060;
RPC_NT_PIPE_EMPTY = 0xC0030061;
RPC_NT_INVALID_ASYNC_HANDLE = 0xC0020062;
RPC_NT_INVALID_ASYNC_CALL = 0xC0020063;
RPC_NT_SEND_INCOMPLETE = 0x400200AF;
STATUS_ACPI_INVALID_OPCODE = 0xC0140001;
STATUS_ACPI_STACK_OVERFLOW = 0xC0140002;
STATUS_ACPI_ASSERT_FAILED = 0xC0140003;
STATUS_ACPI_INVALID_INDEX = 0xC0140004;
STATUS_ACPI_INVALID_ARGUMENT = 0xC0140005;
STATUS_ACPI_FATAL = 0xC0140006;
STATUS_ACPI_INVALID_SUPERNAME = 0xC0140007;
STATUS_ACPI_INVALID_ARGTYPE = 0xC0140008;
STATUS_ACPI_INVALID_OBJTYPE = 0xC0140009;
STATUS_ACPI_INVALID_TARGETTYPE = 0xC014000A;
STATUS_ACPI_INCORRECT_ARGUMENT_COUNT = 0xC014000B;
STATUS_ACPI_ADDRESS_NOT_MAPPED = 0xC014000C;
STATUS_ACPI_INVALID_EVENTTYPE = 0xC014000D;
STATUS_ACPI_HANDLER_COLLISION = 0xC014000E;
STATUS_ACPI_INVALID_DATA = 0xC014000F;
STATUS_ACPI_INVALID_REGION = 0xC0140010;
STATUS_ACPI_INVALID_ACCESS_SIZE = 0xC0140011;
STATUS_ACPI_ACQUIRE_GLOBAL_LOCK = 0xC0140012;
STATUS_ACPI_ALREADY_INITIALIZED = 0xC0140013;
STATUS_ACPI_NOT_INITIALIZED = 0xC0140014;
STATUS_ACPI_INVALID_MUTEX_LEVEL = 0xC0140015;
STATUS_ACPI_MUTEX_NOT_OWNED = 0xC0140016;
STATUS_ACPI_MUTEX_NOT_OWNER = 0xC0140017;
STATUS_ACPI_RS_ACCESS = 0xC0140018;
STATUS_ACPI_INVALID_TABLE = 0xC0140019;
STATUS_ACPI_REG_HANDLER_FAILED = 0xC0140020;
STATUS_ACPI_POWER_REQUEST_FAILED = 0xC0140021;
STATUS_CTX_WINSTATION_NAME_INVALID = 0xC00A0001;
STATUS_CTX_INVALID_PD = 0xC00A0002;
STATUS_CTX_PD_NOT_FOUND = 0xC00A0003;
STATUS_CTX_CDM_CONNECT = 0x400A0004;
STATUS_CTX_CDM_DISCONNECT = 0x400A0005;
STATUS_CTX_CLOSE_PENDING = 0xC00A0006;
STATUS_CTX_NO_OUTBUF = 0xC00A0007;
STATUS_CTX_MODEM_INF_NOT_FOUND = 0xC00A0008;
STATUS_CTX_INVALID_MODEMNAME = 0xC00A0009;
STATUS_CTX_RESPONSE_ERROR = 0xC00A000A;
STATUS_CTX_MODEM_RESPONSE_TIMEOUT = 0xC00A000B;
STATUS_CTX_MODEM_RESPONSE_NO_CARRIER = 0xC00A000C;
STATUS_CTX_MODEM_RESPONSE_NO_DIALTONE = 0xC00A000D;
STATUS_CTX_MODEM_RESPONSE_BUSY = 0xC00A000E;
STATUS_CTX_MODEM_RESPONSE_VOICE = 0xC00A000F;
STATUS_CTX_TD_ERROR = 0xC00A0010;
STATUS_CTX_LICENSE_CLIENT_INVALID = 0xC00A0012;
STATUS_CTX_LICENSE_NOT_AVAILABLE = 0xC00A0013;
STATUS_CTX_LICENSE_EXPIRED = 0xC00A0014;
STATUS_CTX_WINSTATION_NOT_FOUND = 0xC00A0015;
STATUS_CTX_WINSTATION_NAME_COLLISION = 0xC00A0016;
STATUS_CTX_WINSTATION_BUSY = 0xC00A0017;
STATUS_CTX_BAD_VIDEO_MODE = 0xC00A0018;
STATUS_CTX_GRAPHICS_INVALID = 0xC00A0022;
STATUS_CTX_NOT_CONSOLE = 0xC00A0024;
STATUS_CTX_CLIENT_QUERY_TIMEOUT = 0xC00A0026;
STATUS_CTX_CONSOLE_DISCONNECT = 0xC00A0027;
STATUS_CTX_CONSOLE_CONNECT = 0xC00A0028;
STATUS_CTX_SHADOW_DENIED = 0xC00A002A;
STATUS_CTX_WINSTATION_ACCESS_DENIED = 0xC00A002B;
STATUS_CTX_INVALID_WD = 0xC00A002E;
STATUS_CTX_WD_NOT_FOUND = 0xC00A002F;
STATUS_CTX_SHADOW_INVALID = 0xC00A0030;
STATUS_CTX_SHADOW_DISABLED = 0xC00A0031;
STATUS_RDP_PROTOCOL_ERROR = 0xC00A0032;
STATUS_CTX_CLIENT_LICENSE_NOT_SET = 0xC00A0033;
STATUS_CTX_CLIENT_LICENSE_IN_USE = 0xC00A0034;
STATUS_CTX_SHADOW_ENDED_BY_MODE_CHANGE = 0xC00A0035;
STATUS_CTX_SHADOW_NOT_RUNNING = 0xC00A0036;
STATUS_PNP_BAD_MPS_TABLE = 0xC0040035;
STATUS_PNP_TRANSLATION_FAILED = 0xC0040036;
STATUS_PNP_IRQ_TRANSLATION_FAILED = 0xC0040037;
STATUS_SXS_SECTION_NOT_FOUND = 0xC0150001;
STATUS_SXS_CANT_GEN_ACTCTX = 0xC0150002;
STATUS_SXS_INVALID_ACTCTXDATA_FORMAT = 0xC0150003;
STATUS_SXS_ASSEMBLY_NOT_FOUND = 0xC0150004;
STATUS_SXS_MANIFEST_FORMAT_ERROR = 0xC0150005;
STATUS_SXS_MANIFEST_PARSE_ERROR = 0xC0150006;
STATUS_SXS_ACTIVATION_CONTEXT_DISABLED = 0xC0150007;
STATUS_SXS_KEY_NOT_FOUND = 0xC0150008;
STATUS_SXS_VERSION_CONFLICT = 0xC0150009;
STATUS_SXS_WRONG_SECTION_TYPE = 0xC015000A;
STATUS_SXS_THREAD_QUERIES_DISABLED = 0xC015000B;
STATUS_SXS_ASSEMBLY_MISSING = 0xC015000C;
STATUS_SXS_RELEASE_ACTIVATION_CONTEXT = 0x4015000D;
STATUS_SXS_PROCESS_DEFAULT_ALREADY_SET = 0xC015000E;
STATUS_SXS_EARLY_DEACTIVATION = 0xC015000F;  
STATUS_SXS_INVALID_DEACTIVATION = 0xC0150010;  
STATUS_SXS_MULTIPLE_DEACTIVATION = 0xC0150011;
STATUS_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY = 0xC0150012;
STATUS_SXS_PROCESS_TERMINATION_REQUESTED = 0xC0150013;
STATUS_CLUSTER_INVALID_NODE = 0xC0130001;
STATUS_CLUSTER_NODE_EXISTS = 0xC0130002;
STATUS_CLUSTER_JOIN_IN_PROGRESS = 0xC0130003;
STATUS_CLUSTER_NODE_NOT_FOUND = 0xC0130004;
STATUS_CLUSTER_LOCAL_NODE_NOT_FOUND = 0xC0130005;
STATUS_CLUSTER_NETWORK_EXISTS = 0xC0130006;
STATUS_CLUSTER_NETWORK_NOT_FOUND = 0xC0130007;
STATUS_CLUSTER_NETINTERFACE_EXISTS = 0xC0130008;
STATUS_CLUSTER_NETINTERFACE_NOT_FOUND = 0xC0130009;
STATUS_CLUSTER_INVALID_REQUEST = 0xC013000A;
STATUS_CLUSTER_INVALID_NETWORK_PROVIDER = 0xC013000B;
STATUS_CLUSTER_NODE_DOWN = 0xC013000C;
STATUS_CLUSTER_NODE_UNREACHABLE = 0xC013000D;
STATUS_CLUSTER_NODE_NOT_MEMBER = 0xC013000E;
STATUS_CLUSTER_JOIN_NOT_IN_PROGRESS = 0xC013000F;
STATUS_CLUSTER_INVALID_NETWORK = 0xC0130010;
STATUS_CLUSTER_NO_NET_ADAPTERS = 0xC0130011;
STATUS_CLUSTER_NODE_UP = 0xC0130012;
STATUS_CLUSTER_NODE_PAUSED = 0xC0130013;
STATUS_CLUSTER_NODE_NOT_PAUSED = 0xC0130014;
STATUS_CLUSTER_NO_SECURITY_CONTEXT = 0xC0130015;
STATUS_CLUSTER_NETWORK_NOT_INTERNAL = 0xC0130016;
STATUS_CLUSTER_POISONED = 0xC0130017;


# NTLMSSP FLAGS
NTLMSSP_NEGOTIATE_UNICODE              = 0x00000001;
NTLMSSP_NEGOTIATE_OEM                  = 0x00000002;
NTLMSSP_REQUEST_TARGET                 = 0x00000004;
NTLMSSP_NEGOTIATE_SIGN                 = 0x00000010;
NTLMSSP_NEGOTIATE_SEAL                 = 0x00000020;
NTLMSSP_NEGOTIATE_LM_KEY               = 0x00000080;
NTLMSSP_NEGOTIATE_00000100             = 0x00000100;
NTLMSSP_NEGOTIATE_NTLM                 = 0x00000200;
NTLMSSP_NEGOTIATE_00000400             = 0x00000400;
NTLMSSP_NEGOTIATE_DOMAIN_SUPPLIED      = 0x00001000;
NTLMSSP_NEGOTIATE_WORKSTATION_SUPPLIED = 0x00002000;
NTLMSSP_NEGOTIATE_ALWAYS_SIGN          = 0x00008000;
NTLMSSP_TARGET_TYPE_DOMAIN             = 0x00010000;
NTLMSSP_TARGET_TYPE_SERVER             = 0x00020000;
NTLMSSP_TARGET_TYPE_SHARE              = 0x00040000;
NTLMSSP_NEGOTIATE_NTLM2                = 0x00080000;
NTLMSSP_NEGOTIATE_TARGET_INFO          = 0x00800000;
NTLMSSP_NEGOTIATE_128                  = 0x20000000;
NTLMSSP_NEGOTIATE_KEY_EXCH             = 0x40000000;
NTLMSSP_NEGOTIATE_56                   = 0x80000000;


# DCE / RPC
DCE_RPC_BIND         = 0x0B;
DCE_RPC_REQUEST      = 0x00;
DCE_RPC_RESPONSE     = 0x02;


# TRANSACTION codes
TRANS_PIPE           = 0x26;


# Opnum codes
OPNUM_OPENHKCR           = 0x00;
OPNUM_OPENHKCU           = 0x01;
OPNUM_OPENHKLM           = 0x02;
OPNUM_OPENHKU            = 0x04;
OPNUM_OPENKEY            = 0x0F;
OPNUM_QUERYINFOKEY       = 0x10;
OPNUM_QUERYVALUE         = 0x11;
OPNUM_ENUMVALUE          = 0x0A;
OPNUM_ENUMKEY            = 0x09;
OPNUM_CLOSEKEY           = 0x05;
OPNUM_GETKEYSECURITY     = 0x0C;
OPNUM_SERVERGETINFO      = 0x15;
OPNUM_SHAREENUM          = 0x0F;
OPNUM_WKSTAGETINFO       = 0x00;
OPNUM_WKSTAUSERENUM      = 0x02;
OPNUM_LSAOPENPOLICY      = 0x2C;
OPNUM_LSAQUERYINFO       = 0x07;
OPNUM_LSAQUERYDOMAININFO = 0x35;
OPNUM_LSASECURITYOBJECT  = 0x03;
OPNUM_LSALOOKUPSID       = 0x0F;
OPNUM_LSALOOKUPNAMES     = 0x0E;
OPNUM_LSACLOSE           = 0x00;
OPNUM_OPENSCMANAGERW     = 0x0F;
OPNUM_OPENSCMANAGERA     = 0x1B;
OPNUM_OPENSERVICEW       = 0x10;
OPNUM_OPENSERVICEA       = 0x1C;
OPNUM_SERVICECONTROL     = 0x01;
OPNUM_CREATESERVICEA     = 0x18;
OPNUM_CREATESERVICEW     = 0x0C;
OPNUM_STARTSERVICEA      = 0x1F;
OPNUM_STARTSERVICEW      = 0x13;
OPNUM_DELETESERVICE      = 0x02;
OPNUM_CLOSESERVICE       = 0x00;
OPNUM_QUERYSERVICE       = 0x06;
OPNUM_QUERYSERVICESECURITY = 0x04;
OPNUM_ENUMSERVICEA       = 0x1A;
OPNUM_ENUMSERVICEW       = 0x0E;
OPNUM_SERVICEDISPLAYNAMEA = 0x20;
OPNUM_SERVICEDISPLAYNAMEW = 0x14;
OPNUM_SAMCONNECT2        = 0x39;
OPNUM_SAMENUMDOM         = 0x06;
OPNUM_SAMLOOKUP          = 0x05;
OPNUM_SAMOPENDOM         = 0x07;
OPNUM_SAMLOOKUPNAME      = 0x11;
OPNUM_SAMOPENUSER        = 0x22;
OPNUM_SAMOPENGROUP       = 0x13;
OPNUM_SAMOPENALIAS       = 0x1B;
OPNUM_SAMGETGROUPS       = 0x27;
OPNUM_SAMCLOSEHANDLE     = 0x01;
OPNUM_SAMLOOKUPIDS       = 0x12;
OPNUM_SAMQUERYINFOU      = 0x24;
OPNUM_SAMQUERYINFOD      = 0x2E;
OPNUM_SAMGETALIASM       = 0x10;
OPNUM_SAMGETMEMALIAS     = 0x21;
OPNUM_SAMGETMEMGROUP     = 0x19;
OPNUM_NETSESSENUM        = 0x0C;
OPNUM_LSAENUMERATEACCOUNTWITHUSERRIGHT = 0x23;

# SERVICE codes
SERVICE_ERROR_IGNORE   = 0;
SERVICE_ERROR_NORMAL   = 1;
SERVICE_ERROR_SEVERE   = 2;
SERVICE_ERROR_CRITICAL = 3;

SERVICE_WIN32_OWN_PROCESS   = 16;
SERVICE_WIN32_SHARE_PROCESS = 32;
SERVICE_KERNEL_DRIVER       = 1;
SERVICE_FILE_SYSTEM_DRIVER  = 2;
SERVICE_INTERACTIVE_PROCESS = 256;

SERVICE_BOOT_START   = 0;
SERVICE_SYSTEM_START = 1;
SERVICE_AUTO_START   = 2;
SERVICE_DEMAND_START = 3;
SERVICE_DISABLED     = 4;

SERVICE_WIN32        = 0x30;
SERVICE_DRIVER       = 0x0B;

SERVICE_ACTIVE       = 1;
SERVICE_INACTIVE     = 2;
SERVICE_ALL_STATE    = SERVICE_ACTIVE | SERVICE_INACTIVE;

SERVICE_STOPPED	                = 1;
SERVICE_START_PENDING	        = 2;
SERVICE_STOP_PENDING	        = 3;
SERVICE_RUNNING	                = 4;
SERVICE_CONTINUE_PENDING	= 5;
SERVICE_PAUSE_PENDING	        = 6;
SERVICE_PAUSED	                = 7;
SERVICE_ACCEPT_STOP	        = 1;
SERVICE_ACCEPT_PAUSE_CONTINUE	= 2;
SERVICE_ACCEPT_SHUTDOWN	        = 4;


# POLICY codes
PolicyAuditEventsInformation          = 2;
PolicyPrimaryDomainInformation        = 3;
PolicyAccountDomainInformation        = 5;
PolicyLsaServerRoleInformation        = 6;
PolicyModificationInformation         = 9;
PolicyDnsDomainInformation            = 12;
PolicyDomainKerberosTicketInformation = 3;

# Security Descriptor FLAGS
OWNER_SECURITY_INFORMATION = 0x00000001;
GROUP_SECURITY_INFORMATION = 0x00000002;
DACL_SECURITY_INFORMATION  = 0x00000004;
SACL_SECURITY_INFORMATION  = 0x00000008;



FILE_SHARE_READ       = 0x00000001;
FILE_SHARE_WRITE      = 0x00000002;
FILE_SHARE_DELETE     = 0x00000004;

CREATE_NEW              = 2;
CREATE_ALWAYS           = 5;
OPEN_EXISTING           = 1;
OPEN_ALWAYS             = 3;
TRUNCATE_EXISTING       = 4;

FILE_ATTRIBUTE_READONLY                = 0x00000001;
FILE_ATTRIBUTE_HIDDEN                  = 0x00000002;
FILE_ATTRIBUTE_SYSTEM                  = 0x00000004;
FILE_ATTRIBUTE_DIRECTORY               = 0x00000010;
FILE_ATTRIBUTE_ARCHIVE                 = 0x00000020;
FILE_ATTRIBUTE_ENCRYPTED               = 0x00000040;
FILE_ATTRIBUTE_NORMAL                  = 0x00000080;
FILE_ATTRIBUTE_TEMPORARY               = 0x00000100;
FILE_ATTRIBUTE_SPARSE_FILE             = 0x00000200;
FILE_ATTRIBUTE_REPARSE_POINT           = 0x00000400;
FILE_ATTRIBUTE_COMPRESSED              = 0x00000800;
FILE_ATTRIBUTE_OFFLINE                 = 0x00001000;
FILE_ATTRIBUTE_NOT_CONTENT_INDEXED     = 0x00002000;
FILE_FLAG_OPEN_NO_RECALL               = 0x00100000;
FILE_FLAG_OPEN_REPARSE_POINT           = 0x00200000;
FILE_FLAG_POSIX_SEMANTICS              = 0x01000000;
FILE_FLAG_BACKUP_SEMANTICS             = 0x02000000;
FILE_FLAG_DELETE_ON_CLOSE              = 0x04000000;
FILE_FLAG_SEQUENTIAL_SCAN              = 0x08000000;
FILE_FLAG_RANDOM_ACCESS                = 0x10000000;
FILE_FLAG_NO_BUFFERING                 = 0x20000000;
FILE_FLAG_OVERLAPPED                   = 0x40000000;
FILE_FLAG_WRITE_THROUGH                = 0x80000000;


# ACCESS Rights
ACCESS_NONE         = 0x00;
ACCESS_READ         = 0x01;
ACCESS_WRITE        = 0x02;
ACCESS_CREATE       = 0x04;
ACCESS_EXEC         = 0x08;
ACCESS_DELETE       = 0x10;
ACCESS_ATRIB        = 0x20;
ACCESS_PERM         = 0x40;
ACCESS_GROUP        = 0x8000;
ACCESS_ALL          = ACCESS_READ   | 
                      ACCESS_WRITE  |
                      ACCESS_CREATE |
                      ACCESS_EXEC   |
                      ACCESS_DELETE |
                      ACCESS_ATRIB  |
                      ACCESS_PERM ;

DELETE                           = 0x00010000;
READ_CONTROL                     = 0x00020000;
WRITE_DAC                        = 0x00040000;
WRITE_OWNER                      = 0x00080000;
SYNCHRONIZE                      = 0x00100000;
STANDARD_RIGHTS_REQUIRED         = 0x000F0000;
STANDARD_RIGHTS_READ             = READ_CONTROL;
STANDARD_RIGHTS_WRITE            = READ_CONTROL;
STANDARD_RIGHTS_EXECUTE          = READ_CONTROL;
STANDARD_RIGHTS_ALL              = 0x001F0000;
SPECIFIC_RIGHTS_ALL              = 0x0000FFFF;
ACCESS_SYSTEM_SECURITY           = 0x01000000;
MAXIMUM_ALLOWED                  = 0x02000000;
GENERIC_READ                     = 0x80000000;
GENERIC_WRITE                    = 0x40000000;
GENERIC_EXECUTE                  = 0x20000000;
GENERIC_ALL                      = 0x10000000;



# FILE Rights

FILE_READ_DATA            = 0x0001 ;
FILE_LIST_DIRECTORY       = 0x0001 ;
FILE_WRITE_DATA           = 0x0002 ;
FILE_ADD_FILE             = 0x0002 ;
FILE_APPEND_DATA          = 0x0004 ;
FILE_ADD_SUBDIRECTORY     = 0x0004 ;
FILE_CREATE_PIPE_INSTANCE = 0x0004 ;
FILE_READ_EA              = 0x0008 ;
FILE_WRITE_EA             = 0x0010 ;
FILE_EXECUTE              = 0x0020 ;
FILE_TRAVERSE             = 0x0020 ;
FILE_DELETE_CHILD         = 0x0040 ;
FILE_READ_ATTRIBUTES      = 0x0080 ;
FILE_WRITE_ATTRIBUTES     = 0x0100 ;

FILE_ALL_ACCESS  = STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x1FF;

FILE_GENERIC_READ         = STANDARD_RIGHTS_READ     |
                            FILE_READ_DATA           |
                            FILE_READ_ATTRIBUTES     |
                            FILE_READ_EA             |
                            SYNCHRONIZE;


FILE_GENERIC_WRITE        = FILE_WRITE_DATA          |
                            FILE_WRITE_ATTRIBUTES    |
                            FILE_WRITE_EA            |
                            FILE_APPEND_DATA;


FILE_GENERIC_EXECUTE      = STANDARD_RIGHTS_EXECUTE  |
                            FILE_READ_ATTRIBUTES     |
                            FILE_EXECUTE             |
                            SYNCHRONIZE;

# SERVICE CODES
SERVICE_NO_CHANGE              = 0xffffffff;
SERVICE_ACTIVE                 = 0x00000001;
SERVICE_INACTIVE               = 0x00000002;
SERVICE_STATE_ALL              = SERVICE_ACTIVE   |
                                 SERVICE_INACTIVE ;

SERVICE_CONTROL_STOP           = 0x00000001;
SERVICE_CONTROL_PAUSE          = 0x00000002;
SERVICE_CONTROL_CONTINUE       = 0x00000003;
SERVICE_CONTROL_INTERROGATE    = 0x00000004;
SERVICE_CONTROL_SHUTDOWN       = 0x00000005;
SERVICE_CONTROL_PARAMCHANGE    = 0x00000006;
SERVICE_CONTROL_NETBINDADD     = 0x00000007;
SERVICE_CONTROL_NETBINDREMOVE  = 0x00000008;
SERVICE_CONTROL_NETBINDENABLE  = 0x00000009;
SERVICE_CONTROL_NETBINDDISABLE = 0x0000000A;

SERVICE_STOPPED                = 0x00000001;
SERVICE_START_PENDING          = 0x00000002;
SERVICE_STOP_PENDING           = 0x00000003;
SERVICE_RUNNING                = 0x00000004;
SERVICE_CONTINUE_PENDING       = 0x00000005;
SERVICE_PAUSE_PENDING          = 0x00000006;
SERVICE_PAUSED                 = 0x00000007;

SERVICE_ACCEPT_STOP            = 0x00000001;
SERVICE_ACCEPT_PAUSE_CONTINUE  = 0x00000002;
SERVICE_ACCEPT_SHUTDOWN        = 0x00000004;
SERVICE_ACCEPT_PARAMCHANGE     = 0x00000008;
SERVICE_ACCEPT_NETBINDCHANGE   = 0x00000010;

SC_MANAGER_CONNECT             = 0x0001;
SC_MANAGER_CREATE_SERVICE      = 0x0002;
SC_MANAGER_ENUMERATE_SERVICE   = 0x0004;
SC_MANAGER_LOCK                = 0x0008;
SC_MANAGER_QUERY_LOCK_STATUS   = 0x0010;
SC_MANAGER_MODIFY_BOOT_CONFIG  = 0x0020;

SC_MANAGER_ALL_ACCESS          = STANDARD_RIGHTS_REQUIRED      |
                                 SC_MANAGER_CONNECT            |
                                 SC_MANAGER_CREATE_SERVICE     |
                                 SC_MANAGER_ENUMERATE_SERVICE  |
                                 SC_MANAGER_LOCK               |
                                 SC_MANAGER_QUERY_LOCK_STATUS  |
                                 SC_MANAGER_MODIFY_BOOT_CONFIG;

SERVICE_QUERY_CONFIG           = 0x0001;
SERVICE_CHANGE_CONFIG          = 0x0002;
SERVICE_QUERY_STATUS           = 0x0004;
SERVICE_ENUMERATE_DEPENDENTS   = 0x0008;
SERVICE_START                  = 0x0010;
SERVICE_STOP                   = 0x0020;
SERVICE_PAUSE_CONTINUE         = 0x0040;
SERVICE_INTERROGATE            = 0x0080;
SERVICE_USER_DEFINED_CONTROL   = 0x0100;

SERVICE_ALL_ACCESS             = STANDARD_RIGHTS_REQUIRED     |
                                 SERVICE_QUERY_CONFIG         |
                                 SERVICE_CHANGE_CONFIG        |
                                 SERVICE_QUERY_STATUS         |
                                 SERVICE_ENUMERATE_DEPENDENTS |
                                 SERVICE_START                |
                                 SERVICE_STOP                 |
                                 SERVICE_PAUSE_CONTINUE       |
                                 SERVICE_INTERROGATE          |
                                 SERVICE_USER_DEFINED_CONTROL;


SERVICE_READ                   = SERVICE_QUERY_CONFIG         |
                                 SERVICE_QUERY_STATUS         |
                                 SERVICE_ENUMERATE_DEPENDENTS |
                                 SERVICE_INTERROGATE          |
                                 SERVICE_USER_DEFINED_CONTROL |
                                 READ_CONTROL;


SERVICE_EXECUTE                = SERVICE_START                |
                                 SERVICE_STOP                 |
                                 SERVICE_PAUSE_CONTINUE       |
                                 READ_CONTROL;


SERVICE_WRITE                  = SERVICE_CHANGE_CONFIG        |
                                 READ_CONTROL;

SERVICE_DELETE                 = DELETE;



# Higher code
HKEY_LOCAL_MACHINE  = OPNUM_OPENHKLM;
HKEY_CURRENT_USER   = OPNUM_OPENHKCU;
HKEY_USERS          = OPNUM_OPENHKU;
HKEY_CLASS_ROOT     = OPNUM_OPENHKCR;


# Write mode codes
WRITE_START         = 0x08;


# SHARE_INFO
SHARE_INFO_0        = 0;
SHARE_INFO_1        = 1;
SHARE_INFO_2        = 2;
SHARE_INFO_502      = 502;


WKSTA_USER_INFO_0  = 0;
WKSTA_USER_INFO_1  = 1;

# Extra codes
ASCII_STRING        = 0;
UNICODE_STRING      = 1;


# Registry
REG_SZ              = 1;
REG_EXPAND_SZ       = 2;
REG_BINARY          = 3;
REG_DWORD           = 4;
REG_MULTI_SZ        = 7;


# Server info
SERVER_INFO_100     = 0;
SERVER_INFO_101     = 1;


# Session info
SESSION_INFO_0      = 0;
SESSION_INFO_1      = 1;
SESSION_INFO_2      = 2;
SESSION_INFO_10     = 10;
SESSION_INFO_50     = 50;
SESSION_INFO_502    = 502;


# SID type
SidTypeUser           = 1;
SidTypeGroup          = 2;
SidTypeDomain         = 3;
SidTypeAlias          = 4;
SidTypeWellKnownGroup = 5;
SidTypeDeletedAccount = 6;
SidTypeInvalid        = 7;
SidTypeUnknown        = 8;
SidTypeComputer       = 9;


SID_TYPE[SidTypeUser]           = "User";
SID_TYPE[SidTypeGroup]          = "Group";
SID_TYPE[SidTypeDomain]         = "Domain";
SID_TYPE[SidTypeAlias]          = "Alias";
SID_TYPE[SidTypeWellKnownGroup] = "Well Known Group";
SID_TYPE[SidTypeDeletedAccount] = "Deleted Account";
SID_TYPE[SidTypeInvalid]        = "Invalid";
SID_TYPE[SidTypeUnknown]        = "Unknown";
SID_TYPE[SidTypeComputer]       = "Computer";


# LsaPolicy
PolicyAuditEventsInformation = 2;
AuditCategorySystem = 0;
AuditCategoryLogon  = 1;
AuditCategoryObjectAccess = 2;
AuditCategoryPrivilegeUse = 3;
AuditCategoryDetailedTracking = 4;
AuditCategoryPolicyChange = 5;
AuditCategoryAccountManagement = 6;
AuditCategoryDirectoryServiceAccess = 7;
AuditCategoryAccountLogon = 8;

POLICY_AUDIT_EVENT_UNCHANGED = 0;
POLICY_AUDIT_EVENT_SUCCESS   = 1;
POLICY_AUDIT_EVENT_FAILURE   = 2;
POLICY_AUDIT_EVENT_NONE      = 4;

POLICY_VIEW_LOCAL_INFORMATION    = 0x00000001;
POLICY_VIEW_AUDIT_INFORMATION    = 0x00000002;
POLICY_GET_PRIVATE_INFORMATION   = 0x00000004;
POLICY_TRUST_ADMIN               = 0x00000008;
POLICY_CREATE_ACCOUNT            = 0x00000010;
POLICY_CREATE_SECRET             = 0x00000020;
POLICY_CREATE_PRIVILEGE          = 0x00000040;
POLICY_SET_DEFAULT_QUOTA_LIMITS  = 0x00000080;
POLICY_SET_AUDIT_REQUIREMENTS    = 0x00000100;
POLICY_AUDIT_LOG_ADMIN           = 0x00000200;
POLICY_SERVER_ADMIN              = 0x00000400;
POLICY_LOOKUP_NAMES              = 0x00000800;

POLICY_ALL_ACCESS =  STANDARD_RIGHTS_REQUIRED_ACCESS  |
                     POLICY_VIEW_LOCAL_INFORMATION    |
                     POLICY_VIEW_AUDIT_INFORMATION    |
                     POLICY_GET_PRIVATE_INFORMATION   |
                     POLICY_TRUST_ADMIN               |
                     POLICY_CREATE_ACCOUNT            |
                     POLICY_CREATE_SECRET             |
                     POLICY_CREATE_PRIVILEGE          |
                     POLICY_SET_DEFAULT_QUOTA_LIMITS  |
                     POLICY_SET_AUDIT_REQUIREMENTS    |
                     POLICY_AUDIT_LOG_ADMIN           |
                     POLICY_SERVER_ADMIN              |
                     POLICY_LOOKUP_NAMES;


POLICY_READ        = STANDARD_RIGHTS_READ_ACCESS      |
                     POLICY_VIEW_AUDIT_INFORMATION    |
                     POLICY_GET_PRIVATE_INFORMATION;

POLICY_WRITE       = STANDARD_RIGHTS_WRITE_ACCESS     |
                     POLICY_TRUST_ADMIN               |
                     POLICY_CREATE_ACCOUNT            |
                     POLICY_CREATE_SECRET             |
                     POLICY_CREATE_PRIVILEGE          |
                     POLICY_SET_DEFAULT_QUOTA_LIMITS  |
                     POLICY_SET_AUDIT_REQUIREMENTS    |
                     POLICY_AUDIT_LOG_ADMIN           |
                     POLICY_SERVER_ADMIN;

POLICY_EXECUTE     = STANDARD_RIGHTS_EXECUTE_ACCESS   |
                     POLICY_VIEW_LOCAL_INFORMATION    |
                     POLICY_LOOKUP_NAMES;



KEY_QUERY_VALUE        = 0x00000001;
KEY_SET_VALUE          = 0x00000002;
KEY_CREATE_SUB_KEY     = 0x00000004;
KEY_ENUMERATE_SUB_KEYS = 0x00000008;
KEY_NOTIFY             = 0x00000010;
KEY_CREATE_LINK        = 0x00000020;

KEY_ALL_ACCESS     = STANDARD_RIGHTS_REQUIRED         |
                     KEY_QUERY_VALUE                  |
                     KEY_SET_VALUE                    |
                     KEY_CREATE_SUB_KEY               |
                     KEY_ENUMERATE_SUB_KEYS           |
                     KEY_NOTIFY                       |
                     KEY_CREATE_LINK;

KEY_READ           = READ_CONTROL                     |
                     KEY_QUERY_VALUE                  |
                     KEY_ENUMERATE_SUB_KEYS           |
                     KEY_NOTIFY;

KEY_EXECUTE        = READ_CONTROL                     |
                     KEY_QUERY_VALUE                  |
                     KEY_ENUMERATE_SUB_KEYS           |
                     KEY_NOTIFY;

KEY_WRITE          = READ_CONTROL                     |
                     KEY_SET_VALUE                    |
                     KEY_CREATE_SUB_KEY;


# User rights

# SeAssignPrimaryTokenPrivilege
# SeAuditPrivilege
# SeBackupPrivilege
# SeBatchLogonRight
# SeChangeNotifyPrivilege
# SeCreateGlobalPrivilege
# SeCreatePagefilePrivilege
# SeCreatePermanentPrivilege
# SeCreateTokenPrivilege
# SeDenyBatchLogonRight
# SeDenyInteractiveLogonRight
# SeDenyNetworkLogonRight
# SeDenyServiceLogonRight
# SeDebugPrivilege
# SeEnableDelegationPrivilege
# SeImpersonatePrivilege
# SeIncreaseBasePriorityPrivilege
# SeIncreaseQuotaPrivilege
# SeInteractiveLogonRight
# SeLoadDriverPrivilege
# SeLockMemoryPrivilege
# SeMachineAccountPrivilege
# SeManageVolumePrivilege
# SeNetworkLogonRight
# SeProfileSingleProcessPrivilege
# SeRemoteShutdownPrivilege
# SeRestorePrivilege
# SeSecurityPrivilege
# SeServiceLogonRight
# SeShutdownPrivilege
# SeSyncAgentPrivilege
# SeSystemEnvironmentPrivilege
# SeSystemProfilePrivilege
# SeSystemtimePrivilege
# SeTakeOwnershipPrivilege
# SeTcbPrivilege
# SeUndockPrivilege
# SeUnsolicitedInputPrivilege