# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200603-07.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(21045);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200603-07");
 script_cve_id("CVE-2006-0459");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200603-07
(flex: Potential insecure code generation)


    Chris Moore discovered a buffer overflow in a special class of
    lexicographical scanners generated by flex. Only scanners generated by
    grammars which use either REJECT, or rules with a "variable trailing
    context" might be at risk.
  
Impact

    An attacker could feed malicious input to an application making
    use of an affected scanner and trigger the buffer overflow, potentially
    resulting in the execution of arbitrary code.
  
Workaround

    Avoid using vulnerable grammar in your flex scanners.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-0459


Solution: 
    All flex users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=sys-devel/flex-2.5.33-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200603-07] flex: Potential insecure code generation");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'flex: Potential insecure code generation');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "sys-devel/flex", unaffected: make_list("ge 2.5.33-r1"), vulnerable: make_list("lt 2.5.33-r1")
)) { security_warning(0); exit(0); }
