# XScale 8 bit Flash Utilities


#
#	FLASH writing code (8 bit functions) - SG565, SG560U/D
#
proc flash8-erase1 { } {
mww 0x10000000 0xe3a01205
mww 0x10000004 0xe3a02020
mww 0x10000008 0xe5c12000
mww 0x1000000c 0xe3a020d0
mww 0x10000010 0xe5c12000
reg pc 0x10000000
stepi 5
sleep 2000
mww 0x10000000 0xe3a020ff
mww 0x10000004 0xe5c12000
reg pc 0x10000000
stepi 2
}

proc flash8-erase2 { } {
mww 0x10000000 0xe3a01205
mww 0x10000004 0xe3811802
mww 0x10000008 0xe3a02020
mww 0x1000000c 0xe5c12000
mww 0x10000010 0xe3a020d0
mww 0x10000014 0xe5c12000
reg pc 0x10000000
stepi 6
sleep 2000
mww 0x10000000 0xe3a020ff
mww 0x10000004 0xe5c12000
reg pc 0x10000000
stepi 2
}

proc flash8-unlock1 { } {
mww 0x10000000 0xe3a01205
mww 0x10000004 0xe3a02060
mww 0x10000008 0xe5c12000
mww 0x1000000c 0xe3a020d0
mww 0x10000010 0xe5c12000
mww 0x10000014 0xe3a020ff
mww 0x10000018 0xe5c12000
reg pc 0x10000000
stepi 7
}

proc flash8-unlock2 { } {
mww 0x10000000 0xe3a01205
mww 0x10000004 0xe3811802
mww 0x10000008 0xe3a02060
mww 0x1000000c 0xe5c12000
mww 0x10000010 0xe3a020d0
mww 0x10000014 0xe5c12000
mww 0x10000018 0xe3a020ff
mww 0x1000001c 0xe5c12000
reg pc 0x10000000
stepi 8
}

proc flash8-program { } {
mww 0x10100000 0xe3a01205
mww 0x10100004 0xe3a02040
mww 0x10100008 0xe3a03080
mww 0x1010000c 0xe3a040ff
mww 0x10100010 0xe3a05000
mww 0x10100014 0xe3a06701
mww 0x10100018 0xe5c12000
mww 0x1010001c 0xe5d57000
mww 0x10100020 0xe5c17000
mww 0x10100024 0xe5d17000
mww 0x10100028 0xe1170003
mww 0x1010002c 0x0afffffc
mww 0x10100030 0xe5c14000
mww 0x10100034 0xe2811001
mww 0x10100038 0xe2855001
mww 0x1010003c 0xe1550006
mww 0x10100040 0x1afffff4
mww 0x10100044 0xe1a00000
mww 0x10100048 0xe1a00000
mww 0x1010004c 0xeafffffe
reg pc 0x10100000
}

proc flash8-boot { } {
mem-init
mem-switch
writable
flash8-unlock1
flash8-erase1
flash8-unlock2
flash8-erase2
load_image boot/boot.bin 0x0 bin 
mem-setmac
flash8-program
resume
}

