# XScale 16 bit Flash Utilities


#
#	FLASH writing code (16bit functions) - SG580, SG560
#
proc flash-erase1 { } {
mww 0x10000000 0xe3a01205
mww 0x10000004 0xe3a02020
mww 0x10000008 0xe3822a02
mww 0x1000000c 0xe1c120b0
mww 0x10000010 0xe3a020d0
mww 0x10000014 0xe3822a0d
mww 0x10000018 0xe1c120b0
reg pc 0x10000000
stepi 7
sleep 2000
mww 0x10000000 0xe3a020ff
mww 0x10000004 0xe3822cff
mww 0x10000008 0xe1c120b0
reg pc 0x10000000
stepi 3
}

proc flash-erase2 { } {
mww 0x10000000 0xe3a01205
mww 0x10000004 0xe3811802
mww 0x10000008 0xe3a02020
mww 0x1000000c 0xe3822a02
mww 0x10000010 0xe1c120b0
mww 0x10000014 0xe3a020d0
mww 0x10000018 0xe3822a0d
mww 0x1000001c 0xe1c120b0
reg pc 0x10000000
stepi 8
sleep 2000
mww 0x10000000 0xe3a020ff
mww 0x10000004 0xe3822cff
mww 0x10000008 0xe1c120b0
reg pc 0x10000000
stepi 3
}

proc flash-unlock1 { } {
mww 0x10000000 0xe3a01205
mww 0x10000004 0xe3a02060
mww 0x10000008 0xe3822a06
mww 0x1000000c 0xe1c120b0
mww 0x10000010 0xe3a020d0
mww 0x10000014 0xe3822a0d
mww 0x10000018 0xe1c120b0
mww 0x1000001c 0xe3a020ff
mww 0x10000020 0xe3822cff
mww 0x10000024 0xe1c120b0
reg pc 0x10000000
stepi 10
}

proc flash-unlock2 { } {
mww 0x10000000 0xe3a01205
mww 0x10000004 0xe3811802
mww 0x10000008 0xe3a02060
mww 0x1000000c 0xe3822a06
mww 0x10000010 0xe1c120b0
mww 0x10000014 0xe3a020d0
mww 0x10000018 0xe3822a0d
mww 0x1000001c 0xe1c120b0
mww 0x10000020 0xe3a020ff
mww 0x10000024 0xe3822cff
mww 0x10000028 0xe1c120b0
reg pc 0x10000000
stepi 11
}

proc flash-id { } {
mww 0x10000000 0xe3a01205
mww 0x10000004 0xe3a02090
mww 0x10000008 0xe3822a09
mww 0x1000000c 0xe1c120b0
reg pc 0x10000000
stepi 4
}

proc flash-program { } {
mww 0x10100000 0xe3a01205
mww 0x10100004 0xe3a02040
mww 0x10100008 0xe3822901
mww 0x1010000c 0xe3a03080
mww 0x10100010 0xe3a040ff
mww 0x10100014 0xe3844cff
mww 0x10100018 0xe3a05000
mww 0x1010001c 0xe3a06701
mww 0x10100020 0xe1c120b0
mww 0x10100024 0xe1d570b0
mww 0x10100028 0xe1c170b0
mww 0x1010002c 0xe1d170b0
mww 0x10100030 0xe1170003
mww 0x10100034 0x0afffffc
mww 0x10100038 0xe1c140b0
mww 0x1010003c 0xe2811002
mww 0x10100040 0xe2855002
mww 0x10100044 0xe1550006
mww 0x10100048 0x1afffff4
mww 0x1010004c 0xe1a00000
mww 0x10100050 0xe1a00000
mww 0x10100054 0xeafffffe
reg pc 0x10100000
}

proc flash-boot { } {
mem-init
mem-switch
writable
big
flash-unlock1
flash-erase1
flash-unlock2
flash-erase2
load_image boot/boot.bin 0x0 bin
mem-setmac
flash-program
echo "Running flash program. Let this run for 20 seconds, then type halt, to halt the cpu"
resume
}
