
package jp.gr.java_conf.u6k.state_engine;

import java.util.ArrayList;
import java.util.List;

public abstract class State {

    private List<Transition> destTransList = new ArrayList<Transition>();

    public abstract void initialize(StateContext ctx);

    public abstract void execute(StateContext ctx);

    public abstract void receiveMessage(StateContext ctx, Message msg);

    public abstract void dispose(StateContext ctx);

    public List<Transition> getDestinationTransitionList() {
        return this.destTransList;
    }

}
