
package jp.gr.java_conf.u6k.sample.stg1;

import java.awt.Graphics2D;

import jp.gr.java_conf.u6k.animation.AnimationWindow;
import jp.gr.java_conf.u6k.state_engine.Message;
import jp.gr.java_conf.u6k.state_engine.State;
import jp.gr.java_conf.u6k.state_engine.StateContext;

public class PlayerDrawState extends State {

    @Override
    public void dispose(StateContext ctx) {
    }

    @Override
    public void execute(StateContext ctx) {
        // 取得
        PlayerObject o = (PlayerObject) ctx.getTarget();
        double x = o.getX();
        double y = o.getY();

        AnimationWindow window = (AnimationWindow) ctx.getValueMap().get("window");
        Graphics2D g = window.getCanvas();

        // 描画
        g.drawRect((int) x - 10, (int) y - 10, 20, 20);
    }

    @Override
    public void initialize(StateContext ctx) {
    }

    @Override
    public void receiveMessage(StateContext ctx, Message msg) {
    }

}
